#!/bin/sh

# we had to blacklist this module in
# /etc/modprobe.d/blacklist-framebuffer.conf and load it here because
# otherwise when ubuntu started the display wont be available on some
# machines
modprobe udl

GRAPHICAL_DISPLAY_USE_V2=1
GRAPHICAL_DISPLAY_V2_FONTSIZE=1

xhost +
export DISPLAY=:0.0

NUM_DEVICES=0
COUNT=0

while [ true ]; do
  if [ "$COUNT" -ge 10 ]; then
    break
  fi

  NUM_DEVICES=`/opt/bin/xrandr_devices | wc -l`

  if [ "$NUM_DEVICES" -ge 2 ]; then
    break
  fi

  COUNT=`expr $COUNT + 1`
  sleep 1
done

# didnt find customer display
if [ $NUM_DEVICES -lt 2 ]; then
  exit
fi

NUM_DEVICES=`/opt/bin/xrandr_devices | wc -l`

if [ $NUM_DEVICES -ge 2 ]; then
  DEVICE_MAIN=`/opt/bin/xrandr_devices | head -1 | cut -f1 -d,`
  DEVICE_USB=`/opt/bin/xrandr_devices | tail -1 | cut -f1 -d,`

  xrandr --output $DEVICE_USB --auto
  sleep 1

  COUNT=0

  while [ true ]; do
    if [ "$COUNT" -ge 10 ]; then
      echo "$0> Can't make it work... will stop trying..."

      HAS_IT=`cat /opt/pos/etc/config.ini | grep USE_GRAPHICAL_CUSTOMER_DISPLAY=1`

      # make sure customer display is disabled
      if [ "$HAS_IT" != "" ]; then
        cat /opt/pos/etc/config.ini | grep -v SCREEN_RESCALE_W | grep -v SCREEN_RESCALE_H | grep -v DISABLE_SCREEN_RESCALE | grep -v USE_GRAPHICAL_CUSTOMER_DISPLAY | grep -v GRAPHICAL_DISPLAY_USE_V2 | grep -v GRAPHICAL_DISPLAY_V2_FONTSIZE | grep -v AUTO_RELOCATE_WINDOWS > /tmp/$$.ini
        mv /tmp/$$.ini /opt/pos/etc/config.ini
        /opt/bin/kill_pos.sh
      fi

      break
    fi

    xrandr --output $DEVICE_USB --right-of $DEVICE_MAIN

    if [ $? -ne 0 ]; then
      echo "$0> Error... Will try again..."
      COUNT=`expr $COUNT + 1`
      sleep 2
    else
      echo "$0> Success!"

      TOUCH=`cat /var/log/Xorg.0.log | grep TOUCHSCREEN | head -1 | grep -o 'id [0-9]\+' | cut -d" " -f2`
      #TOUCH=`cat /var/log/Xorg.0.log | grep TOUCHSCREEN | head -1 | cut -d, -f2 | sed 's/)//' | cut -d" " -f3`

      if [ "$TOUCH" = "" ]; then
        TOUCH=`cat /var/log/Xorg.0.log | grep TABLET | head -1 | grep -o 'id [0-9]\+' | cut -d" " -f2`
        #TOUCH=`cat /var/log/Xorg.0.log | grep TABLET | head -1 | cut -d, -f2 | sed 's/)//' | cut -d" " -f3`
      fi

      if [ "$TOUCH" != "" ]; then
        xinput map-to-output "$TOUCH" "$DEVICE_MAIN"
      fi

      DEVICE_MAIN_SPECS=`/opt/bin/xrandr_devices | head -1`
      DEVICE_USB_SPECS=`/opt/bin/xrandr_devices | tail -1`

      SCREEN_W=`echo $DEVICE_MAIN_SPECS | cut -f2 -d, | cut -f1 -dx`
      SCREEN_H=`echo $DEVICE_MAIN_SPECS | cut -f2 -d, | cut -f2 -dx`
      DISPLAY_W=`echo $DEVICE_USB_SPECS | cut -f2 -d, | cut -f1 -dx`
      DISPLAY_H=`echo $DEVICE_USB_SPECS | cut -f2 -d, | cut -f2 -dx`

      # activate customer display in the software
      if [ "$SCREEN_W" != "" ] && [ "$SCREEN_H" != "" ]; then
        echo "SCREEN_RESCALE_W=$SCREEN_W" > /tmp/$$.ini
        echo "SCREEN_RESCALE_H=$SCREEN_H" >> /tmp/$$.ini
        echo "DISABLE_SCREEN_RESCALE=0" >> /tmp/$$.ini
        echo "USE_GRAPHICAL_CUSTOMER_DISPLAY=1" >> /tmp/$$.ini
        echo "GRAPHICAL_DISPLAY_USE_V2=1" >> /tmp/$$.ini
        echo "GRAPHICAL_DISPLAY_V2_FONTSIZE=1" >> /tmp/$$.ini
        echo "AUTO_RELOCATE_WINDOWS=1" >> /tmp/$$.ini

        cat /opt/pos/etc/config.ini | grep -v SCREEN_RESCALE_W | grep -v SCREEN_RESCALE_H | grep -v DISABLE_SCREEN_RESCALE | grep -v USE_GRAPHICAL_CUSTOMER_DISPLAY | grep -v GRAPHICAL_DISPLAY_USE_V2 | grep -v GRAPHICAL_DISPLAY_V2_FONTSIZE | grep -v AUTO_RELOCATE_WINDOWS >> /tmp/$$.ini
        mv /tmp/$$.ini /opt/pos/etc/config.ini
        /opt/bin/kill_pos.sh

        if [ ! -e "/opt/pos/common/addons/graphical_display/config.xml" ]; then
          if [ -e "/opt/pos/common/addons/graphical_display/config_default_${DISPLAY_W}x${DISPLAY_H}.xml" ]; then
            cp /opt/pos/common/addons/graphical_display/config_default_${DISPLAY_W}x${DISPLAY_H}.xml /opt/pos/common/addons/graphical_display/config.xml
          fi
        fi

        /opt/pos/common/bin/graphical_customer_display_new.sh &
      fi

      break
    fi
  done
else
  HAS_IT=`cat /opt/pos/etc/config.ini | grep USE_GRAPHICAL_CUSTOMER_DISPLAY=1`

  # make sure customer display is disabled
  if [ "$HAS_IT" != "" ]; then
    cat /opt/pos/etc/config.ini | grep -v SCREEN_RESCALE_W | grep -v SCREEN_RESCALE_H | grep -v DISABLE_SCREEN_RESCALE | grep -v USE_GRAPHICAL_CUSTOMER_DISPLAY > /tmp/$$.ini
    mv /tmp/$$.ini /opt/pos/etc/config.ini
    /opt/bin/kill_pos.sh
  fi
fi

# the was needed by a pedro porto machine that had a external customer
# screen that only worked when we clicked on it
sleep 10
if [ "$NUM_DEVICES" = "2" ]; then
  xdotool mousemove 2000 1 click 1
  sleep 1
  xdotool mousemove 50 50 click 1
fi

