#!/bin/bash

export DISPLAY=:0.0

# wait for the screen.sh to finish if it's running
SCREEN_RUNNING=`ps xa | grep "screen\.sh" | grep -v grep`

COUNT=1

while [ "$SCREEN_RUNNING" != "" ]; do
  echo "$0> screen.sh running... waiting for it to finish..." >> /tmp/screen.log
  SCREEN_RUNNING=`ps xa | grep "screen\.sh" | grep -v grep`
  sleep 1
  COUNT=`expr $COUNT + 1`

  if [ $COUNT -gt 20 ]; then
    echo "$0> tryed 20 times, aborting..." >> /tmp/screen.log
    exit
  fi
done

#
# apply screen tweaks
#

xrandr --output HDMI1 --off --output VIRTUAL1 --off --output DP1 --off --output eDP1 --primary --mode 1024x768 --pos 0x0 --rotate normal --output VGA1 --mode 1024x768 --pos 1024x0 --rotate normal

sleep 1

if [ -e "/opt/bin/calibrate.sh" ]; then
  /opt/bin/calibrate.sh
fi

echo "$0> Done!" >> /tmp/screen.log

