#!/bin/bash

filetime="$(date +%m%d%H%M%S)"
SUDO=`which sudo`
INSTALL=`which install`
ROOT_INSTALL=$INSTALL' -o root -g root'
SYSTEMDIR=/usr/sbin
INSTALLDIR=/usr/share/penmount
ARCH=`uname -m`
if [ -f /var/log/Xorg.0.log ]; then
INPUTABI=`cat /var/log/Xorg.0.log | grep "X.Org XInput driver :" | awk -F ': ' '{print $2}'`
elif [ -f $HOME/.local/share/xorg/Xorg.0.log ]; then
INPUTABI=`cat $HOME/.local/share/xorg/Xorg.0.log | grep "X.Org XInput driver :" | awk -F ': ' '{print $2}'`
fi
if [ "$INPUTABI" == "" ]; then
INPUTABI=22.1
fi

if [ $ARCH == "x86_64" ]; then
SRC="x86_64"
LIB="lib64"
else
SRC="i686"
LIB="lib"
fi

echo "========================================"
echo "        PenMount X Installation         "
echo "========================================"

echo "[Installer] Stopping PenMount Utilities ..."
$SUDO killall -q gDraw gCal gPen inputattach

if [ -f /etc/systemd/system/penmount-serio.service ]; then
$SUDO rm /etc/systemd/system/penmount-serio.service
fi
if [ -f /lib/systemd/system/penmount-serio.service ]; then
$SUDO rm /lib/systemd/system/penmount-serio.service
fi

if [ -f /usr/bin/systemctl ]; then
	$SUDO systemctl daemon-reload
elif [ -f /bin/systemctl ]; then
	$SUDO systemctl daemon-reload
fi

echo "[Installer] Copying PenMount Utilities ..."
if [ ! -d $INSTALLDIR ]; then
	$SUDO mkdir $INSTALLDIR
fi
$SUDO $ROOT_INSTALL $SRC/pm-setup             $SYSTEMDIR
$SUDO $ROOT_INSTALL $SRC/gCal                 $SYSTEMDIR
$SUDO $ROOT_INSTALL $SRC/pm-xdraw             $SYSTEMDIR
if [ -f $SRC/pm-wcalib ]; then
$SUDO $ROOT_INSTALL $SRC/pm-wcalib            $SYSTEMDIR
fi
if [ -f $SRC/pm-gcalib ]; then
$SUDO $ROOT_INSTALL $SRC/pm-gcalib            $SYSTEMDIR
fi
$SUDO $ROOT_INSTALL $SRC/gDraw                $SYSTEMDIR
$SUDO $ROOT_INSTALL $SRC/gPen                 $SYSTEMDIR
$SUDO $ROOT_INSTALL -m 4755 $SRC/gPen-wrapper $SYSTEMDIR
$SUDO $ROOT_INSTALL -m 4755 $SRC/gCal-wrapper $SYSTEMDIR
$SUDO $ROOT_INSTALL $SRC/inputattach          $INSTALLDIR

echo "[Installer] Copying PenMount Resource Files..."
$SUDO $ROOT_INSTALL penmount.png              $INSTALLDIR
$SUDO $ROOT_INSTALL README                    $INSTALLDIR

$SUDO $ROOT_INSTALL penmount48.png   /usr/share/pixmaps/penmount.png
$SUDO $ROOT_INSTALL penmount.desktop /usr/share/applications

echo "[Installer] Setting up System ..."

if [ ! -d /etc/penmount ]; then
	$SUDO mkdir /etc/penmount
fi
$SUDO chmod 777 /etc/penmount

if [ -f ./penmount.dat ]; then
	$SUDO cp ./penmount.dat     /etc/penmount
fi

if [ -f /usr/share/gnome-menus/update-gnome-menus-cache ]; then
	/usr/share/gnome-menus/update-gnome-menus-cache /usr/share/applications > ~/desktop.en_US.utf8.cache
	$SUDO mv ~/desktop.en_US.utf8.cache /usr/share/applications/desktop.en_US.utf8.cache
fi

echo "[Installer] Setting up X Server ..."

if [ -d /etc/X11/xorg.conf.d ]; then
    $SUDO rm /etc/X11/xorg.conf.d/*penmount*
elif [ -d /usr/share/X11/xorg.conf.d ]; then
    $SUDO rm /usr/share/X11/xorg.conf.d/*penmount*
elif [ -d /usr/lib/X11/xorg.conf.d ]; then
    $SUDO rm /usr/lib/X11/xorg.conf.d/*penmount*
fi

if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then
    $SUDO rm /usr/share/hal/fdi/policy/20thirdparty/*penmount*
fi

$SUDO /usr/sbin/pm-setup -s

if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then
	$SUDO rm /var/cache/hald/fdi-cache
	$SUDO /etc/init.d/haldaemon restart
fi

echo "[Installer] Copying PenMount X Input module file : " $INPUTABI

if [ -d /usr/$LIB/xorg/modules/input ] ; then 
	$SUDO find /usr/$LIB/xorg/modules/input -name penmount_drv.so -type f -delete
	if [ -f $SRC/$INPUTABI/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/$INPUTABI/penmount_drv.so /usr/$LIB/xorg/modules/input
	elif [ -f $SRC/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/penmount_drv.so /usr/$LIB/xorg/modules/input
	else
		echo "[Installer] ERROR! Cannot find suitable PenMount X Input module for the target system !"
	fi
elif [ -d /usr/lib/xorg/modules/input ] ; then
	$SUDO find /usr/lib/xorg/modules/input -name penmount_drv.so -type f -delete
	if [ -f $SRC/$INPUTABI/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/$INPUTABI/penmount_drv.so /usr/lib/xorg/modules/input
	elif [ -f $SRC/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/penmount_drv.so /usr/lib/xorg/modules/input
	else
		echo "[Installer] ERROR! Cannot find suitable PenMount X Input module for the target system !"
	fi
else
	echo "[Installer] Cannot find a proper X Input module directory !"
fi

if [ -f 99-penmount-hidraw.rules ]; then
$SUDO $ROOT_INSTALL 99-penmount-hidraw.rules /etc/udev/rules.d
fi

if [ -f /sbin/udevadm ]; then
	$SUDO udevadm trigger
fi

if [ -f /usr/bin/systemctl ]; then
	$SUDO systemctl daemon-reload
	$SUDO systemctl start penmount-serio
elif [ -f /bin/systemctl ]; then
	$SUDO systemctl daemon-reload
	$SUDO systemctl start penmount-serio
fi

echo "========================================"
echo "    PenMount Installation Finished !    "
echo "========================================"
echo "[Installer] Please restart the system to make changes take effect !"

