#!/usr/bin/perl
#
# Copyright 2008-2012 3M. All rights reserved.
#
# This perl script is used to determine if a file is found in any of
# the PATH directories. Because some distributions, we add /sbin to
# the path for applications, such as chkconfig, which are there.

$progname = $ARGV[0];

if (-x $progname && -f $progname)
{
   print "$progname";
   for ($i = 1; $i <= $#ARGV; $i++)
   {
      printf " $ARGV[$i]";
   }
   print "\n";
   exit (0);
}

$path = $ENV{'PATH'} . ":/sbin";
@dirs = split /:/, $path;

foreach $dir (@dirs)
{
   $fullfile = "$dir/$progname";
   if (-x $fullfile && -f $fullfile)
   {
      print "$fullfile";
      for ($i = 1; $i <= $#ARGV; $i++)
      {
         printf " $ARGV[$i]";
      }
      print "\n";
      exit (0);
   }
}
exit (1);
