#!/bin/bash

filetime="$(date +%m%d%H%M%S)"
SUDO=`which sudo`
INSTALL=`which install`
ROOT_INSTALL=$INSTALL' -o root -g root'
ARCH=`uname -m`
INPUTABI=`cat /var/log/Xorg.0.log | grep "X.Org XInput driver :" | awk -F ': ' '{print $2}'`

if [ $ARCH == "x86_64" ]; then
SRC="x86_64"
LIB="lib64"
else
SRC="i686"
LIB="lib"
fi

echo "========================================"
echo "        PenMount X Installation         "
echo "========================================"

echo "[Installer] Stopping PenMount Utilities ..."
$SUDO killall -q gDraw gCal gPen

echo "[Installer] Copying PenMount Utilities ..."
$SUDO $ROOT_INSTALL $SRC/pm-setup             /usr/sbin
$SUDO $ROOT_INSTALL $SRC/pm-xdraw             /usr/sbin
$SUDO $ROOT_INSTALL $SRC/gCal                 /usr/sbin
$SUDO $ROOT_INSTALL $SRC/gDraw                /usr/sbin
$SUDO $ROOT_INSTALL $SRC/gPen                 /usr/sbin
$SUDO $ROOT_INSTALL -m 4755 $SRC/gPen-wrapper /usr/sbin
$SUDO $ROOT_INSTALL -m 4755 $SRC/gCal-wrapper /usr/sbin

echo "[Installer] Copying PenMount Resource Files..."
$SUDO mkdir -p /usr/share/penmount
$SUDO $ROOT_INSTALL penmount.png     /usr/share/penmount
$SUDO $ROOT_INSTALL README           /usr/share/penmount

$SUDO $ROOT_INSTALL penmount48.png   /usr/share/pixmaps/penmount.png
$SUDO $ROOT_INSTALL penmount48.png   /usr/share/icons/gnome/48x48/apps/penmount.png
$SUDO $ROOT_INSTALL penmount32.png   /usr/share/icons/gnome/32x32/apps/penmount.png
$SUDO $ROOT_INSTALL penmount24.png   /usr/share/icons/gnome/24x24/apps/penmount.png
$SUDO $ROOT_INSTALL penmount22.png   /usr/share/icons/gnome/22x22/apps/penmount.png
$SUDO $ROOT_INSTALL penmount16.png   /usr/share/icons/gnome/16x16/apps/penmount.png
$SUDO $ROOT_INSTALL penmount.desktop /usr/share/applications

echo "[Installer] Setting up System ..."

if [ ! -d /etc/penmount ]; then
	$SUDO mkdir /etc/penmount
fi
$SUDO chmod 777 /etc/penmount

if [ -f ./penmount.dat ]; then
	$SUDO cp ./penmount.dat     /etc/penmount
fi

if [ -f /usr/share/gnome-menus/update-gnome-menus-cache ]; then
	/usr/share/gnome-menus/update-gnome-menus-cache /usr/share/applications > ~/desktop.en_US.utf8.cache
	$SUDO mv ~/desktop.en_US.utf8.cache /usr/share/applications/desktop.en_US.utf8.cache
fi

if [ ! -d ~/.config/autostart ]; then
	mkdir -p ~/.config/autostart
fi
$INSTALL penmount_autostart.desktop ~/.config/autostart/penmount.desktop

echo "[Installer] Setting up X Server ..."

if [ -d /etc/X11/xorg.conf.d ]; then
    $SUDO rm /etc/X11/xorg.conf.d/*penmount*
elif [ -d /usr/share/X11/xorg.conf.d ]; then
    $SUDO rm /usr/share/xorg.conf.d/*penmount*
elif [ -d /usr/lib/X11/xorg.conf.d ]; then
    $SUDO rm /usr/lib/xorg.conf.d/*penmount*
fi

if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then
    $SUDO rm /usr/share/hal/fdi/policy/20thirdparty/*penmount*
fi

$SUDO /usr/sbin/pm-setup -s

if [ -f /sbin/udevadm ]; then
	$SUDO udevadm trigger
fi

if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then
	$SUDO rm /var/cache/hald/fdi-cache
	$SUDO /etc/init.d/haldaemon restart
fi

echo "[Installer] Copying PenMount X Input module file : " $INPUTABI

if [ -d /usr/$LIB/xorg/modules/input ] ; then 
	$SUDO find /usr/$LIB/xorg/modules/input -name penmount_drv.so -type f -delete
	if [ -f $SRC/$INPUTABI/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/$INPUTABI/penmount_drv.so /usr/$LIB/xorg/modules/input
	elif [ -f $SRC/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/penmount_drv.so /usr/$LIB/xorg/modules/input
	else
		echo "[Installer] ERROR! Cannot find suitable PenMount X Input module for the target system !"
	fi
elif [ -d /usr/lib/xorg/modules/input ] ; then
	$SUDO find /usr/lib/xorg/modules/input -name penmount_drv.so -type f -delete
	if [ -f $SRC/$INPUTABI/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/$INPUTABI/penmount_drv.so /usr/lib/xorg/modules/input
	elif [ -f $SRC/penmount_drv.so ] ; then
		$SUDO $ROOT_INSTALL $SRC/penmount_drv.so /usr/lib/xorg/modules/input
	else
		echo "[Installer] ERROR! Cannot find suitable PenMount X Input module for the target system !"
	fi
else
	echo "[Installer] Cannot find a proper X Input module directory !"
fi

echo "========================================"
echo "    PenMount Installation Finished !    "
echo "========================================"
echo "[Installer] Please restart the system to make changes take effect !"

