package Common;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw( commands );

use strict;
use warnings;
use File::Copy qw( copy );
use FindBin qw( $Bin );

sub commands {
  my $is_new_distro = -e "/fill.iso" ? 1 : 0;
  unlink("/fill.iso") if $is_new_distro;
  system("mkdir -p /root/.original_files") unless -d "/root/.original_files";

  # remove default coordinates.block file
  if (-e "/opt/pos/etc/coordinates.block") {
    system("rm /opt/pos/etc/coordinates.block");
  }

  # backup original files
  &copy("/etc/rc.local", "/root/.original_files/rc.local");
  &copy("/root/.fluxbox/startup", "/root/.original_files/startup");
  &copy("/etc/modules", "/root/.original_files/modules");
  &copy("/etc/default/grub", "/root/.original_files/grub");
  &copy("/etc/modprobe.d/blacklist.conf", "/root/.original_files/blacklist.conf");

  # telstra_4g
  system("cp \"$Bin/../software/telstra_4g/19d2_0166\" /etc/usb_modeswitch.d/19d2:0166");
  system("cp \"$Bin/../software/telstra_4g/40-usb_modeswitch.rules\" /etc/udev/rules.d");
  system("cp \"$Bin/../software/telstra_4g/telstra-4g.conf\" /etc/modprobe.d");

  if (-e "$Bin/pos/config.ini") {
    &copy("$Bin/pos/config.ini", "/opt/pos/etc/config.ini");
  }
  else {
    &copy("$Bin/../software/config.ini", "/opt/pos/etc/config.ini");
  }

  if (-e "$Bin/../software/modules") {
    &copy("$Bin/../software/modules", "/etc/modules");
    system("depmod -a");
  }

  if (-e "$Bin/data/rc.local") {
    &copy("$Bin/data/rc.local", "/etc/rc.local");
  }
  else {
    &copy("$Bin/../software/rc.local", "/etc/rc.local");
  }

  system("chmod 755 /etc/rc.local");

  # wireless adapter
  &copy("$Bin/../software/RT5370.sh", "/opt/bin/RT5370.sh");
  system("chmod 755 /opt/bin/RT5370.sh");


  # copy all custom rules
  system("cp \"$Bin/../software/udev_rules/*\" \"/etc/udev/rules.d\"");

  unlink("/etc/udev/rules.d/70-persistent-net.rules");
  &copy("$Bin/../software/bashrc", "/root/.bashrc");
  &copy("$Bin/../software/chkdsk", "/usr/local/bin/chkdsk");
  &copy("$Bin/../software/machine_selector", "/opt/bin/machine_selector");
  &copy("$Bin/../software/timezone", "/etc/timezone");
  system("dpkg-reconfigure --frontend noninteractive tzdata");
  &copy("$Bin/../software/teamviewer.sh", "/opt/pos/common/bin/teamviewer.sh");

  #if (! -e "/usr/share/man/man3/Digest::HMAC.3pm.gz") {
    system("rm /etc/update-motd.d/*");
    system("dpkg -E -i $Bin/../software/debs/libdigest-hmac-perl_1.03+dfsg-1_all.deb");
    system("dpkg -E -i $Bin/../software/debs/*.deb");
    system("apt-get clean");
  #}

  # install Email::Send::SMTP::Gmail
  if (! -e "/usr/local/share/man/man3/Email::Send::SMTP::Gmail.3pm") {
    system("tar zxf $Bin/../software/Email-Send-SMTP-Gmail-0.46.tar.gz --directory /tmp");
    system("cd /tmp/Email-Send-SMTP-Gmail-0.46 ; perl Makefile.PL ; make ; make install");
  }
  
  # install Image::BMP
  if (! -e "/usr/local/share/man/man3/Image::BMP.3pm") {
    system("tar zxf $Bin/../software/Image-BMP-1.17.tar.gz --directory /tmp");
    system("cd /tmp/Image-BMP-1.17 ; perl Makefile.PL ; make ; make install");
  }

  # Realtek rtl8192cu support - wget ftp://WebUser:fh7SkVT4@95.130.192.218/cn/wlan/RTL8192xC_USB_linux_v3.4.4_4749.20121105.zip
  if (-d "/lib/modules/3.0.0-27-generic-pae") {
    my $depmod = 0;

    if (! -e "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless/8712u.ko") {
      &copy("$Bin/../software/8712u.ko", "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless");
      $depmod = 1;
    }

    if (! -e "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless/r8101.ko") {
      &copy("$Bin/../software/r8101.ko", "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless");
      $depmod = 1;
    }

    if (! -e "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless/r8168.ko") {
      &copy("$Bin/../software/r8168.ko", "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless");
      $depmod = 1;
    }

    if (! -e "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless/r8169.ko") {
      &copy("$Bin/../software/r8169.ko", "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless");
      $depmod = 1;
    }

    if (! -e "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless/8192cu.ko") {
      &copy("$Bin/../software/8192cu.ko", "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless");
      $depmod = 1;
    }

    if (! -d "/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless/rtlwifi") {
      system("cp -r \"$Bin/../software/rtlwifi/\" \"/lib/modules/3.0.0-27-generic-pae/kernel/drivers/net/wireless\"");
      $depmod = 1;
    }

    if ($depmod) {
      system("/sbin/depmod -a");
    }
  }

  system("mkdir -p /root/.vnc") unless -d "/root/.vnc";
  system("cp $Bin/../software/passwd /root/.vnc");
  system("chmod 600 /root/.vnc/passwd");
  system("cp $Bin/../software/xstartup /root/.vnc");

  my $pen_path = "$Bin/../..";

  # grub logo
  if (-e "$pen_path/pos/releases/grub.png") {
    &copy("$pen_path/pos/releases/grub.png", "/boot/grub/grub.png");
  }

  # skin images install
  if (-d "$pen_path/pos/skins") {
    system("cp -r $pen_path/pos/skins/* /opt/pos/common/skins");
  }

  # config.ini
  if (-e "$pen_path/pos/releases/config.ini") {
    &copy("$pen_path/pos/releases/config.ini", "/opt/pos/etc/config.ini");
  }

  # images install
  if (-e "$pen_path/pos/releases/images.zip") {
    print STDERR "WILL INSTALL IMAGES IN /opt/pos/server/data/images\n";
    system("mkdir -p /opt/pos/server/data/images") unless -d "/opt/pos/server/data/images";
    system("unzip -d /opt/pos/server/data/images -q -o $pen_path/pos/releases/images.zip");
  }
  else {
    print STDERR "[WARNING] CANT FIND IMAGES IN $pen_path/pos/releases\n";
  }

  # templates install
  if (-e "$pen_path/pos/releases/tmpl.zip") {
    print STDERR "WILL INSTALL DOCUMENT TEMPLATES IN /opt/pos/common/print_templates\n";
    system("unzip -d /opt/pos/common/print_templates -q -o $pen_path/pos/releases/tmpl.zip");
  }
  else {
    print STDERR "[WARNING] CANT FIND DOCUMENT TEMPLATES IN $pen_path/pos/releases\n";
  }

  my $SKIN = "";

  if (-e "/opt/pos/etc/config.ini") {
    $SKIN=`cat /opt/pos/etc/config.ini | grep LANG= | cut -f2 -d=`;
    $SKIN =~ s/[\r\n]+$//;
  }

  if ($SKIN) {
    # release install
    my $cmd = "ls -tra $pen_path/pos/releases/*-".$SKIN."-*.tgz 2> /dev/null | head -1";
    my $release = `$cmd`;

    if ($release) {
      chop($release);
      print STDERR "WILL INSTALL RELEASE - $release\n";
      system("tar zxf $release --directory /opt/pos");
    }
    else {
      print STDERR "[WARNING] CANT FIND ANY RELEASE IN $pen_path/pos/releases\n";
    }
  }

  # custom stuff
  if (-e "$Bin/../software/custom_commands") {
    system("chmod 755 $Bin/../software/custom_commands");
    system("$Bin/../software/custom_commands");
  }
}

1;

