#!/etc/tsharc/busybox ash
CONFIGDIRECTORY="/etc/tsharc"
PATH="/etc/tsharc"
VERSION="3.0.4b"

alias ps="${CONFIGDIRECTORY}/busybox ps"
alias grep="${CONFIGDIRECTORY}/busybox grep"
alias sed="${CONFIGDIRECTORY}/busybox sed"
alias id="${CONFIGDIRECTORY}/busybox id"
alias rm="${CONFIGDIRECTORY}/busybox rm"

TSHARCD="/usr/bin/tsharcd"
TSHARCX11="/usr/lib/tsharcX11.so"
UNINSTALL="/usr/bin/uninstall.sh"
CPCONSOLE="/usr/bin/cpconsole"
HLINCAL="/usr/bin/hlincal"
TSCAL="/usr/bin/tscal"
# BOOTTSHARCLINK="/usr/bin/boot.tsharc"
VERIFY="n"

if [ $(id -u) != 0 ]; then
	echo "Root permissions necessary to uninstall TSHARC components"
	exit 1
fi

if [ "$(ps -A | grep "tsharcd" | sed -e '/grep/,/grep/d')" != "" ]; then
	boot.tsharc stop
fi

echo -n "Warning: Are you sure you wish to erase all TSHARC data? (y/n): "
read VERIFY

if [ $VERIFY = "n" ]; then
	echo "Uninstall has been cancelled"
	exit 1
fi

echo "Removing TSHARC files..."

rm -f $TSHARCD
rm -f $TSHARCX11
rm -f $UNINSTALL
rm -f $CPSCRIPT
rm -f $CPCONSOLE
rm -f $HLINCAL

rm -f $TSCAL
rm -f /tmp/tsharcctl
rm -f /tmp/tsharcoutput
rm -f /tmp/tsharcevents
rm -f $BOOTTSHARCLINK

if [ -d "/var/log/tsharc" ]; then
    rm -fr "/var/log/tsharc"
fi

if [ -f "/usr/bin/unregisterSysV.sh" ]; then
	echo "Removing TSHARC commands from System V initialization"
	/usr/bin/unregisterSysV.sh
	rm -f /usr/bin/unregisterSysV.sh
fi

if [ -f "/usr/bin/unregisterX11.sh" ]; then
	echo "Removing TSHARC commands from X11 startup scripts"
	/usr/bin/unregisterX11.sh
	rm -f /usr/bin/unregisterX11.sh
fi

if [ -d "${CONFIGDIRECTORY}" ]; then
	echo "Removing files in ${CONFIGDIRECTORY}"
	rm -rf "${CONFIGDIRECTORY}"
fi

echo "The TSHARC daemon files have been removed from the system."
