#!./busybox ash

alias id="./busybox id"
alias ps="./busybox ps"
alias grep="./busybox grep"
alias sleep="./busybox sleep"
alias clear="./busybox clear"
alias uname="./busybox uname"
alias cp="./busybox cp"
alias rm="./busybox rm"
alias chmod="./busybox chmod"
alias ln="./busybox ln"
alias cat="./busybox cat"
alias touch="./busybox touch"
alias mkdir="./busybox mkdir"
alias head="./busybox head"
alias sed="./busybox sed"


if [ $(id -u) != 0 ]; then
        echo "Root permissions necessary to query system components"
        exit 1
fi

# Remove any previous settings
rm -rf /tmp/sysinfo
rm -f /tmp/sysinfo.tar.gz

# Create directory to place system information into
mkdir -p /tmp/sysinfo

echo "sysinfo version 1.1" > /tmp/sysinfo/sysinfo_version.txt

# Current X11 Version
xdpyinfo > /tmp/sysinfo/xdpyinfo.txt

# Current kernel version
uname -a > /tmp/sysinfo/uname.txt

# Current processes running
ps -A > /tmp/sysinfo/ps-a.txt

# Current kernel modules
lsmod > /tmp/sysinfo/lsmod.txt

# Copy the current X configuration file
cp -f /etc/X11/*.conf /tmp/sysinfo

# Xdm startup script configuration
cp -f /etc/X11/xdm/Xsetup /tmp/sysinfo

# Copy kernel configuration files if any are present to see how kernel
# was setup
cp -f /boot/config* /tmp/sysinfo

# Copy current X log file
cp -f /var/log/Xorg.0.log /tmp/sysinfo
cp -f /var/log/XFree86.0.log /tmp/sysinfo

# Copy current tsharc log file
cp -rf /var/log/tsharc /tmp/sysinfo

# see the last system messages logged
dmesg > /tmp/sysinfo/dmesg.txt

# check to see what the current library paths are
cp -f /etc/ld.so.conf /tmp/sysinfo

# check to see available entries in the dev and dev/input branch are
ls -l /dev > /tmp/sysinfo/dev.txt
ls -l /dev/input > /tmp/sysinfo/dev_input.txt

# view how the named pipes are setup
ls -l /tmp/tsharc* /tmp/sysinfo/named_pipes.txt

# see the status of usb devices on the system
cp /proc/bus/input/devices /tmp/sysinfo/proc_bus_input_devices.txt
cp /proc/bus/input/handlers /tmp/sysinfo/proc_bus_input_handlers.txt
cp /proc/bus/usb/devices /tmp/sysinfo/proc_bus_usb_devices.txt

# Check to see how the configuration files may be setup
mkdir /tmp/sysinfo/tsharc
cp -rf . /tmp/sysinfo/tsharc

# Current library files on system
ls -l /usr/lib > /tmp/sysinfo/usrlib.txt
ls -l /usr/X11/lib > /tmp/sysinfo/usr_x11_lib.txt
ls /lib > /tmp/sysinfo/lib.txt

# Current start configuration scripts on system
ls -lr /etc/init.d > /tmp/sysinfo/etc_initd.txt
ls -lr /etc/rc.d > /tmp/sysinfo/etc_rcd.txt

# Uncomment strace and ltrace lines only if there is an error during
# the execution of tscal
# Trace system calls and signals of tscal
# strace /usr/bin/tscal >& /tmp/sysinfo/tscal_strace.txt
# Trace library calls of tscal
# ltrace /usr/bin/tscal >& /tmp/sysinfo/tscal_ltrace.txt

# Uncomment strace and ltrace lines only if there is an error during
# the execution of hlincal
# Trace system calls and signals of hlincal
# strace /usr/bin/hlincal >& /tmp/sysinfo/hlincal_strace.txt
# Trace library calls of hlincal
# ltrace /usr/bin/hlincal >& /tmp/sysinfo/hlincal_ltrace.txt

# See current dependencies and if any are missing on system
ldd /usr/bin/tscal > /tmp/sysinfo/tscal_ldd.txt
ldd /usr/bin/hlincal > /tmp/sysinfo/hlincal_ldd.txt

# copying binarys and scripts to make 100 percent certain the versions are correct
cp -f /usr/bin/tscal /tmp/sysinfo
cp -f /usr/bin/hlincal /tmp/sysinfo
cp -f /usr/bin/boot.tsharc /tmp/sysinfo
cp -f /usr/bin/cp.sh /tmp/sysinfo
cp -f /usr/bin/uninstall.sh /tmp/sysinfo

# Check to see if TinyX is being used and to see if SUID permission set for X
ls -l /usr/X11R6/bin/X* > /tmp/sysinfo/usr_X11R6_bin_X.txt
ls -l /usr/bin/X11/X* > /tmp/sysinfo/usr_bin_X11_X.txt

cat /proc/meminfo > /tmp/sysinfo/mem.txt
cat /proc/cpuinfo > /tmp/sysinfo/cpu.txt

echo "If the daemon stalls for some reason during daemon restarting, 
please run following commands manually:"
echo "tar cvf /tmp/sysinfo.tar /tmp/sysinfo"
echo "gzip /tmp/sysinfo.tar"
echo

echo "Stopping daemon"
boot.tsharc stop > /tmp/sysinfo/stopdaemon.txt

echo "Starting daemon"
boot.tsharc start > /tmp/sysinfo/startdaemon.txt

echo "Querying daemon status"
boot.tsharc status > /tmp/sysinfo/statusdaemon.txt

cd /tmp

# create file to send to Hampshire
tar cvf /tmp/sysinfo.tar sysinfo
gzip sysinfo.tar
mv -v sysinfo.tar.gz sysinfo12.tar.gz

echo "System information has been generated in the /tmp/sysinfo 
subdirectory."
echo "Also this information has been stored in /tmp/sysinfo12.tar.gz"
 
