XSETUPPATH="/etc/X11/xdm"
XINITRCPATH="/etc/X11/xinit"

# we will ensure there is always a backup
backupXsetup()
{
	CURRENTNUM=1
	VALIDFILE=0
	while [ $VALIDFILE = "0" ]; do
		if [ ! -f "${XSETUPPATH}/Xsetup.backup${CURRENTNUM}" ]; then
			cp -fv ${XSETUPPATH}/Xsetup ${XSETUPPATH}/Xsetup.backup${CURRENTNUM}
			VALIDFILE=1
		else
			CURRENTNUM=$((CURRENTNUM+1))
		fi
	done
}



addToXsetup()
{
	RUNSTATUS="$(cat ${XSETUPPATH}/Xsetup | grep TSHARCCONFIGSTART)"
	BLANKSTATUS=""
	
	# we do an additional check to ensure modifications are not applied twice
	if [ "$RUNSTATUS" == "$BLANKSTATUS" ]; then
		backupXsetup
		sed -e 's/^#!.*//g' ${XSETUPPATH}/Xsetup >${XSETUPPATH}/Xsetupnew
		cp -fv ${XSETUPPATH}/Xsetupnew ${XSETUPPATH}/Xsetup
		cp Xsetupheader ${XSETUPPATH}/Xsetup
		cat ${XSETUPPATH}/Xsetupnew >> ${XSETUPPATH}/Xsetup
	fi
}

# we will ensure there is always a backup
backupxinitrc()
{
	CURRENTNUM=1
	VALIDFILE=0
	while [ $VALIDFILE = "0" ]; do
		if [ ! -f "${XINITRCPATH}/xinitrc.backup${CURRENTNUM}" ]; 
		then
			cp -fv ${XINITRCPATH}/xinitrc ${XINITRCPATH}/xinitrc.backup${CURRENTNUM}
			VALIDFILE=1
		else
			CURRENTNUM=$((CURRENTNUM+1))
		fi
	done
}



addToxinitrc()
{
	RUNSTATUS="$(cat ${XINITRCPATH}/xinitrc | grep TSHARCCONFIGSTART)"
	BLANKSTATUS=""
	
	# we do an additional check to ensure modifications are not applied twice
	if [ "$RUNSTATUS" == "$BLANKSTATUS" ]; then
		backupxinitrc
		sed -e 's/^#!.*//g' ${XINITRCPATH}/xinitrc >${XINITRCPATH}/xinitrcnew
		cp -fv ${XINITRCPATH}/xinitrcnew ${XINITRCPATH}/xinitrc
		cp xinitrcheader ${XINITRCPATH}/xinitrc
		cat ${XINITRCPATH}/xinitrcnew >> ${XINITRCPATH}/xinitrc
	fi
}

echo "Adding appropriate lines if necessary to files in ${XSETUPPATH}"
addToXsetup
echo "Adding appropriate lines if necessary to files in ${XINITRCPATH}"
addToxinitrc

cp ./unregisterX11.sh /usr/bin

