#!./busybox ash

export PATH="."

alias id="./busybox id"
alias ash="./busybox ash"
alias ps="./busybox ps"
alias grep="./busybox grep"
alias sleep="./busybox sleep"
alias clear="./busybox clear"
alias uname="./busybox uname"
alias cp="./busybox cp"
alias rm="./busybox rm"
alias chmod="./busybox chmod"
alias ln="./busybox ln"
alias cat="./busybox cat"
alias touch="./busybox touch"
alias mkdir="./busybox mkdir"
alias head="./busybox head"
alias sed="./busybox sed"
alias modprobe="./busybox modprobe"

#CONFIGDIRECTORY="/etc/tsharc"
CONFIGDIRECTORY="/etc/tsharc"
DAEMONINIT=$CONFIGDIRECTORY
COMPONENT=0
numComponents=10
numSelected=0

VERSION="3.0.4c"

# Source files
TSHARCDSRC="./tsharcd"
TSHARCX11SRC="./tsharcX11.so"
UNINSTALLSRC="./uninstall.sh"
# CPSCRIPTSRC="./cp.sh"
CPCONSOLESRC="./hlincal"
TSCALSRC="./tscal"
BOOTTSHARCSRC="./boot.tsharc"
ADDSERIORAWSRC="./add_serio_raw"

# Target files
TSHARCD="/usr/bin/tsharcd"
TSHARCX11="/usr/lib/tsharcX11.so"
UNINSTALL="/usr/bin/uninstall.sh"
#CPSCRIPT="/usr/bin/cp.sh"
CPCONSOLE="/usr/bin/hlincal"
TSCAL="/usr/bin/tscal"
#BOOTTSHARC="${DAEMONINIT}/boot.tsharc"

typesSelected=0
USB=1
SERIAL=2
PS2=4



getTypes()
{
	typesSelected=0
	i=0
	while [ $i -lt 10 ]; do

	if [ $(($COMPONENT & $((1 << $i)))) -eq $((1 << $i)) ]; then

			case ${i} in 
				0)
					typesSelected=$((USB | typesSelected))
					;;
				1)
					typesSelected=$((SERIAL | typesSelected))
					;;
				2)
					typesSelected=$((SERIAL | typesSelected))
					;;
				3)
					typesSelected=$((SERIAL | typesSelected))
					;;
				4)
					typesSelected=$((SERIAL | typesSelected))
					;;
				5)
					typesSelected=$((SERIAL | typesSelected))
					;;
				6)
					typesSelected=$((SERIAL | typesSelected))
					;;
				7)
					typesSelected=$((SERIAL | typesSelected))
					;;
				8)
					typesSelected=$((SERIAL | typesSelected))
					;;
				9)
					typesSelected=$((PS2 | typesSelected))
					;;
			esac
		fi
		i=$((i+1))
	done

}

toggleComponent()
{

	if [ $(($COMPONENT & $((1 << $1)))) -eq $((1 << $1)) ]; then
		COMPONENT=$(($COMPONENT & $(( ~(1 << $1) ))))
		numSelected=$((numSelected-1))
	else
		if [ ${numSelected} -lt 6 ]; then
			numSelected=$((numSelected+1))
			COMPONENT=$(($COMPONENT | $((1 << $1))))
		else
			echo "Maximum controller count reached"
			sleep 1
		fi		
	fi
}

initializeComponents()
{
	COMPONENT=0
}

printSelectedComponent()
{
#	if [ ${COMPONENT[$1]} = 1 ]; then
	if [ $(($COMPONENT & $((1 << $1)))) -eq $((1 << $1)) ]; then

		case $1 in 
			0)
				echo "TSHARC USB Controller support"
				;;
			1)
				echo "TSHARC SERIAL Controller on COM1 (/dev/ttyS0)"
				;;
			2)
				echo "TSHARC SERIAL Controller on COM2 (/dev/ttyS1)"
				;;
			3)
				echo "TSHARC SERIAL Controller on COM3 (/dev/ttyS2)"
				;;
			4)
				echo "TSHARC SERIAL Controller on COM4 (/dev/ttyS3)"
				;;
			5)
				echo "TSHARC SERIAL Controller on COM5 (/dev/ttyS4)"
				;;
			6)
				echo "TSHARC SERIAL Controller on COM6 (/dev/ttyS5)"
				;;
			7)
				echo "TSHARC SERIAL Controller on COM7 (/dev/ttyS6)"
				;;
			8)
				echo "TSHARC SERIAL Controller on COM8 (/dev/ttyS7)"
				;;
			9)
				echo "TSHARC PS/2 controller"
				;;
		esac
	fi
}

installSelectedComponent()
{
#	if [ ${COMPONENT[$1]} = 1 ]; then
#	if [ $(eval $COMPONENT$1) -eq 1 ]; then
	if [ $(($COMPONENT & $((1 << $1)))) -eq $((1 << $1)) ]; then

		case $1 in 
			0)
				echo "Installing TSHARC USB Controller support"
				touch ${CONFIGDIRECTORY}/tsharcusb.conf
				chmod 666 ${CONFIGDIRECTORY}/tsharcusb.conf
				;;
			1)
				echo "Installing TSHARC SERIAL Controller on COM1 (/dev/ttyS0)"
				echo "/dev/ttyS0" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			2)
				echo "Installing TSHARC SERIAL Controller on COM2 (/dev/ttyS1)"
				echo "/dev/ttyS1" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			3)
				echo "Installing TSHARC SERIAL Controller on COM3 (/dev/ttyS2)"
				echo "/dev/ttyS2" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			4)
				echo "Installing TSHARC SERIAL Controller on COM4 (/dev/ttyS3)"
				echo "/dev/ttyS3" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			5)
				echo "Installing TSHARC SERIAL Controller on COM5 (/dev/ttyS4)"
				echo "/dev/ttyS4" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			6)
				echo "Installing TSHARC SERIAL Controller on COM6 (/dev/ttyS5)"
				echo "/dev/ttyS5" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			7)
				echo "Installing TSHARC SERIAL Controller on COM7 (/dev/ttyS6)"
				echo "/dev/ttyS6" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			8)
				echo "Installing TSHARC SERIAL Controller on COM8 (/dev/ttyS7)"
				echo "/dev/ttyS7" >> "${CONFIGDIRECTORY}/tsharcs.conf"
				;;
			9)
				echo "Installing TSHARC PS/2 controller"
					# create device node

					echo "/dev/tsharcps2" >> "${CONFIGDIRECTORY}/tsharcs.conf"
					cp $ADDSERIORAWSRC "${CONFIGDIRECTORY}/add_serio_raw"
					echo "Enabling SERIO_RAW kernel component"
					chmod 4755 "${CONFIGDIRECTORY}/add_serio_raw"
					"${CONFIGDIRECTORY}/add_serio_raw"
				;;
		esac
	fi

}


printComponents()
{
	if [ $COMPONENT = "0" ]; then
		echo "No controller components selected"
	else
		i=0

		while [ $i -lt 10 ]; do
#
#		for ((i=0;i<$numComponents;i++)); do
			printSelectedComponent ${i}
			i=$((i+1))
		done
	fi
}

printHeader()
{
	echo "TSHARC controller setup version ${VERSION}"
	echo "This version supports a maximum of 6 controllers"
	echo
	echo "Currently selected TSHARC components:"
	printComponents
	echo
}
 
printInterfaceMenu()
{
	printHeader

	echo "1.  Toggle TSHARC USB Controller support"
	echo "2.  Toggle TSHARC SERIAL Controller on COM1 (/dev/ttyS0)"
	echo "3.  Toggle TSHARC SERIAL Controller on COM2 (/dev/ttyS1)"
	echo "4.  Toggle TSHARC SERIAL Controller on COM3 (/dev/ttyS2)"
	echo "5.  Toggle TSHARC SERIAL Controller on COM4 (/dev/ttyS3)"
	echo "6.  Toggle TSHARC SERIAL Controller on COM5 (/dev/ttyS4)"
	echo "7.  Toggle TSHARC SERIAL Controller on COM6 (/dev/ttyS5)"
	echo "8.  Toggle TSHARC SERIAL Controller on COM7 (/dev/ttyS6)"
	echo "9.  Toggle TSHARC SERIAL Controller on COM8 (/dev/ttyS7)"
	echo "10. Toggle TSHARC PS/2 controller"
	echo "11. Set configuration file directory (Current: \"${CONFIGDIRECTORY}\")"
	echo "12. Install selected components"
	echo "13. Exit"
	echo 
	echo -n "Enter selection: "
}

installDriver()
{
	clear
	echo "Starting installation"
	echo

	if [ ${numSelected} = "0" ]; then
		echo "No controller components selected. Exiting."
		echo
		exit 1
	fi
	echo "Creating configuration directory..."
	mkdir -p "${CONFIGDIRECTORY}"

	echo "Copying files..."
	
	cp -f $TSHARCDSRC $TSHARCD
	cp -f $TSHARCX11SRC $TSHARCX11
#	cp -fv $CPSCRIPTSRC $CPSCRIPT
	cp -f $CPCONSOLESRC $CPCONSOLE
	cp -f $TSCALSRC $TSCAL
	cp -f $ADDSERIORAWSRC "${CONFIGDIRECTORY}/add_serio_raw"
	cp -f ./sysinfo.sh $CONFIGDIRECTORY

	echo "Setting permissions..."
	
	# The SUID bit is set on the daemon so we can directly access input devices on the system.
	# Setting this SUID bit can be avoided if there are security concerns by starting the boot.tsharc
	# script during SysV initialization.
	# See the readme.txt file for more information on how to do this.
	chmod 4755 $TSHARCD
	chmod 4755 "${CONFIGDIRECTORY}/add_serio_raw"
#	chmod 755 $CPSCRIPT
	chmod 755 $CPCONSOLE
	chmod 755 $TSCAL
	
	
	echo "Preparing configuration file directory..."

	if [ ! -d "${CONFIGDIRECTORY}" ]; then
		echo "${CONFIGDIRECTORY} directory does not exist, creating..."
		mkdir -p ${CONFIGDIRECTORY}
		chmod 777 ${CONFIGDIRECTORY}
	fi

	mkdir -p /var/log/tsharc
	chmod 777 /var/log/tsharc
	touch /var/log/tsharc/tsharc.log
	chmod 666 /var/log/tsharc/tsharc.log

	getTypes

	if [ "0" != $((typesSelected & USB)) ]; then
		if [ ! -f "${CONFIGDIRECTORY}/tsharcusb.conf" ]; then
			echo "tsharcusb.conf configuration file does not exist, creating..."
			touch "${CONFIGDIRECTORY}/tsharcusb.conf"
		fi
		chmod 666 "${CONFIGDIRECTORY}/tsharcusb.conf"

	else
		if [ -f "${CONFIGDIRECTORY}/tsharcusb.conf" ]; then
			echo "tsharcusb.conf configuration file should not exist, removing..."
			rm -f "${CONFIGDIRECTORY}/tsharcusb.conf"
		fi
	fi

	if [ "0" != $((typesSelected & SERIAL)) ]; then
		if [ ! -f "${CONFIGDIRECTORY}/tsharcs.conf" ]; then
			echo "tsharcs.conf configuration file does not exist, creating..."
			touch "${CONFIGDIRECTORY}/tsharcs.conf"
		else
#			rm -f "${CONFIGDIRECTORY}/tsharcs.conf"
			touch "${CONFIGDIRECTORY}/tsharcs.conf"
		fi
		chmod 666 "${CONFIGDIRECTORY}/tsharcs.conf"
	else
		if [ -f "${CONFIGDIRECTORY}/tsharcs.conf" ]; then
			echo "tsharcs.conf configuration file should not exist, removing..."
			rm -f "${CONFIGDIRECTORY}/tsharcs.conf"
		fi
	fi

	
	# create new tsharcs.conf file no matter what is selected.  This will change in next release.
	rm -f "${CONFIGDIRECTORY}/tsharcs.conf"
	touch "${CONFIGDIRECTORY}/tsharcs.conf"
	chmod 666 "${CONFIGDIRECTORY}/tsharcs.conf"


	if [ "0" != $((typesSelected & PS2)) ]; then
		if [ ! -f "${CONFIGDIRECTORY}/tsharcp.conf" ]; then
			echo "tsharcp.conf configuration file does not exist, creating..."
			touch "${CONFIGDIRECTORY}/tsharcp.conf"

		fi
		chmod 666 "${CONFIGDIRECTORY}/tsharcp.conf"
	else
		if [ -f "${CONFIGDIRECTORY}/tsharcp.conf" ]; then
			echo "tsharcp.conf configuration file should not exist, removing..."
			rm -f "${CONFIGDIRECTORY}/tsharcp.conf"
		fi
	fi

	i=0
	while [ $i -lt "$numComponents" ]; do


#	for ((i=0;i<$numComponents;i++)); do
		installSelectedComponent ${i}
		i=$((i+1))
	done

	echo "Creating daemon script"
	echo "#!${CONFIGDIRECTORY}/busybox ash" > ./boottsharcheader	
	echo "CONFIGDIRECTORY=\"${CONFIGDIRECTORY}\"" >> ./boottsharcheader
	echo "PATH=\"${CONFIGDIRECTORY}\"" >> ./boottsharcheader
	cat ./boottsharcbase >> boottsharcheader
	cp -f boottsharcheader $BOOTTSHARCSRC

	echo "Copying busybox utility"
	cp ./busybox "$CONFIGDIRECTORY"
#	ln -s "${CONFIGDIRECTORY}/busybox" "${CONFIGDIRECTORY}/ash"


	echo "Copying add_serio_raw utility"
	cp -f $ADDSERIORAWSRC "${CONFIGDIRECTORY}/add_serio_raw"
	echo "Copying daemon script"
	cp -f $BOOTTSHARCSRC "${CONFIGDIRECTORY}/boot.tsharc"
	chmod 755 "${CONFIGDIRECTORY}/boot.tsharc"

	ln -sf "${CONFIGDIRECTORY}/boot.tsharc" /usr/bin/boot.tsharc

#	echo "Creating menu links"
#	cp -fv *.desktop /usr/share/applications

	echo "Creating uninstall script"

	echo "#!${CONFIGDIRECTORY}/busybox ash" > ./uninstallheader	
	echo "CONFIGDIRECTORY=\"${CONFIGDIRECTORY}\"" >> ./uninstallheader
	echo "PATH=\"${CONFIGDIRECTORY}\"" >> ./uninstallheader
	echo "VERSION=\"${VERSION}\"" >> ./uninstallheader
	cat ./uninstallbase >> uninstallheader
	cp -f uninstallheader $UNINSTALLSRC
	rm -f ./uninstallheader

	echo "Creating System V initialization script"

	echo '#!/bin/bash' > ./registerSysVheader	
	echo "CONFIGDIRECTORY=\"${CONFIGDIRECTORY}\"" >> ./registerSysVheader
	echo "VERSION=\"${VERSION}\"" >> ./registerSysVheader
	cat ./registerSysVbase >> registerSysVheader
	cp -f registerSysVheader registerSysVexample.sh
	rm -f ./registerSysVheader
	chmod 755 registerSysVexample.sh

	echo "Copying uninstall script"
	cp -f $UNINSTALLSRC $CONFIGDIRECTORY
	ln -s "${CONFIGDIRECTORY}/uninstall.sh" /usr/bin/uninstall.sh
	chmod 755 $UNINSTALL
	chmod 755 "${CONFIGDIRECTORY}/uninstall.sh"


	echo "Setting permissions on uninstall script"
	chmod 755 $UNINSTALL

	echo "Installation is complete."
	echo "To have the daemon start automatically after a reboot or for additional information, please look at the readme.txt file which can be found in this directory."
	echo "To start daemon, enter \"boot.tsharc start\" at the command prompt."

}

processInput()
{
	SELECTION=0

	while [ "$SELECTION" != 13 ];
	do
		case "$SELECTION" in
			1) 
				toggleComponent 0
				;;
			2) 
				toggleComponent 1
				;;
			3) 
				toggleComponent 2
				;;
			4) 
				toggleComponent 3
				;;
			5) 
				toggleComponent 4
				;;
			6)
				toggleComponent 5
				;;
			7)
				toggleComponent 6
				;;
			8)
				toggleComponent 7
				;;		
			9)
				toggleComponent 8
				;;
			10)
				if [ "$(uname -a | grep '2.6.')" != "" ]; then

			        RUNSTATUS="$(modprobe serio_raw 2>&1)"

			        if [ "$RUNSTATUS" != "" ]; then
					echo "The SERIO_RAW component was not detected and it may need be added to the kernel."
					echo "Please see ps2readme.txt for more information on how to do this"
					echo
					echo "Press Enter to continue..."
					read
					toggleComponent 9
			        else
					echo "SERIO_RAW successfully detected"
					toggleComponent 9
			        fi

				else
					toggleComponent 9
				fi


#				cp -fv /proc/config.gz /tmp
#				gzip -d /tmp/config.gz
#				if [ $(cat /tmp/config | grep SERIO_RAW | grep -o m) = "m" ]; then
#				elif [ $(cat /tmp/config | grep SERIO_RAW | grep -o y) = "y" ]; then
#					echo "SERIO_RAW successfully detected"
#					toggleComponent 9
#				else
#				fi
#
#				else
#					toggleComponent 9
#
#				fi
#
#				rm -fv /tmp/config
				;;		
			11)
				clear
				printHeader
				echo "Please enter the configuration file directory: "
				read CONFIGDIRECTORY
				set DAEMONINIT=$CONFIGDIRECTORY

				;;		
			12)
				installDriver
				exit 1
				;;

		esac
		sleep 1
		clear
		printInterfaceMenu
		read SELECTION
	done;
	
}

if [ $(id -u) != 0 ]; then
	echo "Root permissions required for this script."
	exit 1
fi

if [ "$(ps -A | grep "tsharcd" | sed -e '/grep/,/grep/d')" != "" ]; then
	echo "Cannot run installation script.  The TSHARC daemon process must first been stopped."
	exit 1
fi

initializeComponents
processInput
