#!/usr/bin/perl

use strict;
use warnings;
use File::Find qw( find );
use Data::Dumper;

my %valid_folders = (
  '/opt/pos/common/gambas' => 1,
  '/opt/pos/common/addons/machine_config' => 1,
  '/opt/pos/lib/App/POS/Hardware' => 1,
  '/opt/pos/lib/App/POS/Machine' => 1,
);

my %words = ();

&find( sub {
  return unless exists $valid_folders{ $File::Find::dir };
  return unless -f $File::Find::name;
  return if $File::Find::name =~ /~$/;
  return if $_ =~ /^\./;

  my $fname = $_;

  open(F, "< $File::Find::name");
  while (<F>) {
    my $line = $_;
    $line =~ s/\n//g;
    $line =~ s/\r//g;

    if ($fname eq 'config_questions_server.txt' || $fname eq 'config_questions_station.txt') {
      my @a = split /=/, $line;
      if (scalar @a) {
        my $word = $a[1];
        
        if (defined $word) {
          $word =~ s/^\s+//;
          $word =~ s/\s+$//;
          $words{$word} = 1;
        }
      }
    }
    elsif ($File::Find::dir !~ /\/opt\/pos\/lib/) {
      my( @a ) = $line =~ /\_\(\"(.*?)\"\)/g;

      for (@a) {
        $words{$_} = 1;
      }
    }
    else {
      my( @a ) = $line =~ /_translated_term\(.*?, \"(.*?)\"\)/g;

      for (@a) {
        $words{$_} = 1;
      }
    }
  }
  close(F);

}, ( "/opt/pos/" ));

if (%words) {
  foreach my $word (sort keys %words) {
    print "$word\n";
  }
}

