#!/usr/bin/perl

use strict;
use warnings;
use FindBin qw( $Bin );
use lib "$Bin/../../lib";
use Data::Dumper;
use App::POS::Config;

my $cfg = App::POS::Config->new( file => "/opt/pos/etc/config.ini" );

my $i = $cfg->load_fixed();

my $cashiers = $i->{Cashiers}->{Cashier} ||= [];

my $idx = 1;
my $info = {};

foreach my $c (@$cashiers) {
  my $station = -1;
  $station = $c->{Station} if exists $c->{Station};

  $c->{Mobile} ||= 0;
  $c->{Description} ||= "";

  $info->{$idx}->{station} = $station;
  $info->{$idx}->{mobile} = $c->{Mobile};
  $info->{$idx}->{description} = $c->{Description};
  $idx++;
}

foreach my $cx_num (sort { $a <=> $b } keys %$info) {
  print $cx_num."»«".$info->{$cx_num}->{station}."»«".$info->{$cx_num}->{description}."\n";
}

