#!/bin/bash

sleep 10

USE_TICKET_SCALE=`cat /opt/pos/etc/config.ini | grep USE_TICKET_SCALE\= | cut -f2 -d=`
HAS_BIZERBA=`cat /opt/pos/etc/config.ini | grep USE_SCALE_CUSTOM_BIZERBA\= | cut -f2 -d=`

if [ "$USE_TICKET_SCALE" = "0" ]; then
  USE_TICKET_SCALE=""
fi

if [ "$HAS_BIZERBA" = "0" ]; then
  HAS_BIZERBA=""
fi

if [ "$USE_TICKET_SCALE" = "" ] && [ "$HAS_BIZERBA" = "" ]; then
  echo "No custom scales, aborting..."
  exit
fi

export DISPLAY=:0.0

while [ 1 ]; do
  RUNNING=""

  if [ "$USE_TICKET_SCALE" != "" ]; then
    RUNNING=`ps xa | grep scale_tickets | grep -v grep`
  fi

  if [ "$HAS_BIZERBA" != "" ]; then
    RUNNING=`ps xa | grep scale_bizerba | grep -v grep`
  fi

  if [ "$USE_TICKET_SCALE" = "1" ] && [ "$RUNNING" = "" ] && [ ! -e "/tmp/stop_scale.txt" ]; then
    if [ -e "/opt/pos/common/addons/scale_tickets/app" ]; then
      echo "Starting scale_tickets app..."

      /opt/pos/common/addons/scale_tickets/app &
    else
      echo "Cant find /opt/pos/common/addons/scale_tickets/app"
    fi
  fi

  if [ "$HAS_BIZERBA" = "1" ] && [ ! -e "/tmp/stop_scale.txt" ]; then
    if [ "$RUNNING" = "" ]; then
      if [ -e "/opt/pos/common/addons/scale_bizerba/app" ]; then
        echo "Starting scale_bizerba app..."
        /opt/pos/common/addons/scale_bizerba/app &
      else
        echo "Cant find /opt/pos/common/addons/scale_bizerba/app"
      fi
    fi

    /opt/pos/common/addons/scale_bizerba/check_integrate
  fi

  echo "Loop..."

  sleep 5
done


