#!/usr/bin/perl

use strict;
use warnings;
use lib "/opt/pos/lib";
use FindBin qw( $Bin );
use Data::Dumper;
use Date::Calc qw(Delta_Days);
use POSIX qw( strftime );
use App::POS::Counters;
use App::POS::Config;
use App::POS::Machine::Server;

my $cfg = App::POS::Config->new(
  file => "$Bin/../../etc/config.ini",
);

my $server = App::POS::Machine::Server->new( config => $cfg );
my $db = $server->database();
my $dbh = $db->dbh();

$db->do(qq{
  DELETE FROM counters
  WHERE updated < NOW() - INTERVAL '10 DAY'
    AND (name = 'products_requested' OR name = 'request_numbers_checks' OR name = 'products_requested_req_number' OR name = 'products_voided' OR name = 'request_numbers' OR name = 'products_voided_qttys')
});

