#!/usr/bin/perl

use strict;
use warnings;
use FindBin qw( $Bin );
use Data::Dumper;
use Date::Calc qw(Delta_Days);
use POSIX qw( strftime );
use BerkeleyDB;

my $cur_date = &strftime("%Y-%m-%d", localtime);

my $db_dir = "/opt/pos/server/data/database";

my %request_numbers;
tie %request_numbers, "BerkeleyDB::Hash", -Filename => "$db_dir/request_numbers.db", -Flags => DB_CREATE
  or die "Cannot open file $db_dir/request_numbers.db: $! $BerkeleyDB::Error\n" ;

my %request_numbers_checks;
tie %request_numbers_checks, "BerkeleyDB::Hash", -Filename => "$db_dir/request_numbers_checks.db", -Flags => DB_CREATE
  or die "Cannot open file $db_dir/request_numbers_checks.db: $! $BerkeleyDB::Error\n" ;

my %products_requested;
tie %products_requested, "BerkeleyDB::Hash", -Filename => "$db_dir/products_requested.db", -Flags => DB_CREATE
  or die "Cannot open file $db_dir/products_requested.db: $! $BerkeleyDB::Error\n" ;

my %products_requested_qttys;
tie %products_requested_qttys, "BerkeleyDB::Hash", -Filename => "$db_dir/products_requested_qttys.db", -Flags => DB_CREATE
  or die "Cannot open file $db_dir/products_requested_qttys.db: $! $BerkeleyDB::Error\n" ;

my %products_voided;
tie %products_voided, "BerkeleyDB::Hash", -Filename => "$db_dir/products_voided.db", -Flags => DB_CREATE
  or die "Cannot open file $db_dir/products_voided.db: $! $BerkeleyDB::Error\n" ;

my %products_voided_qttys;
tie %products_voided_qttys, "BerkeleyDB::Hash", -Filename => $db_dir."/products_voided_qttys.db", -Flags => DB_CREATE
  or die "Cannot open file ".$db_dir."/products_voided_qttys.db: $! $BerkeleyDB::Error\n" ;

my %products_requested_req_number;
tie %products_requested_req_number, "BerkeleyDB::Hash", -Filename => $db_dir."/products_requested_req_number.db", -Flags => DB_CREATE
  or die "Cannot open file ".$db_dir."/products_requested_req_number.db: $! $BerkeleyDB::Error\n" ;

&process(\%request_numbers);
&process(\%request_numbers_checks);
&process(\%products_requested);
&process(\%products_requested_qttys);
&process(\%products_voided);
&process(\%products_voided_qttys);
&process(\%products_requested_req_number);

untie %request_numbers;
untie %request_numbers_checks;
untie %products_requested;
untie %products_requested_qttys;
untie %products_voided;
untie %products_voided_qttys;
untie %products_requested_req_number;

sub process {
  my $info = shift;

  foreach my $k (keys %$info) {
    my $date = "";

    if ($k =~ /#/) {
      my @i = split /#/, $k;
      $date = $i[0];
    }
    else {
      my( $yy, $mm, $dd ) = $k =~ /^(\d\d\d\d)(\d\d)(\d\d)/;

      if (defined $yy) {
        $date = "$yy-$mm-$dd";
      }
    }

    if ($date eq '') {
      print STDERR "Will delete key: $k\n";
      delete $info->{$k};
    }
    else {
      if ($date !~ /^\d\d\d\d\-\d\d\-\d\d$/) {
        #201208290851030.217896853687435

        if ($date =~ /^(\d\d\d\d)(\d\d)(\d\d)/) {
          $date = "$1-$2-$3";
        }
        else {
          print STDERR "INVALID DATE: $date\n";
          next;
        }
      }

      my $days = &_days_between_dates( $cur_date, $date );

      #print STDERR "DAYS: $days\n";

      if ($days > 3) {
        delete $info->{$k};
        print STDERR "Will delete key: $k | days: $days | $date\n";
      }
    }
  }
}

sub _days_between_dates {
  my( $date1, $date2 ) = @_;

  my( $y1, $m1, $d1 ) = $date1 =~ /^(\d+)\-(\d+)\-(\d+)$/;
  my( $y2, $m2, $d2 ) = $date2 =~ /^(\d+)\-(\d+)\-(\d+)$/;

  return Delta_Days(($y2, $m2, $d2), ($y1, $m1, $d1));
}


