package App::POS::Utils;

use App::POS::Config;
use Data::Dumper;
use Number::Format;
use Date::Calc qw( Date_to_Time Delta_Days Add_Delta_Days Today );
use Digest::MD5 qw( md5_hex );
use Encode qw( decode encode );
use Exporter::Easy (
  EXPORT => [qw( translate my_round my_conv date_based_on_closing_hour
    md5_from_file chars
  )]
);

my %TRANSLATION_CACHE = ();
my $NFORMATER = Number::Format->new();

sub my_round {
  my $d = shift;
  my $r = shift || 2;
  return sprintf("%.2f", $NFORMATER->round($d, $r));
}

sub my_conv {
  my $w = shift;
  return "" unless defined $w && $w ne '';

  my $bck = $w;

  eval { decode( 'utf8', $bck, Encode::FB_CROAK ) };

  if ($@) {
    $w =~ s/[^\w ]//g;
    return $w;
  }
  else {
    return $w;
  }
}

sub translate {
  my( $machine, $term ) = @_;

  my $ucterm = uc($term);

  my $dict = 'general';
  my $info = {};

  if (! exists $TRANSLATION_CACHE{$dict}) {
    my $cfg = $machine->config()->load_fixed();
    $cfg->{LANG_TRANSLATION} ||= 'PT';

    my $f = "/opt/pos/etc/i18n/".$cfg->{LANG_TRANSLATION}.".lang";

    if (open(F, "< $f")) {
      while (<F>) {
        s/\n//g;
        s/\r//g;
        next unless $_;
        my @a = split /§/;
        $a[0] =~ s/^\s+//;
        $a[0] =~ s/\s+$//;
        next if $a[0] =~ /^#/;
        $a[1] =~ s/^\s+//;
        $a[1] =~ s/\s+$//;
        $info->{uc($a[0])} = $a[1];
      }
      close(F);
    }

    $TRANSLATION_CACHE{$dict} = $info;
  }
  else {
    $info = $TRANSLATION_CACHE{$dict};
  }

  return exists $info->{$ucterm} ? $info->{$ucterm} : $term;
}

sub date_based_on_closing_hour {
  my $sale_date = shift;
  my $closing   = shift;

  $closing = $closing->[0] if ref($closing);

  my( $y, $m, $d, $h, $mi, $s ) = $sale_date =~ /^(\d+)\-(\d+)\-(\d+) (\d+):(\d+):(\d+)$/;

  my $close = "$y-$m-$d $closing";
  my( $y2, $m2, $d2, $h2, $mi2, $s2 ) = $close =~ /^(\d+)\-(\d+)\-(\d+) (\d+):(\d+):(\d+)$/;

  my $sale_time  = &Date_to_Time( $y, $m, $d, $h, $mi, $s );
  my $close_time = &Date_to_Time( $y2, $m2, $d2, $h2, $mi2, $s2 );

  my $diff = $sale_time - $close_time;

  if ($h2 >= 12) {
    if ($diff > 0) {
      $sale_date =~ s/\s+.*?$//;
      return $sale_date;
    } else {
      #my( $year, $month, $day ) = $sale_date =~ /^(\d+)\-(\d+)\-(\d+)/;
      my ($fy, $fm, $fd) = Add_Delta_Days($y, $m, $d, -1);
      return "$fy-".sprintf("%02d", $fm)."-".sprintf("%02d", $fd);
    }
  } else {
    if ($diff > 0) {
      $sale_date =~ s/\s+.*?$//;
      return $sale_date;
    } else {
      my ($fy, $fm, $fd) = Add_Delta_Days($y, $m, $d, -1);
      return "$fy-".sprintf("%02d", $fm)."-".sprintf("%02d", $fd);
    }
  }

  $sale_date =~ s/\s+.*?$//;
  return $sale_date;
}

sub md5_from_file {
  my $file = shift;

  if (open(F, "< $file")) {
    local $/ = undef;
    my $cnt = <F>;
    close(F);
    return md5_hex($cnt);
  }

  return "";
}

sub chars {
  my $scalar = shift;
  my $num = shift;
  return $scalar unless defined $num;

  my $decoded = decode("utf8", $scalar);

  if (length($decoded) > $num) {
    $decoded = substr($decoded, 0, $num);
  }
  elsif (length($decoded) < $num) {
    my $spaces = $num - length($decoded);
    $decoded .= " " x $spaces;
  }

  $decoded = encode("utf8", $decoded);

  return $decoded;
};

1;

