package App::POS::Printer::STAR_TSP600;

use strict;
use warnings;

use base qw( App::Class );

sub tweak_content {}

sub init {
  my $self = shift;
}

sub logo {
  return
    chr(28).
    chr(112).
    chr(1).
    chr(0);
}

sub document_start {
  return 
    chr(0x1B).
    chr(0x6C).
    chr(0x04).
    chr(0x1B).
    chr(0x1D).
    chr(0x74).
    chr(0x06);
}

sub document_end {
  return "";
}

sub print_invert {
  return
    chr(0x0F);
}

sub print_normal {
  return
    chr(0x12);
}

sub black {
  return
    chr(0x1B).
    chr(0x45);
}

sub red {
  return
    chr(0x1B).
    chr(0x46);
}

sub bold {
  return "";
}

sub size_small {
  return
    chr(0x1B).
    chr(0x4D).
    chr(0x01);
}

sub size_double {
  return
    chr(0x0E);
}

sub size_huge {
  return
    chr(0x0E);
}

sub size_normal {
  return
    chr(0x14);
}

sub underlined {
  return
    chr(0x1B).
    chr(0x2D).
    chr(0x01);
}

sub underlined_off {
  return
    chr(0x1B).
    chr(0x2D).
    chr(0x00);
}

sub line_change {
  return
    chr(0x0A);
}

sub cashdrawer1_open {
  return
    chr(0x07);
}

sub cashdrawer2_open {
  return
    chr(0x1A);
}

sub paper_cut {
  return
    chr(0x1B).
    chr(0x61).
    chr(0x06).
    chr(0x1B).
    chr(0x64).
	chr(0x01);
}

sub bell {
  return "";
}

sub line_spacing_normal {
  return "";
}

sub line_spacing_big {
  return "";
}

sub justify_right {
  return "";
}
sub justify_center {
  return "";
}

sub justify_left {
  return "";
}

# discontinued
sub barcode {
  #return barcode_39();
  return barcode_ean13();
}

# discontinued
sub barcode_small {
  #return barcode_small_39();
  return barcode_small_ean13();
}

# discontinued
sub barcode_big {
  #return barcode_big_39();
  return barcode_big_ean13();
}

sub barcode_ean13 {
  # first line defines barcode height. 3rd char is the height. From 1 to 255.
  return
    chr(29).chr(104).chr(80).chr(0).
    chr(29).chr(107).chr(2)."#BARCODE#".chr(0);
}

sub barcode_small_ean13 {
  return
    chr(29).chr(104).chr(50).chr(0).
    chr(29).chr(107).chr(2)."#BARCODE#".chr(0);
}

sub barcode_big_ean13 {
  return
    chr(29).chr(104).chr(150).chr(0).
    chr(29).chr(107).chr(2)."#BARCODE#".chr(0);
}

sub barcode_39 {
  # first line defines barcode height. 3rd char is the height. From 1 to 255.
  return
    chr(29).chr(104).chr(80).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub barcode_small_39 {
  return
    chr(29).chr(104).chr(50).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub barcode_big_39 {
  return
    chr(29).chr(104).chr(150).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

1;

