package App::POS::Printer::MINIPOS;

use strict;
use warnings;

use base qw( App::Class );

sub tweak_content {
  my $self = shift;
  my $cnt_ref = shift;

  my @lines = split /\n/, $$cnt_ref;
  my $str = "";

  for (@lines) {
    $str .= " ".$_."\n";
  }

  $$cnt_ref = $str;
}

# reset printer - 1B 40

sub logo {
  return "";
}

sub init {
  my $self = shift;
}

sub document_start {
  return "";
}

sub document_end {
  return "";
}

sub print_invert {
  return "";
}

sub print_normal {
  return
    chr(0x1B).
    chr(0x45).
    chr(0x00);
}

sub black {
  return
    chr(0x1B).
    chr(0x45).
    chr(0x00);
}

sub red {
  return "";
  return
    chr(0x1B).
    chr(0x45).
    chr(0x00);
}

sub bold {
  return
    chr(0x1B).
    chr(0x45).
    chr(0x01);
}

sub size_small {
  return
    chr(0x1B).
    chr(0x4D).
    chr(0x01);
}

sub size_double {
  return
    chr(0x1D).
    chr(0x21).
    chr(0x10);
}

sub size_huge {
  return
    chr(0x1D).
    chr(0x21).
    chr(0x10);
}

sub size_normal {
  return
    chr(0x1D).
    chr(0x21).
    chr(0x00);
}

sub underlined {
  return
    chr(0x1B).
    chr(0x2D).
    chr(2);
}

sub underlined_off {
  return
    chr(0x1B).
    chr(0x2D).
    chr(0);
}

sub line_change {
  return "";
}

sub cashdrawer1_open {
  return
    chr(0x1B).
    chr(0x70).
    chr(0x00).
    chr(0x60).
    chr(0xFF);
}

sub cashdrawer2_open {
  return
    chr(0x1B).
    chr(0x70).
    chr(0x01).
    chr(0x60).
    chr(0xFF);
}

sub paper_cut {
  return
    chr(0x1B).
    chr(0x64).
    chr(0x04).
    chr(0x1D).
    chr(0x56).
    chr(49);
}

sub bell {
  return "";
}

sub line_spacing_normal {
  return "";
}

sub line_spacing_big {
  return "";
}

sub justify_right {
  return
    chr(0x1B).chr(0x61).2
}
sub justify_center {
  return
    chr(0x1B).chr(0x61).1;
}

sub justify_left {
  return
    chr(0x1B).chr(0x61).0;
}

sub barcode {
  return (
    chr(0x1D).chr(0x68).chr(162),
    chr(0x1D)."h".chr(50),
    chr(0x1D)."k".chr(4),
    "#BARCODE#".chr(0),
  );
}

sub barcode_small {
  return ();
}

sub barcode_big {
  return ();
}

1;

