package App::POS::Printer::EpsonTM88;

use strict;
use warnings;

use base qw( App::Class );

sub tweak_content {}

sub init {
  my $self = shift;
}

sub logo {
  return
    chr(28).
    chr(112).
    chr(1).
    chr(0);
}

sub document_start {
  return 
    chr(0x1B).
    chr(0x40).
    chr(0x1B).
    chr(0x63).
    chr(0x34).
    chr(0x02).
    chr(0x1B).
    chr(0x74).
    chr(0x03);
}

sub document_end {
  return "";
}

sub print_invert {
  return
    chr(0x1B).
    chr(0x7B).
    chr(0x01);
}

sub print_normal {
  return
    chr(0x1B).
    chr(0x7B).
    chr(0x00);
}

sub black {
  return
    chr(0x1B).
    chr(0x45).
    chr(0x00);
}

sub red {
  return
    chr(0x1B).
    chr(0x45).
    chr(0x01);
}

sub bold {
  return "";
}

sub size_small {
  return
    chr(0x1B).
    chr(0x4D).
    chr(0x01);
}

sub size_double {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x20);
}

sub size_huge {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x71);
}

sub size_normal {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x00);
}

sub underlined {
  return
    chr(0x1B).
    chr(0x2D).
    chr(0x01);
}

sub underlined_off {
  return
    chr(0x1B).
    chr(0x2D).
    chr(0x00);
}

sub line_change {
  return
    chr(0x0D).
    chr(0x0A);
}

sub cashdrawer1_open {
  return
    chr(0x1B).
    chr(0x70).
    chr(0x00).
    chr(0x60).
    chr(0xFF);
}

sub cashdrawer2_open {
  return
    chr(0x1B).
    chr(0x70).
    chr(0x01).
    chr(0x60).
    chr(0xFF);
}

sub paper_cut {
  return
    chr(0x1B).
    chr(0x64).
    chr(0x06).
    chr(0x1B).
    chr(0x69);
}

sub bell {
  return "";
}

sub line_spacing_normal {
  return
    chr(0x1B).
    chr(0x32);
}

sub line_spacing_big {
  return
    chr(0x1B).
    chr(0x33).
    chr(0x60);
}

# discontinued
sub barcode {
  #return barcode_39();
  return barcode_ean13();
}

# discontinued
sub barcode_small {
  #return barcode_small_39();
  return barcode_small_ean13();
}

# discontinued
sub barcode_big {
  #return barcode_big_39();
  return barcode_big_ean13();
}

sub barcode_ean13 {
  # first line defines barcode height. 3rd char is the height. From 1 to 255.
  return
    chr(29).chr(104).chr(80).chr(0).
    chr(29).chr(107).chr(2)."#BARCODE#".chr(0);
}

sub barcode_small_ean13 {
  return
    chr(29).chr(104).chr(50).chr(0).
    chr(29).chr(107).chr(2)."#BARCODE#".chr(0);
}

sub barcode_big_ean13 {
  return
    chr(29).chr(104).chr(150).chr(0).
    chr(29).chr(107).chr(2)."#BARCODE#".chr(0);
}

sub barcode_39 {
  # first line defines barcode height. 3rd char is the height. From 1 to 255.
  return
    chr(29).chr(104).chr(80).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub barcode_small_39 {
  return
    chr(29).chr(104).chr(50).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub barcode_big_39 {
  return
    chr(29).chr(104).chr(150).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub justify_right {
  return
    chr(0x1B).chr(0x61).2
}
sub justify_center {
  return
    chr(0x1B).chr(0x61).1;
}

sub justify_left {
  return
    chr(0x1B).chr(0x61).0;
}

1;

