package App::POS::Printer::EpsonTM295;

use strict;
use warnings;

use base qw( App::Class );

sub init {
  my $self = shift;
}

sub tweak_content {}

sub logo {
  return
    chr(28).
    chr(112).
    chr(1).
    chr(0);
}

sub document_start {
  return
     chr(0x1B).
	 chr(0x43).
	 chr(0xFF).
	 chr(0x1B).
	 chr(0x40).
	 chr(0x1B).
	 chr(0x65).
	 chr(0x01).
	 chr(0x1B).
	 chr(0x63).
	 chr(0x34).
	 chr(0xFF);
}

sub document_end {
  return 
     chr(0x1B).
	 chr(0x46).
	 chr(0x01).
	 chr(0x0C).
	 chr(0x1B).
	 chr(0x71);
}

sub print_invert {
  return
     chr(0x1B).
	 chr(0x7B).
	 chr(0x01);
}

sub print_normal {
  return
     chr(0x1B).
	 chr(0x7B).
	 chr(0x00);
}

sub black {
  return
    chr(0x1B).
    chr(0x72).
    chr(0x00);
}

sub red {
  return
    chr(0x1B).
    chr(0x72).
    chr(0x01);
}

sub bold {
  return "";
}

sub size_small {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x01);
}

sub size_double {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x21);
}

sub size_huge {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x71);
}

sub size_normal {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x21);
}
#    chr(0x00);

sub underlined {
  return
     chr(0x1B).
	 chr(0x21).
	 chr(0x81);
}

sub underlined_off {
  return
     chr(0x1B).
	 chr(0x21).
	 chr(0x01);
}

sub line_change {
  return
     chr(0x0D).
	 chr(0x0A);
}

sub cashdrawer1_open {
  return
     chr(0x1B).
	 chr(0x70).
	 chr(0x00).
	 chr(0x60).
	 chr(0xFF);
}

sub cashdrawer2_open {
  return
     chr(0x1B).
	 chr(0x70).
	 chr(0x01).
	 chr(0x60).
	 chr(0xFF);
}

sub paper_cut {
  return
    chr(0x1B).
    chr(0x64).
    chr(0x04).
    chr(0x1B).
    chr(0x69);
}

sub bell {
  return 
    chr(0x07);
}

sub line_spacing_normal {
  return "";
}

sub line_spacing_big {
  return "";
}

sub barcode {
  return ();
}

sub barcode_small {
  return ();
}

sub barcode_big {
  return ();
}

sub justify_right {
  return
    chr(0x1B).chr(0x61).2
}
sub justify_center {
  return
    chr(0x1B).chr(0x61).1;
}

sub justify_left {
  return
    chr(0x1B).chr(0x61).0;
}

1;

