package App::POS::Printer::ELLIX40;

use strict;
use warnings;

use base qw( App::Class );

sub init {
  my $self = shift;
}

sub tweak_content {}

sub logo {
  return
    chr(28).
    chr(112).
    chr(1).
    chr(0);
}

sub document_start {
  return 
    chr(0x1B).
    chr(0x40).
    chr(0x1B).
    chr(0x63).
    chr(0x34).
    chr(0x02).
    chr(0x1B).
    chr(0x74).
    chr(0x03);
}

sub document_end {
  return "";
}

sub print_invert {
  return
    chr(0x1B).
    chr(0x7B).
    chr(0x01);
}

sub print_normal {
  return
    chr(0x1B).
    chr(0x7B).
    chr(0x00);
}

sub black {
  return
    chr(0x1B).
    chr(0x45).
    chr(0x00);
}

sub red {
  return
    chr(0x1B).
    chr(0x45).
    chr(0x01);
}

sub bold {
  return "";
}

sub size_small {
  return
    chr(0x1B).
    chr(0x4D).
    chr(0x01);
}

sub size_double {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x20);
}

sub size_huge {
  return "";
}

sub size_normal {
  return
    chr(0x1B).
    chr(0x21).
    chr(0x00);
}

sub underlined {
  return
    chr(0x1B).
    chr(0x2D).
    chr(0x01);
}

sub underlined_off {
  return
    chr(0x1B).
    chr(0x2D).
    chr(0x00);
}

sub line_change {
  return
    chr(0x0D).
    chr(0x0A);
}

sub cashdrawer1_open {
  return
    chr(27).
    chr(112).
    chr(0).
    chr(200).
    chr(200);
}

sub cashdrawer2_open {
  return
    chr(27).
    chr(112).
    chr(0).
    chr(200).
    chr(200);
}

sub paper_cut {
  return
    chr(0x1B).
    chr(0x64).
    chr(0x06).
    chr(0x1B).
    chr(0x69);
}

sub bell {
  return "";
}

sub line_spacing_normal {
  return "";
}

sub line_spacing_big {
  return "";
}

sub barcode {
  # first line defines barcode height. 3rd char is the height. From 1 to 255.
  return
    chr(29).chr(104).chr(80).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub barcode_small {
  return
    chr(29).chr(104).chr(50).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub barcode_big {
  return
    chr(29).chr(104).chr(150).chr(0).
    chr(29).chr(107).chr(4)."#BARCODE#".chr(0);
}

sub justify_right {
  return
    chr(0x1B).chr(0x61).2
}
sub justify_center {
  return
    chr(0x1B).chr(0x61).1;
}

sub justify_left {
  return
    chr(0x1B).chr(0x61).0;
}

1;

