package App::POS::Machine::Station;
use strict;
use warnings;
use File::Path qw( make_path );
use File::Copy qw( copy move );
use File::Slurp qw( read_dir );
use Encode qw( decode encode );
use POSIX qw( strftime );
use DBI;
use File::Find qw( find );
use App::POS::DB::Postgres;
use App::POS::Config;
use base qw( App::POS::Machine );
sub init{my$self=shift;
$self->debug("init");
my$c=$self->config()->load();
my$ip=$self->vfh($c,'NETWORK_IP');
my$server_ip=$self->vfh($c,'NETWORK_SERVER_IP');
my$station_number=$self->vfh($c,'STATION_NUMBER');
my$gateway=$self->vfh($c,'NETWORK_GATEWAY');
die"Missing 'NETWORK_SERVER_IP' parameter in config file..." unless defined$server_ip;
die"Missing 'STATION_NUMBER' parameter in config file..." unless defined$station_number;
if(!-d$self->dir_tmp()){make_path($self->dir_tmp());}}sub dir_database{my$self=shift;
return$self->dir_server().'/server/data/database';}sub server_config{my$self=shift;
my$f=$self->dir_server().'/etc/config.ini';
return App::POS::Config->new(file=>$f);}sub register_on_server{my$self=shift;
my$c=$self->config()->load();
$c->{STATION_NAME}||="";
$c->{STATION_CASHIERS}||=[];
my$d=$self->dir_server().'/server/data/registered_stations';
my$ff=$d."/".$self->number();
if(!-d$d){&make_path($d);}my@ips=`/sbin/ifconfig | grep "inet addr" | grep -v "127.0.0.1"`;
open(F,"> $ff")or die"Can't write to $ff : $!";
print F$self->number()."\n";
print F$c->{STATION_NAME}."\n";
print F join(",",@{$c->{STATION_CASHIERS}})."\n";
if(scalar@ips){for(@ips){s/\s+/ /g;
my@t=split/ /;
my$ip="";
for(@t){$ip=$_ if/addr/;}if($ip){$ip=~s/addr\://;
print F"$ip\n";}}}close(F);}sub dir_server{my$self=shift;
return"/shares/pos";}sub number{my$self=shift;
my$c=$self->config()->load();
return$c->{STATION_NUMBER};}sub database_host{my$self=shift;
return$self->server_ip();}sub server_ip{my$self=shift;
my$c=$self->config()->load();
my$server_ip=$self->vfh($c,'NETWORK_SERVER_IP');
return$server_ip;}sub ip{my$self=shift;
$self->debug("ip");
my$c=$self->config()->load();
return$c->{NETWORK_IP};}sub _umount_all{my$self=shift;
while(1){my$mounts=`mount | grep shares/pos | grep -v grep | wc -l`;
chop($mounts);
if($mounts>0){my$umounts=`ps xa | grep umount | grep shares/pos | grep -v grep | wc -l`;
chop($umounts);
if($umounts==0){my$res=system("umount -f -l ".$self->dir_server());
last if$res!=0;}}last if$mounts==0;}}sub mount_server{my$self=shift;
$self->debug("mount_server");
$self->_umount_all();
eval{&make_path($self->dir_server())unless-d$self->dir_server();};
my$str=`mount | grep "/pos on /shares/pos"`;
if($str){$self->debug("mounted already, returning...");
return 1;}my$cmd="/sbin/mount.cifs //".$self->server_ip()."/pos ".$self->dir_server()." -o guest,rw,noperm,noserverino,nobrl";
my$res=`$cmd`;
my$server_tmpl_dir=$self->dir_server().'/common/print_templates';
my$server_cfg_file=$self->dir_server().'/etc/config.ini';
my$server_coord_file=$self->dir_server().'/etc/coordinates.ini';
my$server_db_dir=$self->dir_server().'/server/data/database';
if($res eq ''){$self->register_on_server();}else{$self->debug("Error mounting server: $res");}}sub check_server{my$self=shift;
if(-e"/tmp/server_ok.txt"){return 1;}return 0;}sub setup{my$self=shift;
$self->debug("setup");
$self->__setup_linux();
$self->mount_server();}sub __move_files{my$self=shift;
my($from,$to)=@_;
my@files=();
eval{@files=&read_dir($from);};
for(@files){$self->debug("Will move $_ from $from to $to");
&move("$from/$_","$to/$_");}}sub __setup_linux{my$self=shift;
$self->debug("__setup_linux");
my$c=$self->config()->load();
my$ip=$self->ip();
my$gateway=$self->vfh($c,'NETWORK_GATEWAY');
if(defined$ip&&$ip){if(open(F,"> /etc/network/interfaces")){my$conf="auto lo\n"."iface lo inet loopback\n\n"."auto eth0\n"."iface eth0 inet static\n"."\taddress ".$ip."\n"."\tnetmask 255.255.255.0\n";
if(defined$gateway){$conf.="\tgateway $gateway\n";}print F$conf;
close(F);
system("/etc/init.d/networking restart");}}my$dns1=$self->vfh($c,'NETWORK_DNS1');
my$dns2=$self->vfh($c,'NETWORK_DNS2');
my$dns="";
$dns.="nameserver ".$dns1."\n" if defined$dns1;
$dns.="nameserver ".$dns2."\n" if defined$dns2;
if($dns){if(open(F,"> /etc/resolv.conf")){print F$dns;
close(F);}}}sub __db_file_path{my$self=shift;
my$folder_server=$self->dir_server();
return$folder_server.'/server/data/database/pos.db';}sub apply_sql_file{my$self=shift;
my$files=shift;
$files=[]unless defined$files;
my$db=$self->database_backup();
local$/=undef;
foreach my $file(@$files){open(F,"< $file");
my$data=<F>;
close(F);
my@i=split/\n\t\n/,$data;
my@params=split/#/,$i[1];
my@new_params=();
for(@params){push@new_params,$_ eq 'NULL'?undef:$_;}$self->debug("$file");
eval{$db->do($i[0],@new_params);};
if($@){print STDERR"SQL ERROR!!!! $@\n";}unlink$file;}}1;
