package App::POS::Machine::Server;
use strict;
use warnings;
use Encode qw( from_to decode encode is_utf8 );
use UUID::Tiny;
use File::Slurp qw( read_dir );
use File::Copy qw( copy move );
use File::Path qw( make_path remove_tree );
use File::Remove qw( remove );
use DBI;
use File::Spec;
use File::Find qw( find );
use POSIX qw( strftime );
use Date::Calc qw( Date_to_Time Delta_Days Add_Delta_Days );
use Data::Dumper;
use POSIX qw( ceil );
use Number::Format;
use Benchmark ':hireswallclock';
use IO::Socket;
use Cache::Memcached::Fast;
use App::POS::Check;
use App::POS::Counters;
use App::POS::Utils qw( translate my_round my_conv date_based_on_closing_hour );
my$CLERK_SERIES={};
my%DELIVERY_AREAS=();
my%DID_STOCK_IDS_ALERT=();
my%TRANSLATION_CACHE=();
my$NFORMATER=Number::Format->new();
my$DEBUG_TIMINGS=0;
use base qw( App::POS::Machine );
my%EXTRA_DATA_IGNORE=(has_pzones=>1,internal_print=>1,station_print_checks=>1,was_external_doc=>1,assoc_transport_doc=>1,did_real_hold=>1,custom_table_number=>1,points_total_before=>1,points_current=>1,dont_group_lines=>1,print_to_simplified_invoice=>1,missing_products_to_offer=>1,value_already_offered=>1,);
sub init{my$self=shift;
$self->debug("BUILD");
my$c=$self->config()->load();
my$network_ip=$self->vfh($c,'NETWORK_IP');
my$gateway=$self->vfh($c,'NETWORK_GATEWAY');
if(!-d$self->dir_tmp()){make_path($self->dir_tmp());}if(!-d$self->dir_registered_stations()){make_path($self->dir_registered_stations());}if(!-d$self->dir_registered_printers()){make_path($self->dir_registered_printers());}if(!-d$self->dir_opened_cashiers()){make_path($self->dir_opened_cashiers());}my$memc=Cache::Memcached::Fast->new({servers=>[{address=>$self->server_ip().':11211',weight=>1},],namespace=>'pos_files:',connect_timeout=>0.1,io_timeout=>0.1,close_on_error=>1,compress_threshold=>-1,compress_ratio=>0,max_failures=>3,failure_timeout=>1,nowait=>1,hash_namespace=>1,serialize_methods=>[\&JSON::encode_json,\&JSON::decode_json],});
$self->{_memc}=$memc;}sub server_ip{"127.0.0.1"}sub dir_server{my$self=shift;
return$self->dir();}sub dir_registered_stations{my$self=shift;
return$self->dir_server().'/server/data/registered_stations';}sub dir_opened_cashiers{my$self=shift;
return$self->dir_server().'/server/data/opened_cashiers';}sub dir_queues{my$self=shift;
return$self->dir_server().'/server/data/queues';}sub dir_registered_printers{my$self=shift;
return$self->dir_server().'/server/data/registered_stations';}sub dir_database{my$self=shift;
return$self->dir().'/server/data/database';}sub dir_apps{my$self=shift;
return$self->dir().'/server/apps';}sub registered_stations{my$self=shift;
my@stations=&read_dir($self->dir_registered_stations());
return\@stations;}sub database_host{return"127.0.0.1";}sub ip{my$self=shift;
$self->debug("ip");
my$c=$self->config()->load();
return$c->{NETWORK_IP};}sub setup{my$self=shift;
$self->debug("setup");
if($^O eq 'MSWin32'){$self->__setup_win32();}else{$self->__setup_linux();}}sub integrate_check_in_db{my$self=shift;
my$file=shift;
my$products=shift;
my$clerks=shift;
my$check=shift;
my$t1=new Benchmark;
my$cnt=0;
my$db=$self->database();
my$dbh=$db->dbh();
my$db_dir=$self->dir_database();
my$c=$self->config()->load_fixed();
my$pt_certified_software=-e$self->dir()."/common/skins/".$c->{LANG}."/sign_server"?1:0;
if(!scalar keys%$CLERK_SERIES){my$recs=$db->select("SELECT id, serie FROM clerks WHERE deleted = 0");
map{$CLERK_SERIES->{$_->{id}}=$_->{serie}}@$recs;}$c->{LOG_POS_USAGE}||=0;
$c->{KEEP_TABLE_NAMES_ON_CLOSE}||=0;
$c->{VOIDS_REGISTER}||=0;
$c->{PRODUCTS_SUGESTION}||=0;
$c->{PRODUCTS_SUGESTION_AUTO}||=0;
$c->{PRODUCTS_SUGESTION_EXTRAS_ONLY}||=0;
$c->{DOC_NUMBERS_USE_SERIE}||=0;
$c->{DOC_TYPE_SERIE}||=0;
$c->{MINIMAL_CONSUMPTION_PRODUCT}||="";
$c->{POINTS_USAGE}||=0;
$c->{POINTS_VALUE_PER_POINT}||=0;
my$mc_product_id=undef;
if($c->{MINIMAL_CONSUMPTION_PRODUCT}ne ''){if(!exists$self->{__mc_product_id}){my$r=$db->select("SELECT id FROM products WHERE name = ? AND deleted = 0",$c->{MINIMAL_CONSUMPTION_PRODUCT});
$self->{__mc_product_id}=$r->[0]->{id}if scalar@$r;
$mc_product_id=$self->{__mc_product_id};}else{$mc_product_id=$self->{__mc_product_id};}}my$daily_specials=$self->daily_specials();
my$query="";
my$media_ignore="Change";
$c->{CHECK_MONEY_CHANGE_TEXT}||="";
if($c->{CHECK_MONEY_CHANGE_TEXT}){$media_ignore=&translate($self,$c->{CHECK_MONEY_CHANGE_TEXT});}my$external_doc="";
my$lang=$self->vfh($c,'LANG');
print STDERR"INTEGRATE: $file\n";
my$data=$check->data();
my$cur_date=$check->business_date();
$cur_date=~s/\-//g;
my$h=$data->{header}||[];
my$details=$data->{details}||[];
my$details_deleted=$data->{details_deleted}||[];
my$footers=$data->{footers}||[];
my$info={};
my$check_value=$h->[19];
if(!scalar@$footers||(scalar@$footers==1&&!scalar@{$footers->[0]})){print STDERR"footers\n";
push@{$footers},[&translate($self,"DINHEIRO"),$check_value,'',];}if((!scalar@$details||(scalar@$details==1&&!scalar@{$details->[0]}))&&(!scalar@$details_deleted||(scalar@$details_deleted==1&&!scalar@{$details_deleted->[0]}))){print STDERR"details\n";
return undef;}my$check_hour=&strftime("%H:%M:%S",localtime);
my$business_date=$check->business_date();
my$table_number=$check->table_number();
my$extra_data=$check->extra_data();
my$custom_invoice_id=exists$extra_data->{invoice_id}?$extra_data->{invoice_id}:"";
my$cdd=&strftime("%Y-%m-%d",localtime);
my$cdh=$check_hour;
my$close_date="$cdd $cdh";
$table_number=-1 if$table_number!~/^\d+$/;
$extra_data->{original_table_number}||='';
if($extra_data->{original_table_number}&&$extra_data->{original_table_number}=~/^\d+$/){$table_number=$extra_data->{original_table_number}if$extra_data->{original_table_number};}my$orig_table_number=$table_number;
my$doc_type="";
my$mult=1;
$doc_type=$h->[8];
my$clerk_serie=1;
if(exists$CLERK_SERIES->{$h->[3]}){$clerk_serie=$CLERK_SERIES->{$h->[3]};}my$doc_serie="";
my$doc_serie_config="";
if($c->{DOC_TYPE_SERIE}){my$year=&strftime("%y",localtime);
$doc_serie=$c->{DOC_TYPE_SERIE};
$doc_serie=~s/\@YEAR\@/$year/g;
$doc_serie.=$clerk_serie;
$doc_serie_config=$doc_serie;}else{$doc_serie=strftime("%y",localtime).$clerk_serie;}if($doc_type==7){if(!exists$extra_data->{invoice_is_payed}||$extra_data->{invoice_is_payed}==0){$doc_serie.="C";}else{$doc_serie.="P";}}if(exists$extra_data->{manualdoc_type}){if($extra_data->{manualdoc_type}eq 'manual'){$doc_serie=$doc_serie."M";}else{$doc_serie=$doc_serie."R";}}my$t1_1=new Benchmark;
print STDERR"Server> INTEGRATE CHECK 1.1:".timestr(timediff($t1_1,$t1))."\n" if$DEBUG_TIMINGS;
my$areas_validation=$self->_areas_with_validation_required();
if(scalar@$h){my$doc_counters=App::POS::Counters->new(db=>$db,name=>'doc_counters',);
my$doc_hashes=App::POS::Counters->new(db=>$db,name=>'doc_hashes',);
my$products_suggest=App::POS::Counters->new(db=>$db,name=>'products_suggest',);
if(-d$self->dir()."/server/data/day_change"&&-e$self->dir()."/server/data/day_change/$business_date.export"){my($year,$month,$day)=$business_date=~/^(\d+)\-(\d+)\-(\d+)$/;
my($y,$m,$d)=Add_Delta_Days($year,$month,$day,1);
$h->[23]="$y-$m-$d";}my$t1_2=new Benchmark;
print STDERR"Server> INTEGRATE CHECK 1.2:".timestr(timediff($t1_2,$t1_1))."\n" if$DEBUG_TIMINGS;
my@customer=();
my$training_mode=-e$self->dir_server()."/training_mode.txt"?1:0;
if($training_mode){$doc_type=99;}my$doc_types=$self->config()->doc_types_by_id();
my$doc_type_str=$doc_types->{$doc_type};
if($h->[8]==2||$h->[8]==13||$h->[8]==14||$h->[8]==33){$mult=-1;}elsif($h->[8]==3){if($c->{VOIDS_REGISTER}==0){print STDERR"We're not registering VOIDs, returning...\n";
return;}}my$fo_doc_number=$doc_type_str;
if($training_mode){$external_doc="999";
$fo_doc_number.="999";}else{if($h->[20]){$external_doc=$h->[20];}}my$bdate=$self->{_memc}->get('last_sale_date#'.$doc_type."#".$doc_serie_config);
my$t1_3=new Benchmark;
print STDERR"Server> INTEGRATE CHECK 1.3:".timestr(timediff($t1_3,$t1_2))."\n" if$DEBUG_TIMINGS;
if($pt_certified_software){my$rr=[];
if(!defined$bdate){$rr=$db->select(qq{
          SELECT MAX(date_closed) AS date_closed
          FROM sales_headers
          WHERE doc_type = ? AND doc_serie = ?
        },$doc_type,$doc_serie);
if(scalar@$rr&&$rr->[0]->{date_closed}ne ''){my($date_closed)=$rr->[0]->{date_closed}=~/^(.*?) /;
$self->{_memc}->set('last_sale_date#'.$doc_type."#".$doc_serie_config,$date_closed);
$rr=[{business_date=>$date_closed}];}}else{push@$rr,{business_date=>$bdate};}if(scalar@$rr&&defined$rr->[0]->{business_date}){if($cdd ne$rr->[0]->{business_date}){my($year2,$month2,$day2)=$cdd=~/^(\d+)\-(\d+)\-(\d+)/;
my($year1,$month1,$day1)=$rr->[0]->{business_date}=~/^(\d+)\-(\d+)\-(\d+)/;
my$ress=Delta_Days($year1,$month1,$day1,$year2,$month2,$day2);
if($ress<0){my$str="****************************************\n".&translate($self,"JÁ EXISTE UMA VENDA COM DATA POSTERIOR")."\n"."****************************************\n".&translate($self,"ÚLTIMO REGISTO EFETUADO EM").": ".$rr->[0]->{business_date}."\n"."****************************************\n".&translate($self,"TENTATIVA DE INTEGRAR NA DATA").": ".$cdd."\n"."****************************************\n".&translate($self,"VERIFICAR SE O RELÓGIO ESTÁ CORRECTO");
open(F,"> /opt/pos/common/tmp/printer_screen.txt");
print F$str;
close(F);
print STDERR"Check business_date is lower than LAST business date, ignoring...\n";
return undef;}}}}$self->{_memc}->set('last_sale_date#'.$doc_type."#".$doc_serie_config,$cdd);
my$station_closed=$h->[5];
$doc_serie=~s/\@STATION_NUMBER\@/$station_closed/g;
$doc_serie=~s/\-//g;
my$t1_4=new Benchmark;
print STDERR"Server> INTEGRATE CHECK 1.4:".timestr(timediff($t1_4,$t1_3))."\n" if$DEBUG_TIMINGS;
my$doc_counter_key=$doc_type_str.'#'.$external_doc.'#'.$doc_serie;
my$previous_hash="";
my$dnumber=$doc_counters->cur_value($doc_counter_key);
my$t1_5=new Benchmark;
print STDERR"Server> INTEGRATE CHECK 1.5:".timestr(timediff($t1_5,$t1_4))."\n" if$DEBUG_TIMINGS;
if(defined$dnumber&&$dnumber){$previous_hash=$doc_hashes->cur_value($doc_counter_key);}else{$doc_counters->set_value($doc_counter_key,1);
$dnumber=1;
$previous_hash="";}my$doc_number=$dnumber;
my$str="";
my@chars=();
$fo_doc_number.=" ".$doc_serie."/".$doc_number;
my$t2=new Benchmark;
print STDERR"Server> INTEGRATE CHECK ATE SIGN_STRING:".timestr(timediff($t2,$t1_5))."\n" if$DEBUG_TIMINGS;
my$hash_check_value=$check_value;
if(exists$extra_data->{manualdoc_total_w_vat}){$extra_data->{manualdoc_total_w_vat}||=0;
$hash_check_value=$extra_data->{manualdoc_total_w_vat}*1;}if($pt_certified_software){my$str_to_sign=$business_date.";".$cdd."T".$cdh.";".$fo_doc_number.";".sprintf("%.02f",$hash_check_value).";".$previous_hash;
my$socket=IO::Socket::INET->new(PeerAddr=>'127.0.0.1',PeerPort=>8050,Proto=>"tcp",);
if(!defined$socket){print STDERR"!!!! Couldn't connect to SIGN server !!!!\n";
my$sign_app="";
if(-e$self->dir()."/common/skins/".$c->{LANG}."/sign_server.src"){$sign_app=$self->dir()."/common/skins/".$c->{LANG}."/sign_server.src";}else{$sign_app=$self->dir()."/common/skins/".$c->{LANG}."/sign_server";}$str=`$sign_app --cli --string=\"$str_to_sign\"`;}else{print$socket "--string=\"".$str_to_sign."\"\n";
$str=<$socket>;
$socket->close();}chop($str);
@chars=&_get_sign_chars(signature=>$str);}my$t3=new Benchmark;
print STDERR"Server> INTEGRATE CHECK DEPOIS SIGN_STRING".($cnt++).":".timestr(timediff($t3,$t2))."\n" if$DEBUG_TIMINGS;
my$clerk_open_name=exists$clerks->{$h->[2]}?$clerks->{$h->[2]}->{login}:'UNKNOWN';
my$clerk_close_name=exists$clerks->{$h->[3]}?$clerks->{$h->[3]}->{login}:'UNKNOWN';
if($business_date!~/^\d\d\d\d\-\d\d\-\d\d$/){print STDERR"Invalid business date: $business_date, returning...\n";
return;}my$cashier=$self->_decode_sale_cashier($c,$clerks,$h->[5],$h->[3]);
my$new_id=$db->next_id("sales_headers");
my$inserted_id=$new_id;
if($custom_invoice_id ne ''){$h->[12]=$custom_invoice_id;}my$service_charge=$h->[17]||0;
$service_charge=0 if$service_charge<0;
my$check_name=$check->name();
$extra_data->{check_name}=$check_name if$check_name;
my$customer_id=$h->[11]||0;
my$customer_name=$h->[12];
my$customer_nif=$h->[13]||0;
my$overrided_customer_id=0;
my$overrided_customer_name="";
my$overrided_customer_nif="";
$extra_data->{override_customer_id}||=0;
$info->{headers}={__unique_id=>$h->[-1],gb_identifier=>$h->[-1],to_print=>$check->to_print(),points_used=>$extra_data->{points_used}||0,id=>$inserted_id,table_number=>$table_number,date=>$h->[0],business_date=>$check->business_date(),date_closed=>$close_date,hour=>$check_hour,doc_type=>$doc_type,fo_doc_number=>$fo_doc_number,value=>$check_value,discount=>$h->[10],clerk_open=>$h->[2],clerk_close=>$h->[3],station_open=>$h->[4],station_close=>$h->[5],area=>$h->[7],meals=>$h->[14],hash=>$str,hash_small=>join("",@chars),clerk_open_name=>$clerk_open_name,clerk_close_name=>$clerk_close_name,customer_id=>$customer_id,customer=>$customer_name,customer_nif=>$customer_nif||"",customer_credit=>undef,persons_number=>$h->[15],tip=>$h->[16]||0,service_charge=>$service_charge,check_name=>$check_name,external_doc=>$external_doc,custom_invoice_id=>$custom_invoice_id,doc_counter_key=>$doc_counter_key,training_mode=>$training_mode,};
my$t3_1=new Benchmark;
my$update_customer=0;
if(exists$data->{extra_data}->{carwash_customer_plate}){$info->{headers}->{customer_aux}=$data->{extra_data}->{carwash_customer_plate};
$update_customer=1;}else{$info->{headers}->{customer_aux}="";}if(exists$data->{extra_data}->{carwash_customer_contact}){$info->{headers}->{customer_contact}=$data->{extra_data}->{carwash_customer_contact};
$update_customer=1;}else{$info->{headers}->{customer_contact}="";}my$db_customer_id=undef;
my$db_customer_nif=undef;
my$db_customer_name=undef;
my$db_customer_info={};
if($info->{headers}->{customer_nif}){my$check=$db->select("SELECT * FROM customers WHERE UPPER(nif) = ? ORDER BY deleted",uc($info->{headers}->{customer_nif}),);
if(scalar@$check){$db_customer_id=$check->[0]->{id};
$db_customer_nif=$check->[0]->{nif};
$db_customer_name=$check->[0]->{name};
$db_customer_info=$check->[0];}else{if($info->{headers}->{customer}){my$check=$db->select("SELECT * FROM customers WHERE UPPER(name) = ? AND nif = '' ORDER BY deleted",uc($info->{headers}->{customer}),);
if(scalar@$check){$db_customer_id=$check->[0]->{id};
$db_customer_nif=$check->[0]->{nif};
$db_customer_name=$check->[0]->{name};
$db_customer_info=$check->[0];}}}}elsif($info->{headers}->{customer}&&!$info->{headers}->{customer_nif}){my$check=$db->select("SELECT * FROM customers WHERE UPPER(name) = ? ORDER BY deleted",uc($info->{headers}->{customer}));
if(scalar@$check){$db_customer_id=$check->[0]->{id};
$db_customer_nif=$check->[0]->{nif};
$db_customer_name=$check->[0]->{name};
$db_customer_info=$check->[0];}}if(defined$db_customer_id){$info->{headers}->{customer_id}=$db_customer_id;
$info->{headers}->{customer_credit}=$db_customer_info->{total_credit};
$info->{headers}->{customer_address}=$db_customer_info->{address};
$info->{headers}->{customer_postal_code}=$db_customer_info->{postal_code};
$info->{headers}->{customer_city}=$db_customer_info->{city};
$info->{headers}->{customer_contact}=$db_customer_info->{contact};
$info->{headers}->{customer_aux}=$db_customer_info->{aux};
$info->{headers}->{customer_card_number}=$db_customer_info->{card_number};
$info->{headers}->{customer_days_to_pay}=$db_customer_info->{days_to_pay};
if($info->{headers}->{customer}){if($info->{headers}->{customer}ne$db_customer_name){$db->do("UPDATE customers SET name = ? WHERE id = ?",$info->{headers}->{customer},$db_customer_id);}if($info->{headers}->{customer_nif}ne$db_customer_nif){$db->do("UPDATE customers SET nif = ? WHERE id = ?",$info->{headers}->{customer_nif},$db_customer_id);}}}else{if($info->{headers}->{customer}||$info->{headers}->{customer_nif}){my$id=$db->next_id("customers");
if($id<1000000){$id+=1000000;}$db->do("INSERT INTO customers (id, name, nif, deleted, contact, aux) VALUES (?, ?, ?, ?, ?, ?)",$id,&my_conv($info->{headers}->{customer}),$info->{headers}->{customer_nif},0,&my_conv($info->{headers}->{customer_contact}),&my_conv($info->{headers}->{customer_aux}));
$info->{headers}->{customer_id}=$id;}}my@params=($new_id,$close_date,$h->[0],$close_date,$check->business_date(),$check_hour,$doc_type,$fo_doc_number,$check_value*$mult,$h->[9],$h->[2],$h->[3],$h->[4],$h->[5],$h->[7],&my_conv($clerk_open_name),&my_conv($clerk_close_name),$info->{headers}->{customer}||'',$info->{headers}->{customer_nif}||0,$h->[15]||0,$h->[16]||0,$service_charge,$cashier,$table_number,$h->[-1],$clerk_serie,$info->{headers}->{customer_id}||0,$doc_serie_config,);
print STDERR"------------------ ANTES HEADERS...\n" if$DEBUG_TIMINGS;
$dbh->do(qq{
      COPY sales_headers (
        id, timestamp, date, date_closed, business_date, hour, doc_type, fo_doc_number, value,
        discount, clerk_open, clerk_close, station_open, station_close, area, clerk_open_name,
        clerk_close_name, customer, customer_nif, persons_number, tip, service_charge, cashier,
        table_num, gb_identifier, serie, customer_id, doc_serie
      ) FROM stdin
    });
$dbh->pg_putline(join("\t",@params)."\n");
$dbh->pg_endcopy;
print STDERR"------------------ DEPOIS HEADERS...\n" if$DEBUG_TIMINGS;
print STDERR"------------------ ANTES document_operations...\n" if$DEBUG_TIMINGS;
if(exists$extra_data->{assoc_transport_doc}&&$extra_data->{assoc_transport_doc}){my%used_prods=map{$_->[1]=>1}@$details;
my@ids=keys%used_prods;
if(scalar@ids){my$where_str=" AND sd.product IN (".join(",",@ids).")";
my$gt_products=$db->select(qq{
          SELECT sd.product
          FROM sales_details sd
          LEFT JOIN sales_headers sh ON (sd.header = sh.id)
          WHERE sh.gb_identifier = ?$where_str
          GROUP BY sd.product
        },$extra_data->{assoc_transport_doc});
if(scalar@$gt_products){$db->do("INSERT INTO document_operations VALUES (?, ?, 0)",$extra_data->{assoc_transport_doc},$h->[-1]);}}}print STDERR"------------------ DEPOIS document_operations...\n" if$DEBUG_TIMINGS;
my$points_customer_id=undef;
if($extra_data->{override_customer_id}){$points_customer_id=$extra_data->{override_customer_id};}elsif($info->{headers}->{customer_id}){$points_customer_id=$info->{headers}->{customer_id};}if($c->{POINTS_USAGE}&&defined$points_customer_id&&$c->{POINTS_VALUE_PER_POINT}){my$hcid=$info->{headers}->{customer_id}||0;
if($points_customer_id!=$hcid){my$cust=$db->select("SELECT id, name, nif FROM customers WHERE id = ? ORDER BY deleted",$points_customer_id);
if(scalar@$cust){$info->{headers}->{points_customer_name}=$cust->[0]->{name};
$info->{headers}->{points_customer_id}=$cust->[0]->{id};
$info->{headers}->{points_customer_nif}=$cust->[0]->{nif};}}else{$info->{headers}->{points_customer_name}=$info->{headers}->{customer};
$info->{headers}->{points_customer_id}=$info->{headers}->{customer_id};
$info->{headers}->{points_customer_nif}=$info->{headers}->{customer_nif};}if($info->{headers}->{doc_type}==1||$info->{headers}->{doc_type}==5||$info->{headers}->{doc_type}==90||$info->{headers}->{doc_type}==7){if(!exists$extra_data->{points_used}){my$points=int($info->{headers}->{value}/$c->{POINTS_VALUE_PER_POINT});
$points||=0;
if($points){$info->{headers}->{points_assigned}=$points;
$extra_data->{points_assigned}=$points;
$extra_data->{points_current}||=0;
$info->{headers}->{points_current}=$extra_data->{points_current}+$extra_data->{points_assigned};
$db->do("UPDATE customers SET points = points + $points WHERE id = ?",$points_customer_id,);}}else{$extra_data->{points_current}||=0;
$info->{headers}->{points_current}=$extra_data->{points_current}-$extra_data->{points_used};
$info->{headers}->{points_current}=0 if$info->{headers}->{points_current}<0;}}}print STDERR"------------------ ANTES HEADERS AUX...\n" if$DEBUG_TIMINGS;
my%did_extra_data=();
foreach my $k(keys%$extra_data){next if exists$EXTRA_DATA_IGNORE{$k};
next unless defined$extra_data->{$k}&&$extra_data->{$k}ne '';
next if exists$did_extra_data{$k};
next if$k eq 'original_area'&&$extra_data->{$k}eq$h->[7];
next if$k eq 'original_table_number'&&$extra_data->{$k}eq$orig_table_number;
my$id=$db->next_id("sales_headers_aux");
$dbh->do("COPY sales_headers_aux (id, header, key_name, key_value) FROM stdin");
$dbh->pg_putline("$id\t$inserted_id\t".&my_conv($k)."\t".&my_conv($extra_data->{$k})."\n");
$dbh->pg_endcopy;
$did_extra_data{$k}=1;}print STDERR"------------------ DEPOIS HEADERS AUX...\n" if$DEBUG_TIMINGS;
$extra_data->{obs}||="";
my$t4=new Benchmark;
print STDERR"Server> INTEGRATE CHECK DEPOIS SALES_HEADERS ".($cnt++).":".timestr(timediff($t4,$t3_1))."\n" if$DEBUG_TIMINGS;
$info->{details}=[];
$info->{payments}=[];
my$dbh=$db->dbh();
my%stock_ids=();
my$stock_products=$self->_stock_products();
print STDERR"------------------ ANTES SALES DETAILS...\n" if$DEBUG_TIMINGS;
$dbh->do(qq{
      COPY sales_details (
        header, product, hour, quantity, price, discount, offer, vat, clerk, station,
        operation_type, product_name, clerk_name, free_text, price_wo_vat, inside_menu,
        gb_identifier, department, price_used, business_date, had_bill
      ) FROM stdin
    });
my$idx=0;
my$global_discount_percent=0;
my$global_discount=0;
if($h->[10]){if($h->[10]=~/\%$/){$global_discount_percent=1;
($global_discount)=$h->[10]=~/^(.*?)\%$/;}else{$global_discount=$h->[10];}}my@add_details_aux=();
my%prod_ids=();
my$value_net=0;
my@suggestions_collected=();
if($c->{LOG_POS_USAGE}){open(NN,">> /opt/pos/server/data/checks_integration.log");
print NN"[".&strftime("%Y%m%d_%H%M%S",localtime)."][DETAILS] ".$check->business_date().",$fo_doc_number,$orig_table_number,$doc_type,".$check_value.",".scalar(@$details).",".$h->[-1]."\n";
close(NN);}my$total_discounts_in_lines=0;
if(!$global_discount_percent&&$global_discount>0){foreach my $d(@$details){next unless scalar@$d;
next unless defined$d->[3];
my$discount=$d->[5]||0;
my$vat=$d->[6]||0;
my$qtty=$d->[3]*$mult;
if($vat>0){$total_discounts_in_lines+=($discount*$qtty)*(1+$vat/100);}}}foreach my $d(@$details){next unless scalar@$d;
next unless defined$d->[3];
$d->[14]||=0;
my$clerk_name=exists$clerks->{$d->[7]}?$clerks->{$d->[7]}->{login}:'UNKNOWN';
my$free_text=$d->[13];
$free_text=~s/\\/\\\\/g;
my$op_type=1;
my$product_name='UNKNOWN';
my$department='UNKNOWN';
if(exists$products->{$d->[1]}){$product_name=$products->{$d->[1]}->{name};
if(defined$mc_product_id&&$mc_product_id==$d->[1]){if($h->[21]){$product_name.=" ".$h->[21]}}my$fam_name=$products->{$d->[1]}->{family_name}||"";
my$subfam_name=$products->{$d->[1]}->{subfamily_name}||"";
if($fam_name&&$subfam_name){$department=&my_conv($fam_name)."§".&my_conv($subfam_name);}elsif($fam_name&&!$subfam_name){$department=&my_conv($fam_name)."§UNKNOWN";}elsif(!$fam_name&&$subfam_name){$department="UNKNOWN§".&my_conv($subfam_name);}}if($c->{PRODUCTS_SUGESTION_AUTO}){push@suggestions_collected,$d;}my$discount_orig=0;
my$qtty=$d->[3]*$mult;
my$discount=$d->[5]||0;
my$line_discount=0;
my$disc=0;
my$offer=0;
my$v1=0;
my$gdiscount=0;
my$PIVA=$d->[6];
my$PCI=$d->[4];
my$PSI=$PCI/(1+$PIVA/100);
my$VDU=$discount;
my$PU=$PSI-$VDU;
my$PL=$PU*$qtty;
my$VIVA=$PL*($PIVA/100);
if($global_discount_percent){$discount+=($PSI-$discount)*($global_discount/100);}elsif($global_discount>0){my$check_total_no_discounts=$info->{headers}->{value}+$global_discount+$total_discounts_in_lines;
my$disc_w_vat=$discount*(1+$PIVA/100);
my$racio=$global_discount/$check_total_no_discounts;
my$next=($PCI-$disc_w_vat)-($PCI*$racio);
my$discccc=$PCI-$next;
$discccc=$discccc/(1+$PIVA/100);
$discount=$discccc;}$d->[4]||=0;
$d->[16]||=1;
$d->[2]=~s/\-/:/g;
$prod_ids{$d->[1]}=1;
if(exists$stock_products->{$d->[1]}){if($op_type==1){if($info->{headers}->{doc_type}==1||$info->{headers}->{doc_type}==5||$info->{headers}->{doc_type}==90||$info->{headers}->{doc_type}==2||$info->{headers}->{doc_type}==4||$info->{headers}->{doc_type}==10||$info->{headers}->{doc_type}==11||$info->{headers}->{doc_type}==13||$info->{headers}->{doc_type}==12||$info->{headers}->{doc_type}==15){$stock_ids{$d->[1]}+=$qtty;}elsif($info->{headers}->{doc_type}==7&&!exists$extra_data->{invoiced}){$stock_ids{$d->[1]}+=$qtty;}}}my$sem_iva=$qtty*$PSI;
my$desconto_sem_iva=$qtty*$discount;
my$net_v=($sem_iva-$desconto_sem_iva);
$value_net+=$net_v;
my$gbi=$d->[-1];
my$had_bill=$self->{_memc}->get('gbi_had_bill#'.$gbi);
$had_bill||=0;
my@params=($inserted_id,$d->[1],$d->[2],$qtty,$d->[4],$discount,$offer,$d->[6],$d->[7],$d->[12],$op_type,&my_conv($product_name),&my_conv($clerk_name),&my_conv($free_text),$PSI,$d->[14],$gbi,$department,$d->[16]||1,$check->business_date(),$had_bill,);
map{tr/\\\t\n/   /;}@params;
push@add_details_aux,{header=>$inserted_id,product_id=>$d->[1],gb_identifier=>$gbi,};
push@{$info->{details}},{product=>$d->[1],hour=>$d->[2],quantity=>$d->[3],price=>$d->[4],price_wo_vat=>$PSI,discount=>$discount,global_discount=>$gdiscount,offer=>$offer,vat=>$d->[6],clerk=>$d->[7],station=>$d->[12],product_name=>$product_name,clerk_name=>$clerk_name,free_text=>$free_text,product_type=>$d->[13],idx=>$idx,gb_identifier=>$gbi,};
$idx++;
$dbh->pg_putline(join("\t",@params)."\n");}$dbh->pg_endcopy;
print STDERR"------------------ DETAILS SALES DETAILS...\n" if$DEBUG_TIMINGS;
my$id=&create_UUID_as_string();
$dbh->do("COPY sales_hashes (id, header, gb_identifier_header, business_date, system_entry_date, fo_doc_number, "."value, hash, hash_small, doc_type, value_net, clerk_close, customer_id, serie) FROM stdin");
$info->{headers}->{customer_id}||=0;
$info->{headers}->{value_net}=$value_net;
my@tmp_arr=split/\s/,$info->{headers}->{date_closed};
$info->{headers}->{value_net}=0 if$info->{headers}->{value}*1==0;
$dbh->pg_putline("$id\t".$info->{headers}->{id}."\t".$info->{headers}->{gb_identifier}."\t".$info->{headers}->{business_date}."\t".$tmp_arr[0]."T".$tmp_arr[1]."\t".$info->{headers}->{fo_doc_number}."\t".$info->{headers}->{value}."\t".$info->{headers}->{hash}."\t".$info->{headers}->{hash_small}."\t".$info->{headers}->{doc_type}."\t".$info->{headers}->{value_net}."\t".$info->{headers}->{clerk_close}."\t".$info->{headers}->{customer_id}."\t".$clerk_serie."\n");
$dbh->pg_endcopy();
$doc_hashes->set_value($info->{headers}->{doc_counter_key},$info->{headers}->{hash});
if($pt_certified_software){if($info->{headers}->{doc_type}==2){$dbh->do("COPY sales_hashes_products (hash_id, gb_identifier_detail, business_date, product_id, "."price, price_wo_vat, quantity, discount, vat) FROM stdin");
foreach my $d(@{$info->{details}}){$dbh->pg_putline("$id\t$d->{gb_identifier}\t".$info->{headers}->{business_date}."\t$d->{product}\t"."$d->{price}\t$d->{price_wo_vat}\t$d->{quantity}\t$d->{discount}\t$d->{vat}\n");}$dbh->pg_endcopy();}}my$t5=new Benchmark;
print STDERR"Server> INTEGRATE CHECK DEPOIS SALES DETAILS2 ".($cnt++).":".timestr(timediff($t5,$t4))."\n" if$DEBUG_TIMINGS;
for(@suggestions_collected){$self->_handle_product_suggestions($products_suggest,$_,$info->{headers}->{area},$details);}$extra_data->{payed_tables}||="";
if($extra_data->{payed_tables}){$extra_data->{original_area}||="";
my$ch_area=$extra_data->{original_area}?$extra_data->{original_area}:$check->area();
my$pc_dir=$self->dir()."/server/data/payed_cards/".$ch_area;
system("mkdir -p $pc_dir")unless-d$pc_dir;
$extra_data->{payed_tables}=~s/,$//;
my@t=split/,/,$extra_data->{payed_tables};
for(@t){my@tmp=split/_/,$_;
if($mult<0){unlink("$pc_dir/".$tmp[0]);}else{open(F,"> $pc_dir/".$tmp[0]);
print F$tmp[1]."\n";
close(F);}}}else{$extra_data->{disco_card}||=0;
if($extra_data->{disco_card}){my$ch_area=$extra_data->{original_area}?$extra_data->{original_area}:$check->area();
my$pc_dir=$self->dir()."/server/data/payed_cards/".$ch_area;
system("mkdir -p $pc_dir")unless-d$pc_dir;
if($mult<0){unlink("$pc_dir/".$orig_table_number);}else{open(F,"> $pc_dir/".$orig_table_number);
print F$check_value."\n";
close(F);}}}$extra_data->{dont_update_stock}||=0;
if(!$extra_data->{dont_update_stock}){foreach my $id(keys%stock_ids){$db->do("UPDATE products SET stock_current = stock_current - ".$stock_ids{$id}." WHERE id = $id");
my$below_stock_min=$db->select(qq{
          SELECT id, stock_min, stock_current
          FROM products
          WHERE stock_use = 1 and deleted = 0 and stock_current <= stock_min
        });
my$did=0;
for(@$below_stock_min){if(!exists$DID_STOCK_IDS_ALERT{$_->{id}}){$did=1;
$DID_STOCK_IDS_ALERT{$_->{id}}=1;}}if($did){my$tmp_fname="/opt/pos/common/tmp/".$$.time.int(rand(10000));
my$final_fname="/opt/pos/server/data/tmp/ui_alert#".$info->{headers}->{station_close}."#".time.".txt";
open(FFF,"> $tmp_fname");
print FFF&translate($self,"EXISTEM PRODUTOS ABAIXO DO STOCK MINIMO");
close(FFF);
&move($tmp_fname,$final_fname);}}}if(scalar@add_details_aux){my$str=join(",",keys%prod_ids);
my$data=$db->select("SELECT * FROM products_extra_data WHERE product_id IN ($str)");
my%info=();
if(scalar@$data){for(@$data){$info{$_->{product_id}}=[$_->{field_name},$_->{field_value}];}$dbh->do("COPY sales_details_aux (header, product_id, gb_identifier, key_name, key_value) FROM stdin");
foreach my $rec(@add_details_aux){if(exists$info{$rec->{product_id}}){my@params=($rec->{header},$rec->{product_id},$rec->{gb_identifier},&my_conv("extra_data#".$info{$rec->{product_id}}->[0]),&my_conv($info{$rec->{product_id}}->[1]));
map{tr/\\\t\n/   /;}@params;
$dbh->pg_putline(join("\t",@params)."\n");}}$dbh->pg_endcopy;}}if($c->{VOIDS_REGISTER}){my$void_idx=0;
$dbh->do("COPY sales_details (header, product, hour, quantity, price, discount, offer, vat, clerk, station, operation_type, product_name, clerk_name, free_text, price_wo_vat, inside_menu, gb_identifier, department, price_used, business_date, had_bill) FROM stdin");
foreach my $d(@$details_deleted){next unless scalar@$d;
next unless defined$d->[3];
$d->[14]||=0;
my$qtty=$d->[3]*$mult;
my$discount=$d->[5]||0;
my$offer=0;
my$op_type=$d->[10]ne ''?$d->[10]:4;
$op_type=4 if$op_type eq '1';
my$clerk_name=exists$clerks->{$d->[7]}?$clerks->{$d->[7]}->{login}:'UNKNOWN';
my$free_text=$d->[13];
$free_text=~s/\\/\\\\/g;
my$product_name='UNKNOWN';
my$department='UNKNOWN';
if(exists$products->{$d->[1]}){$product_name=$products->{$d->[1]}->{name};
my$fam_name=$products->{$d->[1]}->{family_name}||"";
my$subfam_name=$products->{$d->[1]}->{subfamily_name}||"";
if($fam_name&&$subfam_name){$department=$fam_name." / ".$subfam_name;}elsif($fam_name&&!$subfam_name){$department=$fam_name." / UNKNOWN";}elsif(!$fam_name&&$subfam_name){$department="UNKNOWN / ".$subfam_name;}}my$PIVA=$d->[6];
my$PCI=$d->[4];
my$PSI=$PCI/(1+$PIVA/100);
my$VDU=$discount;
my$PU=$PSI-$VDU;
my$PL=$PU*$qtty;
my$VIVA=$PL*($PIVA/100);
$d->[4]||=0;
$d->[16]||=1;
$d->[2]=~s/\-/:/g;
my($register_hour,$void_hour)=split/\@/,$d->[2];
$free_text.="§".&my_conv($register_hour);
my$gbi=$d->[-1].$void_idx++;
my$had_bill=$self->{_memc}->get('gbi_had_bill#'.$gbi);
$had_bill||=0;
@params=($inserted_id,$d->[1],$void_hour,$d->[3]*$mult,$d->[4],$discount,$offer,$d->[6],$d->[7],$d->[12],$op_type,&my_conv($product_name),&my_conv($clerk_name),$free_text,$PSI,$d->[14],$gbi,&my_conv($department),$d->[16],$check->business_date(),$had_bill,);
map{tr/\\\t\n/   /;}@params;
$dbh->pg_putline(join("\t",@params)."\n");}$dbh->pg_endcopy;}my$t6=new Benchmark;
print STDERR"Server> INTEGRATE CHECK DEPOIS SALES DETAILS1 ".($cnt++).":".timestr(timediff($t6,$t5))."\n" if$DEBUG_TIMINGS;
my$change_value=0;
foreach my $footer(@$footers){if(defined$media_ignore&&defined$footer->[0]&&$footer->[0]eq$media_ignore){$change_value=$footer->[1]*1;
last;}}my$has_cash=0;
my%tt=();
foreach my $footer(@$footers){next unless scalar@$footer;
my$value=$footer->[1];
my$obs=scalar@$footer==3?$footer->[2]:'0';
if($footer->[0]ne$media_ignore){my$v=0;
if($footer->[0]eq&translate($self,"DINHEIRO")){$has_cash=1;
$v=($value-$change_value)*$mult;}else{$v=$value*$mult;}my$id=$db->next_id("sales_payments");
$dbh->do("COPY sales_payments (id, header, payment_media, value, obs, business_date) FROM stdin");
$dbh->pg_putline("$id\t$inserted_id\t".&my_conv($footer->[0])."\t$v\t".&my_conv($obs)."\t".$check->business_date()."\n");
$dbh->pg_endcopy;}push@{$info->{payments}},{payment_media=>$footer->[0],value=>$value,obs=>$obs,};}my$t7=new Benchmark;
print STDERR"Server> INTEGRATE CHECK DEPOIS SALES PAYMENTS ".($cnt++).":".timestr(timediff($t7,$t6))."\n" if$DEBUG_TIMINGS;
$doc_counters->increment($doc_counter_key);
if($c->{LOG_POS_USAGE}){$info->{payments}||=[];
open(NN,">> /opt/pos/server/data/checks_integration.log");
print NN"[".&strftime("%Y%m%d_%H%M%S",localtime)."][PAYMENTS] ".$check->business_date().",$fo_doc_number,$orig_table_number,$doc_type,".$check_value.",".scalar(@{$info->{payments}}).",".$h->[-1]."\n";
close(NN);}}my$ds=$doc_serie;
$ds=~s/ //g;
open(F,"> /opt/pos/server/data/areas/last_integrated.txt");
print F"$business_date $check_hour $ds";
close(F);
open(F,"> /opt/pos/server/data/areas/".$check->area()."/last_integrated.txt");
print F$business_date."\n".$check_hour."\n";
close(F);
if(exists$DELIVERY_AREAS{$check->area()}){&copy($file,"/tmp/$$");}if(exists$areas_validation->{$check->area()}){open(F,"> /opt/pos/server/data/areas/".$check->area()."/".$orig_table_number.".tovalidate");
close(F);
&copy($file,"/opt/pos/server/data/areas/".$check->area()."/".$orig_table_number);
unlink($file);}else{my$areas_table_names=App::POS::Counters->new(db=>$db,name=>'areas_table_names',);
my$kk=$check->area()."#".$orig_table_number;
my$orig_check_file="/opt/pos/server/data/areas/".$check->area()."/".$orig_table_number;
my$name_file=$orig_check_file.".name";
my$move=0;
if($areas_table_names->exists($kk)){$move=1;
&copy($name_file,"/tmp/.pos_name");}elsif($c->{KEEP_TABLE_NAMES_ON_CLOSE}){$move=1;
&copy($name_file,"/tmp/.pos_name");}if(-e$name_file){my$refresh_file="/opt/pos/server/data/tmp/checksrefresh.txt";
open(NNN,"> $refresh_file");
print NNN"1\n";
close(NNN);}$check->delete();
if($move){&copy("/tmp/.pos_name",$name_file);
unlink("/tmp/.pos_name");}}if(exists$DELIVERY_AREAS{$check->area()}){my$tmp_f=$file;
$tmp_f=~s/\.close$/.delivered/;
&move("/tmp/$$",$tmp_f);}if(defined$info->{headers}->{customer_id}&&$info->{headers}->{doc_type}==7){$info->{headers}->{customer_credit}+=$info->{headers}->{value};
$db->do("UPDATE customers SET total_credit = ? WHERE id = ?",$info->{headers}->{customer_credit},$info->{headers}->{customer_id},);}elsif(defined$info->{headers}->{customer_id}&&$info->{headers}->{doc_type}==8){$info->{headers}->{customer_credit}-=$info->{headers}->{value};
$info->{headers}->{customer_credit}=0 if$info->{headers}->{customer_credit}<0;
$db->do("UPDATE customers SET total_credit = ? WHERE id = ?",$info->{headers}->{customer_credit},$info->{headers}->{customer_id},);}elsif(defined$info->{headers}->{customer_id}&&$info->{headers}->{doc_type}==2){$info->{headers}->{customer_credit}-=$info->{headers}->{value};
$info->{headers}->{customer_credit}=0 if$info->{headers}->{customer_credit}<0;
$db->do("UPDATE customers SET total_credit = ? WHERE id = ?",$info->{headers}->{customer_credit},$info->{headers}->{customer_id},);}my$t8=new Benchmark;
print STDERR"Server> INTEGRATE CHECK TOTAL!!!!! ".($cnt++).":".timestr(timediff($t8,$t1))."\n" if$DEBUG_TIMINGS;
return$info;}sub areas_with_fixed_names{my$self=shift;
return$self->{__areas_with_fixed_names}if exists$self->{__areas_with_fixed_names};
my$r={};
if(-e"/opt/pos/server/data/areas/with_fixed_names.txt"){my$i=$self->hash_from_hdd("/opt/pos/server/data/areas/with_fixed_names.txt");
if(scalar keys%$i){my@a=split/,/,$i->{areas};
map{$r->{$_}=1}@a;}}$self->{__areas_with_fixed_names}=$r;
return$r;}sub _handle_product_suggestions{my$self=shift;
my($sug,$detail,$area,$details)=@_;
my$c=$self->config()->load();
$c->{PRODUCTS_SUGESTION_EXTRAS_ONLY}||=0;
my$id=$detail->[1];
my$station=$detail->[12];
my$price=$detail->[4];
return if exists$self->{__products_suggestions}->{$id};
my$valid=0;
foreach my $d(@$details){next unless scalar@$d;
if($d->[1]==$id){$valid=1;
next;}my$is_extra=$d->[13]eq 'EXTRA'?1:0;
if($c->{PRODUCTS_SUGESTION_EXTRAS_ONLY}&&!$is_extra){next;}if($valid==1){my$global_key=$id."#".$d->[1]."#";
my$area_key=$id."#".$d->[1]."#a=$area";
my$station_key=$id."#".$d->[1]."#s=$station";
$sug->increment($global_key);
$sug->increment($area_key);
$sug->increment($station_key);}}$self->{__products_suggestions}->{$id}=1;}sub __setup_linux{my$self=shift;
$self->debug("__setup_linux");
die"setup method needs to be run by root...\n" unless$ENV{USER}eq 'root';
if(-d"/shares/server"){system("umount -f /shares/server");
system("rm -rf /shares/server");}my$c=$self->config()->load();
my$ip=$self->ip();
my$gateway=$self->vfh($c,'NETWORK_GATEWAY');
if(open(F,"> /etc/samba/smb.conf")){my$conf=$self->__etc_samba_smb_conf();
print F$conf;
close(F);
system("/etc/init.d/samba restart");}}sub __etc_samba_smb_conf{return <<END;
[global]
workgroup = pos
server string = %h server
dns proxy = no
interfaces = lo eth0
bind interfaces only = true
log file = /var/log/samba/log.%m
max log size = 1000
syslog = 0
panic action = /usr/share/samba/panic-action %d
security = share
encrypt passwords = true
passdb backend = tdbsam
obey pam restrictions = yes
guest account = pos
invalid users = root
passwd program = /usr/bin/passwd %u
passwd chat = *Enter\\snew\\sUNIX\\spassword:* %n\\n *Retype\\snew\\sUNIX\\spassword:* %n\\n *password\\supdated\\ssuccessfully* .

[pos]
comment = pos share
path = /share
browseable = yes
read only = no
guest ok = yes
END
}sub _get_sign_chars{my%a=(signature=>undef,chars=>[0,10,20,30],@_);
my@chars=split//,$a{signature};
my@c=@{$a{chars}};
return@chars[@c];}sub daily_specials{my$self=shift;
return$self->{__daily_specials}if exists$self->{__daily_specials};
my$db=$self->database();
my$i={};
my$rec=$db->select("SELECT * FROM product_daily_specials");
map{$i->{$_->{product_id}}=$_}@$rec;
$self->{__daily_specials}=$i;
return$self->{__daily_specials};}sub _stock_products{my$self=shift;
return$self->{__stock_products}if exists$self->{__stock_products};
my$db=$self->database();
my$sth=$db->dbh()->prepare(qq{
    SELECT id FROM products WHERE deleted = 0 AND stock_use = 1
  });
$sth->execute();
my%c=();
while(my$row=$sth->fetchrow_arrayref){$c{$row->[0]}=1;}$self->{__stock_products}=\%c;
return$self->{__stock_products};}sub _areas_with_validation_required{my$self=shift;
return$self->{__areas_with_validation_required}if exists$self->{__areas_with_validation_required};
my$r={};
my$i={};
my$c=$self->config()->load_fixed();
$c->{AREA}||=[];
$c->{AREA_CHECK_VALIDATION}||=[];
for(my$n=0;$n<scalar@{$c->{AREA}};$n++){if($c->{AREA}->[$n]=~/,delivery/){$DELIVERY_AREAS{$n}=1;}my@k=split/,/,$c->{AREA}->[$n];
$i->{$k[0]}=$n;}foreach(@{$c->{AREA_CHECK_VALIDATION}}){if(exists$i->{$_}){$r->{$i->{$_}}=$_;}}$self->{__areas_with_validation_required}=$r;
return$r;}sub _decode_sale_cashier{my$self=shift;
my($config,$clerks,$station,$clerk)=@_;
if(!exists$config->{CASHIERS}){return"0";}my$cashiers=$self->_machine_cashiers($self,$station);
if(scalar keys%$cashiers>1){return$clerks->{$clerk}->{cashier};}elsif(scalar keys%$cashiers==1){my@a=keys%$cashiers;
return$a[0];}else{return"0";}}sub _dumper_read{my($f)=@_;
my$VAR1={};
if(open(F,"< $f")){local$/=undef;
my$cnt=<F>;
eval"$cnt";
close(F);}return$VAR1;}sub _dumper_save{my($f,$i)=@_;
if(open(F,"> $f")){print F Dumper($i);
close(F);}}sub _machine_cashiers{my$self=shift;
my($machine,$station)=@_;
return$self->{__cashiers_in_use}->{$station}if exists$self->{__cashiers_in_use}->{$station};
my$cashiers={};
my$tmp="";
if($station==0){if(open(F,"< ".$machine->dir_server()."/etc/config.ini")){while(<F>){if(/^STATION_CASHIERS/){my@t=split/=/;
$t[1]=~s/\n//g;
$t[1]=~s/\r//g;
$tmp.=$t[1].",";}}close(F);
$tmp=~s/,$//;}}else{if(open(F,"< ".$machine->dir_server()."/server/data/registered_stations/$station")){my$c=0;
while(<F>){if($c++ ==2){$tmp=$_;
$tmp=~s/\n//g;
$tmp=~s/\r//g;
last;}}close(F);}}if($tmp ne ''){my@toks=split/,/,$tmp;
map{$cashiers->{$_}=1}@toks;}$self->{__cashiers_in_use}->{$station}=$cashiers;
return$cashiers;}1;
