package App::POS::Hardware::Scales::SIGMA_SG100_P18;
use warnings;
use strict;
use Time::HiRes qw( sleep );
use App::POS::Hardware::Scales;

use base qw( App::POS::Hardware::Scales );

sub debug_readings { 0 }

sub setup_port {
  my $s = shift;

  my $PortObj = $s->serial_obj();
  $PortObj->baudrate(9600);
  $PortObj->parity("none");
  $PortObj->databits(8);
  $PortObj->stopbits(1);
  $PortObj->handshake("none");
}

sub start {
  my $s = shift;

  my $PortObj = $s->serial_obj();

  my $sleep = 0.2;
  my $clean_after = 0;

  while (1) {
    my( $count_in, $string_in ) = $PortObj->read(1024);

    $s->debug("chars read: $count_in, string_read: #$string_in#");
    $string_in =~ s/^\+\ //g;
    if ($count_in > 0) {
      my( $read1, $read2 ) = $string_in =~ /^(\d+)\.(\d+)/;
      my $num = 0;

      if (defined $read1 && defined $read2) {
        #$read1 = '000';
        #$read2 = '500';

        my $num2;

        if ($read1 * 1 == 0) {
          $num2 = $read2 / 1000;
        }
        else {
          $num2 = ($read1 * 1) . "." . $read2;
        }

        $num = $num2;

        if (defined $num && $num ne '') {
          #print STDERR "### $num\n";
          if ($num > 0) {
            $clean_after = 1;
            open(N, "> /opt/pos/common/tmp/scale.txt");
            print N sprintf("%.3f", $num)."\n";
            close(N);
          }
          elsif ($clean_after == 1) {
            $clean_after = 0;
            open(N, "> /opt/pos/common/tmp/scale.txt");
            print N "0\n";
            close(N);
          }
        }
      }
    }

    sleep $sleep;
  }
}

1;

