package App::POS::Hardware::Scales::RUBY3;
use warnings;
use strict;
use Time::HiRes qw( sleep );
use Data::Dumper;
use App::POS::Hardware::Scales;

use base qw( App::POS::Hardware::Scales );

sub debug_readings { 0 }

sub setup_port {
  my $s = shift;

  my $PortObj = $s->serial_obj();
  $PortObj->baudrate(9600);
  $PortObj->parity("even");
  $PortObj->databits(8);
  $PortObj->stopbits(1);
  $PortObj->handshake("none");
}

sub start {
  my $s = shift;

  my $PortObj = $s->serial_obj();

  my $sleep = 0.2;
  my $clean_after = 0;

  while (1) {
    my( $count_in, $string_in ) = $PortObj->read(1024);

    $s->debug("chars read: $count_in, string_read: #$string_in#");

    if ($count_in > 0) {
      my $tmp = $string_in;
      $string_in =~ s/\r//g;

      my @a = split /\+/, $string_in;
      next unless scalar @a;

      my $num = $a[0] ? $a[0] : $a[1];
      next unless defined $num;

      if (defined $num && $num ne '') {
        $num =~ s/^\s+//;

        if ($num > 0) {
          $clean_after = 1;
          open(N, "> /opt/pos/common/tmp/scale.txt");
          print N sprintf("%.3f", $num)."\n";
          close(N);
        }
        elsif ($clean_after == 1) {
          $clean_after = 0;
          open(N, "> /opt/pos/common/tmp/scale.txt");
          print N "0\n";
          close(N);
        }
      }
    }

    sleep $sleep;
  }
}

1;

