package App::POS::Hardware::Scales::DIBAL3;
use warnings;
use strict;
use Time::HiRes qw( sleep );
use App::POS::Hardware::Scales;

use base qw( App::POS::Hardware::Scales );

sub debug_readings { 0 }

sub setup_port {
  my $s = shift;

  my $PortObj = $s->serial_obj();
  $PortObj->baudrate(9600);
  $PortObj->parity("even");
  $PortObj->databits(8);
  $PortObj->stopbits(1);
  $PortObj->handshake("none");
}

sub start {
  my $s = shift;

  my $PortObj = $s->serial_obj();

  my $sleep = 0.2;
  my $clean_after = 0;

  while (1) {
    my( $count_in, $string_in ) = $PortObj->read(1024);

    $s->debug("chars read: $count_in, string_read: #$string_in#");

    if ($count_in >= 5) {
      if ($count_in == 9) {
        $string_in =~ s/\s.*?$//;
        $string_in =~ s/\W//g;

        if (length($string_in) == 4) {
          my @a = reverse split //, $string_in;
          my $num = "";
          map { $num .= $_ } @a;

          if ($num) {
            $num = $num*1;

            if ($num && $num*1 > 0) {
              $clean_after = 1;
              $num = $num / 1000;
              #print STDERR "###### #$num#\n";
              open(N, "> /opt/pos/common/tmp/scale.txt");
              print N sprintf("%.3f", $num)."\n";
              close(N);
            }
            elsif ($clean_after == 1) {
              $clean_after = 0;
              open(N, "> /opt/pos/common/tmp/scale.txt");
              print N "0\n";
              close(N);
            }
          }
        }
      }
    }

    sleep $sleep;
  }
}

1;

