package App::POS::Hardware::Scales::CAS_ER_PLUS;

use warnings;
use strict;
use Time::HiRes qw( sleep );
use App::POS::Hardware::Scales;

use base qw( App::POS::Hardware::Scales );

sub debug_readings { 0 }

sub setup_port {
  my $s = shift;

  my $PortObj = $s->serial_obj();
  $PortObj->baudrate(9600);
  $PortObj->parity("even");
  $PortObj->databits(8);
  $PortObj->stopbits(1);
  $PortObj->handshake("none");
}

sub start {
  my $s = shift;

  my $PortObj = $s->serial_obj();

  my $sleep = 0.2;
  my $clean_after = 0;

  while (1) {
    $PortObj->write(chr(0x05));
    my( $count_in, $string_in ) = $PortObj->read(1);
    $PortObj->write(chr(0x11).chr(0x12));
    ( $count_in, $string_in ) = $PortObj->read(1024);

    $s->debug("chars read: $count_in, string_read: #$string_in#");

    if ($count_in >= 5) {
      my( $num ) = $string_in =~ /(\d+\.\d+)/;

      #if (defined $num && $num*1 > 0) {
      if (defined $num && $num ne '') {
        if ($num > 0) {
          $clean_after = 1;
          open(N, "> /opt/pos/common/tmp/scale.txt");
          print N sprintf("%.3f", $num)."\n";
          close(N);
        }
        elsif ($clean_after == 1) {
          $clean_after = 0;
          open(N, "> /opt/pos/common/tmp/scale.txt");
          print N "0\n";
          close(N);
        }
      }
    }

    sleep $sleep;
  }
}

1;

