package App::POS::Hardware::Scales::ASEP30P;

use warnings;
use strict;
use Time::HiRes qw( sleep );
use App::POS::Hardware::Scales;

use base qw( App::POS::Hardware::Scales );

sub debug_readings { 0 }

sub setup_port {
  my $s = shift;

  my $PortObj = $s->serial_obj();
  $PortObj->baudrate(9600);
  $PortObj->parity("none");
  $PortObj->databits(8);
  $PortObj->stopbits(1);
  $PortObj->handshake("none");
}

sub start {
  my $s = shift;

  my $PortObj = $s->serial_obj();

  my $sleep = 0.2;
  my $clean_after = 0;

  while (1) {
    my( $count_in, $string_in ) = $PortObj->read(1024);

    $s->debug("chars read: $count_in, string_read: #$string_in#");

    if ($count_in == 12) {
      $string_in =~ s/\W|A|I//g;

      if ($string_in*1 > 0) {
        $clean_after = 1;
        my $a = $string_in / 1000;
        open(N, "> /opt/pos/common/tmp/scale.txt");
        print N sprintf("%.3f", $a)."\n";
        close(N);
      }
      elsif ($clean_after == 1) {
        $clean_after = 0;
        open(N, "> /opt/pos/common/tmp/scale.txt");
        print N "0\n";
        close(N);
      }
    }

    sleep $sleep;
  }
}

1;

