package App::POS::Hardware::PrinterLogo::BitArray;
use Mouse;
use Image::BMP;

has dots => (
  is => 'rw'
);

has width => (
  is => 'rw'
);

has height => (
  is => 'rw'
);

has path => (
  is => 'rw',
  required => 1
);

sub BUILD {
  my $self = shift;

  my $img = Image::BMP->new( file => $self->path() );
  my($width, $height) = ( $img->{Width}, $img->{Height} );

  $self->width( $width );
  $self->height( $height );

  $self->dots( [] );
  $self->width(575) if ( $self->width() > 575 );

  for (my $hi = 0; $hi < $self->height(); $hi++) {
    for (my $wi = 0; $wi < $self->width(); $wi++) {
      my ($r,$g,$b) = $img->xy_rgb($wi,$hi);

      $r = 256 + $r if ($r < 0);
      if ( $r > 200 && $b > 200 && $g > 200 ) {
        push @{$self->dots()}, 0
      } else {
        push @{$self->dots()}, 1
      }
    }
  }
}

__PACKAGE__->meta->make_immutable();

