package App::POS::Hardware::Handlers;
use strict;
use warnings;
use UUID::Tiny;
use URI::Escape;
use LWP::Simple qw($ua get);
use Number::Format;
use Time::HiRes qw( sleep stat );
use MIME::Base64 qw( encode_base64 decode_base64 );
use Data::Dumper;
use Device::SerialPort qw( :STAT );
use Template;
use Template::Stash;
use Template::Config;
use IO::File;
use Net::Ping;
use File::Slurp qw( read_dir read_file );
use POSIX qw( strftime ceil );
use File::Path qw( make_path );
use File::Copy qw( copy move );
use Encode qw( decode encode from_to );
use Encode::Guess;
use File::Find qw( find );
use Date::Calc qw( Date_to_Time Delta_Days Add_Delta_Days Today );
use File::Remove 'remove';
use File::Basename qw( basename );
use Benchmark ':hireswallclock';
use IO::Socket;
use Cache::Memcached::Fast;
use JSON;
use HTML::Entities;
use Digest::MD5 qw( md5_hex );
use Text::Wrap;
use File::ChangeNotify;
use App::POS::Utils qw( translate my_round my_conv date_based_on_closing_hour md5_from_file );
use App::POS::Counters;
use App::POS::Check;
use App::POS::Printer;
use App::POS::Hardware::PrinterLogo;
use App::POS::Hardware::CustomerDisplays::BLEEP750;
use App::POS::Hardware::CustomerDisplays::ICF2002;
use App::POS::Hardware::CustomerDisplays::MINIO2;
use App::POS::Hardware::CustomerDisplays::MINIPOS;
use App::POS::Hardware::CustomerDisplays::PLAIN;
use App::POS::Hardware::CustomerDisplays::CCTV;
use App::POS::Hardware::CustomerDisplays::SAM4S;
use App::POS::Hardware::CustomerDisplays::TOSHIBA;
use App::POS::Hardware::CustomerDisplays::TOSHIBA_C10;
use App::POS::Hardware::CustomerDisplays::VFD;
use App::POS::Hardware::CustomerDisplays::VFD_Inverted;
use App::POS::Hardware::CustomerDisplays::VIRTUAL;
use App::POS::Hardware::CustomerDisplays::AUDITORNOVA;
use App::POS::Hardware::Scales::ASEP30P;
use App::POS::Hardware::Scales::CAS_ER_PLUS;
use App::POS::Hardware::Scales::DIBAL2;
use App::POS::Hardware::Scales::DIBAL;
use App::POS::Hardware::Scales::PROTOCOL_DOLLAR_96008N1;
use App::POS::Hardware::Scales::RUBY;
use App::POS::Hardware::Scales::BIZERBA_CS300;
use App::POS::Hardware::Scales::CAS_PD_II_PARAM6;
use App::POS::Hardware::Scales::DIBAL3;
use App::POS::Hardware::Scales::DIGI_DS_788;
use App::POS::Hardware::Scales::RUBY2;
use App::POS::Hardware::Scales::RUBY3;
use App::POS::Hardware::Scales::TOWA_OZ15L;
use App::POS::Hardware::Scales::SIGMA_SG100_P18;
use Exporter::Easy (OK=>[qw/
  read_magnetic_card
  read_dallas_reader
  read_barcode
  read_scale
  printers_monitor_group
  files_monitor
  server_monitor
  queue_manager
  /]);
&File::Basename::fileparse_set_fstype('MSWin32');
my$print_bill_md5_valid='';
my$print_bill_md5_cur=undef;
my$print_invoice_md5_valid='';
my$print_invoice_md5_cur=undef;
my$REAL_PRINT=1;
my$SERVER_FILE_MONITOR_METHOD='';
my$DEBUG_FILES=0;
my$DEBUG_TIMINGS=0;
my$LAST_INTEGRATED_CHECK;
my$DECIMAL_PLACES=2;
my$SOFTWARE_INFO=[];
my%DOC_VIAS=(1=>'Original',2=>'Duplicado',3=>'Triplicado',4=>'Quadruplicado',5=>'Quintuplicado',);
my$NFORMATER=Number::Format->new();
$Template::Config::STASH='Template::Stash::XS';
$Template::Stash::SCALAR_OPS->{"mycustomerwrap"}=sub{my$scalar=shift;
$Text::Wrap::columns=31;
return wrap('','',($scalar));};
$Template::Stash::SCALAR_OPS->{"format_qtty"}=sub{my$scalar=shift;
my$decimal_places=shift||3;
$scalar=abs($scalar);
if($scalar=~m/^\d+.\d+$/){return sprintf("%.".$decimal_places."f",$scalar);}else{return$scalar*1;}};
$Template::Stash::SCALAR_OPS->{"to_positive"}=sub{my$scalar=shift;
my$decimals=shift||$DECIMAL_PLACES;
$scalar||=0;
if($scalar){if($scalar=~/^\-/){$scalar=$scalar*-1;}$scalar=sprintf("%.0".$decimals."f",$scalar);}return$scalar;};
$Template::Stash::SCALAR_OPS->{"myround"}=sub{my$scalar=shift;
my$decimals=shift||$DECIMAL_PLACES;
return sprintf("%.".$decimals."f",$NFORMATER->round($scalar,$decimals));};
$Template::Stash::SCALAR_OPS->{"myround_qtty"}=sub{my$d=shift;
my$r=shift||$DECIMAL_PLACES;
my@a=split/\./,$d;
my$ret=$d;
if(scalar@a==2){$a[1]=substr($a[1],0,$r);
$ret=join(".",@a);}return$ret;};
$Template::Stash::SCALAR_OPS->{"chars"}=sub{my$scalar=shift;
my$num=shift;
return$scalar unless defined$num;
my$decoded=decode("utf8",$scalar);
if(length($decoded)>$num){$decoded=substr($decoded,0,$num);}elsif(length($decoded)<$num){my$spaces=$num-length($decoded);
$decoded.=" " x$spaces;}$decoded=encode("utf8",$decoded);
return$decoded;};
my%BARCODES=();
my$STATION_MAIN_PRINTER=undef;
my$TEMPLATE=undef;
my$PRINTING_PRIORITIES=undef;
my$PRODUCTS_INFO=undef;
my$PRODUCTS_EXTRAS=undef;
my$PRODUCTS_EXTRA_DATA=undef;
my$PRODUCTS_MENUS=undef;
my$MESSAGES_INFO=undef;
my$VAT_ISENTIONS=undef;
my$VAT_ISENTIONS_IDX=undef;
my$CLERKS_INFO=undef;
my$CLERKS_DRAWER={};
my$PRODUCTS_TRANSLATIONS=undef;
my$CLERKS_IDS_BY_LOGIN=undef;
my$PRODUCTS_IDS_BY_HANDY_PLU=undef;
my$PRINTING_ZONES_CONFIG=undef;
my$PRINTING_ZONES_FILTERS=undef;
my%CHECKS_REQUESTED=();
my%AREAS_INFO=();
my%HAPPYHOUR_INFO=();
my%TABLES_TO_CARDS=();
my%MAIN_PRINTERS=();
my$CAN_DELIVER_PRODUCT_ID=undef;
my%X64_CONTROL=();
my%MOBILE_PRINT_BILLS=();
my%MOBILE_PRINT_INVOICES=();
my%DOC_TYPE_PRINTER_OVERRIDES=();
my%CASHIER_NAMES=();
my%RECEIPT_PRINT_VIAS=();
my%OWNER_INFO_CACHE=();
my$CLERK_SERIES={};
my$DOC_TYPE_SERIE=undef;
my%DELIVERY_AREAS=();
my%DOCS_TO_HISTORY=(7=>1,5=>1,8=>1,12=>1,13=>1,14=>1,32=>1,33=>1,34=>1,35=>1,90=>1,);
my$CLOSE_HOUR=undef;
my%EXECUTE_FILTERS=('drawer#'=>'execute_cash_drawer','customer_display#'=>'execute_customer_display','new_config\.txt$'=>'activate_new_config','.close$'=>'check_finalize','\d+\.hold$'=>'print_check_hold','print#\d+#\d+#\d+#.*?\.txt'=>'print_file','reprint_check#\d+#\d+'=>'check_reprint','print_reprint_checks#\d+#\d+'=>'print_reprint_checks','pdf_to_station_print#\d+#'=>'pdf_to_station_print','printer_error#\d+'=>'printer_error','server_sql_query#'=>'server_sql_query','print_notclosed_check#\d+'=>'print_notclosed_check','print_offer_ticket#\d+'=>'print_offer_ticket','moneycount#\d+#\d+'=>'print_moneycount','report#closeday'=>'print_report_closeday','report#resumed#'=>'print_report_resumed','report#detailed#'=>'print_report_detailed','report#user#'=>'print_report_clerk','report#tables#'=>'print_report_tables','clerk_in_out#'=>'integrate_clerk_in_out','clerk_in#'=>'integrate_clerk_in','clerk_out#'=>'integrate_clerk_out','recover_document_stock#'=>'recover_document_stock','keyboard\.txt$'=>'keyboard_process','print_voucher#\d+'=>'create_voucher','burn_voucher#\d+'=>'burn_voucher','restart_software#\d+\.txt$'=>'restart_station','restart_hardware_handlers#\d+\.txt$'=>'restart_hardware_handlers','station_message#\d+'=>'station_message','register_cashdrawer_open#\d+'=>'register_cashdrawer_open','table_transfer#\d+'=>'table_transfer','printers_register#\d+'=>'printers_register','x64_request_'=>'x64_request','x64_transfer_'=>'x64_transfer','x64_printbill_'=>'x64_printbill','x64_void_'=>'x64_void','print_daily_specials#\d+'=>'print_daily_specials','print_tech_report#\d+'=>'print_tech_report','print_to_main_printer#\d+'=>'print_to_main_printer','reprint_orders#\d+'=>'reprint_orders','cache_refresh#\d+'=>'cache_refresh','ccreport#'=>'print_cc_report','doc_history#'=>'print_cc_doc_history','printer_screen#'=>'printer_screen','report_stk_below_minimal#'=>'report_stk_below_minimal','report_stk_current#'=>'report_stk_current','report_stk_movements#'=>'report_stk_movements','report_products_list#'=>'report_products_list','print_schedule#\d+'=>'print_schedule','print_customer_profile#\d+'=>'print_customer_profile','cashier_open#\d+#\d+'=>'cashier_open','cashier_in_out#\d+#\d+'=>'cashier_in_out','cashier_close#\d+#\d+'=>'cashier_close','print_barcode_label#\d+#\d+'=>'print_barcode_label','print_shelf_label#\d+#\d+'=>'print_shelf_label','ui_alert#\d+'=>'ui_alert','execute_command\-\d+'=>'execute_command','barcode\.txt'=>'process_barcode','scale\.txt'=>'process_scale','shutdown#'=>'process_shutdown','sms_report'=>'sms_report','points_customer_statement'=>'points_customer_statement',);
sub queue_manager{my($daemon_name,$machine,$devices)=@_;
$machine->config()->__cache("");
$devices=$machine->config()->devices_by_type($daemon_name);
$devices||=[];
my$num;
my$info;
my$valid=undef;
foreach my $d(@$devices){$num=$d->{num};
$info=$d->{device};
$info->{Inactive}||=0;
if(!exists$info->{Device}||!$info->{Device}||$info->{Inactive}){print STDERR"Device $num: Missing 'Device' parameter or 'Inactive' device... skipping...\n";
next;}print STDERR"Device $num - WILL USE: ".$info->{Model}." - ".$info->{Device}."\n";
$valid=1;
last;}if(!defined$valid){print STDERR"Didn't find any valid device, aborting...\n";
return;}my$cfg=$machine->config()->load_fixed();
$info->{InitSystemCommand}||="";
if($info->{InitSystemCommand}){my$device=$info->{Device};
$info->{InitSystemCommand}=~s/\@DEVICE\@/$device/g;
print STDERR"Will execute: ".$info->{InitSystemCommand}."\n";
my$res=system($info->{InitSystemCommand});
print STDERR"Result: $res\n";}my$strobe=chr(13).chr(8).chr(83).chr(1).chr(151);
my$PortObj=Device::SerialPort->new($info->{Device});
$PortObj->baudrate(2400);
$PortObj->parity("none");
$PortObj->databits(8);
$PortObj->stopbits(1);
$PortObj->handshake("none");
if(!$PortObj){print STDERR"Can't open ".$info->{Device}.": $!\n";}else{my$last_read=-1;
my$write=0;
while(1){if(-e$machine->dir_tmp()."/queue.txt"){local$/=undef;
open(F,"< ".$machine->dir_tmp()."/queue.txt");
my$cnt=<F>;
chop($cnt);
close(F);
$cnt||=0;
my$num1=0;
my$num2=0;
if($cnt!=0){if($cnt!=$last_read){$write=1;
$last_read=$cnt;}else{$write=0;}if($cnt<10){$num2=$cnt;}else{my@a=split//,$cnt;
$num1=$a[0];
$num2=$a[1];}}if($write){my$strobe=chr(13).chr(8).chr(83).chr(1).chr(151);
my$sleep=0.05;
print STDERR"num1: $num1, num2: $num2\n";
my$str;
my$checksum;
$checksum=256-(13+0+65+ord($num1))%256;
$str=chr(13).chr(0).chr(65).$num1.chr($checksum);
$PortObj->write($str);
sleep($sleep);
$checksum=(256-(13+1+65+ord($num2)))%256;
$str=chr(13).chr(1).chr(65).$num2.chr($checksum);
$PortObj->write($str);
sleep($sleep);
$PortObj->write($strobe);}else{sleep 1;}}else{sleep 2;}}}}sub read_dallas_reader{my($daemon_name,$machine,$devices)=@_;
$machine->config()->__cache("");
$devices=$machine->config()->devices_by_type($daemon_name);
$devices||=[];
my$num;
my$info;
my$valid=undef;
foreach my $d(@$devices){$num=$d->{num};
$info=$d->{device};
$info->{Inactive}||=0;
if(!exists$info->{Device}||!$info->{Device}||$info->{Inactive}){print STDERR"Device $num: Missing 'Device' parameter or 'Inactive' device... skipping...\n";
next;}print STDERR"Device $num - WILL USE: ".$info->{Model}." - ".$info->{Device}."\n";
$valid=1;
last;}if(!defined$valid){print STDERR"Didn't find any valid device, aborting...\n";
return;}print STDERR"> read_dallas_reader - ".$info->{Device}."\n";
$info->{InitSystemCommand}||="";
$info->{Driver}||="";
if($info->{InitSystemCommand}){my$device=$info->{Device};
$info->{InitSystemCommand}=~s/\@DEVICE\@/$device/g;
print STDERR"Will execute: ".$info->{InitSystemCommand}."\n";
my$res=system($info->{InitSystemCommand});
print STDERR"Result: $res\n";}my$PortObj=Device::SerialPort->new($info->{Device});
$PortObj->baudrate(9600);
$PortObj->parity("none");
$PortObj->databits(8);
$PortObj->stopbits(1);
$PortObj->handshake("none");
if(!$PortObj){print STDERR"Can't open ".$info->{Device}.": $!\n";}else{if($info->{Driver}eq 'CUSTOM1'){while(1){my($count_in,$string_in)=$PortObj->read(255);
if(defined$count_in&&$count_in>0){chop($string_in);chop($string_in);
if($string_in&&$string_in=~/^\w+$/){print STDERR"#$string_in#\n";
if($string_in eq 'OUT'){&lazy_file_create("/tmp/logout.txt",1);}else{&lazy_file_create("/opt/pos/common/tmp/barcode.txt",$string_in);}}}sleep 0.2;}return;}elsif($info->{Driver}eq 'CSI_CHD'){while(1){my($count_in,$string_in)=$PortObj->read(255);
if(defined$count_in&&$count_in>0){my@chars=split//,$string_in;
my$logout=1;
my$idx=0;
my$read="";
for my $c(@chars){my$n=ord($c);
if($idx==0&&$n==39){$logout=1;}elsif($idx>0&&$n!=0){$logout=0;
$read.=$n;}$idx++;}if($logout){&lazy_file_create("/tmp/logout.txt",1);}elsif($read){&lazy_file_create("/opt/pos/common/tmp/barcode.txt",$read);}}sleep 0.2;}return;}my$collect=0;
my$read="";
my$logout=0;
while(1){my($count_in,$string_in)=$PortObj->read(255);
if($count_in>0){my@chars=split//,$string_in;
for my $c(@chars){my$n=ord($c);
print STDERR"###### $n\n";
if($n==242){$collect=0;
$read="";
$logout=1;}elsif($n==241){$collect=1;
$logout=0;}else{if($collect){$read.=$c;}}}if($logout){print STDERR"### logout: $logout, read: $read\n";
&lazy_file_create("/tmp/logout.txt",1);}else{if(length($read)>16){$read=substr($read,0,15);}if(length($read)==16){print STDERR"### login!!!, read: $read\n";
&lazy_file_create("/opt/pos/common/tmp/barcode.txt",$read);
$read="";}}}sleep 0.2;}}}sub read_magnetic_card{my($daemon_name,$machine,$devices)=@_;
my$db=$machine->database();
$machine->config()->__cache("");
$devices=$machine->config()->devices_by_type($daemon_name);
$devices||=[];
my$num;
my$info;
my$valid=undef;
foreach my $d(@$devices){$num=$d->{num};
$info=$d->{device};
$info->{Inactive}||=0;
if(!exists$info->{Device}||!$info->{Device}||$info->{Inactive}){print STDERR"Device $num: Missing 'Device' parameter or 'Inactive' device... skipping...\n";
next;}print STDERR"Device $num - WILL USE: ".$info->{Model}." - ".$info->{Device}."\n";
$valid=1;
last;}if(!defined$valid){print STDERR"Didn't find any valid device, aborting...\n";
return;}print STDERR"> read_magnetic_card - ".$info->{Device}."\n";
$info->{InitSystemCommand}||="";
$info->{UseTrack}||=2;
$info->{Baudrate}||='9600';
$info->{Parity}||='none';
$info->{Databits}||='8';
$info->{Stopbits}||='1';
$info->{RtsCts}||=0;
$info->{DtrDsr}||=0;
$info->{Handshake}||="";
my$PortObj=Device::SerialPort->new($info->{Device})or die"Can't open ".$info->{Device};
$PortObj->baudrate($info->{Baudrate})if$info->{Baudrate};
$PortObj->parity($info->{Parity})if$info->{Parity};
$PortObj->databits($info->{Databits})if$info->{Databits};
$PortObj->stopbits($info->{Stopbits})if$info->{Stopbits};
$PortObj->rts_active($info->{RtsCts})if$info->{RtsCts};
$PortObj->dtr_active($info->{DtrDsr})if$info->{DtrDsr};
$PortObj->handshake($info->{Handshake})if$info->{Handshake};
if(!$PortObj){print STDERR"Can't open ".$info->{Device}.": $!\n";}else{if(exists$info->{MatchMask}){if(ref$info->{MatchMask}eq 'HASH'){my$tmp=delete$info->{MatchMask};
push@{$info->{MatchMask}},$tmp;}}else{$info->{MatchMask}||=[];}while(1){my($count_in,$string_in)=$PortObj->read(255);
my$i=&_decode_card_data($string_in);
if($i->{type}eq 'card'&&exists$i->{$info->{UseTrack}}){my$cnt=$i->{$info->{UseTrack}};
$cnt=~s/\n//g;
$cnt=~s/\r//g;
if($cnt=~/^\d+$/){$cnt=int($cnt);}if(scalar@{$info->{MatchMask}}){foreach my $mask(@{$info->{MatchMask}}){my$pattern=$mask->{Pattern};
my$customer=$mask->{Customer};
if($cnt=~/$pattern/){print STDERR"######> $pattern - fez match ($customer)\n";
if(uc($customer)eq '@TABLE_MATCH@'){my$filter=$1;
print STDERR"TABLE_MATCH: $filter\n";
my$rec=$db->select(qq{
                  SELECT id
                  FROM customers
                  WHERE deleted = 0 AND (id = ? OR card_number = ?)
                  ORDER BY deleted
                },$filter,$filter);
if(!scalar@$rec){print STDERR"Can't find any record in table customers with id or card_number: $filter\n";}else{open(N,"> ".$machine->dir_tmp()."/barcode.txt");
print N$rec->[0]->{id};
close(N);}}else{open(N,"> ".$machine->dir_tmp()."/barcode.txt");
print N$customer;
close(N);}last;}else{print STDERR"######> $pattern - nao fez match ($customer)\n";}}}else{open(N,"> ".$machine->dir_tmp()."/barcode.txt");
print N$cnt;
close(N);}}elsif($i->{type}eq 'dallas'){if($i->{read}eq '1'){print STDERR"### dallas logout\n";
&lazy_file_create("/tmp/logout.txt",1);}else{my$read=$i->{read};
if(length($read)>16){$read=substr($read,0,15);}if(length($read)==16){print STDERR"### dallas login - $read\n";
&lazy_file_create("/opt/pos/common/tmp/barcode.txt",$read);}}}sleep 0.2;}}}sub read_barcode{my($daemon_name,$machine,$devices)=@_;
$machine->config()->__cache("");
$devices=$machine->config()->devices_by_type($daemon_name);
$devices||=[];
my$num;
my$info;
my$valid=undef;
foreach my $d(@$devices){$num=$d->{num};
$info=$d->{device};
$info->{Inactive}||=0;
if(!exists$info->{Device}||!$info->{Device}||$info->{Inactive}){print STDERR"Device $num: Missing 'Device' parameter or 'Inactive' device... skipping...\n";
next;}print STDERR"Device $num - WILL USE: ".$info->{Model}." - ".$info->{Device}."\n";
$valid=1;
last;}if(!defined$valid){print STDERR"Didn't find any valid device, aborting...\n";
return;}print STDERR"> read_barcode - ".$info->{Device}."\n";
my$chars_ignore_before=exists$info->{NumCharsToIgnoreBefore}&&defined$info->{NumCharsToIgnoreBefore}?$info->{NumCharsToIgnoreBefore}:0;
my$chars_ignore_after=exists$info->{NumCharsToIgnoreAfter}&&defined$info->{NumCharsToIgnoreAfter}?$info->{NumCharsToIgnoreAfter}:0;
$info->{Baudrate}||='9600';
$info->{Parity}||='none';
$info->{Databits}||='8';
$info->{Stopbits}||='1';
$info->{RtsCts}||=0;
$info->{DtrDsr}||=0;
my$PortObj=Device::SerialPort->new($info->{Device})or die"Can't open ".$info->{Device};
$PortObj->baudrate($info->{Baudrate});
$PortObj->parity($info->{Parity});
$PortObj->databits($info->{Databits});
$PortObj->stopbits($info->{Stopbits});
$PortObj->rts_active($info->{RtsCts});
$PortObj->dtr_active($info->{DtrDsr});
while(1){my($count_in,$string_in)=$PortObj->read(255);
if($chars_ignore_after&&$string_in){$string_in=substr($string_in,0,length($string_in)-$chars_ignore_after);}if($chars_ignore_before&&$string_in){$string_in=substr($string_in,$chars_ignore_before,length($string_in));}if($string_in ne ''){open(N,"> ".$machine->dir_tmp()."/barcode.txt");
print N$string_in;
close(N);}sleep 0.2;}}sub read_scale{my($daemon_name,$machine,$devices)=@_;
$machine->config()->__cache("");
$devices=$machine->config()->devices_by_type($daemon_name);
$devices||=[];
my$num;
my$info;
my$valid=undef;
foreach my $d(@$devices){$num=$d->{num};
$info=$d->{device};
$info->{Inactive}||=0;
if(!exists$info->{Device}||!$info->{Device}||$info->{Inactive}){print STDERR"Device $num: Missing 'Device' parameter or 'Inactive' device... skipping...\n";
next;}print STDERR"Device $num - WILL USE: ".$info->{Model}." - ".$info->{Device}."\n";
$valid=1;
last;}if(!defined$valid){print STDERR"Didn't find any valid device, aborting...\n";
return;}print STDERR"> read_scale -> ".$info->{Device}."\n";
$info->{Model}||='';
die"Missing 'Model' parameter..." unless$info->{Model};
my$class="App::POS::Hardware::Scales::".$info->{Model};
my$obj=$class->new(device=>$info->{Device},info=>$info,);
$obj->start();}sub printers_register{my($machine,$file)=@_;
print STDERR"> printers_register - $file\n";
my$cfg=$machine->config()->load_fixed();
$cfg->{STATION_NUMBER}||=0;
my($station)=$file=~/printers_register#(\d+)\./;
if($station!=$cfg->{STATION_NUMBER}){return 2;}my$dir_server_tmp=$machine->server_dir_tmp();
my$register_file="$dir_server_tmp/printers_register#".$station.".txt";
my$devices=$machine->config()->devices_by_type("Printers");
print STDERR"Will register printers for station $station...\n";
&_register_printers($machine,$devices,1);}sub server_monitor{my($daemon_name,$machine,$devices)=@_;
my$config=$machine->config()->load();
$config->{STATION_NUMBER}||=0;
$devices=$machine->config()->devices_by_type("Printers");
local$SIG{ALRM}=sub{die"alarm\n"};
my$reg_file=$machine->dir_server().'/server/data/registered_stations/'.$config->{STATION_NUMBER};
my$register_printers=0;
my$was_in_error=0;
my$count=0;
while(1){print STDERR"Loop...\n";
if(-e"/tmp/server_error.txt"){print STDERR"Server error, will try to mount server...\n";
$was_in_error=1;
eval{alarm(3);
$machine->mount_server();
alarm(0);};
if($@){alarm(0);}}else{if($was_in_error){print STDERR"Was in error, will register station and printers...\n";
if(!-e$reg_file){if(open(F,"> $reg_file")){$register_printers=1;
print STDERR"Will register station ".$config->{STATION_NUMBER}."...\n";
print F$config->{STATION_NUMBER};
close(F);}}if($register_printers){print STDERR"Will register printers for station ".$config->{STATION_NUMBER}."...\n";
&_register_printers($machine,$devices,1);
foreach my $device(@$devices){my$num=$device->{num};
print STDERR"Will register device $num...\n";
my$info=$device->{device};
next if uc($info->{Device})eq '@SCREEN@';
&_handle_printer($machine,$config,$num,$info,$config->{STATION_NUMBER});}$register_printers=0;}$was_in_error=0;}else{my$db=$machine->database();
if($count++ ==10){eval{alarm(3);
$machine->register_on_server();
alarm(0);};
if($@){print STDERR"ERROR ON register_on_server()\n";}$count=0;}}}sleep 3;}}sub files_monitor{my($daemon_name,$machine)=@_;
$machine->config()->__cache("");
my$config=$machine->config()->load();
print STDERR"> files_monitor\n";
my%REGEXPS=();
foreach my $filter(keys%EXECUTE_FILTERS){my$Regex=qr/$filter/;
$REGEXPS{$filter}=$Regex;}my@folders_to_monitor=();
my@folders_cleanup=();
my$pt_certified_software=-e"/opt/pos/common/skins/".$config->{LANG}."/sign_server"?1:0;
if($pt_certified_software){my$cmd="";
if(-e"/opt/pos/common/skins/".$config->{LANG}."/sign_server.src"){$cmd="/opt/pos/common/skins/".$config->{LANG}."/sign_server.src --saft --cli";}else{$cmd="/opt/pos/common/skins/".$config->{LANG}."/sign_server --saft --cli";}my$info=`$cmd`;
chop($info);
my@toks=split/#/,$info;
$SOFTWARE_INFO=\@toks;}if($machine->is_station()){$config->{STATION_NUMBER}||=0;
push@folders_cleanup,$machine->dir_tmp();
push@folders_to_monitor,$machine->dir_tmp();}else{my$db=$machine->database();
push@folders_cleanup,$machine->dir_tmp();
push@folders_cleanup,$machine->server_dir_tmp();
push@folders_to_monitor,$machine->dir_tmp();
push@folders_to_monitor,$machine->dir_areas();
push@folders_to_monitor,$machine->server_dir_tmp();
$config->{CAN_DELIVER_PRODUCT_NAME}||="";
if($config->{CAN_DELIVER_PRODUCT_NAME}ne ''){my$prod=$db->select("SELECT id FROM products WHERE name = ? AND deleted = 0",$config->{CAN_DELIVER_PRODUCT_NAME});
if(scalar@$prod){$CAN_DELIVER_PRODUCT_ID=$prod->[0]->{id};}}}print STDERR Dumper(\@folders_cleanup);
print STDERR Dumper(\@folders_to_monitor);
eval{&find(sub{return unless/\.txt$/||/^#db#/;
return if/printer_ignore/;
return if/queue\.txt$/;
return if/money_transit\.txt$/;
return if/printer_redirect/;
my$st=unlink($File::Find::name);
print STDERR"####> CLEANUP: $File::Find::name - $_ - $st\n";},@folders_cleanup);};
if($@){print STDERR"ERROR IN CLEANUP: $@\n";}$config->{AREA}||=[];
my$area_idx=0;
foreach my $area(@{$config->{AREA}}){my@t=split/,/,$area;
print STDERR Dumper(\@t);
if(scalar(@t)>=5&&$t[4]eq 'delivery'){$DELIVERY_AREAS{$area_idx}=1;}$AREAS_INFO{$area_idx++}=\@t;}{my$happy_hour=$config->{AREA_HAPPY_HOUR}||[];
if(scalar@$happy_hour){my%names_to_number=();
for(keys%AREAS_INFO){$names_to_number{$AREAS_INFO{$_}->[0]}=$_;}for(@$happy_hour){my@toks=split/,/;
my$area_num=$names_to_number{$toks[0]};
if(defined$area_num){my$price=$toks[2];
my$vat=$toks[3];
$HAPPYHOUR_INFO{$area_num}=[$price,$vat];}}}}&get_cashier_names($machine);
{my$close_hour=$config->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}my$fname=$machine->dir_server()."/server/data/areas/tables_to_cards.txt";
if(-e$fname){if(open(F,"< $fname")){while(<F>){chop;
my@t=split/=/,$_;
next unless defined$t[1];
my@t2=split/,/,$t[1];
for my $t(@t2){$TABLES_TO_CARDS{$t}=$t[0];}}close(F);}}my$printers=$machine->printers();
$printers||=[];
for(my$idx=0;$idx<scalar@$printers;$idx++){my$prn=$printers->[$idx];
$prn->{Main}||=0;
if($prn->{Main}){$STATION_MAIN_PRINTER=$idx;}}$config->{PRINT_RECEIPT_PRINTER_VIAS}||=[];
if(exists$config->{DECIMAL_PLACES}&&$config->{DECIMAL_PLACES}ne ''){$DECIMAL_PLACES=$config->{DECIMAL_PLACES};}eval{for(@{$config->{PRINT_RECEIPT_PRINTER_VIAS}}){my@a=split/,/;
my@b=split/\-/,$a[0];
$RECEIPT_PRINT_VIAS{$b[0]}=$a[1];}};
print STDERR"WILL USE readir() TO MONITOR FILES...\n";
my%to_ignore_cache=();
my$regex1=qr/print#\d+#\d+/;
my$regex2=qr/drawer#\d+#\d/;
my$regex3=qr/\/tmp$/;
my$db=$machine->database();
my$memc=Cache::Memcached::Fast->new({servers=>[{address=>$machine->server_ip().':11211',weight=>1},],namespace=>'pos_files:',connect_timeout=>0.1,io_timeout=>0.1,close_on_error=>1,compress_threshold=>-1,compress_ratio=>0,max_failures=>3,failure_timeout=>1,nowait=>1,hash_namespace=>1,serialize_methods=>[\&JSON::encode_json,\&JSON::decode_json],});
my$watcher;
if($machine->is_server()){$watcher=File::ChangeNotify->instantiate_watcher(directories=>\@folders_to_monitor,);}my$is_first_time=1;
while(1){if(!$is_first_time){if($machine->is_server()){my@events=$watcher->wait_for_events();
sleep 0.1;}else{sleep 0.5;}}$is_first_time=0;
my@server_files=();
my@files=();
find({wanted=>sub{my$full_path=$File::Find::name;
return unless-f$full_path;
my$fileName=$_;
my@stat=stat($full_path);
if(exists$to_ignore_cache{$fileName}){my$last_mod=time-$stat[8];
if($File::Find::dir=~/$regex3/){if($last_mod>=60){print STDERR"File $full_path has more than 60 seconds, will remove it...\n";
unlink($full_path);}}return;}if($machine->is_server()){if($fileName=~/$regex1/||$fileName=~/$regex2/){my$last_mod=time-$stat[8];
if($last_mod>=60){print STDERR"File $full_path has more than 60 seconds, will remove it...\n";
unlink($full_path);
return;}}my$dir1=$machine->dir_areas();
my$dir2=$machine->server_dir_tmp();
if($File::Find::dir=~/^$dir1/||$File::Find::dir=~/^$dir2/){push@server_files,$File::Find::name;}}my$size=-s$full_path;
unless($size>0){my$last_mod=time-$stat[8];
if($last_mod>120){print STDERR"   REMOVED!\n";
unlink$full_path;}return;}push@files,$File::Find::name;},},@folders_to_monitor);
if($machine->is_server()){$memc->set('server_files',\@server_files,10);}else{my@myfiles=$memc->get('server_files');
if(scalar@myfiles){my$f=$myfiles[0];
@server_files=@$f;
for(@server_files){$_=~s/\/opt\/pos/\/shares\/pos/;
push@files,$_;}}}my@hold_files=();
my@close_files=();
my@final_files=();
for(@files){if(/\d+\.hold$/){push@hold_files,$_;}elsif(/\d+\.close$/){push@close_files,$_;}else{push@final_files,$_;}}@files=@final_files;
push@files,@hold_files if scalar@hold_files;
push@files,@close_files if scalar@close_files;
if($DEBUG_FILES){foreach my $file(@files){if(-e$file){my@st=stat($file);
my$str=$st[9];
print STDERR"FILE> ".sprintf("%-17s",$st[9])." - $file\n";}}print STDERR"--------------------------------------------------\n" if scalar@files;}&_apply_regexp_rules($machine,\@files,\%REGEXPS,\%to_ignore_cache);}}sub _apply_regexp_rules{my($machine,$files,$regexps,$cache)=@_;
my$did_one_filter=0;
my$filter_idx=0;
foreach my $full_path(@$files){my$fileName=&basename($full_path);
foreach my $filter(keys%$regexps){my$re=$regexps->{$filter};
if($fileName=~/$re/){$did_one_filter=1;
no strict 'refs';
my$ret=0;
eval{$ret=&{"$EXECUTE_FILTERS{$filter}"}($machine,$full_path);};
$ret||=0;
if($@){print STDERR"AN ERROR OCURRED, saved in /root/logs/ERRORS.log!!!! - $@\n";
open(Y,">> /root/logs/ERRORS.log");
print Y"##################################################\n";
print Y$@."\n";
close(Y);}if($ret!=2){unlink($full_path);}}$filter_idx++;}if($did_one_filter==0){$cache->{$fileName}=1;}}}sub server_sql_query{my($machine,$file)=@_;
if($machine->is_server()){if(open(F,"< $file")){local$/=undef;
my$query=<F>;
close(F);
my$db=$machine->database();
$db->do($query)if defined$query&&$query;}}else{return 2;}}sub keyboard_process{my($machine,$file)=@_;
print STDERR"> keyboard_process - $file\n";
if(open(F,"< $file")){local$/=undef;
my$cnt=<F>;
close(F);
if(length($cnt)>0){$cnt=~s/[^A-Za-z0-9]+//g;
$cnt='*LOGOUT*' if$cnt eq '0';
print STDERR"Got: #$cnt#\n";
if($cnt ne ''){open(N,"> ".$machine->dir_tmp()."/barcode.txt");
print N$cnt;
close(N);}}}}sub register_cashdrawer_open{my($machine,$file)=@_;
if($machine->is_server()){if(open(F,"< $file")){my($date,$station,$clerk,$clerk_name,$business_date)=("","","","","");
while(<F>){chop;
if($_){my@a=split/#/;
($date,$station,$clerk,$clerk_name,$business_date)=($a[0],$a[1],$a[2],$a[3],$a[4]);}}close(F);
my$cfg=$machine->config()->load_fixed();
$cfg->{CASHDRAWER_OPENS_REGISTER}||=0;
if($date&&$cfg->{CASHDRAWER_OPENS_REGISTER}){my$db=$machine->database();
my$id=$db->next_id("cashdrawer_opens");
$db->do("INSERT INTO cashdrawer_opens VALUES (?, ?, ?, ?, ?, ?)",$id,$date,$station,$clerk,$clerk_name,$business_date);}}return 1;}else{return 2;}}sub execute_cash_drawer{my($machine,$file)=@_;
my$server_dir_tmp=$machine->server_dir_tmp();
my$server_dir_data=$machine->server_dir_data();
my$db=$machine->database();
&get_clerks_information($db);
my$cfg=$machine->config()->load_fixed();
$cfg->{Hardware}->{CashDrawers}->{Device}||=[];
my($station,$clerk,$manual,$pnum,$drawer_num,$clerk_decoded,$business_date)=$file=~/\/drawer#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)#(.*?)#/;
return unless defined$station&&defined$clerk;
if($station!=$cfg->{STATION_NUMBER}){return 2;}$manual||=0;
my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$clerk_name=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'UNKNOWN';
my$ret_code=1;
if(!$clerk_decoded){$ret_code=&clerk_cashdrawer_decode($machine,$station,$clerk,$manual,$pnum);}return unless defined$ret_code;
my$did_open=0;
$cfg->{Hardware}->{CashDrawers}->{Device}||=[];
my$devices=$cfg->{Hardware}->{CashDrawers}->{Device};
if($pnum eq '9999'){$cfg->{Hardware}->{CashDrawers}->{Device}||=[];
my$cd=$cfg->{Hardware}->{CashDrawers}->{Device}||=[];
my$dnum=$drawer_num-1;
my$info=$cd->[$dnum];
if(!defined$info){print STDERR"INVALID DRAWER NUMBER - $drawer_num\n";
return;}$drawer_num=1;
$devices=[$info];}foreach my $info(@{$devices}){$info->{Device}||="";
$info->{Printer}||="";
$info->{Script}||="";
$info->{Inactive}||=0;
if($info->{Inactive}){next;}if($info->{Device}){print STDERR"WILL OPEN CASHDRAWER IN ".$info->{Device}."\n";
my$PortObj=Device::SerialPort->new($info->{Device})or die"Can't open ".$info->{Device};
$PortObj->baudrate(9600);
$PortObj->parity("even");
$PortObj->databits(8);
$PortObj->stopbits(1);
$PortObj->handshake("none");
$PortObj->write(chr(0x05));
$did_open=1;}if($info->{Script}){print STDERR"WILL OPEN CASHDRAWER WITH SCRIPT ".$info->{Script}."\n";
if(!-e$info->{Script}){print STDERR"CAN'T FIND SCRIPT - ".$info->{Script}."\n";}else{$did_open=1;
system($info->{Script});}}if($info->{Printer}){my$printer_num=$info->{Printer}-1;
$printer_num=0 if$printer_num<0;
if($pnum!=99&&$pnum!=9999){$printer_num=$pnum;}my@files=&read_dir($server_dir_data);
my$redirected=0;
foreach my $file(@files){if(my($station_to,$printer_to)=$file=~/^printer_redirect#$station#$printer_num#(\d+)#(\d+)\./){my$r=int(rand(10000));
my$f=$server_dir_tmp."/drawer#$station_to#$clerk#$manual#$printer_to#".time."$r.txt";
$redirected=1;
if(open(F,"> $f")){print F"1\n";}else{print STDERR"ERROR: Can't write to - $f\n";}}}if(!$redirected){my$pp=$cfg->{Hardware}->{Printers}->{Device}->[$printer_num];
my$info=$pp;
if(defined$pp){$pp->{Inactive}||=0;
if($pp->{Inactive}){foreach my $prn(@{$cfg->{Hardware}->{Printers}->{Device}}){$prn->{Device}||="";
$prn->{Inactive}||=0;
$prn->{Main}||=0;
next if$prn->{Device}=~/^.SCREEN.$/;
if(!$prn->{Inactive}&&$prn->{Main}){$pp=$prn;
$info=$prn;
last;}}}my$driver=$info->{Driver}||'';
my$printer=App::POS::Printer->new(driver=>$driver);
my$p_class=$printer->get_class();
$info->{Device}||="";
$info->{IP}||="";
$info->{CupsQueue}||="";
my$method="cashdrawer".$drawer_num."_open";
my$seq=$p_class->$method();
if($info->{CupsQueue}){print STDERR"WILL OPEN CASHDRAWER IN CupsQueue ".$info->{CupsQueue}."\n";
$did_open=1;
my$r=$$."_".int(rand(10000));
my$file="/tmp/$r.txt";
open(F,"> $file");
print F$seq;
close(F);
system("lp -d \"".$info->{CupsQueue}."\" $file");
unlink($file);}elsif($info->{IP}){print STDERR"WILL OPEN CASHDRAWER IP ".$info->{IP}."\n";
my$sock=new IO::Socket::INET(PeerAddr=>$info->{IP},PeerPort=>'9100',Proto=>'tcp',Timeout=>5,);
die"Could not create socket to ".$info->{IP}.": $!\n" unless$sock;
print$sock $seq;
$did_open=1;
close($sock);}elsif($info->{Device}){print STDERR"WILL OPEN CASHDRAWER IN ".$info->{Device}."\n";
if(open(F,"> ".$info->{Device})){$did_open=1;
print F$seq;
close(F);}else{print STDERR"ERROR: Can't write to ".$info->{Device}.": $!\n";}}}else{print STDERR"ERROR: printer specified for cashdrawer doesn't exists...\n";}}}}if($manual==1&&$did_open){my$r=int(rand(10000));
my$new_file=$machine->server_dir_tmp()."/register_cashdrawer_open#".time."$r.txt";
my$cnt=$date."#".$station."#".$clerk."#".$clerk_name."#".$business_date."\n";
open(F,"> $new_file");
print F$cnt;
close(F);}}sub activate_new_config{my($machine,$file)=@_;
print STDERR"> activate_new_config - $file\n";
&copy("/opt/pos/etc/config.ini","/opt/pos/etc/config.ini.bak");
&move($file,"/opt/pos/etc/config.ini");
my$pid=`ps xauf | grep gbr2 | grep -v grep | awk '{print \$2}'`;
if($pid ne ''){system("kill -9 $pid");}unlink$file;
if(open(F,"> /tmp/restart.txt")){print F time."\n";
close(F);}system("/opt/pos/common/bin/restart_hardware_handler.sh");}sub cache_refresh{my($machine,$file)=@_;
my$cfg=$machine->config()->load_fixed();
my$station=$cfg->{STATION_NUMBER}||"0";
my($station_num)=$file=~/cache_refresh#(\d+)\.txt$/;
if($station eq$station_num){print STDERR"> cache_refresh - $file\n";
my$db=$machine->database();
$PRODUCTS_TRANSLATIONS=undef;
$CLERKS_INFO=undef;
$PRODUCTS_INFO=undef;
$VAT_ISENTIONS=undef;
$CLERK_SERIES={};
&get_products_information($db);
&get_clerks_information($db);
&get_products_translations($db);
delete$machine->{__daily_specials};
delete$machine->{__stock_products};
delete$machine->{__products_suggestions};
return 1;}return 2;}sub restart_station{my($machine,$file)=@_;
print STDERR"> restart_station - $file\n";
my$cfg=$machine->config()->load_fixed();
my$station=$cfg->{STATION_NUMBER}||"0";
my($station_restart)=$file=~/restart_software#(\d+)\.txt$/;
if($station eq$station_restart){my$pid=`ps xauf | grep gbr2 | grep -v grep | awk '{print \$2}'`;
if($pid){chop$pid;
print STDERR"RESTART PID: #$pid#\n";
system("kill -9 $pid")if$pid;}unlink$file;
system("/opt/pos/common/bin/restart_hardware_handler.sh");
return 1;}return 2;}sub restart_hardware_handlers{my($machine,$file)=@_;
print STDERR"> restart_hardware_handlers - $file\n";
my$cfg=$machine->config()->load_fixed();
my$station=$cfg->{STATION_NUMBER}||"0";
my($station_restart)=$file=~/restart_hardware_handlers#(\d+)\.txt$/;
if($station eq$station_restart){unlink$file;
system("/opt/pos/common/bin/restart_hardware_handler.sh");
return 1;}return 2;}sub cashier_open{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}my($station,$clerk,$cashier,$amount)=$file=~/cashier_open#(\d+)#(\d+)#(\d+)#(.*?)#/;
print STDERR"> cashier_open - $file, $station, $clerk, $cashier, $amount\n";
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
&get_clerks_information($db);
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{cashier_number}=$cashier;
$info{amount}=$amount||0;
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('cashier_open.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub cashier_in_out{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}my($station,$clerk,$cashier,$op,$amount)=$file=~/cashier_in_out#(\d+)#(\d+)#(\d+)#(.*?)#(.*?)#/;
print STDERR"> cashier_in_out - $file, $station, $clerk, $cashier, $amount, $op\n";
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
&get_clerks_information($db);
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my$justification="";
if(open(F,"< $file")){local$/=undef;
$justification=<F>;
close(F)}my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{justification}=$justification;
$info{cashier_number}=$cashier;
$info{amount}=$amount||0;
my$template;
if($op eq 'in'){$template="cashier_in.tmpl";}else{$template="cashier_out.tmpl";}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub cashier_close{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}my($station,$clerk,$cashier,$counted,$sales,$to_next,$id)=$file=~/cashier_close#(\d+)#(\d+)#(\d+)#(.*?)#(.*?)#(.*?)#(\d+)#/;
print STDERR"> cashier_close - $file, $station, $clerk, $cashier, $counted, $sales, $to_next, $id\n";
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
&get_clerks_information($db);
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my%info=();
my$content="";
my$cashier_info=$db->select("SELECT * FROM cashiers WHERE id = ?",$id);
my$ins=$db->select("SELECT * FROM cashier_operations WHERE cashier = ? AND operation = 'IN' ORDER BY date",$id);
my$outs=$db->select("SELECT * FROM cashier_operations WHERE cashier = ? AND operation = 'OUT' ORDER BY date",$id);
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{cashier_number}=$cashier;
$info{sales}=$sales||0;
$info{counted}=$counted||0;
$info{to_next}=$to_next||0;
$info{cashier}=$cashier_info->[0];
$info{ins}=$ins;
$info{outs}=$outs;
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('cashier_close.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub execute_command{my($machine,$file)=@_;
my($station)=$file=~/execute_command\-(\d+)\./;
print STDERR"> execute_command - $station\n";
my$db=$machine->database();
my$cfg=$machine->config()->load_fixed();
if($station ne$cfg->{STATION_NUMBER}){return 2;}open(F,"< $file");
local$/=undef;
my$cmd=<F>;
$cmd=~s/\n//;
$cmd=~s/\r//;
close(F);
print STDERR"WILL EXECUTE: $cmd\n";
system($cmd);
print STDERR"DONE!\n";}sub ui_alert{my($machine,$file)=@_;
my($station)=$file=~/ui_alert#(\d+)#/;
print STDERR"> ui_alert - $station\n";
my$db=$machine->database();
my$cfg=$machine->config()->load_fixed();
if($station ne$cfg->{STATION_NUMBER}){print STDERR"File $file was generated from station $station, this is station ".$cfg->{STATION_NUMBER}.", ignoring...\n";
return 2;}&move($file,"/tmp/ui_alert.txt");}sub print_shelf_label{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}my($station,$clerk,$count)=$file=~/print_shelf_label#(\d+)#(\d+)#(\d+)#/;
print STDERR"> print_shelf_label - $file, $station, $clerk, $count\n";
return unless$count;
if(!-e"/tmp/label_final.bmp"){print STDERR"Can't find file /tmp/label_final.bmp... did you generate it?\n";
return;}my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
my$main_file=$machine->dir_server()."/server/data/registered_printers/".$station."/main";
if(!-e$main_file){print STDERR"Can't find main file for station $station ($main_file)\n";
print STDERR"CHECK IF THAT STATION HAS A 'Main' PRINTER!\n";}else{my$printer=read_file($main_file);
chop($printer);
print STDERR"Will load BMP...\n";
my$o=App::POS::Hardware::PrinterLogo->new(image=>"/tmp/label_final.bmp",use_cache=>0);
my$cnt=$o->image_data();
$cnt.=chr(0x1B).chr(0x32);
$cnt.=chr(0x1B).chr(0x64).chr(0x06).chr(0x1B).chr(0x69);
print STDERR"Done loading BMP...\n";
for(my$i=0;$i<$count;$i++){my$r=int(rand(100000));
my$print_file=$machine->server_dir_tmp()."/print#$station#".$printer."#0#binary".time."$r.txt";
open(F,"> $print_file");
binmode(F);
print F$cnt;
close(F);}print STDERR"Done\n";}return;}sub print_barcode_label{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}my($station,$clerk,$barcode,$count,$product_id)=$file=~/print_barcode_label#(\d+)#(\d+)#(.*?)#(\d+)#(\d+)#/;
print STDERR"> print_barcode_label - $file, $station, $clerk, $barcode, $count, $product_id\n";
return unless$count;
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
&get_clerks_information($db);
&get_products_information($db);
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{product}=$PRODUCTS_INFO->{$product_id};
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('print_barcode_label.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my$printers=$machine->config()->devices_by_type("Printers")||[];
my$main_printer=-1;
my$label_printer=-1;
my$has_label_printer=0;
my$printer_to_use=-1;
my$cfg_main={};
my$cfg_label={};
my$cfg_final={};
for(my$i=0;$i<scalar(@$printers);$i++){my$dev=$printers->[$i];
$dev->{device}->{PrintLabels}||="";
$dev->{device}->{Main}||=0;
if($dev->{device}->{PrintLabels}){$has_label_printer=1;
$label_printer=$i;
$cfg_label=$dev;}if($dev->{device}->{Main}){$main_printer=$i;
$cfg_main=$dev;}}if($label_printer!=-1){$printer_to_use=$label_printer;
$cfg_final=$cfg_label;}elsif($main_printer!=-1){$printer_to_use=$main_printer;
$cfg_final=$cfg_main;}if($printer_to_use!=-1){$cfg_final->{device}->{GenerateGraphicalLabel}||=0;
$cfg_final->{device}->{CupsQueue}||=0;
if($cfg_final->{device}->{GenerateGraphicalLabel}&&$cfg_final->{device}->{CupsQueue}){my$product=$info{product};
my$name=$product->{name}||="";
my$line2=sprintf("%.3f",$product->{sell_price1})." - ".sprintf("%.2f",$product->{sell_vat1});
my$file=`/opt/pos/common/bin/gen_barcode_label.pl "$barcode" "$name" "$line2"`;
for(my$i=0;$i<$count;$i++){system("lp -d \"".$cfg_final->{device}->{CupsQueue}."\" $file");}return 1;}my$dir_server_tmp=$machine->server_dir_tmp();
my$timestamp=time.$$.int(rand(10000));
my$print_file="$dir_server_tmp/print#$station#$printer_to_use#0#$timestamp.txt";
if($count==1){$BARCODES{$print_file}=$barcode;
open(F,"> $print_file");
print F$content;
close(F);}else{for(my$i=0;$i<$count;$i++){my$str=$print_file;
$str=~s/\.txt$/$i.txt/;
$BARCODES{$str}=$barcode;
open(F,"> $str");
print F$content;
close(F);}}}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub x64_void{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}print STDERR"> x64_void - $file\n";
my$cfg=$machine->config()->load_fixed();
my$station=$cfg->{STATION_NUMBER}||"0";
my$db=$machine->database();
&get_products_information($db);
&get_clerks_information($db);
my($comando,$clerk,$area,$table,$msg_num)=$file=~/x64_void_(\d+)_(\d+)_(\d+)_(\d+)_.*?_(\d+)\./;
my$login=$clerk;
my$clerk_info=$CLERKS_INFO->{$clerk};
$clerk_info->{can_void_products}||=0;
$clerk_info->{used_for_training}||=0;
if(!$clerk_info->{can_void_products}&&!$clerk_info->{used_for_training}){my$msg=&x64_txt_message("$login","Nao pode anular");
open(NNN,"> /tmp/x64_message_$comando.txt");
print NNN$msg;
close(NNN);
return;}my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$hour=&strftime("%H:%M:%S",localtime);
my%void_products=();
my$did_products=0;
my@prods=();
my$line_num=0;
my@ndup_products=();
my$ignored=0;
if(open(F,"< $file")){while(<F>){s/\n//g;
s/\r//g;
my($prod,$qtty)=split/#/;
$prod||="";
next unless$prod;
my$prod_id=$PRODUCTS_IDS_BY_HANDY_PLU->{$prod};
next unless defined$prod_id;
push@prods,{id=>$prod_id,qty=>$qtty,line_num=>$line_num};
$line_num++;}close(F);}for(@prods){my$md5_str="v#".$comando."#".$clerk."#".$area."#".$table."#".$_->{id}."#".$_->{qty}."#".$_->{line_num};
my$md5=&md5_hex($md5_str);
if(!exists$X64_CONTROL{$md5}){push@ndup_products,$_;}else{my$cur_time=time;
my$diff=$cur_time-$X64_CONTROL{$md5};
if($diff<=8){$ignored=1;
my$msg="VOID - DUPLICATE! ($diff secs), comando: $comando, clerk: $clerk, area: $area, "."table: $table, product: ".$_->{id}.", qty: ".$_->{qty}.", linenum: ".$_->{line_num}."\n";
&x64_log($msg);}else{my$msg="VOID - IN MD5, BUT OK! ($diff secs), comando: $comando, clerk: $clerk, area: $area, "."table: $table, product: ".$_->{id}.", qty: ".$_->{qty}.", linenum: ".$_->{line_num}."\n";
&x64_log($msg);
push@ndup_products,$_;}}$X64_CONTROL{$md5}=time;}&x64_log("PRODS TO VOID: ".(scalar@ndup_products).", comando: $comando, clerk: $clerk, area: $area, table: $table");
if(!scalar@ndup_products){return;}@prods=@ndup_products;
map{$void_products{$_->{id}}+=$_->{qty}}@prods;
my$checks_dir=$machine->dir_server()."/server/data/areas";
my$check_file="$checks_dir/$area/$table";
my$check_o=App::POS::Check->new(file=>$check_file);
my$data=$check_o->data();
$data->{details}||=[];
if(!scalar@{$data->{details}}){print STDERR"x64_void> Check without details, returning...\n";
return;}my$new_data={};
$new_data->{extra_data}=$data->{extra_data};
$new_data->{header}=$data->{header};
$new_data->{details_deleted}=$data->{details_deleted};
$new_data->{header}||=[];
$new_data->{details}||=[];
$new_data->{details_deleted}||=[];
if(!scalar@{$new_data->{header}}){my$business_date=&date_based_on_closing_hour($date,$CLOSE_HOUR);
push@{$new_data->{header}},$check_o->generate_empty_header($date,$business_date,$clerk,$area);}my@details=();
foreach my $d(reverse@{$data->{details}}){next unless scalar@$d;
my$to_remove=$void_products{$d->[1]};
if(!defined$to_remove){push@details,$d;
next;}my$rand=&strftime("%Y%m%d%H%M%S",localtime).rand();
$rand=~s/\.//g;
if($void_products{$d->[1]}>=$d->[3]){$void_products{$d->[1]}-=$d->[3];
my$num_extras_to_remove=0;
for(my$i=scalar(@details)-1;$i>=0;$i--){last if!$details[$i]->[13];
$num_extras_to_remove++;}for(my$i=0;$i<$num_extras_to_remove;$i++){pop@details;}my@new_p=@$d;
$new_p[0]=$rand;
push@{$new_data->{details_deleted}},\@new_p;}else{my@new_p=@$d;
$new_p[3]=$to_remove;
$new_p[0]=$rand;
push@{$new_data->{details_deleted}},\@new_p;
$d->[3]-=$void_products{$d->[1]};
push@details,$d;
delete$void_products{$d->[1]};}}@details=reverse@details;
$new_data->{details}=\@details;
$check_o->set_data($new_data);
$check_o->save();
open(NNN,"> $check_file.99.hold");
print NNN"1\n";
close(NNN);
&copy($check_file,$check_file.".99.hold.check");
open(NNN,"> $check_file.refresh");
print NNN"1\n";
close(NNN);
if(-e"$check_file.total"){local$/=undef;
open(NNN,"< $check_file.total");
my$total=<NNN>;
close(NNN);
if($total ne ''){$total=$total*1;
if($total==0){unlink"$check_file.total";}}}}sub x64_transfer{my($machine,$file)=@_;
print STDERR"> x64_transfer - $file\n";
print STDERR"X64 transfers are disabled...\n";
&x64_log("X64 transfers are disabled...");
return;}sub x64_printbill{my($machine,$file)=@_;
print STDERR"> x64_printbill - $file\n";
my$cfg=$machine->config()->load_fixed();
my($comando,$clerk,$area,$table,$is_internal,$station)=$file=~/x64_printbill_(\d+)_(\d+)_(\d+)_(\d+)_(\d+)_(\d+)#/;
my$db=$machine->database();
&get_clerks_information($db);
my$checks_dir=$machine->dir_server()."/server/data/areas";
my$check_file="$checks_dir/$area/$table";
my$clerk_info=$CLERKS_INFO->{$clerk};
$clerk_info->{cant_print_bill}||=0;
$clerk_info->{cant_print_bill_internal}||=0;
if($clerk_info->{cant_print_bill}&&$clerk_info->{cant_print_bill_internal}){print STDERR"Clerk isn't allowed to print any kind of bills, returning...\n";
my$msg=&x64_txt_message("$clerk","Nao autorizado");
open(F,"> /tmp/x64_message_$comando.txt");
print F$msg;
close(F);
return;}if($is_internal&&$clerk_info->{cant_print_bill_internal}){print STDERR"clerk can't print internal bills, ignoring...\n";
my$msg=&x64_txt_message("$clerk","Nao autorizado");
open(F,"> /tmp/x64_message_$comando.txt");
print F$msg;
close(F);
return;}if(!$is_internal&&$clerk_info->{cant_print_bill}){print STDERR"clerk can't print bills, ignoring...\n";
my$msg=&x64_txt_message("$clerk","Nao autorizado");
open(F,"> /tmp/x64_message_$comando.txt");
print F$msg;
close(F);
return;}my$file_print=$machine->dir_server()."/server/data/tmp/print_notclosed_check#".$station."#$area#$is_internal#0#$table#1.txt";
if($is_internal){unlink("$check_file.bill");}else{if(open(F,"> $check_file.bill")){print F"1\n";
close(F);}}if(open(F,"> $file_print")){print F"1\n";
close(F);}&copy($check_file,$check_file.".toprint");}sub report_stk_below_minimal{my($machine,$file)=@_;
my($to_screen,$station,$clerk)=$file=~/report_stk_below_minimal#(\d+)#(\d+)#(\d+)#/;
my$db=$machine->database();
&get_clerks_information($db);
my$prods=$db->select(qq{
    SELECT id, handy_plu, name, barcode, stock_current, stock_min
    FROM products
    WHERE deleted = 0 AND stock_current <= stock_min AND stock_use = 1 AND stock_min != 0
    ORDER BY name
  });
return unless scalar@$prods;
my$cfg=$machine->config()->load_fixed();
my%info=(products=>$prods,date=>&strftime("%Y-%m-%d",localtime),hour=>&strftime("%H:%M:%S",localtime),datetime=>&strftime("%Y-%m-%d %H:%M:%S",localtime),station=>$station,clerk_code=>$clerk,clerk_name=>exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>',);
my$content;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_stock_below_minimal.tmpl',\%info,\$content,)||die$TEMPLATE->error;
if($to_screen){$content=~s/\@.*?\@//g;
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);}else{my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
open(F,"> $print_file");
print F$content;
close(F);}}sub report_stk_current{my($machine,$file)=@_;
my($to_xls,$station,$clerk)=$file=~/report_stk_current#(\d+)#(\d+)#(\d+)#/;
my$db=$machine->database();
&get_clerks_information($db);
my%cost_prices=();
my$recs=$db->select(qq{
    SELECT *
    FROM stock_movements
    WHERE cost_price > 0
    ORDER BY date
  });
map{$cost_prices{$_->{product_id}}=$_->{cost_price}}@$recs;
my$prods=$db->select(qq{
    SELECT id, handy_plu, name, barcode, stock_current, stock_min
    FROM products
    WHERE deleted = 0 AND stock_use = 1
    ORDER BY name
  });
return unless scalar@$prods;
for(@$prods){$_->{cost_price}=exists$cost_prices{$_->{id}}?$cost_prices{$_->{id}}:0;
my$len=length($_->{name});
if($len<26){$_->{name}=$_->{name}.("_" x(26-$len));}}my$cfg=$machine->config()->load_fixed();
my%info=(cost_prices=>\%cost_prices,products=>$prods,date=>&strftime("%Y-%m-%d",localtime),hour=>&strftime("%H:%M:%S",localtime),datetime=>&strftime("%Y-%m-%d %H:%M:%S",localtime),station=>$station,clerk_code=>$clerk,clerk_name=>exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>',);
my$content;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_stock_current.tmpl',\%info,\$content,)||die$TEMPLATE->error;
if($to_xls==2){$content=~s/\@.*?\@//g;
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);
my$xls_file="/opt/pos/common/data/stock_".$info{date}.".xls";
&_to_xls($content,$info{date},$info{date},$xls_file);}elsif($to_xls==1){$content=~s/\@.*?\@//g;
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);}else{my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
open(F,"> $print_file");
print F$content;
close(F);}}sub report_stk_movements{my($machine,$file)=@_;
my($to_xls,$station,$clerk,$product_id)=$file=~/report_stk_movements#(\d+)#(\d+)#(\d+)#(\d+)#/;
my$where_str1=$product_id?" AND sm.product_id = $product_id":"";
my$where_str2=$product_id?" AND sd.product = $product_id":"";
my$db=$machine->database();
&get_clerks_information($db);
my%data=();
my$recs=$db->select(qq{
    SELECT sm.date, p.name, sm.operation, SUM(sm.quantity) AS qtty
    FROM stock_movements sm
    LEFT JOIN products p ON (sm.product_id = p.id)
    WHERE p.stock_use = 1$where_str1
    GROUP BY sm.date, p.name, sm.operation
  });
for(@$recs){$_->{qtty}=$_->{qtty}*-1 if$_->{qtty}<0;
$data{my_conv($_->{name})}->{$_->{date}}->{$_->{operation}}=$_->{qtty};}$recs=$db->select(qq{
    SELECT sd.business_date AS date, p.name, SUM(sd.quantity) AS qtty
    FROM sales_details sd
    LEFT JOIN sales_headers sh ON (sh.id = sd.header)
    LEFT JOIN products p ON (sd.product = p.id)
    WHERE p.stock_use = 1 AND sh.doc_type IN (1, 5, 90, 12, 7)$where_str2
    GROUP BY sd.business_date, sd.business_date, p.name
  });
for(@$recs){$data{my_conv($_->{name})}->{$_->{date}}->{"qtty_sold"}+=$_->{qtty};}my$cfg=$machine->config()->load_fixed();
my%info=(products=>\%data,date=>&strftime("%Y-%m-%d",localtime),hour=>&strftime("%H:%M:%S",localtime),datetime=>&strftime("%Y-%m-%d %H:%M:%S",localtime),station=>$station,clerk_code=>$clerk,clerk_name=>exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>',);
my$content;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_stock_movements.tmpl',\%info,\$content,)||die$TEMPLATE->error;
if($to_xls==2){$content=~s/\@.*?\@//g;
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);
my$xls_file="/opt/pos/common/data/stock_".$info{date}.".xls";
&_to_xls($content,$info{date},$info{date},$xls_file);}elsif($to_xls==1){$content=~s/\@.*?\@//g;
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);}else{my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
open(F,"> $print_file");
print F$content;
close(F);}}sub recover_document_stock{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}my($id)=$file=~/recover_document_stock#(\d+)#/;
return unless$id;
my$db=$machine->database();
my$lines=$db->select("SELECT * FROM sales_headers_aux WHERE header = ? AND key_name = 'invoiced'",$id);
if(!scalar@$lines){my$lines=$db->select("SELECT quantity, product FROM sales_details WHERE header = ? AND operation_type = 1",$id);
my%stock_ids=();
for(@$lines){$stock_ids{$_->{product}}+=$_->{quantity};}foreach my $id(keys%stock_ids){$db->do("UPDATE products SET stock_current = stock_current + ".$stock_ids{$id});}}}sub x64_request{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}print STDERR"> x64_request - $file\n";
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
&get_products_information($db);
&get_clerks_information($db);
my($comando,$clerk,$area,$table,$msg_num,$station)=$file=~/x64_request_(\d+)_(\d+)_(\d+)_(\d+)_.*?_(\d+)_(\d+)\./;
my$bck=$clerk;
$clerk=$CLERKS_IDS_BY_LOGIN->{$clerk};
if(!defined$clerk){$clerk=$bck;}my$clerk_info=$CLERKS_INFO->{$clerk};
$clerk_info->{cant_use_others_tables}||=0;
my$dir_server=$machine->dir_server();
if(open(F,"< $file")){my$checks_dir=$dir_server."/server/data/areas";
my$check_file="$checks_dir/$area/$table";
my$area_o=App::POS::Area->new(machine=>$machine,number=>$area);
my$price_field=$area_o->price_field();
my$vat_field=$area_o->vat_field();
my$check=App::POS::Check->new(file=>$check_file);
my$data=$check->data();
my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$hour=&strftime("%H:%M:%S",localtime);
if(!scalar@{$data->{header}}){push@{$data->{header}},$check->generate_empty_header($date,&date_based_on_closing_hour($date,$CLOSE_HOUR),$clerk,$area);}if($clerk_info->{cant_use_others_tables}&&$clerk ne$data->{header}->[2]){print STDERR"Clerk can't use some other's table, returning...\n";
my$msg=&x64_txt_message("Acesso negado"," a mesa $table");
open(NNN,"> /tmp/x64_message_$comando.txt");
print NNN$msg;
close(NNN);
return;}my$print_bill_internal=-1;
my$did_products=0;
my@prods=();
my$line_num=0;
my$has_invalid_qty=0;
while(<F>){s/\n//g;
s/\r//g;
my($prod,$qtty)=split/#/;
$prod||="";
next unless$prod;
if($prod eq '9999'){$print_bill_internal=1;
last;}elsif($prod eq '9998'){$print_bill_internal=0;
last;}my$prod_id=$PRODUCTS_IDS_BY_HANDY_PLU->{$prod};
next unless defined$prod_id;
if($qtty==0){$has_invalid_qty=1;}push@prods,{id=>$prod_id,qty=>$qtty,line_num=>$line_num,handy=>$prod};
$line_num++;}close(F);
if($has_invalid_qty){my$area_name=$AREAS_INFO{$area}->[0];
my$clerk_name=$CLERKS_INFO->{$clerk}->{login};
my$txt="----------------------------------------\n"."      !!!!!! INVALID REQUEST !!!!!!\n"."----------------------------------------\n".$area_name." / ".$table."\n".$clerk_name."\n"."----------------------------------------\n";
for(@prods){my$name=$PRODUCTS_INFO->{$_->{id}}->{name};
$name=sprintf("%-25s",substr($name,0,20));
$txt.=sprintf("%6s",$_->{handy})." ".$name." ".$_->{qty}."\n";}$txt.="\@paper_cut\@";
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
print STDERR$txt."\n";
open(F,"> $print_file");
print F$txt;
close(F);
return;}if($print_bill_internal!=-1){my$file=$dir_server."/server/data/tmp/x64_printbill_".$comando."_".$clerk."_".$area."_".$table."_".$print_bill_internal."_$station#".time.$$.".txt";
open(NNN,"> $file");
print NNN"1\n";
close(NNN);
return;}my@ndup_products=();
my$ignored=0;
for(@prods){my$md5_str="r#".$comando."#".$clerk."#".$area."#".$table."#".$_->{id}."#".$_->{qty}."#".$_->{line_num};
my$md5=&md5_hex($md5_str);
if(!exists$X64_CONTROL{$md5}){push@ndup_products,$_;}else{my$cur_time=time;
my$diff=$cur_time-$X64_CONTROL{$md5};
if($diff<=8){$ignored=1;
my$msg="REQ - DUPPLICATE! ($diff secs), comando: $comando, clerk: $clerk, area: $area, "."table: $table, product: ".$_->{id}.", qty: ".$_->{qty}.", linenum: ".$_->{line_num}."\n";
&x64_log($msg);}else{my$msg="REQ - IN MD5, BUT OK! ($diff secs), comando: $comando, clerk: $clerk, area: $area, "."table: $table, product: ".$_->{id}.", qty: ".$_->{qty}.", linenum: ".$_->{line_num}."\n";
&x64_log($msg);
push@ndup_products,$_;}}$X64_CONTROL{$md5}=time;}&x64_log("PRODS TO REQUEST: ".(scalar@ndup_products).", comando: $comando, clerk: $clerk, area: $area, table: $table");
if(!scalar@ndup_products){return;}@prods=();
my%prod_idx=();
for(my$i=0;$i<scalar(@ndup_products);$i++){my$cur=$ndup_products[$i];
my$next=$ndup_products[$i+1];
if(exists$PRODUCTS_EXTRAS->{$cur->{id}}){push@prods,$cur;}else{if(defined$next&&exists$PRODUCTS_EXTRAS->{$next->{id}}){push@prods,$cur;}else{if(exists$prod_idx{$cur->{id}}){$prods[$prod_idx{$cur->{id}}]->{qty}+=$cur->{qty};}else{push@prods,$cur;
$prod_idx{$cur->{id}}=scalar@prods-1;}}}}foreach my $pp(@prods){my$prod=$pp->{id};
my$qty=$pp->{qty};
my$rand=&strftime("%Y%m%d%H%M%S",localtime).rand();
$rand=~s/\.//g;
my$prod_info=$PRODUCTS_INFO->{$prod};
my$price=$prod_info->{$price_field}||0;
my$vat=$prod_info->{$vat_field}||0;
my@r=();
if(exists$PRODUCTS_EXTRAS->{$prod}){@r=(0,$prod,$hour,$qty,$price,0,$vat,$clerk,"","","","",99,"EXTRA",0,1,1,$rand);}else{@r=(0,$prod,$hour,$qty,$price,0,$vat,$clerk,"","","","",99,"",0,1,1,$rand);}$did_products=1;
push@{$data->{details}},\@r;}if(!$did_products){print STDERR"Didn't find any valid product, aborting...\n";
return;}if(-e"$check_file.bill"){unlink("$check_file.bill");}$check->save();
my$refresh_file="/opt/pos/server/data/tmp/checksrefresh.txt";
open(NNN,"> $refresh_file");
print NNN"1\n";
close(NNN);
open(NNN,"> $check_file.refresh");
print NNN"1\n";
close(NNN);
open(NNN,"> $check_file.99.hold");
print NNN"1\n";
close(NNN);
&copy($check_file,$check_file.".99.hold.check");
if(-e"$check_file.total"){local$/=undef;
open(NNN,"< $check_file.total");
my$total=<NNN>;
close(NNN);
if($total ne ''){$total=$total*1;
if($total==0){unlink"$check_file.total";}}}}}sub x64_request2{my($machine,$file)=@_;
if(!$machine->is_server()){return 2;}print STDERR"> x64_request - $file\n";
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
&get_products_information($db);
&get_clerks_information($db);
my($comando,$clerk,$area,$table,$msg_num,$station)=$file=~/x64_request_(\d+)_(\d+)_(\d+)_(\d+)_.*?_(\d+)_(\d+)\./;
my$bck=$clerk;
$clerk=$CLERKS_IDS_BY_LOGIN->{$clerk};
if(!defined$clerk){$clerk=$bck;}my$clerk_info=$CLERKS_INFO->{$clerk};
$clerk_info->{cant_use_others_tables}||=0;
my$dir_server=$machine->dir_server();
if(open(F,"< $file")){my$checks_dir=$dir_server."/server/data/areas";
my$check_file="$checks_dir/$area/$table";
my$area_o=App::POS::Area->new(machine=>$machine,number=>$area);
my$price_field=$area_o->price_field();
my$vat_field=$area_o->vat_field();
my$check=App::POS::Check->new(file=>$check_file);
my$data=$check->data();
my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$hour=&strftime("%H:%M:%S",localtime);
if(!scalar@{$data->{header}}){push@{$data->{header}},$check->generate_empty_header($date,&date_based_on_closing_hour($date,$CLOSE_HOUR),$clerk,$area);}if($clerk_info->{cant_use_others_tables}&&$clerk ne$data->{header}->[2]){print STDERR"Clerk can't use some other's table, returning...\n";
my$msg=&x64_txt_message("Acesso negado"," a mesa $table");
open(NNN,"> /tmp/x64_message_$comando.txt");
print NNN$msg;
close(NNN);
return;}my$print_bill_internal=-1;
my$did_products=0;
my@prods=();
my$line_num=0;
my$has_invalid_qty=0;
while(<F>){s/\n//g;
s/\r//g;
my($prod,$qtty)=split/#/;
$prod||="";
next unless$prod;
if($prod eq '9999'){$print_bill_internal=1;
last;}elsif($prod eq '9998'){$print_bill_internal=0;
last;}my$prod_id=$PRODUCTS_IDS_BY_HANDY_PLU->{$prod};
next unless defined$prod_id;
if($qtty==0){$has_invalid_qty=1;}push@prods,{id=>$prod_id,qty=>$qtty,line_num=>$line_num,handy=>$prod};
$line_num++;}close(F);
if($has_invalid_qty){my$area_name=$AREAS_INFO{$area}->[0];
my$clerk_name=$CLERKS_INFO->{$clerk}->{login};
my$txt="----------------------------------------\n"."      !!!!!! INVALID REQUEST !!!!!!\n"."----------------------------------------\n".$area_name." / ".$table."\n".$clerk_name."\n"."----------------------------------------\n";
for(@prods){my$name=$PRODUCTS_INFO->{$_->{id}}->{name};
$name=sprintf("%-25s",substr($name,0,20));
$txt.=sprintf("%6s",$_->{handy})." ".$name." ".$_->{qty}."\n";}$txt.="\@paper_cut\@";
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
print STDERR$txt."\n";
open(F,"> $print_file");
print F$txt;
close(F);
return;}if($print_bill_internal!=-1){my$file=$dir_server."/server/data/tmp/x64_printbill_".$comando."_".$clerk."_".$area."_".$table."_".$print_bill_internal."_$station#".time.$$.".txt";
open(NNN,"> $file");
print NNN"1\n";
close(NNN);
return;}my@ndup_products=();
my$ignored=0;
for(@prods){my$md5_str="r#".$comando."#".$clerk."#".$area."#".$table."#".$_->{id}."#".$_->{qty}."#".$_->{line_num};
my$md5=&md5_hex($md5_str);
if(!exists$X64_CONTROL{$md5}){push@ndup_products,$_;}else{my$cur_time=time;
my$diff=$cur_time-$X64_CONTROL{$md5};
if($diff<=8){$ignored=1;
my$msg="REQ - DUPPLICATE! ($diff secs), comando: $comando, clerk: $clerk, area: $area, "."table: $table, product: ".$_->{id}.", qty: ".$_->{qty}.", linenum: ".$_->{line_num}."\n";
&x64_log($msg);}else{my$msg="REQ - IN MD5, BUT OK! ($diff secs), comando: $comando, clerk: $clerk, area: $area, "."table: $table, product: ".$_->{id}.", qty: ".$_->{qty}.", linenum: ".$_->{line_num}."\n";
&x64_log($msg);
push@ndup_products,$_;}}$X64_CONTROL{$md5}=time;}&x64_log("PRODS TO REQUEST: ".(scalar@ndup_products).", comando: $comando, clerk: $clerk, area: $area, table: $table");
if(!scalar@ndup_products){return;}@prods=();
my%prod_idx=();
for(my$i=0;$i<scalar(@ndup_products);$i++){my$cur=$ndup_products[$i];
my$next=$ndup_products[$i+1];
if(exists$PRODUCTS_EXTRAS->{$cur->{id}}){push@prods,$cur;}else{if(defined$next&&exists$PRODUCTS_EXTRAS->{$next->{id}}){push@prods,$cur;}else{if(exists$prod_idx{$cur->{id}}){$prods[$prod_idx{$cur->{id}}]->{qty}+=$cur->{qty};}else{push@prods,$cur;
$prod_idx{$cur->{id}}=scalar@prods-1;}}}}foreach my $pp(@prods){my$prod=$pp->{id};
my$qty=$pp->{qty};
&_send_product_request_to_ui($machine,$station,$clerk,$area,$table,$prod,$qty);}}}sub station_message{my($machine,$file)=@_;
print STDERR"> station_message - $file\n";
my$cfg=$machine->config()->load_fixed();
my$station=$cfg->{STATION_NUMBER}||"0";
my($station_from,$station_to,$clerk_who_sent)=$file=~/station_message#(\d+)#(\d+)#(\d+)\.txt$/;
if($station eq$station_from){my$db=$machine->database();
&get_clerks_information($db);
local$/=undef;
open(F,"< $file");
my$cnt=<F>;
close(F);
my$clerk_name=exists$CLERKS_INFO->{$clerk_who_sent}?$CLERKS_INFO->{$clerk_who_sent}->{login}:'UNKNOWN';
my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$full_msg="==========================================\n"."================ MENSAGEM ================\n"."==========================================\n"."DATA         : $date\n"."ENVIADO POR  : $clerk_name\n"."POSTO ORIGEM : $station_from\n"."POSTO DESTINO: $station_to\n"."\n"."$cnt"."==========================================\n";
open(F,"> ".$machine->dir_tmp()."/printer_screen.txt");
print F$full_msg;
close(F);}}sub burn_voucher{my($machine,$file)=@_;
print STDERR"> burn_voucher - $file\n";
if($machine->is_server()){my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
if(!defined$CLOSE_HOUR){my$close_hour=$cfg->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my($voucher_id,$amount,$unknown_id)=$file=~/burn_voucher#(\d+)#(.*?)#(.*?)\.txt$/;
if($voucher_id==0){my$tmp=$db->select("SELECT MAX(id) AS doc_id FROM sales_headers");
my$gen_doc={};
if(scalar@$tmp){my$doc=$db->select("SELECT * FROM sales_headers WHERE id = ?",$tmp->[0]->{doc_id});
$gen_doc=$doc->[0];}my$generated_doc=$gen_doc?$gen_doc->{fo_doc_number}:"";
my$business_date=&date_based_on_closing_hour($date,$CLOSE_HOUR);
my$id=$db->next_id("vouchers");
$db->do("INSERT INTO vouchers VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",$id,$business_date,$date,'2200-01-01',undef,$generated_doc,1,$amount,1,$unknown_id,$date);}else{$db->do("UPDATE vouchers SET date_used = ?, was_used_already = 1 WHERE id = ?",$date,$voucher_id,);}}else{return 2;}}sub create_voucher{my($machine,$file)=@_;
if($machine->is_server()){print STDERR"> create_voucher - $file\n";
my$cfg=$machine->config()->load_fixed();
$cfg->{VOUCHER_EXPIRES}||='';
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}if(!defined$CLOSE_HOUR){my$close_hour=$cfg->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}my($orig_doc_id,$created_rvd_gambas_id,$station,$clerk)=$file=~/print_voucher#(\d+)#(\d+)#(\d+)#(\d+)\.txt$/;
my$gen_doc={};
my$orig_doc={};
print STDERR"$orig_doc_id - $created_rvd_gambas_id - $station - $clerk\n";
my$db=$machine->database();
if($orig_doc_id){my$doc=$db->select("SELECT * FROM sales_headers WHERE id = ?",$orig_doc_id);
$orig_doc=$doc->[0];}if($created_rvd_gambas_id){my$tmp=$db->select("SELECT MAX(id) AS doc_id FROM sales_headers");
if(scalar@$tmp){my$doc=$db->select("SELECT * FROM sales_headers WHERE id = ?",$tmp->[0]->{doc_id});
$gen_doc=$doc->[0];}}local$/=undef;
open(F,"< $file");
my$cnt=<F>;
$cnt=~s/\n//g;
$cnt=~s/\r//g;
close(F);
my$date_created=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$expires=$cfg->{VOUCHER_EXPIRES}?&_decode_expire($cfg->{VOUCHER_EXPIRES}):'';
my$original_doc=$orig_doc?$orig_doc->{fo_doc_number}:"";
my$generated_doc=$gen_doc?$gen_doc->{fo_doc_number}:"";
my$business_date=&date_based_on_closing_hour($date_created,$CLOSE_HOUR);
my$new_id=$db->next_id("vouchers");
$expires='2300-01-01' if$expires eq"";
$db->do("INSERT INTO vouchers VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",$new_id,$business_date,$date_created,$expires,$original_doc,$generated_doc,0,$cnt,0,undef,undef);
my$inserted_id=$new_id;
my$content="";
my%info=(business_date=>$business_date,date_created=>$date_created,expiration_date=>$expires,value=>$cnt,voucher_num=>$inserted_id,original_doc=>$original_doc,generated_doc=>$generated_doc,);
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('voucher_create.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){$BARCODES{$print_file}=$inserted_id;
open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}else{return 2;}}sub execute_customer_display{my($machine,$file)=@_;
my($area,$check_id)=$file=~/\/customer_display#(\d+)#(.*?)#/;
my$str="";
if(open(F,"< ".$file)){local$/=undef;
$str=<F>;
$str=~s/\n//g;
$str=~s/\r//g;
close(F);
unlink($file);}my$cfg=$machine->config()->load_fixed();
$cfg->{VIDEO_RECORDER_PORT}||="";
if($cfg->{VIDEO_RECORDER_PORT}){system("/opt/pos/common/bin/send_to_recorder.pl ".$cfg->{VIDEO_RECORDER_PORT}." $area \"".$AREAS_INFO{$area}->[0]."\" $check_id customerdisplay \"$str\"");}$cfg->{Hardware}->{CustomerDisplays}->{Device}||=[];
foreach my $info(@{$cfg->{Hardware}->{CustomerDisplays}->{Device}}){$info->{Model}||='TOSHIBA';
$info->{Baudrate}||='';
$info->{Parity}||='';
$info->{Databits}||='';
$info->{Stopbits}||='';
$info->{RtsCts}||=0;
$info->{DtrDsr}||=0;
$info->{Inactive}||=0;
if($info->{Inactive}){next;}my$obj=undef;
eval{my$class="App::POS::Hardware::CustomerDisplays::".$info->{Model};
$obj=$class->new(info=>$info);};
if($@){print STDERR"ERROR USING DRIVER - ".$info->{Model}." : $@\n";
return;}if($obj->type()eq 'SERIAL'){my$PortObj=Device::SerialPort->new($info->{Device});
if(defined$PortObj){$PortObj->baudrate($info->{Baudrate})if$info->{Baudrate};
$PortObj->parity($info->{Parity})if$info->{Parity};
$PortObj->databits($info->{Databits})if$info->{Databits};
$PortObj->stopbits($info->{Stopbits})if$info->{Stopbits};
$PortObj->rts_active($info->{RtsCts})if$info->{RtsCts};
$PortObj->dtr_active($info->{DtrDsr})if$info->{DtrDsr};
$obj->serial_obj($PortObj);
$obj->write($str);}else{print STDERR"Error on ".$info->{Device}."\n";}}elsif($obj->type eq 'VIRTUAL'){$obj->write($str);}else{print STDERR"Customer display's type (".$obj->type().") is not supported at this moment...\n";
return;}}}sub print_offer_ticket{my($machine,$file)=@_;
my($id,$station)=$file=~/\/print_offer_ticket#(\d+)#(\d+)\./;
my$db=$machine->database();
my$cfg=$machine->config()->load_fixed();
my$headers=$db->select(qq{
    SELECT h.*, sh.hash, sh.hash_small
    FROM sales_headers h
    LEFT JOIN sales_hashes sh ON (h.id = sh.header)
    WHERE h.id = ?
  },$id);
my$details=$db->select("SELECT * FROM sales_details WHERE header = ? AND operation_type = 1",$id);
my$footers=$db->select("SELECT * FROM sales_payments WHERE header = ?",$id);
return unless scalar@$headers;
my%offer_lines=();
my@offer_lines=();
{local$/=undef;
open(N,"< $file");
my$cnt=<N>;
chop($cnt);
close(N);
@offer_lines=split/\n/,$cnt;
if(scalar@offer_lines&&$offer_lines[0]!=0){map{$offer_lines{$_}=1}@offer_lines;}}my$clerk_closed=0;
my$h=$headers->[0];
&get_products_information($db);
&get_clerks_information($db);
$cfg->{STATION_PRINT_CHECKS}=exists$cfg->{STATION_PRINT_CHECKS}?$cfg->{STATION_PRINT_CHECKS}:99;
$cfg->{STATION_PRINT_CHECKS}=99 if$cfg->{STATION_PRINT_CHECKS}==$cfg->{STATION_NUMBER};
$cfg->{CHECK_GROUP_PRODUCTS_TEXT}||="";
my$mult=1;
return if$h->{doc_type}==3;
my$template="check_offer";
$clerk_closed=$h->{clerk_close};
my$total_discounts=0;
my$total_offers=0;
if($template){if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}if($cfg->{PRINT_BARCODE_IN_CHECK}){$BARCODES{$file}="77777".sprintf("%07s",$h->{id});}$h->{clerk_open_name}=exists$CLERKS_INFO->{$h->{clerk_open}}?$CLERKS_INFO->{$h->{clerk_open}}->{login}:'UNKNOWN';
$h->{clerk_close_name}=exists$CLERKS_INFO->{$h->{clerk_close}}?$CLERKS_INFO->{$h->{clerk_close}}->{login}:'UNKNOWN';
my%vat=();
$h->{discount}||="";
my$global_discount_ratio=0;
if($h->{discount}ne ''){my@a=split/\@/,$h->{discount};
$global_discount_ratio=$a[1];}$h->{value}=$h->{value}*$mult;
($h->{hour_opened})=$h->{date}=~/^.*?\s(\d\d\:\d\d)/;
($h->{hour_closed})=$h->{date_closed}=~/^.*?\s(\d\d\:\d\d)/;
my$medias=[];
foreach my $d(sort{$a->{payment_media}cmp$b->{payment_media}}@{$footers}){$d->{payment_media_orig}=$d->{payment_media};
$d->{payment_media}=&my_conv($d->{payment_media},20);
$d->{value}=$d->{value}*$mult;
push@$medias,$d;}$footers=$medias;
my$my_details=[];
my$products_quantities=0;
foreach my $d(@{$details}){if(scalar keys%offer_lines){next unless exists$offer_lines{$d->{gb_identifier}};}next if$d->{quantity}*1==0;
$d->{quantity}=$d->{quantity}*$mult;
$d->{clerk_name}=exists$CLERKS_INFO->{$d->{clerk}}?$CLERKS_INFO->{$d->{clerk}}->{login}:'UNKNOWN';
$d->{product_name}=exists$PRODUCTS_INFO->{$d->{product}}?$PRODUCTS_INFO->{$d->{product}}->{name}:'UNKNOWN';
$d->{vat}||=0;
if($d->{quantity}*($d->{price}-$d->{discount}-$d->{offer})>0&&$global_discount_ratio>0){my$v=$d->{quantity}*($d->{price}-$d->{discount}-$d->{offer})*$global_discount_ratio;
$d->{discount}+=$v;}$total_discounts+=$d->{discount};
$total_offers+=$d->{offer};
my$price=$d->{price}-$d->{discount}-$d->{offer};
my$wo_vat=$d->{price}-(($d->{price}*$d->{vat})/100);
my$line_total=$d->{quantity}*($price);
$vat{$d->{vat}}->{w_vat}+=sprintf("%.2f",$d->{quantity}*$price);
$vat{$d->{vat}}->{wo_vat}+=sprintf("%.2f",$wo_vat);
$vat{$d->{vat}}->{vat_v}+=sprintf("%.2f",$d->{quantity}*$price-$wo_vat);
$d->{line_total}=sprintf("%7s",sprintf("%.02f",$line_total));
$d->{unit_price}=sprintf("%7s",sprintf("%.02f",$price));
$d->{product_name}=&my_conv($d->{product_name},26);
$d->{txts}=[];
if($d->{free_text}&&$d->{free_text}ne 'EXTRA'){my@t=split/;/,$d->{free_text};
for my $tok(@t){next unless$tok;
$Text::Wrap::columns=38;
my$l=wrap('','',$tok);
my@lines=split/\n/,$l;
for(@lines){push@{$d->{txts}},$_;}}if(scalar@{$d->{txts}}==1&&$d->{txts}->[0]eq 'MENU'){$d->{txts}=[];}}$products_quantities+=$d->{quantity};
push@$my_details,$d;}$details=$my_details;
my%info=(check=>{headers=>$h,details=>$details,payments=>$footers,products_number=>scalar@$details,products_quantities=>$products_quantities,total_discounts=>$total_discounts,},);
my$content="";
$info{vat_info}=\%vat;
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template.'.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}sub reprint_orders{my($machine,$file)=@_;
if($machine->is_server()){my($station,$printer,$number_to_print,$type)=$file=~/\/reprint_orders#(\d+)#(\d+)#(\d+)#(.*?)\./;
print STDERR"##> $file - $station - $printer - $number_to_print\n";
my$dir_to_use=$type eq 'orders'?'order_archive':'print_checks_archive';
my$archive_dir=$machine->dir_server().'/server/data/'.$dir_to_use.'/'.$station."/".$printer;
return 1 unless-d$archive_dir;
$number_to_print=3 unless$number_to_print;
my$done_count=0;
opendir(DIR,$archive_dir);
my@dir=readdir(DIR);
closedir(DIR);
@dir=sort{-M"$archive_dir/$a"<=>-M"$archive_dir/$b"}(@dir);
foreach my $file(@dir){next if$file=~/^\./;
if($done_count>10){unlink$archive_dir."/".$file;
return;}if($done_count<$number_to_print){print STDERR"###### WILL COPY - $file - $\n";
&copy($archive_dir."/".$file,$machine->server_dir_tmp()."/".$_);}$done_count++;}}else{return 2;}}sub print_reprint_checks{my($machine,$file)=@_;
my($station,$clerk,$business_date)=$file=~/\/print_reprint_checks#(\d+)#(\d+)#(.*?)#/;
print STDERR"##> $file - $station - $clerk - $business_date\n";
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my$db=$machine->database();
&get_clerks_information($db);
my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{business_date}=$business_date;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
my$doc_types=$machine->config()->doc_types_by_id();
my@recs=();
my$total=0;
if(open(F,"< $file")){while(<F>){chop;
my($id,$doc_type,$fo_doc_num,$datetime,$tmp1,$tmp2,$value,$clerk_open,$clerk_close)=split/#/,$_;
my$doc_type_name=$doc_types->{$doc_type};
$total+=$value;
push@recs,{id=>$id,doc_type=>$doc_type,doc_type_name=>$doc_type_name,fo_doc_number=>$fo_doc_num,datetime=>$datetime,area_table=>defined$tmp1&&$tmp1?$tmp1:"        ",tmp2=>$tmp2,value=>$value,clerk_open=>$clerk_open,clerk_close=>$clerk_close,};}close(F);}$info{tickets}=\@recs;
$info{total}=$total;
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_reprint_checks.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub print_customer_profile{my($machine,$file)=@_;
my($customer_id,$to_screen,$station,$clerk)=$file=~/\/print_customer_profile#(\d+)#(\d+)#(\d+)#(\d+)\./;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my$db=$machine->database();
my$cfg=$machine->config()->load_fixed();
&get_clerks_information($db);
&get_products_information($db);
my%info=();
my$content="";
my$sth=$db->dbh()->prepare(qq{
    SELECT h.id, d.clerk_name, COUNT(*)
    FROM sales_details d
    LEFT JOIN sales_headers h ON (d.header = h.id)
    WHERE h.customer_id = ? AND d.operation_type = 1 AND h.doc_type IN (1,5,90,12,7)
    GROUP BY h.id, d.clerk_name
  });
$sth->execute($customer_id);
my%qttys_control=();
my%quantities_sold_by_clerk=();
while(my$row=$sth->fetchrow_hashref){if(!exists$qttys_control{$row->{clerk_name}."#".$row->{id}}){$qttys_control{$row->{clerk_name}."#".$row->{id}}=1;
$quantities_sold_by_clerk{$row->{clerk_name}}++;}}$sth=$db->dbh()->prepare(qq{
    SELECT d.product, h.customer_nif, h.customer,
      SUM(d.quantity) AS qtty, MIN(h.business_date) AS first_visit,
      MAX(h.business_date) AS last_visit
    FROM sales_details d
    LEFT JOIN sales_headers h ON (d.header = h.id)
    WHERE h.customer_id = ? AND d.operation_type = 1 AND h.doc_type IN (1,5,90,12,7)
    GROUP BY d.product, h.customer_nif, h.customer
    ORDER BY SUM(d.quantity) DESC
  });
$sth->execute($customer_id);
my%sales_by_factor_tmp=();
my%son_products=();
while(my$row=$sth->fetchrow_hashref){$info{name}=$row->{customer}unless exists$info{name};
$info{first_visit}=$row->{first_visit}unless exists$info{first_visit};
$info{last_visit}=$row->{last_visit}unless exists$info{last_visit};
$info{nif}=$row->{customer_nif};
my$product_name=exists$PRODUCTS_INFO->{$row->{product}}?$PRODUCTS_INFO->{$row->{product}}->{name}:'UNKNOWN';
push@{$info{products}},{id=>$row->{product},quantity=>$row->{qtty},name=>$product_name,}}$info{qttys_by_clerk}=\%quantities_sold_by_clerk;
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_customer_profile.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
if($to_screen){$content=~s/\@.*?\@//g;
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);}else{my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}sub print_schedule{my($machine,$file)=@_;
my($schedule,$date_start,$date_end,$to_screen,$station,$clerk)=$file=~/\/print_schedule#(\d+)#(.*?)#(.*?)#(\d+)#(\d+)#(\d+)\./;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my$db=$machine->database();
my$cfg=$machine->config()->load_fixed();
my$schedules_tmp=$cfg->{SCHEDULES}||"";
my$schedules=[];
if($schedules_tmp){if(!ref$schedules_tmp){push@$schedules,$schedules_tmp;}else{$schedules=$schedules_tmp;}}if(!scalar@$schedules){print STDERR"No schedules available...\n";
return;}&get_clerks_information($db);
my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{name}=$schedules->[$schedule];
$info{date_start}=$date_start;
$info{date_end}=$date_end;
my$recs=$db->select(qq{
    SELECT *
    FROM schedules
    WHERE schedule = ? AND schedule_date >= ? AND schedule_date <= ? ORDER BY start_hour, end_hour
  },$schedule,$date_start,$date_end);
foreach my $r(@$recs){push@{$info{schedules}->{$r->{schedule_date}}},{start_hour=>$r->{start_hour},end_hour=>$r->{end_hour},description=>$r->{description},};}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_schedule.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
if($to_screen){$content=~s/\@.*?\@//g;
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);}else{my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}sub report_products_list{my($machine,$file)=@_;
my($report_type,$gid,$parent_gid,$code,$price,$sort,$station,$clerk)=$file=~/\/report_products_list#(.*?)#(.*?)#(.*?)#(.*?)#(.*?)#(.*?)#(\d+)#(\d+)\./;
print STDERR"##> $file - $station - $clerk - $report_type - $gid - $parent_gid - $code - $price - $sort\n";
my$db=$machine->database();
my$where="";
my@groups=();
my$group_name="";
my$department_name="";
if($report_type eq 'group'){if($parent_gid eq '0'){my$recs=$db->select("SELECT name FROM groups WHERE id = $gid");
$group_name=$recs->[0]->{name};
$department_name="";
$recs=$db->select("SELECT id FROM groups WHERE parent = $gid AND deleted = 0");
map{push@groups,$_->{id}}@$recs;}else{my$recs=$db->select("SELECT name, parent FROM groups WHERE id = $gid");
$department_name=$recs->[0]->{name};
$recs=$db->select("SELECT name FROM groups WHERE id = ".$recs->[0]->{parent});
$group_name=$recs->[0]->{name};
push@groups,$gid;}if(scalar@groups){$where.=" AND pg.group_id IN (".join(",",@groups).")";}}if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}&get_clerks_information($db);
my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{group_name}=$group_name;
$info{department_name}=$department_name;
my$code_field=$code eq 'handy_plu'?'handy_plu':'id';
my$sort_field="name";
if($sort eq 'code'){$sort_field=$code_field;}elsif($sort eq 'price'){$sort_field="sell_price".$price;}my$recs=$db->select(qq{
    SELECT p.id, p.$code_field AS product_code, p.sell_price$price AS product_price, p.name AS product_name
    FROM products p
    LEFT JOIN product_groups pg ON (pg.product_id = p.id)
    WHERE p.deleted = 0$where
    ORDER BY p.$sort_field
  });
my%tmp;
for(@$recs){next if exists$tmp{$_->{id}};
$tmp{$_->{id}}=1;
$_->{product_name}=string_normalize(my_conv($_->{product_name}));}$info{records}=$recs;
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_product_list.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub print_to_main_printer{my($machine,$file)=@_;
my($station,$clerk)=$file=~/\/print_to_main_printer#(\d+)#(\d+)#/;
open(F,"< $file");
local$/=undef;
my$content=<F>;
close(F);
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub print_tech_report{my($machine,$file)=@_;
my($station,$clerk)=$file=~/\/print_tech_report#(\d+)#(\d+)\./;
print STDERR"##> $file - $station - $clerk\n";
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my$db=$machine->database();
&get_clerks_information($db);
my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_tech.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub print_daily_specials{my($machine,$file)=@_;
my($station,$clerk)=$file=~/\/print_daily_specials#(\d+)#(\d+)#.*?\./;
print STDERR"##> $file - $station - $clerk\n";
if(open(F,"< $file")){my$db=$machine->database();
&get_products_information($db);
my@products=();
while(<F>){chop;
next unless$_;
my@a=split/#/;
my$name=exists$PRODUCTS_INFO->{$a[0]}?$PRODUCTS_INFO->{$a[0]}->{name}:'UNKNOWN';
push@products,{id=>$a[0],price=>$a[1],name=>$name,};}close(F);
if(scalar@products){my$content="";
my%info;
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{products}=\@products;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('daily_specials.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}}sub check_reprint{my($machine,$file)=@_;
return 2 unless$machine->is_server();
my($id,$meals,$station,$check_date,$time,$lang,$to_screen,$is_dup,$pdf_only)=$file=~/\/reprint_check#(\d+)#(\d+)#(\d+)#(.*?)#(.*?)#(.*?)#(\d+)#(\d+)#(\d+)\./;
my($y,$m)=$check_date=~/^(\d+)\-(\d+)\-/;
my$db=$machine->database();
my$cfg=$machine->config()->load_fixed();
if($lang){&get_products_translations($db);}$pdf_only||=0;
if(!defined$MESSAGES_INFO){my$q=qq{
      SELECT id, name FROM products WHERE is_message = 1 AND deleted = 0
    };
my$tmp=$db->select($q);
map{$MESSAGES_INFO->{$_->{id}}=$_}@$tmp;}my$headers=$db->select(qq{
    SELECT h.*, sh.hash, sh.hash_small, sha1.key_value AS check_name, sha2.key_value AS obs,
      sha3.key_value AS canceled, sha4.key_value AS car_plate, sha5.key_value AS delivery_site,
      sha6.key_value AS load_site, sha7.key_value AS kept_in_source,
      sha8.key_value AS print_to_simplified_invoice, sha9.key_value AS at_code,
      sha10.key_value AS delivery_hour, sha11.key_value AS load_hour, sha12.key_value AS load_date,
      sha13.key_value AS delivery_date, sha14.key_value AS manualdoc_serie,
      sha15.key_value AS manualdoc_total_w_vat, sha16.key_value AS manualdoc_total_vat,
      sha17.key_value AS manualdoc_docnum, sha18.key_value AS manualdoc_date,
      sha19.key_value AS manualdoc_type, sha20.key_value AS lines_source_assoc,
      sha21.key_value AS refunded
    FROM sales_headers h
    LEFT JOIN sales_headers_aux sha1  ON (h.id = sha1.header  AND sha1.key_name  = 'check_name')
    LEFT JOIN sales_headers_aux sha2  ON (h.id = sha2.header  AND sha2.key_name  = 'obs')
    LEFT JOIN sales_headers_aux sha3  ON (h.id = sha3.header  AND sha3.key_name  = 'canceled')
    LEFT JOIN sales_headers_aux sha4  ON (h.id = sha4.header  AND sha4.key_name  = 'car_plate')
    LEFT JOIN sales_headers_aux sha5  ON (h.id = sha5.header  AND sha5.key_name  = 'delivery_site')
    LEFT JOIN sales_headers_aux sha6  ON (h.id = sha6.header  AND sha6.key_name  = 'load_site')
    LEFT JOIN sales_headers_aux sha7  ON (h.id = sha7.header  AND sha7.key_name  = 'kept_in_source')
    LEFT JOIN sales_headers_aux sha8  ON (h.id = sha8.header  AND sha8.key_name  = 'print_to_simplified_invoice')
    LEFT JOIN sales_headers_aux sha9  ON (h.id = sha9.header  AND sha9.key_name  = 'at_code')
    LEFT JOIN sales_headers_aux sha10 ON (h.id = sha10.header AND sha10.key_name = 'delivery_hour')
    LEFT JOIN sales_headers_aux sha11 ON (h.id = sha11.header AND sha11.key_name = 'load_hour')
    LEFT JOIN sales_headers_aux sha12 ON (h.id = sha12.header AND sha12.key_name = 'load_date')
    LEFT JOIN sales_headers_aux sha13 ON (h.id = sha13.header AND sha13.key_name = 'delivery_date')
    LEFT JOIN sales_headers_aux sha14 ON (h.id = sha14.header AND sha14.key_name = 'manualdoc_serie')
    LEFT JOIN sales_headers_aux sha15 ON (h.id = sha15.header AND sha15.key_name = 'manualdoc_total_w_vat')
    LEFT JOIN sales_headers_aux sha16 ON (h.id = sha16.header AND sha16.key_name = 'manualdoc_total_vat')
    LEFT JOIN sales_headers_aux sha17 ON (h.id = sha17.header AND sha17.key_name = 'manualdoc_docnum')
    LEFT JOIN sales_headers_aux sha18 ON (h.id = sha18.header AND sha18.key_name = 'manualdoc_date')
    LEFT JOIN sales_headers_aux sha19 ON (h.id = sha19.header AND sha19.key_name = 'manualdoc_type')
    LEFT JOIN sales_headers_aux sha20 ON (h.id = sha20.header AND sha20.key_name = 'lines_source_assoc')
    LEFT JOIN sales_headers_aux sha21 ON (h.id = sha21.header AND sha21.key_name = 'refunded')
    LEFT JOIN sales_hashes sh ON (h.id = sh.header)
    WHERE h.id = ?
  },$id);
my$details=$db->select(qq{
    SELECT *
    FROM sales_details
    WHERE header = ? AND operation_type = 1
    ORDER BY gb_identifier
  },$id);
my$footers=$db->select(qq{
    SELECT * FROM sales_payments WHERE header = ?
  },$id);
return unless scalar@$headers;
$cfg->{SAFT_PRINT_TRANSPORT_DOCS}||=0;
$cfg->{LANG}||='PT';
$cfg->{STATION_PRINT_CHECKS}=exists$cfg->{STATION_PRINT_CHECKS}?$cfg->{STATION_PRINT_CHECKS}:99;
$cfg->{STATION_PRINT_CHECKS}=99 if$cfg->{STATION_PRINT_CHECKS}==$cfg->{STATION_NUMBER};
$cfg->{CHECK_GROUP_PRODUCTS_TEXT}||="";
$cfg->{WEIGHT_AS_INVOICE_ID}||=0;
$cfg->{MENUS_PRINT_SELECTIONS}||=0;
$cfg->{TAX_TO_KEEP_IN_SOURCE}||=0;
$cfg->{CUSTOMER_VAT_ISENTION}||="";
$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}||=0;
$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}=1 if$headers->[0]->{doc_type}==10;
my$pt_certified_software=-e$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server"?1:0;
if($pt_certified_software){$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}=1;
$cfg->{SHOW_ZERO_PRICE_IN_BILL}=1;}if($pt_certified_software){if($headers->[0]->{doc_type}eq '10'||$headers->[0]->{doc_type}eq '11'){$headers->[0]->{at_code}||=&translate($machine,"SEM CODIGO AT");}}my$clerk_closed=0;
my$h=$headers->[0];
$h->{refunded}||=0;
$h->{canceled}=1 if$h->{refunded};
$h->{meals}=$meals;
$h->{training_mode}=$h->{fo_doc_number}=~/^EXT999 /?1:0;
if($h->{training_mode}&&scalar@$SOFTWARE_INFO){$h->{training_software_number}=$SOFTWARE_INFO->[0];
$h->{training_software_company}=$SOFTWARE_INFO->[1];
$h->{training_software_version}=$SOFTWARE_INFO->[2];
$h->{training_software_nif}=$SOFTWARE_INFO->[3];}my$business_date=$h->{business_date};
if($h->{customer_nif}){my$cust=$db->select("SELECT * FROM customers WHERE nif = ? ORDER BY deleted ASC LIMIT 1",$h->{customer_nif});
if(scalar@$cust){$h->{customer_id}=$cust->[0]->{id};
$h->{customer_credit}=$cust->[0]->{total_credit};
$h->{customer_address}=$cust->[0]->{address};
$h->{customer_postal_code}=$cust->[0]->{postal_code};
$h->{customer_city}=$cust->[0]->{city};
$h->{customer_contact}=$cust->[0]->{contact};}}&get_products_information($db);
if(!defined$VAT_ISENTIONS){my%t=();
my$tmp=$db->select(qq{
      SELECT id, vat_isention
      FROM products
      WHERE vat_isention <> '' AND vat_isention <> '0'
    });
for(@$tmp){next if$_->{vat_isention}=~/^\s+$/;
$Text::Wrap::columns=38;
my$l=wrap('','',$_->{vat_isention});
$t{$l}=1;
$VAT_ISENTIONS->{$_->{id}}=$l;}my$idx=1;
for(sort keys%t){$VAT_ISENTIONS_IDX->{$_}=$idx++;}}&get_clerks_information($db);
my$custom_invoice_id="";
if($cfg->{WEIGHT_AS_INVOICE_ID}){$custom_invoice_id=$h->{customer}||"";}$h->{custom_invoice_id}=$custom_invoice_id;
my$mult=$h->{doc_type}==2||$h->{doc_type}==13?-1:1;
return if$h->{doc_type}==3;
my$template="";
if($h->{doc_type}!=8){if(-e$machine->dir().'/common/print_templates/'.$cfg->{LANG}."/check_reprint.tmpl"){$template=$cfg->{LANG}."/check_reprint";}else{$template="check_reprint";}}else{if(-e$machine->dir().'/common/print_templates/'.$cfg->{LANG}."/customer_payment_reprint.tmpl"){$template=$cfg->{LANG}."/customer_payment_reprint";}else{$template="customer_payment_reprint";}}$clerk_closed=$h->{clerk_close};
my$total_discounts=0;
my$total_offers=0;
if($template){if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}if($cfg->{PRINT_BARCODE_IN_CHECK}){$BARCODES{$file}="77777".sprintf("%07s",$h->{id});}&set_owner_information($machine,$h);
$h->{doc_via}=$is_dup?2:1;
$h->{clerk_open_name}=exists$CLERKS_INFO->{$h->{clerk_open}}?$CLERKS_INFO->{$h->{clerk_open}}->{login}:'UNKNOWN';
$h->{clerk_close_name}=exists$CLERKS_INFO->{$h->{clerk_close}}?$CLERKS_INFO->{$h->{clerk_close}}->{login}:'UNKNOWN';
my%vat=();
$h->{discount}||="";
my$global_discount_ratio=0;
if($h->{discount}ne ''){my@a=split/\@/,$h->{discount};
$global_discount_ratio=$a[1];}my$cur_date=&strftime("%Y-%m-%d",localtime);
my$cur_hour=&strftime("%H:%M:%S",localtime);
$h->{cur_date}=$cur_date;
$h->{cur_hour}=$cur_hour;
$h->{area_name}=exists$AREAS_INFO{$h->{area}}?$AREAS_INFO{$h->{area}}->[0]:'<UNKNOWN>';
$h->{area_tables}=exists$AREAS_INFO{$h->{area}}?$AREAS_INFO{$h->{area}}->[1]:0;
$h->{table_number}=$h->{table_num};
$h->{print_to_simplified_invoice}||=0;
$h->{value}=$h->{value}*$mult;
$h->{meals_txt}=&translate($machine,$cfg->{CHECK_GROUP_PRODUCTS_TEXT});
($h->{hour_opened})=$h->{date}=~/^.*?\s(\d\d\:\d\d)/;
($h->{hour_closed})=$h->{date_closed}=~/^.*?\s(\d\d\:\d\d)/;
my$medias=[];
foreach my $d(sort{$a->{payment_media}cmp$b->{payment_media}}@{$footers}){$d->{payment_media_orig}=$d->{payment_media};
$d->{payment_media}=&my_conv($d->{payment_media},20);
$d->{value}=$d->{value}*$mult;
push@$medias,$d;}$footers=$medias;
my$my_details=[];
my%vat_isentions=();
my$use_print_priorities=0;
my%t=();
$h->{lines_source_assoc}||="";
my%ft_gt_assocs=();
my$ft_gt_idx;
my%ft_gt_idx=();
if($h->{doc_type}==7&&$h->{lines_source_assoc}){my@a=split/,/,$h->{lines_source_assoc};
for(@a){my@b=split/_/,$_;
if(!exists$ft_gt_idx{$b[1]}){$ft_gt_idx++;
$ft_gt_idx{$b[1]}=$ft_gt_idx;}$ft_gt_assocs{$b[0]}={gbi=>$b[1],idx=>$ft_gt_idx{$b[1]}};}}foreach my $d(@{$details}){if($d->{free_text}eq 'MENU'){$d->{product_type}='MENU';}elsif($d->{free_text}eq 'EXTRA'){$d->{product_type}='EXTRA';}else{$d->{product_type}='';}next if$d->{product_name}=~/^\-\-\-\-\-\-\-\-\-\-/;
if($cfg->{MENUS_PRINT_SELECTIONS}eq"1"){if(!exists$PRODUCTS_MENUS->{$d->{product}}&&$d->{product_type}ne 'MENU'){if(!$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}){next unless$d->{price}*1!=0;}}}else{if(!$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}){next unless$d->{price}*1!=0;}}$d->{discount}||=0;
$d->{offer}||=0;
$d->{printing_priority}=$PRINTING_PRIORITIES->{$d->{product}};
$d->{is_menu}=exists$PRODUCTS_MENUS->{$d->{product}}?1:0;
$use_print_priorities=1 if$PRINTING_PRIORITIES->{$d->{product}};
my$key=$d->{product}."#".$d->{price}."#".$d->{discount}."#".$d->{free_text};
if(!$cfg->{MENUS_PRINT_SELECTIONS}){if($d->{product_type}eq 'MENU'&&$d->{price}==0){next;}}if($d->{is_menu}||$d->{product_type}eq 'MENU'){$key=$d->{gb_identifier};}if($PRODUCTS_INFO->{$d->{product}}->{is_weight}){$key=$d->{gb_identifier};}if($d->{is_menu}||$d->{free_text}eq 'MENU'){$key=$d->{gb_identifier};}if(%ft_gt_assocs){$key.="#".$ft_gt_assocs{$d->{gb_identifier}}->{gbi};}if(exists$t{$key}){$t{$key}->{quantity}+=$d->{quantity};}else{$t{$key}=$d;}}my@t=values%t;
if($use_print_priorities){@t=reverse sort{$a->{printing_priority}<=>$b->{printing_priority}}@t;}else{@t=sort{$a->{gb_identifier}cmp$b->{gb_identifier}}@t;}$details=\@t;
my$total_wo_discount=0;
my$total_wo_discount_wo_vat=0;
my$total_wo_vat=0;
my$total_wo_vat2=0;
my$products_quantities=0;
my$total_vat=0;
my$total_discount_wo_vat=0;
my$last_menu="";
foreach my $d(@{$details}){next if$d->{quantity}*1==0;
next if exists$MESSAGES_INFO->{$d->{product}};
$last_menu=$d if$d->{is_menu};
$d->{quantity}=$d->{quantity}*$mult;
$d->{vat}||=0;
next if exists$PRODUCTS_EXTRAS->{$d->{product}}&&$d->{price}==0;
if($lang&&exists$PRODUCTS_TRANSLATIONS->{$d->{product}}->{$lang}){$d->{product_name}=&my_conv($PRODUCTS_TRANSLATIONS->{$d->{product}}->{$lang},26);}else{$d->{product_name}=&my_conv($d->{product_name},26);}if(exists$VAT_ISENTIONS->{$d->{product}}&&$VAT_ISENTIONS->{$d->{product}}ne '0'&&$d->{vat}*1==0){$d->{product_name}="(".$VAT_ISENTIONS_IDX->{$VAT_ISENTIONS->{$d->{product}}}.") ".$d->{product_name};
$vat_isentions{$VAT_ISENTIONS_IDX->{$VAT_ISENTIONS->{$d->{product}}}}=$VAT_ISENTIONS->{$d->{product}};}if(%ft_gt_assocs&&exists$ft_gt_assocs{$d->{gb_identifier}}){$d->{product_name}="[".$ft_gt_assocs{$d->{gb_identifier}}->{idx}."] ".$d->{product_name};}$d->{is_weight}=$PRODUCTS_INFO->{$d->{product}}->{is_weight};
$d->{is_service}=$PRODUCTS_INFO->{$d->{product}}->{is_service};
$d->{txts}=[];
if($d->{free_text}&&$d->{free_text}ne 'EXTRA'){my@t=split/;/,$d->{free_text};
for my $tok(@t){next unless$tok;
$Text::Wrap::columns=38;
my$l=wrap('','',$tok);
my@lines=split/\n/,$l;
for(@lines){push@{$d->{txts}},$_;}}if(scalar@{$d->{txts}}==1&&$d->{txts}->[0]eq 'MENU'){$d->{txts}=[];}}my$sem_iva=my_round($d->{quantity}*$d->{price_wo_vat});
my$com_iva=my_round($d->{quantity}*$d->{price});
my$desconto_com_iva=0;
my$desconto_sem_iva=0;
if($d->{price}!=0){$d->{price_wo_vat}||=1;
$desconto_com_iva=$d->{quantity}*$d->{price}*($d->{discount}/$d->{price_wo_vat});
$desconto_sem_iva=$d->{quantity}*$d->{discount};}$total_discount_wo_vat+=$desconto_sem_iva;
$total_wo_vat+=$d->{quantity}*$d->{price_wo_vat};
$com_iva=$com_iva-$desconto_com_iva;
$sem_iva=$sem_iva-$desconto_sem_iva;
$total_wo_vat2+=($d->{quantity}*$d->{price_wo_vat})-($d->{quantity}*$d->{discount});
my$valor_iva=$com_iva-$sem_iva;
$d->{line_total_wo_vat}=$d->{price_wo_vat}*$d->{quantity};
$d->{unit_price_wo_vat}=$d->{price_wo_vat};
$d->{line_total}=$d->{price}*$d->{quantity};
$d->{unit_price}=$d->{price};
$d->{quantity}=$d->{quantity};
$d->{line_total_w_discount}=$d->{line_total}-my_round($desconto_com_iva);
$vat{$d->{vat}}->{w_vat}+=$d->{line_total_w_discount};
$vat{$d->{vat}}->{wo_vat}+=$desconto_com_iva>0?my_round($sem_iva):$sem_iva;
$total_discounts+=$desconto_com_iva;
$total_wo_discount+=my_round($d->{line_total});
$total_wo_discount_wo_vat+=my_round($d->{line_total_wo_vat});
$products_quantities+=$d->{quantity};
if(!$cfg->{MENUS_PRINT_SELECTIONS}){if($d->{product_type}eq 'MENU'){if($d->{price}*1>0){push@$my_details,$d;}}else{push@$my_details,$d;}}else{push@$my_details,$d;}}$total_vat=0;
for(keys%vat){$vat{$_}->{vat_v}=&my_round($vat{$_}->{w_vat})-&my_round($vat{$_}->{wo_vat});
$total_vat+=$vat{$_}->{vat_v};}$details=$my_details;
my$customer_name=$h->{customer};
my$customer_nif=$h->{customer_nif};
if($pt_certified_software){if(!$h->{customer_nif}||$h->{customer_nif}eq '999999990'){$h->{customer_nif}='*********';}if(!$h->{customer}){$h->{customer}='*********';}}$total_wo_vat||=1;
my$disc=100-(($total_wo_vat2/$total_wo_vat)*100);
$cfg->{MACHINE_LABEL}||="";
my%info=(check=>{machine_label=>$cfg->{MACHINE_LABEL},headers=>$h,details=>$details,payments=>$footers,products_number=>scalar@$details,products_quantities=>$products_quantities,discount_percent=>$disc,discount_amount=>$total_discounts,total_wo_discount=>$total_wo_discount,total_wo_discount_wo_vat=>$total_wo_discount_wo_vat,total_w_discount_wo_vat=>$total_wo_discount_wo_vat-$total_discount_wo_vat,total_vat=>$total_vat,total_wo_vat=>$total_wo_vat2,total_discounts=>$total_discounts,total_discount_wo_vat=>$total_discount_wo_vat,calculated_percent=>($total_discounts/($total_wo_discount||1))*100,percent_to_keep_in_source=>$cfg->{TAX_TO_KEEP_IN_SOURCE},customer_vat_isention=>$cfg->{CUSTOMER_VAT_ISENTION},},);
$info{vat_info}=\%vat;
$info{vat_isentions}=\%vat_isentions;
$h->{manualdoc_docnum}||="";
if($h->{manualdoc_docnum}){$info{check}->{manualdoc_serie}=$h->{manualdoc_serie};
$info{check}->{manualdoc_total_w_vat}=$h->{manualdoc_total_w_vat};
$info{check}->{manualdoc_total_vat}=$h->{manualdoc_total_vat};
$info{check}->{manualdoc_docnum}=$h->{manualdoc_docnum};
$info{check}->{manualdoc_date}=$h->{manualdoc_date};
$info{check}->{manualdoc_type}=$h->{manualdoc_type};}$h->{check_name}||="";
if(!$h->{check_name}){$info{table_desc}=$h->{table_number};}else{if($h->{check_name}=~/^\d+$/){$info{table_desc}=$h->{check_name};}else{$info{table_desc}=$h->{table_number}." (".$h->{check_name}.")";}}if($h->{obs}){my@obs=split/§/,$h->{obs};
$info{check}->{obs}=\@obs;}my$doc_origin=_get_doc_origin($machine,$h,\%ft_gt_assocs);
if(scalar@$doc_origin){$info{check}->{obs}||=[];
push@{$info{check}->{obs}},@$doc_origin;}my$doc_bills=_get_doc_bills($machine,$h);
if(scalar@$doc_bills){$info{check}->{obs}||=[];
push@{$info{check}->{obs}},@$doc_bills;}$h->{delivery_hour}||="";
$h->{load_hour}||="";
$h->{delivery_site}||="";
$h->{load_site}||="";
$h->{kept_in_source}||=0;
$h->{car_plate}||="";
$h->{delivery_date}||="";
$h->{load_date}||="";
if($h->{kept_in_source}>0&&($h->{doc_type}==2||$h->{doc_type}==13||$h->{doc_type}==14||$h->{doc_type}==33)){$h->{kept_in_source}=$h->{kept_in_source}*-1;}$info{check}->{delivery_date}=$h->{delivery_date};
$info{check}->{load_date}=$h->{load_date};
$info{check}->{delivery_hour}=$h->{delivery_hour};
$info{check}->{load_hour}=$h->{load_hour};
$info{check}->{delivery_site}=$h->{delivery_site};
$info{check}->{load_site}=$h->{load_site};
$info{check}->{kept_in_source}=$h->{kept_in_source};
$info{check}->{car_plate}=$h->{car_plate};
$info{check}->{delivery_site}=~s/\+/\n/g if$info{check}->{delivery_site};
$info{check}->{load_site}=~s/\+/\n/g if$info{check}->{load_site};
$info{check}->{car_plate}=~s/\+/\n/g if$info{check}->{car_plate};
my$content="";
return unless$REAL_PRINT;
$info{check}->{docs_payed}=[];
if($info{check}->{headers}->{doc_type}==8||$info{check}->{headers}->{doc_type}==35){my$dests=$db->select("SELECT source_gb_identifier FROM document_operations WHERE dest_gb_identifier = ?",$info{check}->{headers}->{gb_identifier},);
my@a=();
for(@$dests){push@a,$_->{source_gb_identifier};}if(scalar@a){my$q="";
for(@a){$q.="sh.gb_identifier = '$_' OR ";}$q=~s/ OR $//;
$info{check}->{docs_payed}=$db->select(qq{
          SELECT sh.*, dop.value AS doc_value
          FROM sales_headers sh
          LEFT JOIN document_operations dop ON (sh.gb_identifier = dop.source_gb_identifier)
          WHERE dop.dest_gb_identifier = ? AND ($q)
        },$info{check}->{headers}->{gb_identifier});}}if($info{check}->{headers}->{doc_type}==7&&$info{check}->{headers}->{customer_nif}eq '999999990'){$info{check}->{headers}->{customer_nif}='*********'}$info{check}->{headers}->{doc_type_str}=$machine->config()->doc_type_str_by_id($info{check}->{headers}->{doc_type});
my$print_destination=$machine->config()->print_destination($info{check}->{headers}->{doc_type});
if($to_screen){$print_destination=1;}my$tmpl_file=$machine->config()->document_template($machine->dir(),$info{check}->{headers}->{doc_type},$print_destination);
if($h->{print_to_simplified_invoice}){if(!$to_screen){$print_destination=$machine->config()->print_destination(90);}$tmpl_file=$machine->config()->document_template($machine->dir(),$info{check}->{headers}->{doc_type},$print_destination);}my$invoice_to_customer_account=0;
if($cfg->{PRINT_DOC_TYPE_CUSTOMER_CREDIT_CC}){if($info{check}->{headers}->{fo_doc_number}=~/C\/(\d+)$/){$invoice_to_customer_account=1;
$print_destination=$machine->config()->print_destination(71);
$tmpl_file=$machine->config()->document_template($machine->dir(),$info{check}->{headers}->{doc_type},$print_destination);}}if($print_destination==2){my$page=0;
my$lines_per_page=30;
my$did_lines=0;
my@details_orig=@{$info{check}->{details}};
my%details=();
foreach my $d(@details_orig){my$will_count=1;
if(scalar@{$d->{txts}}){$will_count+=(scalar@{$d->{txts}}+1);}if($did_lines+$will_count<$lines_per_page){$did_lines+=$will_count;
push@{$details{$page}},$d;}else{$page++;
$did_lines=0;
push@{$details{$page}},$d;}}my$diff=($lines_per_page-$did_lines)-3;
while($diff-- >0){push@{$details{$page}},{product=>''};}foreach my $pg(sort keys%details){my$page_num=$pg+1;
$info{check}->{pages}=scalar(keys%details);
$info{check}->{page_number}=$page_num;
$info{check}->{details}=$details{$pg};
$info{check}->{headers}->{via}=&translate($machine,$DOC_VIAS{"1"});
$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($tmpl_file,\%info,\$content,)||die$TEMPLATE->error;
&external_print($cfg,$content,$info{check}->{headers}->{fo_doc_number},0,$station,$pdf_only);}}else{$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($tmpl_file,\%info,\$content,)||die$TEMPLATE->error;
if($pt_certified_software){if($print_invoice_md5_valid){$print_invoice_md5_cur=_file_md5("/opt/pos/common/print_templates/print_invoice.tmpl")unless defined$print_invoice_md5_cur;
if($print_invoice_md5_cur ne$print_invoice_md5_valid){$content="\n\n"."---------------------------------------\n"."DOCUMENTO DE IMPRESSAO NAO E VALIDO\n"."---------------------------------------\n"."\n\n\@paper_cut\@";}}}if(-e"/opt/pos/.nif"){open(F,"< /opt/pos/.nif");
my$nif=<F>;
chop($nif);
close(F);
if($nif){my@lines=split/\n/,$content;
$lines[2].="\nContribuinte n. $nif";
$content=join("\n",@lines);}}if($pdf_only){my$doc_name=$h->{fo_doc_number};
$doc_name=~s/\s/_/g;
$doc_name=~s/\//_/g;
my$pdf_file="/opt/pos/common/data/doc_".$doc_name.".pdf";
my$rrr=int(rand(10000));
my$fff="/tmp/print_$rrr.html";
my$content_tmp=$content;
$content_tmp=encode_entities(decode("utf8",$content_tmp));
$content_tmp=~s/\@size_double\@/<b>/g;
$content_tmp=~s/\@size_normal\@/<\/b>/g;
$content_tmp=~s/\@paper_cut\@//g;
$content_tmp=~s/\@justify_.*?\@//g;
my$server_cfg=$machine->is_server()?$cfg:$machine->server_config->load();
_replace_saft_tags($server_cfg,\$content_tmp);
open(F,"> $fff");
print F"<html><body><pre>$content_tmp</pre></body></html>";
close(F);
_pdf_gen($fff,$pdf_file);
return;}if($to_screen){$content=~s/\@size_.*?\@//g;
$content=~s/\@justify_.*?\@//g;
$content=~s/\@paper_cut\@//g;
my$server_cfg=$machine->is_server()?$cfg:$machine->server_config->load();
_replace_saft_tags($server_cfg,\$content);
open(F,"> ".$machine->dir_tmp()."/printer_screen#$station.txt");
print F$content;
close(F);}else{$cfg->{PRINTER_OVERRIDE_BY_DOCUMENT}||="";
my$print_station=undef;
my$print_printer=undef;
if($cfg->{PRINTER_OVERRIDE_BY_DOCUMENT}&&!defined$print_station&&!defined$print_printer){if(!%DOC_TYPE_PRINTER_OVERRIDES){my@by_doc=split/\-/,$cfg->{PRINTER_OVERRIDE_BY_DOCUMENT};
foreach my $tok(@by_doc){my@toks=split/,/,$tok;
if(scalar@toks==3){$DOC_TYPE_PRINTER_OVERRIDES{$toks[0]}->{station}=$toks[1];
$DOC_TYPE_PRINTER_OVERRIDES{$toks[0]}->{printer}=$toks[2];}else{print STDERR"PRINTER_OVERRIDE_BY_DOCUMENT has an incorrect value... Check docs...\n";}}}if(exists$DOC_TYPE_PRINTER_OVERRIDES{$info{headers}->{doc_type}}){$print_station=$DOC_TYPE_PRINTER_OVERRIDES{$info{headers}->{doc_type}}->{station};
$print_printer=$DOC_TYPE_PRINTER_OVERRIDES{$info{headers}->{doc_type}}->{printer};}}my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){if(defined$print_station){$print_printer--;
$print_file=~s/print#\d+#\d+#/print#$print_station#$print_printer#/;}else{open(F,"> $print_file");
print F$content;
close(F);}}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}}}sub _prices_info{my$arr=shift;
my%r=();
foreach my $d(@{$arr}){my$sem_iva=$d->{quantity}*$d->{price_wo_vat};
my$com_iva=$d->{quantity}*$d->{price};
my$taxa_iva=$d->{vat};
$sem_iva=&my_round($sem_iva);
$com_iva=&my_round($com_iva);
my$valor_iva=&my_round($com_iva-$sem_iva);
push@{$r{artigos}},{vat=>$d->{vat},quantity=>$d->{quantity},line_total=>$com_iva,unit_price=>&my_round($d->{price}),};
$r{iva}->{$taxa_iva}->{valor_iva}+=$valor_iva;
$r{iva}->{$taxa_iva}->{valor_com_iva}+=$com_iva;
$r{iva}->{$taxa_iva}->{valor_sem_iva}+=$sem_iva;}return\%r;}sub check_finalize{my($machine,$file)=@_;
return 2 unless$machine->is_server();
my$clerk_closed=0;
my$t1=new Benchmark;
my$t2;
if(-e$machine->dir_server()."/server/data/tmp/stop_sales_integration.txt"){print STDERR"SALES INTEGRATION IS STOPED! IGNORING FILE...\n";
return 2;}my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
if(!scalar keys%$CLERK_SERIES){my$recs=$db->select("SELECT id, serie FROM clerks WHERE deleted = 0");
map{$CLERK_SERIES->{$_->{id}}=$_->{serie}}@$recs;}if(!defined$CLOSE_HOUR){my$close_hour=$cfg->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}&get_products_information($db);
if(!defined$MESSAGES_INFO){my$q=qq{
      SELECT id, name FROM products WHERE is_message = 1 AND deleted = 0
    };
my$tmp=$db->select($q);
map{$MESSAGES_INFO->{$_->{id}}=$_}@$tmp;}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T1:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
if(!defined$VAT_ISENTIONS){my%t=();
my$tmp=$db->select("SELECT id, vat_isention FROM products WHERE vat_isention <> '' AND vat_isention <> '0'");
for(@$tmp){next if$_->{vat_isention}=~/^\s+$/;
$Text::Wrap::columns=38;
my$l=wrap('','',$_->{vat_isention});
$t{$l}=1;
$VAT_ISENTIONS->{$_->{id}}=$l;}my$idx=1;
for(sort keys%t){$VAT_ISENTIONS_IDX->{$_}=$idx++;}}&get_clerks_information($db);
$cfg->{LANG}||="PT";
$cfg->{MACHINE_LABEL}||="";
$cfg->{STATION_PRINT_CHECKS}=exists$cfg->{STATION_PRINT_CHECKS}?$cfg->{STATION_PRINT_CHECKS}:99;
$cfg->{STATION_PRINT_CHECKS}=99 if$cfg->{STATION_PRINT_CHECKS}==$cfg->{STATION_NUMBER};
$cfg->{CHECK_GROUP_PRODUCTS_TEXT}||="";
$cfg->{TAX_TO_KEEP_IN_SOURCE}||="";
$cfg->{CUSTOMER_VAT_ISENTION}||="";
$cfg->{SAFT_PRINT_TRANSPORT_DOCS}||=0;
my$pt_certified_software=-e$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server"?1:0;
if($pt_certified_software){$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}=1;
$cfg->{SHOW_ZERO_PRICE_IN_BILL}=1;}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T2:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
my$check=App::POS::Check->new(file=>$file);
my$data=$check->data();
my$ex=$check->extra_data();
$ex->{from_mobile}||=0;
my$from_mobile=$ex->{from_mobile};
my$info=undef;
eval{$info=$machine->integrate_check_in_db($file,$PRODUCTS_INFO,$CLERKS_INFO,$check);};
if($@){$machine->{__pg_conn}=undef;
print STDERR"ERROR INTEGRATING CHECK IN DB: $@";
&remove($file.'*');
return;}elsif(!defined$info){print STDERR"ERROR - integrate_check_in_db returned undef...\n";
&remove($file.'*');
return;}$ex->{lines_source_assoc}||="";
my%ft_gt_assocs=();
my$ft_gt_idx;
my%ft_gt_idx=();
if($info->{headers}->{doc_type}==7&&$ex->{lines_source_assoc}){my@a=split/,/,$ex->{lines_source_assoc};
for(@a){my@b=split/_/,$_;
if(!exists$ft_gt_idx{$b[1]}){$ft_gt_idx++;
$ft_gt_idx{$b[1]}=$ft_gt_idx;}$ft_gt_assocs{$b[0]}={gbi=>$b[1],idx=>$ft_gt_idx{$b[1]}};}}$ex->{print_language}||="";
$ex->{obs}||="";
if($ex->{print_language}){&get_products_translations($db);}if($ex->{obs}){my@obs=split/§/,$ex->{obs};
$info->{obs}=\@obs;}my$doc_origin=_get_doc_origin($machine,$info->{headers},\%ft_gt_assocs);
if(scalar@$doc_origin){$info->{obs}||=[];
push@{$info->{obs}},@$doc_origin;}my$doc_bills=_get_doc_bills($machine,$info->{headers});
if(scalar@$doc_bills){$info->{obs}||=[];
push@{$info->{obs}},@$doc_bills;}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T3 (integrate_check_in_db):".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
my$to_print=$info->{headers}->{to_print};
my$mult=$info->{headers}->{doc_type}==2||$info->{headers}->{doc_type}==13||$info->{headers}->{doc_type}==14||$info->{headers}->{doc_type}==33?-1:1;
return if$info->{headers}->{doc_type}==3;
my$discount_percent=$info->{headers}->{discount};
$clerk_closed=$info->{headers}->{clerk_close};
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}if($pt_certified_software){if($info->{headers}->{doc_type}eq '10'||$info->{headers}->{doc_type}eq '11'){$info->{headers}->{at_code}=&translate($machine,"SEM CODIGO AT");}}$info->{headers}->{clerk_open_name}=exists$CLERKS_INFO->{$info->{headers}->{clerk_open}}?$CLERKS_INFO->{$info->{headers}->{clerk_open}}->{login}:'UNKNOWN';
$info->{headers}->{clerk_close_name}=exists$CLERKS_INFO->{$info->{headers}->{clerk_close}}?$CLERKS_INFO->{$info->{headers}->{clerk_close}}->{login}:'UNKNOWN';
my%vat=();
my$cur_date=&strftime("%Y-%m-%d",localtime);
my$cur_hour=&strftime("%H:%M:%S",localtime);
$info->{headers}->{cur_date}=$cur_date;
$info->{headers}->{cur_hour}=$cur_hour;
$info->{headers}->{doc_via}=1;
&set_owner_information($machine,$info->{headers});
$info->{headers}->{value}=$info->{headers}->{value}*$mult;
$info->{headers}->{meals_txt}=&translate($machine,$cfg->{CHECK_GROUP_PRODUCTS_TEXT});
($info->{headers}->{hour_opened})=$info->{headers}->{date}=~/^.*?\s(\d\d\:\d\d)/;
($info->{headers}->{hour_closed})=$info->{headers}->{date_closed}=~/^.*?\s(\d\d\:\d\d)/;
$info->{headers}->{area_name}=exists$AREAS_INFO{$info->{headers}->{area}}?$AREAS_INFO{$info->{headers}->{area}}->[0]:'<UNKNOWN>';
$info->{headers}->{area_tables}=exists$AREAS_INFO{$info->{headers}->{area}}?$AREAS_INFO{$info->{headers}->{area}}->[1]:0;
if($cfg->{PRINT_BARCODE_IN_CHECK}){$BARCODES{$file}="77777".sprintf("%07s",$info->{headers}->{id});}my$medias=[];
foreach my $d(sort{$a->{payment_media}cmp$b->{payment_media}}@{$info->{payments}}){$d->{payment_media_orig}=$d->{payment_media};
$d->{payment_media}=&my_conv($d->{payment_media},20);
$d->{payment_media}=~s/\s+$//;
$d->{value}=$d->{value}*$mult;
if($d->{payment_media}eq&translate($machine,$cfg->{CHECK_MONEY_CHANGE_TEXT})){$d->{is_change}=1;}else{$d->{is_change}=0;}push@$medias,$d;}$info->{payments}=$medias;
my$details=[];
my$total_discounts=0;
my$total_offers=0;
$info->{headers}->{discount}||='';
if($info->{headers}->{training_mode}&&scalar@$SOFTWARE_INFO){$info->{headers}->{training_software_number}=$SOFTWARE_INFO->[0];
$info->{headers}->{training_software_company}=$SOFTWARE_INFO->[1];
$info->{headers}->{training_software_version}=$SOFTWARE_INFO->[2];
$info->{headers}->{training_software_nif}=$SOFTWARE_INFO->[3];}my%t=();
my$use_print_priorities=0;
$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T4:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
$cfg->{MENUS_PRINT_SELECTIONS}||="";
$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}||=0;
$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}=1 if$info->{headers}->{doc_type}==10;
foreach my $d(@{$info->{details}}){$d->{product_type}||="";
next if$d->{product_name}=~/^\-\-\-\-\-\-\-\-\-\-/;
$d->{discount}||=0;
$d->{offer}||=0;
$d->{printing_priority}=$PRINTING_PRIORITIES->{$d->{product}};
$d->{is_menu}=exists$PRODUCTS_MENUS->{$d->{product}}?1:0;
$use_print_priorities=1 if$PRINTING_PRIORITIES->{$d->{product}};
my$key=$d->{product}."#".$d->{price}."#".$d->{discount}."#".$d->{free_text};
if($PRODUCTS_INFO->{$d->{product}}->{is_weight}){$key=$d->{idx};}if($cfg->{MENUS_PRINT_SELECTIONS}eq"1"){if(!exists$PRODUCTS_MENUS->{$d->{product}}&&$d->{product_type}ne 'MENU'){if(!$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}){next unless$d->{price}*1!=0;}}}else{if(!$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}){next unless$d->{price}*1!=0;}}if($d->{is_menu}||$d->{product_type}eq 'MENU'){$key=$d->{idx};}if(%ft_gt_assocs){$key.="#".$ft_gt_assocs{$d->{gb_identifier}}->{gbi};}if(exists$t{$key}){$t{$key}->{quantity}+=$d->{quantity};}else{$t{$key}=$d;}}my@t=values%t;
if($use_print_priorities){@t=reverse sort{$a->{printing_priority}<=>$b->{printing_priority}}@t;}else{@t=sort{$a->{idx}<=>$b->{idx}}@t;}$info->{details}=\@t;
my%vat_isentions=();
my$total_wo_discount=0;
my$total_discount_wo_vat=0;
my$total_wo_discount_wo_vat=0;
my$products_quantities=0;
my$total_vat=0;
my$last_menu="";
my$total_wo_vat=0;
foreach my $d(@{$info->{details}}){next if$d->{quantity}*1==0;
next if exists$MESSAGES_INFO->{$d->{product}};
$last_menu=$d if$d->{is_menu};
$d->{quantity}||=1;
next if exists$PRODUCTS_EXTRAS->{$d->{product}}&&$d->{price}==0;
next if$PRODUCTS_INFO->{$d->{product}}->{name}=~/^\-\-\-\-\-\-\-\-\-\-/;
$d->{quantity}=$d->{quantity}*$mult;
$d->{clerk_name}=exists$CLERKS_INFO->{$d->{clerk}}?$CLERKS_INFO->{$d->{clerk}}->{login}:'UNKNOWN';
if($ex->{print_language}&&exists$PRODUCTS_TRANSLATIONS->{$d->{product}}->{$ex->{print_language}}){$d->{product_name}=$PRODUCTS_TRANSLATIONS->{$d->{product}}->{$ex->{print_language}};}if(exists$VAT_ISENTIONS->{$d->{product}}&&$VAT_ISENTIONS->{$d->{product}}ne '0'&&$d->{vat}*1==0){$d->{product_name}="(".$VAT_ISENTIONS_IDX->{$VAT_ISENTIONS->{$d->{product}}}.") ".$d->{product_name};
$vat_isentions{$VAT_ISENTIONS_IDX->{$VAT_ISENTIONS->{$d->{product}}}}=$VAT_ISENTIONS->{$d->{product}};}if(%ft_gt_assocs&&exists$ft_gt_assocs{$d->{gb_identifier}}){$d->{product_name}="[".$ft_gt_assocs{$d->{gb_identifier}}->{idx}."] ".$d->{product_name};}$d->{is_weight}=$PRODUCTS_INFO->{$d->{product}}->{is_weight};
$d->{is_service}=$PRODUCTS_INFO->{$d->{product}}->{is_service};
$d->{product_name}=&my_conv($d->{product_name},26);
$d->{txts}=[];
if($d->{free_text}&&$d->{free_text}ne 'EXTRA'){my@t=split/;/,$d->{free_text};
for my $tok(@t){next unless$tok;
$Text::Wrap::columns=38;
my$l=wrap('','',$tok);
my@lines=split/\n/,$l;
for(@lines){push@{$d->{txts}},$_;}}if(scalar@{$d->{txts}}==1&&$d->{txts}->[0]eq 'MENU'){$d->{txts}=[];}}$d->{vat}||=0;
my$sem_iva=my_round($d->{quantity}*$d->{price_wo_vat});
my$com_iva=my_round($d->{quantity}*$d->{price});
my$desconto_com_iva=0;
my$desconto_sem_iva=0;
if($d->{price}!=0){$d->{price_wo_vat}||=1;
$desconto_com_iva=$d->{quantity}*$d->{price}*($d->{discount}/$d->{price_wo_vat});
$desconto_sem_iva=$d->{quantity}*$d->{discount};}$total_discount_wo_vat+=$desconto_sem_iva;
$com_iva=$com_iva-$desconto_com_iva;
$sem_iva=$sem_iva-$desconto_sem_iva;
$total_wo_vat+=$sem_iva;
my$valor_iva=$com_iva-$sem_iva;
$info->{headers}->{value_net}+=$sem_iva;
$d->{line_total_wo_vat}=$d->{price_wo_vat}*$d->{quantity};
$d->{unit_price_wo_vat}=$d->{price_wo_vat};
$d->{line_total}=$d->{price}*$d->{quantity};
$d->{unit_price}=$d->{price};
$d->{quantity}=$d->{quantity};
$d->{line_total_w_discount}=$d->{line_total}-my_round($desconto_com_iva);
$vat{$d->{vat}}->{w_vat}+=$d->{line_total_w_discount}*$mult;
$vat{$d->{vat}}->{wo_vat}+=$desconto_com_iva>0?my_round($sem_iva*$mult):$sem_iva*$mult;
$total_discounts+=$desconto_com_iva;
$total_wo_discount+=my_round($d->{line_total});
$total_wo_discount_wo_vat+=my_round($d->{line_total_wo_vat});
$products_quantities+=$d->{quantity};
if(!$cfg->{MENUS_PRINT_SELECTIONS}){if($d->{product_type}eq 'MENU'){if($d->{price}*1>0){push@$details,$d;}}else{push@$details,$d;}}else{push@$details,$d;}}$total_vat=0;
for(keys%vat){$vat{$_}->{vat_v}=&my_round($vat{$_}->{w_vat})-&my_round($vat{$_}->{wo_vat});
$total_vat+=$vat{$_}->{vat_v};}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T5:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
my$discount_was_percentage=0;
if($discount_percent=~/%/){$discount_was_percentage=1;
$discount_percent=~s/%//g;}$discount_was_percentage=0 if exists$ex->{has_line_discounts}&&$ex->{has_line_discounts};
$info->{details}=$details;
$info->{products_number}=scalar@$details;
$info->{products_quantities}=$products_quantities;
$info->{total_discounts}=$total_discounts;
$info->{discount_was_percentage}=$discount_was_percentage;
$info->{discount_percent}=$discount_percent;
$info->{total_wo_discount}=$total_wo_discount;
$info->{total_wo_discount_wo_vat}=$total_wo_discount_wo_vat;
$info->{total_w_discount_wo_vat}=$total_wo_discount_wo_vat-$total_discount_wo_vat;
$info->{total_vat}=$total_vat;
$info->{total_discount_wo_vat}=$total_discount_wo_vat;
$info->{total_wo_vat}=$total_wo_vat;
$info->{percent_to_keep_in_source}=$cfg->{TAX_TO_KEEP_IN_SOURCE};
$info->{customer_vat_isention}=$cfg->{CUSTOMER_VAT_ISENTION};
if(exists$ex->{kept_in_source}&&$ex->{kept_in_source}){$info->{kept_in_source}=$ex->{kept_in_source}*1;}else{$info->{kept_in_source}=0;}my$div=$info->{total_wo_discount};
$div||=1;
$info->{calculated_percent}=($info->{total_discounts}/$div)*100;
$info->{table_number}||=0;
if($info->{table_number}<0){$info->{table_number}=$info->{table_number}*-1;}if(exists$ex->{original_table_number}&&$ex->{original_table_number}){$info->{headers}->{table_number}=$ex->{original_table_number};}my%info=(check=>$info);
my$content="";
my$check_unique_id=$info->{headers}->{__unique_id}||undef;
$info{check}->{request_number}="";
$info{check}->{machine_label}=$cfg->{MACHINE_LABEL};
$ex->{has_pzones}||=0;
if($ex->{has_pzones}&&defined$check_unique_id&&$check_unique_id){my$request_numbers_checks=App::POS::Counters->new(db=>$db,name=>'request_numbers_checks',);
$info{check}->{request_number}=$request_numbers_checks->cur_value($check_unique_id);}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T6:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
$ex->{check_name}||="";
if(!$ex->{check_name}){$info{table_desc}=$info->{headers}->{table_number};}else{if($ex->{check_name}=~/^\d+$/){$info{table_desc}=$ex->{check_name};}else{$info{table_desc}=$info->{headers}->{table_number}." (".$ex->{check_name}.")";}}$info{check_name}=$ex->{check_name}||"";
$info->{headers}->{check_name}=$info{check_name};
$info{check}->{headers}->{check_name}=$info{check_name};
$info{vat_info}=\%vat;
$info{vat_isentions}=\%vat_isentions;
$info{check_number}=$info->{headers}->{table_number};
$ex->{delivery_date}||="";
$ex->{load_date}||="";
$ex->{delivery_hour}||="";
$ex->{load_hour}||="";
$ex->{delivery_site}||="";
$ex->{load_site}||="";
$ex->{car_plate}||="";
$info{check}->{delivery_date}=$ex->{delivery_date};
$info{check}->{load_date}=$ex->{load_date};
$info{check}->{delivery_hour}=$ex->{delivery_hour};
$info{check}->{load_hour}=$ex->{load_hour};
$info{check}->{delivery_site}=$ex->{delivery_site};
$info{check}->{load_site}=$ex->{load_site};
$info{check}->{car_plate}=$ex->{car_plate};
$info{check}->{invoice_is_payed}=$ex->{invoice_is_payed};
$info{check}->{delivery_site}=~s/\+/\n/g if$info{check}->{delivery_site};
$info{check}->{load_site}=~s/\+/\n/g if$info{check}->{load_site};
$info{check}->{car_plate}=~s/\+/\n/g if$info{check}->{car_plate};
$ex->{manualdoc_docnum}||="";
if($ex->{manualdoc_docnum}){$info{check}->{manualdoc_serie}=$ex->{manualdoc_serie};
$info{check}->{manualdoc_total_w_vat}=$ex->{manualdoc_total_w_vat};
$info{check}->{manualdoc_total_vat}=$ex->{manualdoc_total_vat};
$info{check}->{manualdoc_docnum}=$ex->{manualdoc_docnum};
$info{check}->{manualdoc_date}=$ex->{manualdoc_date};
$info{check}->{manualdoc_type}=$ex->{manualdoc_type};}$data->{extra_data}->{delivery_info}||="";
if($data->{extra_data}->{delivery_info}){my$dinfo=&_decode_delivery_info($db,$data);
$info{delivery_info}=$dinfo;}$data->{extra_data}->{queue_name}||="";
if($data->{extra_data}->{queue_name}){$info{queue_number}=_read_queue_number($machine,$data->{extra_data}->{queue_name});}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T7:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
return unless$REAL_PRINT;
$ex->{docs_payed}||="";
my$docs_payed=[];
if($ex->{docs_payed}){my@a=split/,/,$ex->{docs_payed};
my$q="";
for(@a){$q.="sh.gb_identifier = '$_' OR ";}$q=~s/ OR $//;
my$count=0;
while(!scalar@$docs_payed){last if$count++ ==10;
my$query=qq{
        SELECT sh.*, dop.value AS doc_value
        FROM sales_headers sh
        LEFT JOIN document_operations dop ON (sh.gb_identifier = dop.source_gb_identifier)
        WHERE dop.dest_gb_identifier = ? AND ($q)
      };
$docs_payed=$db->select($query,$info->{headers}->{gb_identifier});
sleep 0.5;}}$info->{docs_payed}=$docs_payed;
$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T8:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
&_add_to_document_history($db,$info,$check);
$info->{headers}->{customer_nif}='*********' if$info->{headers}->{customer_nif}eq '999999990';
if($info->{headers}->{doc_type}==7&&$info->{headers}->{customer_nif}eq '999999990'){$info->{headers}->{customer_nif}='*********';}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T9:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
$info->{headers}->{doc_type_str}=$machine->config()->doc_type_str_by_id($info->{headers}->{doc_type});
my$print_destination=$machine->config()->print_destination($info->{headers}->{doc_type});
my$tmpl_file=$machine->config()->document_template($machine->dir(),$info->{headers}->{doc_type});
$ex->{print_to_simplified_invoice}||=0;
if($ex->{print_to_simplified_invoice}){$print_destination=$machine->config()->print_destination(90);
$tmpl_file=$machine->config()->document_template($machine->dir(),$info->{headers}->{doc_type},$print_destination);}my$invoice_to_customer_account=0;
if($cfg->{PRINT_DOC_TYPE_CUSTOMER_CREDIT_CC}){if($info->{headers}->{fo_doc_number}=~/C\/(\d+)$/){$invoice_to_customer_account=1;
$print_destination=$machine->config()->print_destination(71);
$tmpl_file=$machine->config()->document_template($machine->dir(),$info->{headers}->{doc_type},$print_destination);}}$info->{extra_data}=$ex;
$LAST_INTEGRATED_CHECK=$info;
if($pt_certified_software&&$cfg->{SAFT_PRINT_TRANSPORT_DOCS}==0&&($info->{headers}->{doc_type}eq '10'||$info->{headers}->{doc_type}eq '11')){}else{if($print_destination==2){my$page=0;
my$lines_per_page=30;
my$did_lines=0;
my@details_orig=@{$info->{details}};
my%details=();
foreach my $d(@details_orig){my$will_count=1;
if(scalar@{$d->{txts}}){$will_count+=(scalar@{$d->{txts}}+1);}if($did_lines+$will_count<$lines_per_page){$did_lines+=$will_count;
push@{$details{$page}},$d;}else{$page++;
$did_lines=0;
push@{$details{$page}},$d;}}my$diff=($lines_per_page-$did_lines)-3;
while($diff-- >0){push@{$details{$page}},{product=>''};}foreach my $pg(sort keys%details){my$page_num=$pg+1;
$info->{pages}=scalar(keys%details);
$info->{page_number}=$page_num;
$info->{details}=$details{$pg};
my$vias;
if($invoice_to_customer_account){$vias=exists$RECEIPT_PRINT_VIAS{71}?$RECEIPT_PRINT_VIAS{71}:1;}else{$vias=exists$RECEIPT_PRINT_VIAS{$info->{headers}->{doc_type}}?$RECEIPT_PRINT_VIAS{$info->{headers}->{doc_type}}:1;}for(my$i=0;$i<$vias;$i++){my$via=$i+1;
my$txt=&translate($machine,$DOC_VIAS{$via});
$content="";
$info{check}->{headers}->{via}=$txt;
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($tmpl_file,\%info,\$content,)||die$TEMPLATE->error;
&external_print($cfg,$content,$info{check}->{headers}->{fo_doc_number},0,$info{check}->{headers}->{station_close},0);}}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T10:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;}else{my$print_station=undef;
my$print_printer=undef;
$cfg->{MOBILE_PRINT_INVOICES}||="";
if($cfg->{MOBILE_PRINT_INVOICES}&&$from_mobile){if(!%MOBILE_PRINT_INVOICES){my@by_area=split/\-/,$cfg->{MOBILE_PRINT_INVOICES};
foreach my $tok(@by_area){my@toks=split/,/,$tok;
if(scalar@toks==3){$MOBILE_PRINT_INVOICES{$toks[0]}->{station}=$toks[1];
$MOBILE_PRINT_INVOICES{$toks[0]}->{printer}=$toks[2];}elsif(scalar@toks==2){$MOBILE_PRINT_INVOICES{ALL}->{station}=$toks[0];
$MOBILE_PRINT_INVOICES{ALL}->{printer}=$toks[1];}}}if(exists$MOBILE_PRINT_INVOICES{$info{check}->{headers}->{area_name}}){$print_station=$MOBILE_PRINT_INVOICES{$info{check}->{headers}->{area_name}}->{station};
$print_printer=$MOBILE_PRINT_INVOICES{$info{check}->{headers}->{area_name}}->{printer};}elsif(exists$MOBILE_PRINT_INVOICES{ALL}){$print_station=$MOBILE_PRINT_INVOICES{ALL}->{station};
$print_printer=$MOBILE_PRINT_INVOICES{ALL}->{printer};}}$cfg->{PRINTER_OVERRIDE_BY_DOCUMENT}||="";
if($cfg->{PRINTER_OVERRIDE_BY_DOCUMENT}&&!defined$print_station&&!defined$print_printer){if(!%DOC_TYPE_PRINTER_OVERRIDES){my@by_doc=split/\-/,$cfg->{PRINTER_OVERRIDE_BY_DOCUMENT};
foreach my $tok(@by_doc){my@toks=split/,/,$tok;
if(scalar@toks==3){$DOC_TYPE_PRINTER_OVERRIDES{$toks[0]}->{station}=$toks[1];
$DOC_TYPE_PRINTER_OVERRIDES{$toks[0]}->{printer}=$toks[2];}else{print STDERR"PRINTER_OVERRIDE_BY_DOCUMENT has an incorrect value... Check docs...\n";}}}if(exists$DOC_TYPE_PRINTER_OVERRIDES{$info->{headers}->{doc_type}}){$from_mobile=1;
$print_station=$DOC_TYPE_PRINTER_OVERRIDES{$info->{headers}->{doc_type}}->{station};
$print_printer=$DOC_TYPE_PRINTER_OVERRIDES{$info->{headers}->{doc_type}}->{printer};}}if($to_print){$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($tmpl_file,\%info,\$content,)||die$TEMPLATE->error;
if($pt_certified_software){if($print_invoice_md5_valid){$print_invoice_md5_cur=_file_md5("/opt/pos/common/print_templates/print_invoice.tmpl")unless defined$print_invoice_md5_cur;
if($print_invoice_md5_cur ne$print_invoice_md5_valid){$content="\n\n"."---------------------------------------\n"."DOCUMENTO DE IMPRESSAO NAO E VALIDO\n"."---------------------------------------\n"."\n\n\@paper_cut\@";}}}if(-e"/opt/pos/.nif"){open(F,"< /opt/pos/.nif");
my$nif=<F>;
chop($nif);
close(F);
if($nif){my@lines=split/\n/,$content;
$lines[2].="\nContribuinte n. $nif";
$content=join("\n",@lines);}}$t2=new Benchmark;
print STDERR"Handlers> CHECK FINALIZE T10:".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;
my$station_print=exists$ex->{station_print_checks}&&$ex->{station_print_checks}ne '99'?$ex->{station_print_checks}:$info->{headers}->{station_close};
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station_print,station_close=>$station_print,);
if(defined$print_file){if($from_mobile&&defined$print_station){$print_printer--;
$print_file=~s/print#\d+#\d+#/print#$print_station#$print_printer#/;}my$vias;
if($invoice_to_customer_account){$vias=exists$RECEIPT_PRINT_VIAS{71}?$RECEIPT_PRINT_VIAS{71}:1;}else{$vias=exists$RECEIPT_PRINT_VIAS{$info->{headers}->{doc_type}}?$RECEIPT_PRINT_VIAS{$info->{headers}->{doc_type}}:1;}if(defined$vias&&$vias){unlink"/tmp/vias.txt";
open(F,">> /tmp/vias.txt");
print F$content;
close(F);
for(my$i=1;$i<$vias;$i++){my$via=$i+1;
my$txt=&translate($machine,$DOC_VIAS{$via});
my$tmp=$content;
$tmp=~s/Original/$txt/gmi;
open(F,">> /tmp/vias.txt");
print F$tmp;
close(F);}&move("/tmp/vias.txt",$print_file);}else{open(F,"> $print_file");
print F$content;
close(F);}my$fname=&basename($print_file);
my($st,$prn)=$fname=~/^print#(\d+)#(\d+)#/;
my$archive_dir=$machine->dir_server().'/server/data/print_checks_archive/'.$st."/".$prn;
&make_path($archive_dir)unless-d$archive_dir;
open(F,"> $archive_dir/$fname");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}$cfg->{VIDEO_RECORDER_PORT}||="";
if($cfg->{VIDEO_RECORDER_PORT}){system("/opt/pos/common/bin/send_to_recorder.pl ".$cfg->{VIDEO_RECORDER_PORT}." ".$check->area()." \"".$AREAS_INFO{$check->area()}->[0]."\" ".$check->table_number()." checkfinalize \"".$info{check}->{headers}->{fo_doc_number}." - ".$info{check}->{headers}->{clerk_close_name}."\"");}}}}my$kitchen_monitor_zones=$machine->config()->pzones_with_kitchen_monitor();
if($kitchen_monitor_zones&&$ex->{has_pzones}){&kitchen_monitor_set_printed_or_payed($machine,$info->{headers}->{__unique_id},"payed");}$t2=new Benchmark;
print STDERR"Handlers> check_finalize: ".timestr(timediff($t2,$t1))."\n" if$DEBUG_TIMINGS;}sub check_finalize_fixup{my($machine,$file)=@_;
if($machine->is_server()){my@stat=stat($file);
my$last_mod=time-$stat[8];
if($last_mod>=10&&!-e$file.".total"){if($file=~/\.deleted$/){print STDERR"WILL DELETE - $file\n";
unlink($file);
open(NN,">> /root/fixup.log");
print NN"WILL DELETE - $file\n";
close(NN);}else{my$c=App::POS::Check->new(file=>$file);
my$d=$c->data();
$d->{footers}||=[];
if(!scalar@{$d->{footers}}){undef$c;
unlink($file);
open(NN,">> /root/fixup.log");
print STDERR"check_finalize_fixup ---> file: $file, last_mod: $last_mod (NO FOOTERS)\n";
print NN"check_finalize_fixup ---> file: $file, last_mod: $last_mod (NO FOOTERS)\n";
close(NN);}else{my$check_total=0;
foreach my $t(@{$d->{footers}}){next unless scalar@$t;
$check_total+=$t->[1];}open(NN,">> /root/fixup.log");
print STDERR"check_finalize_fixup ---> file: $file, last_mod: $last_mod, check_total: $check_total\n";
print NN"check_finalize_fixup ---> file: $file, last_mod: $last_mod, check_total: $check_total\n";
close(NN);
if($check_total>0){my$r=int(rand(10000));
system("mkdir /root/fixup")unless-d"/root/fixup";
&copy($file,"/root/fixup/$r");
open(II,"> ".$file.".total");
print II$check_total."\n";
close(II);}}}}}else{return 2;}}sub table_transfer{my($machine,$file)=@_;
my($station,$clerk,$a_orig,$c_orig,$a_dest,$c_dest)=$file=~/\/table_transfer#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)\.txt$/;
my$cfg=$machine->config()->load_fixed();
$cfg->{PRINT_TABLE_TRANSFERS}||="";
my$db=$machine->database();
&get_products_information($db);
&get_clerks_information($db);
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my%products=();
my$pstr="";
{local$/=undef;
if(open(F,"< $file")){$pstr=<F>;
close(F);}if($pstr){$pstr=~s/\n//g;
my@a=split/,/,$pstr;
for(@a){my@b=split/=/;
my@c=split/\@/,$b[1];
$c[0]=$c[0]*1;
$products{$b[0]}->{$c[1]}+=$c[0];}}}my@prods=();
foreach my $id(keys%products){my$product_name=exists$PRODUCTS_INFO->{$id}?$PRODUCTS_INFO->{$id}->{name}:'UNKNOWN';
foreach my $hour(keys%{$products{$id}}){push@prods,{printing_priority=>$PRINTING_PRIORITIES->{$id},product=>$id,quantity=>$products{$id}->{$hour},product_name=>$product_name,hour_registered=>$hour,};}}my@prods_sorted=reverse sort{$a->{printing_priority}<=>$b->{printing_priority}}@prods;
my$date=&strftime("%Y-%m-%d",localtime);
my$hour=&strftime("%H:%M:%S",localtime);
my$business_date=&date_based_on_closing_hour("$date $hour",$CLOSE_HOUR);
my$id=$db->next_id("transfers");
my%info=(date=>$date,hour=>$hour,datetime=>$date." ".$hour,products=>\@prods_sorted,area_from=>$a_orig,area_to=>$a_dest,area_from_name=>exists$AREAS_INFO{$a_orig}?$AREAS_INFO{$a_orig}->[0]:'<UNKNOWN>',area_to_name=>exists$AREAS_INFO{$a_dest}?$AREAS_INFO{$a_dest}->[0]:'<UNKNOWN>',table_from=>$c_orig,table_to=>$c_dest,clerk=>$clerk,clerk_name=>exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>',);
$db->do(qq{
    INSERT INTO transfers VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
  },$id,$business_date,$hour,$station,$clerk,$info{clerk_name},$a_orig,$a_dest,$c_orig,$c_dest);
foreach my $p(@prods_sorted){$db->do(qq{
      INSERT INTO transfer_products VALUES (?, ?, ?, ?, ?)
    },$id,$p->{product},$p->{product_name},$p->{quantity},$p->{hour_registered});}if($cfg->{PRINT_TABLE_TRANSFERS}){my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('products_transfer.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
$cfg->{PRINT_TABLE_TRANSFERS_PRINTER}||="";
if($cfg->{PRINT_TABLE_TRANSFERS_PRINTER}){my$str=$cfg->{PRINT_TABLE_TRANSFERS_PRINTER};
my@a=split/,/,$str;
if(scalar@a==2){my($station,$printer)=@a;
$printer-- if$printer>0;
$print_file=~s/print#\d+#\d+#/print#$station#$printer#/;}}if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}sub print_cc_report{my($machine,$file)=@_;
if($machine->is_station()){return 2;}my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}&get_clerks_information($db);
if(!defined$CLOSE_HOUR){my$close_hour=$cfg->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}my$where_to_print=$cfg->{PRINT_CC_REPORTS};
my($pdf,$station,$clerk,$date_from,$date_to)=$file=~/ccreport#(.*?)#(\d+)#(\d+)#(.*?)#(.*?)\./;
my$cur_date=&strftime("%Y-%m-%d",localtime);
my$cur_hour=&strftime("%H:%M:%S",localtime);
my%info=(total_invoiced=>0,business_date=>&date_based_on_closing_hour("$cur_date $cur_hour",$CLOSE_HOUR),date_from=>$date_from,date_to=>$date_to,cur_date=>$cur_date,cur_hour=>$cur_hour,station=>$station,clerk=>$clerk,clerk_name=>exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>',rows=>[],);
my$last_date="";
open(F,"< $file");
while(<F>){chop;
my@toks=split/#/;
next unless scalar@toks;
my$h={};
$h->{cols}=scalar@toks;
for(my$i=0;$i<scalar(@toks);$i++){my$key='col'.$i;
$h->{$key}=$toks[$i];}if($h->{cols}==5&&$h->{col2}eq ''&&$h->{col3}eq ''){$h->{is_customer}=1;}$h->{col1}||="";
$h->{col2}=0 if$h->{col2}eq '';
$h->{col3}=0 if$h->{col3}eq '';
if(exists$h->{col4}&&$h->{col4}*1!=0){if($h->{col3}==0&&$h->{col1}ne ''){my@rr=$db->select("SELECT doc_type FROM document_history WHERE fo_doc_number = ?",$h->{col1});
if(scalar@rr){if($rr[0]->{doc_type}!=8){$info{total_invoiced}-=$h->{col2};}}}else{$info{total_invoiced}+=$h->{col3};}}if($h->{col0}&&$h->{col0}=~/^\d\d\d\d\-\d\d\-\d\d$/){$h->{date_changed}=$h->{col0}eq$last_date?0:1;
$last_date=$h->{col0};}push@{$info{rows}},$h;}close(F);
my$content="";
if($pdf){$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_cc.external.tmpl',\%info,\$content,)||die$TEMPLATE->error;
&external_print($cfg,$content,'report_cc_'.$cur_date.'_'.$cur_hour,1,$station,0);}else{if($where_to_print==2){$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_cc.external.tmpl',\%info,\$content,)||die$TEMPLATE->error;
&external_print($cfg,$content,'report_cc_'.$cur_date.'_'.$cur_hour,0,$station,0);}else{$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_cc.tmpl',\%info,\$content,)||die$TEMPLATE->error;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,station_close=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}}sub print_cc_doc_history{my($machine,$file)=@_;
if($machine->is_station()){return 2;}my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}&get_clerks_information($db);
if(!defined$CLOSE_HOUR){my$close_hour=$cfg->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}my$where_to_print=$cfg->{PRINT_CC_REPORTS};
my($pdf,$station,$clerk,$nif,$date_from,$date_to)=$file=~/doc_history#(.*?)#(\d+)#(\d+)#(.*?)#(.*?)#(.*?)\./;
my$cust=$db->select("SELECT * FROM customers WHERE nif = ? ORDER BY deleted ASC LIMIT 1",$nif);
my$cur_date=&strftime("%Y-%m-%d",localtime);
my$cur_hour=&strftime("%H:%M:%S",localtime);
my%info=(business_date=>&date_based_on_closing_hour("$cur_date $cur_hour",$CLOSE_HOUR),date_from=>$date_from,date_to=>$date_to,cur_date=>$cur_date,cur_hour=>$cur_hour,station=>$station,clerk=>$clerk,clerk_name=>exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>',rows=>[],);
for(@$cust){foreach my $k(keys%$_){$info{"customer_".$k}=$_->{$k};}}my$last_date="";
open(F,"< $file");
while(<F>){chop;
my@toks=split/#/;
next unless scalar@toks;
my$h={};
$h->{cols}=scalar@toks;
for(my$i=0;$i<scalar(@toks);$i++){my$key='col'.$i;
$h->{$key}=$toks[$i];}if($h->{col0}&&$h->{col0}=~/^\d\d\d\d\-\d\d\-\d\d$/){$h->{date_changed}=$h->{col0}eq$last_date?0:1;
$last_date=$h->{col0};}$h->{col1}=' ' if$h->{col1}eq '';
$h->{col2}=0 if$h->{col2}eq '';
$h->{col3}=0 if defined$h->{col3}&&$h->{col3}eq '';
$h->{col4}=0 if defined$h->{col4}&&$h->{col4}eq '';
if($h->{col1}=~/\d\d\d\d\-\d\d\-\d\d/){$h->{sub}=1;
$h->{col1}="  ".$h->{col1};}else{$h->{main}=1;
$h->{col3}='';
$h->{col4}='';}push@{$info{rows}},$h;}close(F);
my$content="";
if($pdf){$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_doc_history.external.tmpl',\%info,\$content,)||die$TEMPLATE->error;
&external_print($cfg,$content,'report_doc_history_'.$cur_date.'_'.$cur_hour,1,$station,0);}else{if($where_to_print==2){$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_doc_history.external.tmpl',\%info,\$content,)||die$TEMPLATE->error;
&external_print($cfg,$content,'report_doc_history_'.$cur_date.'_'.$cur_hour,0,$station,0);}else{$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_doc_history.tmpl',\%info,\$content,)||die$TEMPLATE->error;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,station_close=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}}sub printer_screen{my($machine,$file)=@_;
my($station)=$file=~/\/printer_screen#(\d+)\.txt$/;
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
if($station!=$cfg->{STATION_NUMBER}){return 2;}print STDERR"#> printer_screen - $file\n";
&move($file,"/opt/pos/common/tmp/printer_screen.txt");}sub print_report_tables{my($machine,$file)=@_;
if($machine->is_station()){return 2;}my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}&get_clerks_information($db);
my($station,$area_rec,$clerk,$all_clerks,$all_areas,$to_screen,$only_totals,$to_ignore)=$file=~/\/report#tables#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)#(.*?)\.txt$/;
unlink($file);
my$content="";
my%info;
$cfg->{MACHINE_LABEL}||="";
$info{machine_label}=$cfg->{MACHINE_LABEL};
$info{station}=$station;
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
my$card_sets=$machine->card_sets_information();
my%cards_opened;
my$grand_total=0;
my%areas=();
my%tables_from_cards=();
&find(sub{return if$_=~/^\./;
return unless-d$File::Find::name;
my$area=$_;
my$area_info=$AREAS_INFO{$area};
my$start_idx=0;
my$end_idx=0;
if(defined$area_info&&scalar@$area_info>=7){$area_info->[1]||=0;
$area_info->[6]||=0;
$start_idx=$area_info->[6]||1;
$end_idx=($start_idx+$area_info->[1])-1;}else{$area_info->[1]||=0;
$start_idx=$area_info->[1]||1;
$end_idx=($start_idx+$area_info->[1])-1;}$start_idx=0 if$end_idx==0;
my$area_dir=$machine->dir_server()."/server/data/areas/$_";
my@ainfo=();
eval{@ainfo=@{$AREAS_INFO{$_}}};
if("$_" eq"$to_ignore"){return;}if($all_areas!=1){if($area!=$area_rec){return;}}my$cur_area=$_;
my$cur_area_name=$AREAS_INFO{$cur_area}->[0];
&find(sub{return unless-f$File::Find::name;
return unless$_=~/\.total$/;
my($number)=$_=~/^(\d+)\./;
return if$number==0;
if($start_idx!=0&&$end_idx!=0){if($number<$start_idx||$number>$end_idx){return;}}my$o=App::POS::Check->new(file=>$machine->dir_server()."/server/data/areas/$cur_area/$number");
my$i=$o->data();
my$total=$i->{header}->[19];
my$ex=$o->extra_data();
$ex->{custom_table_number}||="";
if($ex->{custom_table_number}){$tables_from_cards{$cur_area_name}->{$ex->{custom_table_number}}->{cards}->{$number}->{total}=$total;
$tables_from_cards{$cur_area_name}->{$ex->{custom_table_number}}->{total}+=$total;}if($all_clerks==0){return unless$i->{header}->[2]==$clerk;}$grand_total+=$total;
if(!$all_areas){return unless$cur_area eq$i->{header}->[6];}$areas{$cur_area_name}->{total}+=$total;
if(!exists$areas{$cur_area_name}->{clerks}->{$CLERKS_INFO->{$i->{header}->[2]}->{login}}->{tables}){$areas{$cur_area_name}->{clerks}->{$CLERKS_INFO->{$i->{header}->[2]}->{login}}->{tables}=[];}if($only_totals==0){push@{$areas{$cur_area_name}->{clerks}->{$CLERKS_INFO->{$i->{header}->[2]}->{login}}->{tables}},{number=>$number,total=>$total};
$areas{$cur_area_name}->{clerks}->{$CLERKS_INFO->{$i->{header}->[2]}->{login}}->{total}+=$total;}},($area_dir));},($machine->dir_server()."/server/data/areas"));
foreach my $area(keys%areas){foreach my $clerk(keys%{$areas{$area}->{clerks}}){my@tables=@{$areas{$area}->{clerks}->{$clerk}->{tables}};
@tables=sort{$a->{number}<=>$b->{number}}@tables;
$areas{$area}->{clerks}->{$clerk}->{tables}=\@tables;}}$info{all_areas}=$all_areas;
$info{all_clerks}=$all_clerks;
$info{only_totals}=$only_totals;
$info{total}=$grand_total;
$info{areas}=\%areas;
$info{cards_opened}=\%cards_opened;
$info{tables_from_cards}=\%tables_from_cards;
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_tables.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
if($to_screen){my$dir_tmp=$machine->server_dir_tmp();
my$cnt_tmp=$content;
$cnt_tmp=~s/\@.*?\@//g;
open(F,">> $dir_tmp/printer_screen#$station.txt");
print F$cnt_tmp;
close(F);}else{my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}}sub _data_for_report{my($machine,$clerk,$station,$business_date,$date_to,$clerk_filter,$sales_details,$selections,$report_type)=@_;
$sales_details||=0;
my$biz_date=$business_date;
my$cfg=$machine->config()->load_fixed();
$cfg->{STATION_NAME}||="";
$cfg->{POINTS_USAGE}||=0;
$cfg->{POINTS_VALUE_PER_POINT_ON_SALE}||=1;
my$db=$machine->database();
my%station_names=();
$station_names{0}=$cfg->{STATION_NAME}?$cfg->{STATION_NAME}:"0";
find(sub{my$station_num=$_;
return unless$station_num=~/^\d+$/;
open(F,"< $File::Find::name");
my@lines=<F>;
my$station_name=$lines[1]||"";
if($station_name){$station_name=~s/\n//g;
$station_name=~s/\r//g;
$station_names{$station_num}=$station_name;}else{$station_names{$station_num}=$station_num;}close(F);},("/opt/pos/server/data/registered_stations"));
my$station_name="";
$db->do("SET enable_nestloop TO off");
my%info=();
my$product_lists_info=&_get_report_lists_info($db);
my%waste_reasons=();
$cfg->{WASTE_JUSTIFICATIONS}||="";
$cfg->{CLERK_FOR_SALES_DATA}||=0;
if($cfg->{WASTE_JUSTIFICATIONS}){my@r=split/,/,$cfg->{WASTE_JUSTIFICATIONS};
my$i=1;
map{$waste_reasons{$i}=$_;$i++;}@r;}&get_clerks_information($db);
&get_products_information($db);
my$customers_info=undef;
print STDERR"QUERY1\n";
my$sth=$db->dbh()->prepare(qq{
    SELECT p1.id, p1.parent_product, p1.qtty_factor AS factor, p2.qtty_factor AS factor_parent
    FROM products p1
    LEFT JOIN products p2 ON (p1.parent_product = p2.id)
    WHERE p1.parent_product <> 0
  });
$sth->execute();
my%sales_by_factor_tmp=();
my%son_products=();
while(my$rec=$sth->fetchrow_hashref){$son_products{$rec->{id}}=1;
$sales_by_factor_tmp{$rec->{id}}->{factor}=$rec->{factor};
$sales_by_factor_tmp{$rec->{id}}->{parent}=$rec->{parent_product};
if($rec->{parent_product}!=0){$son_products{$rec->{parent_product}}=1;
$sales_by_factor_tmp{$rec->{parent_product}}->{factor}=$rec->{factor_parent};
$sales_by_factor_tmp{$rec->{parent_product}}->{parent}=0;}}my$recs=[];
my$total_tips=0;
my$total_service_charges=0;
my%done_tips=();
my%done_persons=();
my%done_service_charges=();
my%transfers=();
my%consumptions=();
my%voids=();
my%voids_detailed=();
my%voids_by_reason=();
my%discounts_family=();
my%persons_number=();
my%sales_family=();
my%sales_vat=();
my%sales_vat_by_date=();
my%sales_by_media=();
my%sales_by_doctype=();
my%sales_by_doctype_fininfo=();
my%sales_by_product=();
my%sales_by_station_product=();
my%sales_by_clerk_product=();
my%sales_by_product_extra_data=();
my%sales_by_product_no_sons=();
my%returns_by_product=();
my%sales_by_station=();
my%sales_by_clerk=();
my%sales_by_clerk_area_product=();
my%sales_by_serie=();
my%sales_by_customer=();
my%sales_by_customer_product=();
my%sales_by_customer_vat=();
my%sales_by_pricelevel=();
my%sales_by_menus=();
my%sales_by_cashier=();
my%sales_by_area=();
my%sales_by_parent=();
my%sales_by_hour=();
my%sales_by_cost=();
my%sales_by_list=();
my%counters_by_doctype=();
my%clocks_by_clerk=();
my%docs_canceled=();
my%drawer_openings=();
my%kept_in_source=();
my%sales_detailed=();
my%sales_by_cardset=();
my%points_by_customer=();
my%manual_docs=();
my%products_to_deliver=();
my$saft_from=$business_date;
my$saft_to=$date_to;
$saft_from=~s/\-//g;
$saft_to=~s/\-//g;
my$clerk_field="sh.clerk_close";
if($cfg->{CLERK_FOR_SALES_DATA}==0){$clerk_field="sd.clerk";}elsif($cfg->{CLERK_FOR_SALES_DATA}==2){$clerk_field="sh.clerk_open";}my$sql_clerk_query1="";
my$sql_clerk_query2="";
my$sql_clerk_query3="";
my$sql_clerk_query4="";
my@sql_params_two=($business_date,$date_to);
my@sql_params_four=($business_date,$date_to,$business_date,$date_to);
if(defined$clerk_filter){$sql_clerk_query1=" AND clerk = ?";
$sql_clerk_query2=" AND clerk_close = ?";
$sql_clerk_query3=" AND $clerk_field = ?";
$sql_clerk_query4=" AND t.clerk = ?";
@sql_params_two=($business_date,$date_to,$clerk);
@sql_params_four=($business_date,$date_to,$clerk,$business_date,$date_to);}eval{$sth=$db->dbh()->prepare(qq{
      SELECT id, station_number, clerk, clerk_name, business_date, to_char(date, 'HH:MI:SS') AS hour, to_char(date, 'YYYY-MM-DD') AS date
      FROM cashdrawer_opens
      WHERE business_date IS NOT NULL AND business_date >= ? AND business_date <= ?$sql_clerk_query1
      ORDER BY id
    });
$sth->execute(@sql_params_two);
while(my$rec=$sth->fetchrow_hashref){push@{$drawer_openings{clerks}->{$rec->{clerk_name}}},$rec;}};
if(scalar keys%DELIVERY_AREAS&&exists$selections->{"50_products_to_deliver.txt"}){$sth=$db->dbh()->prepare(qq{
      SELECT sh.business_date, sd.price, sd.price_wo_vat,
        sd.quantity, sd.discount, sd.offer, sd.vat, sh.doc_type,
        sh.station_close, sh.clerk_close_name, sh.clerk_open_name,
        sh.clerk_open_name, sd.price_used, sh.cashier, sh.area, sh.tip,
        sh.service_charge, sd.header, p.id AS product_id, p.cost_price,
        extract(dow from sh.business_date) AS dow, sh.hour AS sale_hour,
        sh.persons_number, sd.clerk_name, sha3.key_value AS doc_canceled,
        sh.value AS doc_value, sh.fo_doc_number, sd.inside_menu, p.is_menu,
        sh.id AS doc_id, sd.gb_identifier, sh.discount AS doc_discount,
        sh.table_num, sh.customer_nif, sd.product_name, sd.free_text,
        sd.department, sh.customer_id, sd.station, sh.serie,
        sh.date_closed, sh.customer,
        sha1.key_value AS delivery_date,
        sha2.key_value AS delivery_period
      FROM sales_details sd
      LEFT JOIN sales_headers sh ON (sh.id = sd.header)
      LEFT JOIN sales_headers_aux sha1 ON (sh.id = sha1.header AND sha1.key_name = 'delivery_date')
      LEFT JOIN sales_headers_aux sha2 ON (sh.id = sha2.header AND sha2.key_name = 'delivery_period')
      LEFT JOIN sales_headers_aux sha3 ON (sh.id = sha3.header AND sha3.key_name = 'canceled')
      LEFT JOIN products p ON (sd.product = p.id)
      WHERE sd.operation_type = 1
      AND sha1.key_value >= ? AND sha1.key_value <= ?$sql_clerk_query3
      ORDER BY sh.id, sd.gb_identifier
    });
$sth->execute(@sql_params_two);
my@fields_tmp=@{$sth->{NAME}};
my%rec_tmp=();
$sth->bind_columns(map{\$rec_tmp{$_}}@fields_tmp);
while($sth->fetch){my$rec=\%rec_tmp;
next if$rec->{doc_canceled};
next unless$rec->{doc_type}==1||$rec->{doc_type}==2||$rec->{doc_type}==5||$rec->{doc_type}==7||$rec->{doc_type}==90||$rec->{doc_type}==13||$rec->{doc_type}==12;
$rec->{price}||=0;
$rec->{discount}||=0;
my$discount_w_vat=$rec->{discount}*(1+$rec->{vat}/100);
my$price=$rec->{price}-$discount_w_vat;
my$line_total=$rec->{quantity}*$price;
my$line_total_wo_vat=($rec->{quantity}*$price)/(1+$rec->{vat}/100);
my$fam_name=&my_conv($rec->{family_name});
my$prod_name=&my_conv($rec->{product_name});
my$sub_fam_name=&my_conv($rec->{subfamily_name});
my$line_dept=$rec->{department};
my$serie=$rec->{serie};
my$date=$rec->{delivery_date};
my$period=$rec->{delivery_period};
$products_to_deliver{dates}->{$date}->{products}->{$prod_name}->{total}+=$line_total;
$products_to_deliver{dates}->{$date}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$products_to_deliver{dates}->{$date}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$products_to_deliver{dates}->{$date}->{total}+=$line_total;
$products_to_deliver{dates}->{$date}->{total_wo_vat}+=$line_total_wo_vat;
$products_to_deliver{dates}->{$date}->{total_qttys}+=$rec->{quantity};
$products_to_deliver{total}+=$line_total;
$products_to_deliver{total_qttys}+=$rec->{quantity};}}print STDERR"QUERY2\n";
$sth=$db->dbh()->prepare(qq{
    SELECT sh.fo_doc_number, sh.doc_type
    FROM sales_headers sh
    LEFT JOIN sales_headers_aux sha8 ON (sh.id = sha8.header AND sha8.key_name = 'manualdoc_serie')
    WHERE sh.business_date >= ? AND sh.business_date <= ?$sql_clerk_query2 AND
      sh.doc_type <> 99 AND sh.doc_type <> 3
      AND sha8.key_value IS NULL
    ORDER BY sh.id
  });
$sth->execute(@sql_params_two);
while(my$rec=$sth->fetchrow_hashref){my($doc,$num)=$rec->{fo_doc_number}=~/^(.*?)\/(\d+)$/;
if(!exists$counters_by_doctype{$doc}->{min}){$counters_by_doctype{$doc}->{min}=$rec->{fo_doc_number};}$counters_by_doctype{$doc}->{max}=$rec->{fo_doc_number};}$sth=$db->dbh()->prepare(qq{
    SELECT * FROM time_clock WHERE date >= ? AND date <= ?$sql_clerk_query1 ORDER BY id
  });
$sth->execute(@sql_params_two);
while(my$rec=$sth->fetchrow_hashref){$rec->{operation}=~s/^clerk_//;
push@{$clocks_by_clerk{clerks}->{$rec->{clerk_name}}},$rec;}my$card_sets=$machine->card_sets_information();
print STDERR"QUERY3\n";
my$doc_types=$machine->config()->doc_types_by_id();
my$doc_types_by_name=$machine->config()->doc_types_by_name();
$sth=$db->dbh()->prepare(qq{
    SELECT sh.business_date, sd.price, sd.price_wo_vat,
      sd.quantity, sd.discount, sd.offer, sd.vat, sh.doc_type,
      sh.station_close, sh.clerk_close_name, sh.clerk_open_name, sh.clerk_open_name,
      sd.price_used, sh.cashier, sh.area, sh.tip, sh.service_charge,
      sd.header, p.id AS product_id, p.cost_price, sh.customer,
      extract(dow from sh.business_date) AS dow, sh.hour AS sale_hour,
      sh.persons_number, sd.clerk_name, sha3.key_value AS doc_canceled,
      sh.value AS doc_value, sh.fo_doc_number, sd.inside_menu, p.is_menu,
      sha4.key_value AS kept_in_source, sha5.key_value AS is_consumption,
      sh.id AS doc_id, sd.gb_identifier, sh.discount AS doc_discount,
      sh.table_num, sh.customer_nif, sd.product_name, sd.free_text,
      sd.department, sha6.key_value AS invoice_is_payed, sh.customer_id,
      sd.station, sha7.key_value AS override_customer_id, sh.serie,
      sh.date_closed,
    CASE
      WHEN f.id IS NOT NULL THEN COALESCE(f.name,'----------')
      ELSE COALESCE(sf.name,'----------')
    END as family_name,
    CASE
      WHEN sf.id IS NOT NULL THEN COALESCE(sf.name,'----------')
      ELSE '----------'
    END as subfamily_name
    FROM sales_details sd
    LEFT JOIN sales_headers sh ON (sh.id = sd.header)
    LEFT JOIN sales_headers_aux sha3 ON (sh.id = sha3.header AND sha3.key_name = 'canceled')
    LEFT JOIN sales_headers_aux sha4 ON (sh.id = sha4.header AND sha4.key_name = 'kept_in_source')
    LEFT JOIN sales_headers_aux sha5 ON (sh.id = sha5.header AND sha5.key_name = 'is_consumption')
    LEFT JOIN sales_headers_aux sha6 ON (sh.id = sha6.header AND sha6.key_name = 'invoice_is_payed')
    LEFT JOIN sales_headers_aux sha7 ON (sh.id = sha7.header AND sha7.key_name = 'override_customer_id')
    LEFT JOIN sales_headers_aux sha8 ON (sh.id = sha8.header AND sha8.key_name = 'manualdoc_serie')
    LEFT JOIN products p ON (sd.product = p.id)
    LEFT JOIN (
      SELECT product_id, MAX(group_id) as group_id
      FROM product_groups
      GROUP BY product_id
    ) pg ON (p.id = pg.product_id)
    LEFT JOIN groups sf ON (pg.group_id = sf.id)
    LEFT JOIN groups f ON (sf.parent = f.id)
    WHERE sd.operation_type = 1
    AND sh.business_date >= ? AND sh.business_date <= ?$sql_clerk_query3
    AND sd.business_date >= ? AND sd.business_date <= ?
    AND sha8.key_value IS NULL
    ORDER BY sh.id, sd.gb_identifier
  });
$sth->execute(@sql_params_four);
my%did_detail=();
my%processed_control=();
my%did_header=();
my@fields_tmp=@{$sth->{NAME}};
my%rec_tmp=();
$sth->bind_columns(map{\$rec_tmp{$_}}@fields_tmp);
while($sth->fetch){my$rec=\%rec_tmp;
$did_header{$rec->{doc_id}}++;
$rec->{doc_canceled}||=0;
$rec->{kept_in_source}||=0;
$rec->{is_consumption}||=0;
$rec->{invoice_is_payed}||=0;
if($rec->{doc_canceled}){if(!exists$docs_canceled{$rec->{header}}){$docs_canceled{total}+=$rec->{doc_value};}$docs_canceled{$rec->{header}}={business_date=>$rec->{business_date},fo_doc_number=>$rec->{fo_doc_number},value=>$rec->{doc_value},};
next;}$rec->{price}||=0;
$rec->{discount}||=0;
my$discount_w_vat=$rec->{discount}*(1+$rec->{vat}/100);
my$price=$rec->{price}-$discount_w_vat;
my$line_total=$rec->{quantity}*$price;
my$line_total_wo_vat=($rec->{quantity}*$price)/(1+$rec->{vat}/100);
my$fam_name=&my_conv($rec->{family_name});
my$prod_name=&my_conv($rec->{product_name});
my$sub_fam_name=&my_conv($rec->{subfamily_name});
my$line_dept=$rec->{department};
my$serie=$rec->{serie};
my($saft_date)=$rec->{date_closed}=~/^(.*?)\s/;
$saft_date=~s/\-//g;
if($line_dept=~/§/){($fam_name,$sub_fam_name)=split/§/,$line_dept;
$fam_name=&my_conv($fam_name);
$sub_fam_name=&my_conv($sub_fam_name);}$rec->{override_customer_id}||=0;
my$customer_name="";
my$customer_nif="";
my$orig_customer_name="";
my$orig_customer_nif="";
if($rec->{override_customer_id}){if(!defined$customers_info){$customers_info=get_customers_information($db);}$orig_customer_name=$rec->{customer}||"";
$orig_customer_nif=$rec->{customer_nif}||'999999990';
$customer_name=$customers_info->{$rec->{override_customer_id}}->{name}||"";
$customer_nif=$customers_info->{$rec->{override_customer_id}}->{nif}||'999999990';}else{$customer_name=$rec->{customer}||"";
$customer_nif=$rec->{customer_nif}||"";
$orig_customer_name=$customer_name;
$orig_customer_nif=$customer_nif;
if(!$customer_nif){$customer_nif='999999990';
$orig_customer_name='999999990';}if(!$customer_name){$customer_name='999999990';}}$customer_name=~s/^\s+$// if$customer_name;
$orig_customer_name=~s/^\s+$// if$orig_customer_name;
if($orig_customer_nif eq '999999990'){$orig_customer_name='';}my$clerk_name=&my_conv($rec->{clerk_close_name});
if($cfg->{CLERK_FOR_SALES_DATA}==0){$clerk_name=&my_conv($rec->{clerk_name});}elsif($cfg->{CLERK_FOR_SALES_DATA}==2){$clerk_name=&my_conv($rec->{clerk_open_name});}my$doc_type_str=$doc_types->{$rec->{doc_type}};
if($sales_details){if(!exists$did_detail{$rec->{doc_id}}){my$cur_area_name=$AREAS_INFO{$rec->{area}}->[0];
push@{$sales_detailed{docs}->{$rec->{business_date}}->{headers}},{fo_doc_number=>$rec->{fo_doc_number},doc_id=>$rec->{doc_id},doc_value=>$rec->{doc_value},doc_discount=>$rec->{doc_discount},customer_name=>$rec->{customer}||" ",customer_nif=>$rec->{customer_nif},area=>$rec->{area},area_name=>$cur_area_name,table_num=>$rec->{table_num},clerk=>$rec->{clerk_close_name},hour=>$rec->{sale_hour},};
$did_detail{$rec->{doc_id}}=1;}push@{$sales_detailed{products}->{$rec->{doc_id}}},{product_name=>$prod_name,quantity=>$rec->{quantity},total=>$line_total,vat=>$rec->{vat},};
$sales_detailed{total}+=$line_total;
$sales_detailed{total_wo_vat}+=$line_total_wo_vat;}$sales_by_doctype{doc_types}->{$doc_type_str}->{doc_type}=$rec->{doc_type};
$sales_by_doctype{doc_types}->{$doc_type_str}->{is_payed}=$rec->{invoice_is_payed};
$sales_by_doctype{doc_types}->{$doc_type_str}->{total}+=$line_total;
$sales_by_doctype{doc_types}->{$doc_type_str}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_doctype{doc_types}->{$doc_type_str}->{total_qttys}+=$rec->{quantity};
$sales_by_doctype_fininfo{doc_types}->{$doc_type_str}->{$rec->{invoice_is_payed}}->{doc_type}=$rec->{doc_type};
$sales_by_doctype_fininfo{doc_types}->{$doc_type_str}->{$rec->{invoice_is_payed}}->{total}+=$line_total;
$sales_by_doctype_fininfo{doc_types}->{$doc_type_str}->{$rec->{invoice_is_payed}}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_doctype_fininfo{doc_types}->{$doc_type_str}->{$rec->{invoice_is_payed}}->{total_qttys}+=$rec->{quantity};
if($rec->{is_consumption}){$consumptions{logins}->{$clerk_name}->{total}+=$line_total;
$consumptions{logins}->{$clerk_name}->{total_wo_vat}+=$line_total_wo_vat;
$consumptions{logins}->{$clerk_name}->{total_qttys}+=$rec->{quantity};
$consumptions{logins}->{$clerk_name}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$consumptions{logins}->{$clerk_name}->{products}->{$prod_name}->{total}+=$line_total;
$consumptions{logins}->{$clerk_name}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$consumptions{total}+=$line_total;
$consumptions{total_wo_vat}+=$line_total_wo_vat;
$consumptions{total_qttys}+=$rec->{quantity};}if($rec->{doc_type}==1||$rec->{doc_type}==5||$rec->{doc_type}==90||$rec->{doc_type}==12||$rec->{doc_type}==7){$sales_vat{received}->{vats}->{$rec->{vat}*1}->{total}+=$line_total;
$sales_vat{received}->{vats}->{$rec->{vat}*1}->{total_wo_vat}+=$line_total_wo_vat;
$sales_vat{received}->{vats}->{$rec->{vat}*1}->{total_vat}+=$line_total-$line_total_wo_vat;
$sales_vat{received}->{total}+=$line_total;
$sales_vat{received}->{total_wo_vat}+=$line_total_wo_vat;
$sales_vat{received}->{total_vat}+=$line_total-$line_total_wo_vat;
if($did_header{$rec->{doc_id}}==1){$kept_in_source{by_customer}->{$customer_name}+=$rec->{kept_in_source};
$kept_in_source{total}+=$rec->{kept_in_source};}}if($rec->{doc_type}==2||$rec->{doc_type}==13){$sales_vat{payed}->{vats}->{$rec->{vat}*1}->{total}+=$line_total*-1;
$sales_vat{payed}->{vats}->{$rec->{vat}*1}->{total_wo_vat}+=$line_total_wo_vat*-1;
$sales_vat{payed}->{vats}->{$rec->{vat}*1}->{total_vat}+=($line_total-$line_total_wo_vat)*-1;
$sales_vat{payed}->{total}+=$line_total*-1;
$sales_vat{payed}->{total_wo_vat}+=$line_total_wo_vat*-1;
$sales_vat{payed}->{total_vat}+=($line_total-$line_total_wo_vat)*-1;
if($did_header{$rec->{doc_id}}==1){$kept_in_source{by_customer}->{$customer_name}+=$rec->{kept_in_source}*-1;
$kept_in_source{total}+=$rec->{kept_in_source}*-1;}}if($rec->{doc_type}==1||$rec->{doc_type}==2||$rec->{doc_type}==5||$rec->{doc_type}==90||$rec->{doc_type}==12||$rec->{doc_type}==13||$rec->{doc_type}==7){$sales_vat{vats}->{$rec->{vat}*1}->{total}+=$line_total;
$sales_vat{vats}->{$rec->{vat}*1}->{total_wo_vat}+=$line_total_wo_vat;
$sales_vat{vats}->{$rec->{vat}*1}->{total_vat}+=$line_total-$line_total_wo_vat;
$sales_vat{total}+=$line_total;
$sales_vat{total_wo_vat}+=$line_total_wo_vat;
$sales_vat_by_date{dates}->{$rec->{business_date}}->{vats}->{$rec->{vat}*1}->{total}+=$line_total;
$sales_vat_by_date{dates}->{$rec->{business_date}}->{vats}->{$rec->{vat}*1}->{total_wo_vat}+=$line_total_wo_vat;
$sales_vat_by_date{dates}->{$rec->{business_date}}->{vats}->{$rec->{vat}*1}->{total_vat}+=$line_total-$line_total_wo_vat;
$sales_vat_by_date{dates}->{$rec->{business_date}}->{total}+=$line_total;
$sales_vat_by_date{dates}->{$rec->{business_date}}->{total_wo_vat}+=$line_total_wo_vat;
$sales_vat_by_date{vats}->{$rec->{vat}*1}->{total}+=$line_total;
$sales_vat_by_date{vats}->{$rec->{vat}*1}->{total_wo_vat}+=$line_total_wo_vat;
$sales_vat_by_date{vats}->{$rec->{vat}*1}->{total_vat}+=$line_total-$line_total_wo_vat;
$sales_vat_by_date{total}+=$line_total;
$sales_vat_by_date{total_wo_vat}+=$line_total_wo_vat;}if($rec->{doc_type}==1||$rec->{doc_type}==2||$rec->{doc_type}==5||$rec->{doc_type}==90||$rec->{doc_type}==8||($rec->{doc_type}==7&&$rec->{invoice_is_payed})){$sales_by_cashier{cashiers}->{$rec->{cashier}}->{name}=exists$CASHIER_NAMES{$rec->{cashier}}?$CASHIER_NAMES{$rec->{cashier}}:$rec->{cashier};
$sales_by_cashier{cashiers}->{$rec->{cashier}}->{total}+=$line_total;
$sales_by_cashier{cashiers}->{$rec->{cashier}}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cashier{cashiers}->{$rec->{cashier}}->{total_qttys}+=$rec->{quantity};
$sales_by_cashier{total}+=$line_total;
$sales_by_cashier{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cashier{total_qttys}+=$rec->{quantity};}if($rec->{doc_type}==2||$rec->{doc_type}==13){$returns_by_product{products}->{$prod_name}->{total}+=$line_total;
$returns_by_product{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$returns_by_product{products}->{$prod_name}->{total_qttys}+=$rec->{quantity}*-1;
$returns_by_product{total}+=$line_total;
$returns_by_product{total_qttys}+=$rec->{quantity}*-1;}next unless$rec->{doc_type}==1||$rec->{doc_type}==2||$rec->{doc_type}==5||$rec->{doc_type}==7||$rec->{doc_type}==90||$rec->{doc_type}==13||$rec->{doc_type}==12;
my$doc_type_tmp=$rec->{doc_type};
$doc_type_tmp=90 if$rec->{doc_type}==7&&$rec->{invoice_is_payed};
$sales_by_serie{series}->{$serie}->{total}+=$line_total;
$sales_by_serie{series}->{$serie}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_serie{series}->{$serie}->{total_qttys}+=$rec->{quantity};
$sales_by_serie{total}+=$line_total;
$sales_by_serie{total_wo_vat}+=$line_total_wo_vat;
$sales_by_serie{total_qttys}+=$rec->{quantity};
if($rec->{doc_type}!=4){$sales_by_clerk{clerks}->{$clerk_name}->{doc_types}->{$doc_type_tmp}->{total}+=$line_total;
$sales_by_clerk{clerks}->{$clerk_name}->{doc_types}->{$doc_type_tmp}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk{clerks}->{$clerk_name}->{doc_types}->{$doc_type_tmp}->{total_qttys}+=$rec->{quantity};
$sales_by_clerk{total}+=$line_total;
$sales_by_clerk{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk{total_qttys}+=$rec->{quantity};}if($rec->{free_text}){my@toks1=split/;/,$rec->{free_text};
for(@toks1){my@toks2=split/:/;
next unless scalar@toks2>1;
$toks2[1]=~s/^\s+//;
$sales_by_product_extra_data{products}->{$prod_name}->{$toks2[0]}->{$toks2[1]}++;}}if(!exists$done_tips{$rec->{header}}){$total_tips+=$rec->{tip};
$done_tips{$rec->{header}}=1;}if(!exists$done_service_charges{$rec->{header}}){$total_service_charges+=$rec->{service_charge};
$done_service_charges{$rec->{header}}=1;}if($rec->{is_menu}){$sales_by_menus{menus}->{products}->{$prod_name}->{total}+=$line_total;
$sales_by_menus{menus}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_menus{menus}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_menus{menus}->{total}+=$line_total;
$sales_by_menus{menus}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_menus{menus}->{total_qttys}+=$rec->{quantity};
$sales_by_menus{by_product}->{products}->{1}->{$prod_name}->{total}+=$line_total;
$sales_by_menus{by_product}->{products}->{1}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_menus{by_product}->{products}->{1}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_menus{by_product}->{total}+=$line_total;
$sales_by_menus{by_product}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_menus{by_product}->{total_qttys}+=$rec->{quantity};}elsif($rec->{inside_menu}>0){my$menu_product=$rec->{inside_menu};
my$menu_name=&my_conv($PRODUCTS_INFO->{$rec->{inside_menu}}->{name});
$sales_by_menus{menus}->{products}->{$menu_name}->{total_wo_vat}+=$line_total;
$sales_by_menus{menus}->{total}+=$line_total;
$sales_by_menus{menus}->{total_wo_vat}+=$line_total;
$sales_by_menus{menus}->{products}->{$menu_name}->{products}->{$prod_name}->{total}+=$line_total;
$sales_by_menus{menus}->{products}->{$menu_name}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_menus{menus}->{products}->{$menu_name}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_menus{by_product}->{products}->{0}->{$prod_name}->{total}+=$line_total;
$sales_by_menus{by_product}->{products}->{0}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_menus{by_product}->{products}->{0}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_menus{by_product}->{total}+=$line_total;
$sales_by_menus{by_product}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_menus{by_product}->{total_qttys}+=$rec->{quantity};}$rec->{cost_price}||=0;
if($rec->{cost_price}>0){my$v1=$rec->{quantity}*$rec->{cost_price};
my$v2=$rec->{quantity}*$line_total_wo_vat;
$sales_by_cost{products}->{$prod_name}->{value_by_cost}+=$v1;
$sales_by_cost{products}->{$prod_name}->{value_by_sale}+=$v2;
$sales_by_cost{products}->{$prod_name}->{value_diff}+=$v2-$v1;
$sales_by_cost{total_diff}+=$v2-$v1;
$sales_by_cost{total_qttys}+=$rec->{quantity};
$sales_by_cost{total_costs}+=$v1;
$sales_by_cost{total_sales}+=$v2;}if(defined$card_sets){my$card_set_info=$card_sets->{by_table}->{$rec->{table_num}};
if(defined$card_set_info){for(@$card_set_info){$sales_by_cardset{"set"}->{sets}->{$_}->{cards}->{$rec->{table_num}}->{total}+=$line_total;
$sales_by_cardset{"set"}->{sets}->{$_}->{cards}->{$rec->{table_num}}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"set"}->{sets}->{$_}->{cards}->{$rec->{table_num}}->{total_qttys}+=$rec->{quantity};
$sales_by_cardset{"set"}->{sets}->{$_}->{name}=$card_sets->{sets}->{$_}->[0];
$sales_by_cardset{"set"}->{sets}->{$_}->{total}+=$line_total;
$sales_by_cardset{"set"}->{sets}->{$_}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"set"}->{sets}->{$_}->{total_qttys}+=$rec->{quantity};
$sales_by_cardset{"set"}->{total}+=$line_total;
$sales_by_cardset{"set"}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"set"}->{total_qttys}+=$rec->{quantity};}}else{$sales_by_cardset{"without_set"}->{total}+=$line_total;
$sales_by_cardset{"without_set"}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"without_set"}->{total_qttys}+=$rec->{quantity};
$sales_by_cardset{"without_set"}->{cards}->{$rec->{table_num}}->{total}+=$line_total;
$sales_by_cardset{"without_set"}->{cards}->{$rec->{table_num}}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"without_set"}->{cards}->{$rec->{table_num}}->{total_qttys}+=$rec->{quantity};}}$sales_by_pricelevel{prices}->{$rec->{price_used}}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_pricelevel{prices}->{$rec->{price_used}}->{total_qttys}+=$rec->{quantity};
$sales_by_pricelevel{total}+=$line_total;
$sales_by_pricelevel{total_wo_vat}+=$line_total_wo_vat;
$sales_by_pricelevel{total_qttys}+=$rec->{quantity};
$orig_customer_nif='999999990' if!$orig_customer_name&&!$orig_customer_nif;
$orig_customer_name=$orig_customer_nif if!$orig_customer_name&&$orig_customer_nif;
$sales_by_customer_vat{customers}->{$orig_customer_name}->{vats}->{$rec->{vat}}->{total}+=$line_total;
$sales_by_customer_vat{customers}->{$orig_customer_name}->{vats}->{$rec->{vat}}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer_vat{customers}->{$orig_customer_name}->{vats}->{$rec->{vat}}->{total_qttys}+=$rec->{quantity};
$sales_by_customer_vat{customers}->{$orig_customer_name}->{total}+=$line_total;
$sales_by_customer_vat{customers}->{$orig_customer_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer_vat{customers}->{$orig_customer_name}->{total_qttys}+=$rec->{quantity};
$sales_by_customer_vat{customers}->{$orig_customer_name}->{nif}=$orig_customer_nif?$orig_customer_nif:$orig_customer_name;
$sales_by_customer_vat{total}+=$line_total;
$sales_by_customer_vat{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer_vat{total_qttys}+=$rec->{quantity};
$sales_by_customer_product{customers}->{$customer_name}->{products}->{$prod_name}->{total}+=$line_total;
$sales_by_customer_product{customers}->{$customer_name}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer_product{customers}->{$customer_name}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_customer_product{customers}->{$customer_name}->{total}+=$line_total;
$sales_by_customer_product{customers}->{$customer_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer_product{customers}->{$customer_name}->{total_qttys}+=$rec->{quantity};
$sales_by_customer_product{customers}->{$customer_name}->{nif}=$rec->{customer_nif}?$rec->{customer_nif}:$customer_name;
$sales_by_customer_product{total}+=$line_total;
$sales_by_customer_product{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer_product{total_qttys}+=$rec->{quantity};
$sales_by_customer{customers}->{$customer_name||'999999990'}->{total}+=$line_total;
$sales_by_customer{customers}->{$customer_name||'999999990'}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer{customers}->{$customer_name||'999999990'}->{total_qttys}+=$rec->{quantity};
$sales_by_customer{total}+=$line_total;
$sales_by_customer{total_wo_vat}+=$line_total_wo_vat;
$sales_by_customer{total_qttys}+=$rec->{quantity};
$station_name=exists$station_names{$rec->{station_close}}?$station_names{$rec->{station_close}}:$rec->{station_close};
$sales_by_station{stations}->{$station_name}->{total}+=$line_total;
$sales_by_station{stations}->{$station_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_station{stations}->{$station_name}->{total_qttys}+=$rec->{quantity};
$sales_by_station{total}+=$line_total;
$sales_by_station{total_wo_vat}+=$line_total_wo_vat;
$sales_by_station{total_qttys}+=$rec->{quantity};
if(exists$sales_by_factor_tmp{$rec->{product_id}}){my$name_key="";
my$factor=1;
$factor=$sales_by_factor_tmp{$rec->{product_id}}->{factor}if$sales_by_factor_tmp{$rec->{product_id}}->{factor};
if($sales_by_factor_tmp{$rec->{product_id}}->{parent}==0){$name_key=$prod_name;}else{my$pid=$sales_by_factor_tmp{$rec->{product_id}}->{parent};
my$product_name=exists$PRODUCTS_INFO->{$pid}?$PRODUCTS_INFO->{$pid}->{name}:'UNKNOWN';
$name_key=&my_conv($product_name);}$sales_by_parent{products}->{$name_key}->{total}+=$line_total;
$sales_by_parent{products}->{$name_key}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_parent{products}->{$name_key}->{total_qttys}+=$rec->{quantity}*$factor;
$sales_by_parent{total}+=$line_total;
$sales_by_parent{total_qttys}+=$rec->{quantity};}my$area_name=exists$AREAS_INFO{$rec->{area}}?$AREAS_INFO{$rec->{area}}->[0]:'INVALID - '.$rec->{area};
$sales_by_area{areas}->{$area_name}->{total}+=$line_total;
$sales_by_area{areas}->{$area_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_area{areas}->{$area_name}->{total_qttys}+=$rec->{quantity};
$sales_by_area{total}+=$line_total;
$sales_by_area{total_wo_vat}+=$line_total_wo_vat;
$sales_by_area{total_qttys}+=$rec->{quantity};
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{$area_name}->{products}->{$prod_name}->{total}+=$line_total;
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{$area_name}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{$area_name}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_clerk_area_product{clerks}->{total}+=$line_total;
$sales_by_clerk_area_product{clerks}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk_area_product{clerks}->{total_qttys}+=$rec->{quantity};
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{total}+=$line_total;
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{total_qttys}+=$rec->{quantity};
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{$area_name}->{total}+=$line_total;
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{$area_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk_area_product{clerks}->{$clerk_name}->{areas}->{$area_name}->{total_qttys}+=$rec->{quantity};
my($hour)=$rec->{sale_hour}=~/^(\d+)\:/;
$sales_by_hour{hours}->{$hour}->{total}+=$line_total;
$sales_by_hour{hours}->{$hour}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_hour{hours}->{$hour}->{total_qttys}+=$rec->{quantity};
$sales_by_hour{total}+=$line_total;
$sales_by_hour{total_wo_vat}+=$line_total_wo_vat;
$sales_by_hour{total_qttys}+=$rec->{quantity};
$sales_by_clerk{clerks}->{$clerk_name}->{total}+=$line_total;
$sales_by_clerk{clerks}->{$clerk_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk{clerks}->{$clerk_name}->{total_qttys}+=$rec->{quantity};
if(!exists$son_products{$rec->{product_id}}){$sales_by_product_no_sons{products}->{$prod_name}->{total}+=$line_total;
$sales_by_product_no_sons{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_product_no_sons{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_product_no_sons{total}+=$line_total;
$sales_by_product_no_sons{total_qttys}+=$rec->{quantity};}$sales_by_product{products}->{$prod_name}->{total}+=$line_total;
$sales_by_product{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_product{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_product{total}+=$line_total;
$sales_by_product{total_qttys}+=$rec->{quantity};
$station_name=exists$station_names{$rec->{station}}?$station_names{$rec->{station}}:$rec->{station};
$sales_by_station_product{stations}->{$station_name}->{products}->{$prod_name}->{total}+=$line_total;
$sales_by_station_product{stations}->{$station_name}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_station_product{stations}->{$station_name}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_station_product{stations}->{$station_name}->{total}+=$line_total;
$sales_by_station_product{stations}->{$station_name}->{total_qttys}+=$rec->{quantity};
$sales_by_station_product{total}+=$line_total;
$sales_by_station_product{total_qttys}+=$rec->{quantity};
$sales_by_clerk_product{clerks}->{$clerk_name}->{products}->{$prod_name}->{total}+=$line_total;
$sales_by_clerk_product{clerks}->{$clerk_name}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_clerk_product{clerks}->{$clerk_name}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_by_clerk_product{clerks}->{$clerk_name}->{total}+=$line_total;
$sales_by_clerk_product{clerks}->{$clerk_name}->{total_qttys}+=$rec->{quantity};
$sales_by_clerk_product{total}+=$line_total;
$sales_by_clerk_product{total_qttys}+=$rec->{quantity};
if(exists$product_lists_info->{lists_by_products}->{$rec->{product_id}}){my$i=$product_lists_info->{lists_by_products}->{$rec->{product_id}};
my@lists=keys%$i;
foreach my $list(@lists){my$linfo=$product_lists_info->{lists}->{$list};
my$wd=$linfo->{weekdays_as_array};
if($wd->[$rec->{dow}]){my$list_name=$linfo->{name};
if($linfo->{end_hour}ne '00:00'){my$lsh=$rec->{business_date}." ".$linfo->{start_hour};
my$leh=$rec->{business_date}." ".$linfo->{end_hour};
my$sh=$rec->{business_date}." ".$rec->{sale_hour};
my@a=$lsh=~/^(\d+)\-(\d+)\-(\d+)\s(\d+)\:(\d+)/;
push@a,"00";
$lsh=Date_to_Time(@a);
@a=$leh=~/^(\d+)\-(\d+)\-(\d+)\s(\d+)\:(\d+)/;
push@a,"00";
$leh=Date_to_Time(@a);
@a=$sh=~/^(\d+)\-(\d+)\-(\d+)\s(\d+)\:(\d+)/;
push@a,"00";
$sh=Date_to_Time(@a);
if($sh>=$lsh&&$sh<=$leh){$sales_by_list{lists}->{$list_name}->{total}+=$line_total;
$sales_by_list{lists}->{$list_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_list{lists}->{$list_name}->{total_qttys}+=$rec->{quantity};
$sales_by_list{total}+=$line_total;
$sales_by_list{total_qttys}+=$rec->{quantity};}}else{$sales_by_list{lists}->{$list_name}->{total}+=$line_total;
$sales_by_list{lists}->{$list_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_list{lists}->{$list_name}->{total_qttys}+=$rec->{quantity};
$sales_by_list{total}+=$line_total;
$sales_by_list{total_qttys}+=$rec->{quantity};}}}}$sales_family{families}->{$fam_name}->{subfamilies}->{$sub_fam_name}->{products}->{$prod_name}->{total}+=$line_total;
$sales_family{families}->{$fam_name}->{subfamilies}->{$sub_fam_name}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_family{families}->{$fam_name}->{subfamilies}->{$sub_fam_name}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$sales_family{families}->{$fam_name}->{subfamilies}->{$sub_fam_name}->{total}+=$line_total;
$sales_family{families}->{$fam_name}->{subfamilies}->{$sub_fam_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_family{families}->{$fam_name}->{subfamilies}->{$sub_fam_name}->{total_qttys}+=$rec->{quantity};
$sales_family{families}->{$fam_name}->{total}+=$line_total;
$sales_family{families}->{$fam_name}->{total_wo_vat}+=$line_total_wo_vat;
$sales_family{families}->{$fam_name}->{total_qttys}+=$rec->{quantity};
$sales_family{total}+=$line_total;
$sales_family{total_wo_vat}+=$line_total_wo_vat;
$sales_family{total_qttys}+=$rec->{quantity};
if($rec->{discount}>0){$discounts_family{families}->{$fam_name}->{total}+=$discount_w_vat*$rec->{quantity};
$discounts_family{families}->{$fam_name}->{total_qttys}+=$rec->{quantity};
$discounts_family{total}+=$discount_w_vat*$rec->{quantity};
$discounts_family{total_qttys}+=$rec->{quantity};}if(!exists$done_persons{$rec->{header}}){if($rec->{persons_number}>0){if($rec->{doc_type}==2||$rec->{doc_type}==13||$rec->{doc_type}==14||$rec->{doc_type}==33){$rec->{persons_number}=$rec->{persons_number}*-1;}$persons_number{clerks}->{$clerk_name}+=$rec->{persons_number};
$persons_number{areas}->{$AREAS_INFO{$rec->{area}}->[0]}+=$rec->{persons_number};
$persons_number{total}+=$rec->{persons_number};}$done_persons{$rec->{header}}=1;}}my%finantial_info=(opening_amount=>0);
my$initial_file=$machine->dir_server()."/server/data/cashier_open_amount/$date_to/amount.txt";
my$initial_amount=0;
if(!-e$initial_file&&-e$machine->dir_server()."/server/data/cashier_open_amount/amount_hardcoded.txt"){$initial_file=$machine->dir_server()."/server/data/cashier_open_amount/amount_hardcoded.txt";}if(-e$initial_file){open(Z,"< $initial_file");
$initial_amount=<Z>;
chop($initial_amount);
close(Z);
$finantial_info{opening_amount}=$initial_amount;}if(scalar%sales_by_doctype){foreach my $doc_type(keys%{$sales_by_doctype_fininfo{doc_types}}){my@tmp=keys%{$sales_by_doctype_fininfo{doc_types}->{$doc_type}};
my$is_payed=$tmp[0];
my$info=$sales_by_doctype_fininfo{doc_types}->{$doc_type}->{$is_payed};
next if$info->{doc_type}==4;
my$key="";
my$sign=1;
if($doc_type eq$doc_types->{"8"}){$key='receipts';}elsif($doc_type eq$doc_types->{"13"}){$key='sales';}elsif($doc_type eq$doc_types->{"7"}&&!$is_payed){$key='credits';
$sign=1;}elsif(($doc_types_by_name->{$doc_type}==7&&$is_payed)||$doc_types_by_name->{$doc_type}==1||$doc_types_by_name->{$doc_type}==2||$doc_types_by_name->{$doc_type}==90||$doc_types_by_name->{$doc_type}==5){$key='sales';}if($key ne ''){$finantial_info{type}->{$key}->{total}+=$info->{total}*$sign;
if($key ne 'credits'){$finantial_info{balance}+=$info->{total}*$sign;
$finantial_info{balance_wo_vat}+=$info->{total_wo_vat}*$sign;}}}}$finantial_info{balance}+=$finantial_info{opening_amount};
$finantial_info{balance_wo_vat}+=$finantial_info{opening_amount};
print STDERR"QUERY5\n";
$sth=$db->dbh()->prepare(qq{
    SELECT t.*, tp.*
    FROM transfer_products tp
    LEFT JOIN transfers t ON (tp.transfer_id = t.id)
    WHERE t.date >= ? AND t.date <= ?$sql_clerk_query4
    ORDER BY t.id
  });
$sth->execute(@sql_params_two);
print STDERR"QUERY5.1\n";
while(my$rec=$sth->fetchrow_hashref){my$datehour=$rec->{date}." ".$rec->{hour};
my$clerk_name=&my_conv($rec->{clerk_name});
my$prod_name=&my_conv($rec->{product_name});
my$h=$rec->{hour_registered};
my$area_from=$AREAS_INFO{$rec->{area_from}}->[0];
my$area_to=$AREAS_INFO{$rec->{area_to}}->[0];
$transfers{$clerk_name}->{$datehour}->{station}=$rec->{station};
$transfers{$clerk_name}->{$datehour}->{area_from}=$area_from;
$transfers{$clerk_name}->{$datehour}->{area_to}=$area_to;
$transfers{$clerk_name}->{$datehour}->{table_from}=$rec->{table_from};
$transfers{$clerk_name}->{$datehour}->{table_to}=$rec->{table_to};
$transfers{$clerk_name}->{$datehour}->{hours}->{$h}->{product_name}=$rec->{product_name};
$transfers{$clerk_name}->{$datehour}->{hours}->{$h}->{quantity}=$rec->{quantity};}print STDERR"QUERY7\n";
$sth=$db->dbh()->prepare(qq{
      SELECT sd.product_name, sh.business_date, sd.price, sd.price_wo_vat, sd.quantity,
        sd.discount, sd.offer, sd.vat, sd.operation_type, c.login, sd.free_text,
        sh.table_num, sd.hour,
      CASE
        WHEN f.id IS NOT NULL THEN COALESCE(f.name,'----------')
        ELSE COALESCE(sf.name,'----------')
      END as family_name,
      CASE
        WHEN sf.id IS NOT NULL THEN COALESCE(sf.name,'----------')
        ELSE '----------'
      END as subfamily_name
      FROM sales_details sd
      LEFT JOIN sales_headers sh ON (sh.id = sd.header)
      LEFT JOIN products p ON (sd.product = p.id)
      LEFT JOIN (
        SELECT product_id, MAX(group_id) as group_id
        FROM product_groups
        GROUP BY product_id
      ) pg ON (p.id = pg.product_id)
      LEFT JOIN groups sf ON (pg.group_id = sf.id)
      LEFT JOIN groups f ON (sf.parent = f.id)
      LEFT JOIN clerks c ON (sd.clerk = c.id)
      WHERE sd.operation_type IN (2,3,4)
      AND sh.business_date >= ? AND sh.business_date <= ?$sql_clerk_query3
      AND sd.business_date >= ? AND sd.business_date <= ?
    });
$sth->execute(@sql_params_four);
while(my$rec=$sth->fetchrow_hashref){$rec->{price}||=0;
$rec->{discount}||=0;
my$discount_w_vat=$rec->{discount}*(1+$rec->{vat}/100);
my$price=$rec->{price}-$discount_w_vat;
my$line_total=$rec->{quantity}*$price;
my$line_total_wo_vat=($rec->{quantity}*$price)/(1+$rec->{vat}/100);
my$void_type="";
if($rec->{operation_type}==3){$void_type="VOID_WASTE";}elsif($rec->{operation_type}==2){$void_type="VOID";}elsif($rec->{operation_type}==4){$void_type="CORRECTION";}my$prod_name=&my_conv($rec->{product_name});
my$free_text=$rec->{free_text}||"--------§--------§00:00:00";
$free_text=~s/»«/§/g;
my@tmp=split/§/,$free_text;
my$reason=$tmp[0];
my$clerk_registered=$tmp[1];
my$hour_registered=$tmp[2];
if($rec->{operation_type}==3){$reason=exists$waste_reasons{$reason}?$waste_reasons{$reason}:$reason;
$voids_by_reason{logins}->{$rec->{login}}->{$reason}->{total}+=$line_total;
$voids_by_reason{logins}->{$rec->{login}}->{$reason}->{total_wo_vat}+=$line_total_wo_vat;
$voids_by_reason{logins}->{$rec->{login}}->{$reason}->{total_qttys}+=$rec->{quantity};
$voids_by_reason{totals}->{$reason}->{total}+=$line_total;
$voids_by_reason{totals}->{$reason}->{total_wo_vat}+=$line_total_wo_vat;
$voids_by_reason{totals}->{$reason}->{total_qttys}+=$rec->{quantity};}if($rec->{operation_type}==3||$rec->{operation_type}==2){$hour_registered=~s/\:\d\d$//;
$rec->{hour}=~s/\:\d\d$// if defined$rec->{hour};
my$clerk_name=exists$CLERKS_INFO->{$clerk_registered}?$CLERKS_INFO->{$clerk_registered}->{login}:'<UNKNOWN>';
push@{$voids_detailed{$rec->{login}}->{$rec->{business_date}}},{table_num=>$rec->{table_num},product=>$prod_name,quantity=>$rec->{quantity},hour_registered=>$hour_registered,clerk_registered=>$clerk_name,hour_voided=>$rec->{hour},};}$voids{logins}->{$rec->{login}}->{$void_type}->{total}+=$line_total;
$voids{logins}->{$rec->{login}}->{$void_type}->{total_wo_vat}+=$line_total_wo_vat;
$voids{logins}->{$rec->{login}}->{$void_type}->{total_qttys}+=$rec->{quantity};
$voids{logins}->{$rec->{login}}->{$void_type}->{products}->{$prod_name}->{total_qttys}+=$rec->{quantity};
$voids{logins}->{$rec->{login}}->{$void_type}->{products}->{$prod_name}->{total}+=$line_total;
$voids{logins}->{$rec->{login}}->{$void_type}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$voids{totals}->{$void_type}->{total}+=$line_total;
$voids{totals}->{$void_type}->{total_wo_vat}+=$line_total_wo_vat;
$voids{totals}->{$void_type}->{total_qttys}+=$rec->{quantity};}print STDERR"QUERY8\n";
$sth=$db->dbh()->prepare(qq{
      SELECT sd.value, payment_media, sha6.key_value AS invoice_is_payed, sh.doc_type, sh.value AS total_doc,
        sh.station_close
      FROM sales_payments sd
      LEFT JOIN sales_headers sh ON (sh.id = sd.header)
      LEFT JOIN sales_headers_aux sha6 ON (sh.id = sha6.header AND sha6.key_name = 'invoice_is_payed')
      LEFT JOIN sales_headers_aux sha8 ON (sh.id = sha8.header AND sha8.key_name = 'manualdoc_serie')
      WHERE sh.doc_type IN (5, 1, 8, 2, 90, 7) AND sh.business_date >= ? AND sh.business_date <= ?$sql_clerk_query2
      AND sd.business_date >= ? AND sd.business_date <= ? AND sha8.key_value IS NULL
    });
$sth->execute(@sql_params_four);
while(my$rec=$sth->fetchrow_hashref){if($rec->{doc_type}==7&&!defined$rec->{invoice_is_payed}){next;}my$media_name=$rec->{payment_media};
$sales_by_media{medias}->{uc($media_name)}+=$rec->{value};
$sales_by_media{total}+=$rec->{value};
$sales_by_media{total_doc}+=$rec->{total_doc};
$sales_by_media{stations}->{$rec->{station_close}}->{medias}->{uc($media_name)}+=$rec->{value};
$sales_by_media{stations}->{$rec->{station_close}}->{total}+=$rec->{value};
$sales_by_media{stations}->{$rec->{station_close}}->{total_doc}+=$rec->{total_doc};
if($rec->{value}<0){$media_name='REFUNDS';
$sales_by_media{medias}->{uc($media_name)}+=$rec->{value};
$media_name='REFUNDS';
$sales_by_media{stations}->{$rec->{station_close}}->{medias}->{uc($media_name)}+=$rec->{value};}}my$dir_areas=$machine->dir_server()."/server/data/areas";
my%not_closed_checks=();
my$dstart=$business_date;
my$dend=$date_to;
$biz_date=~s/\-//g;
$dstart=~s/\-//g;
$dend=~s/\-//g;
my$do_notclosed_report=0;
if($biz_date>=$dstart and$biz_date<=$dend){$do_notclosed_report=1;}if($do_notclosed_report){print STDERR"QUERY9\n";
find(sub{return unless-d$File::Find::name;
return if$File::Find::name eq$dir_areas;
my$area=$_;
my$area_info=$AREAS_INFO{$area};
my$start_idx=0;
my$end_idx=0;
if(defined$area_info&&scalar@$area_info>=7){$area_info->[1]||=0;
$area_info->[6]||=0;
$start_idx=$area_info->[6]||1;
$end_idx=($start_idx+$area_info->[1])-1;}else{$area_info->[1]||=0;
$start_idx=1;
$end_idx=($start_idx+$area_info->[1])-1;}$start_idx=0 if$end_idx==0;
$not_closed_checks{areas}->{$area}->{checks}=[];
find(sub{my$number=$_;
return unless$number=~/^\d+$/;
return unless$number<90000;
if($start_idx!=0&&$end_idx!=0){if($number<$start_idx||$number>$end_idx){return;}}my$file_check=$dir_areas."/".$area."/".$number;
my$file_check_total=$dir_areas."/".$area."/".$number.".total";
return unless-e$file_check_total;
my$o=App::POS::Check->new(file=>$file_check);
my$data=$o->data();
my$clerk_open=$data->{header}->[3];
my$clerk_name=exists$CLERKS_INFO->{$clerk_open}?$CLERKS_INFO->{$clerk_open}->{login}:'<UNKNOWN>';
$data->{header}->[15]||=0;
$data->{header}->[5]||=0;
if($data->{header}->[15]>0){if(exists$data->{extra_data}->{original_area}){$persons_number{areas}->{$AREAS_INFO{$data->{extra_data}->{original_area}}->[0]}+=$data->{header}->[15];}else{$persons_number{areas}->{$AREAS_INFO{$area}->[0]}+=$data->{header}->[15];}$persons_number{clerks}->{$clerk_name}+=$data->{header}->[15];
$persons_number{total}+=$data->{header}->[15];}my$total=$data->{header}->[19];
my$table_to_card=exists$TABLES_TO_CARDS{$number}?$TABLES_TO_CARDS{$number}:'';
return unless defined$area&&exists$AREAS_INFO{$area};
my@ainfo=@{$AREAS_INFO{$area}};
my$type=scalar@ainfo>=5?$ainfo[4]:'';
$not_closed_checks{areas}->{$area}->{type}=$type;
my$det=$data->{details}||[];
my%cinfo=();
my$global_discount_tmp=$data->{header}->[10];
my$global_discount_percent=0;
my$global_discount=0;
if($global_discount_tmp){if($global_discount_tmp=~/^(\d+)%$/){$global_discount_percent=1;
$global_discount=$1;}else{$global_discount=$global_discount_tmp;}}my$extra_data=$o->extra_data();
foreach my $d(@$det){next unless scalar@$d;
my$clerk_register=$d->[7];
if($cfg->{CLERK_FOR_SALES_DATA}==1||$cfg->{CLERK_FOR_SALES_DATA}==2){$clerk_name=exists$CLERKS_INFO->{$clerk_open}?$CLERKS_INFO->{$clerk_open}->{login}:'<UNKNOWN>';
if(defined$clerk_filter){next unless$clerk==$clerk_open;}}else{$clerk_name=exists$CLERKS_INFO->{$clerk_register}?$CLERKS_INFO->{$clerk_register}->{login}:'<UNKNOWN>';
if(defined$clerk_filter){next unless$clerk==$clerk_register;}}my$pci=$d->[4]||0;
my$q=$d->[3]||0;
my$perciva=$d->[6]||0;
my$psi=$pci/(1+($perciva/100));
my$clerk=$d->[7];
my$product_name=exists$PRODUCTS_INFO->{$d->[1]}?$PRODUCTS_INFO->{$d->[1]}->{name}:'UNKNOWN';
my$prod_name=&my_conv($product_name);
my$desc=0;
if($global_discount>0){if($global_discount_percent){$desc=$psi*($global_discount/100);}else{my$div=$data->{header}->[19]+$global_discount;
my$disc=($global_discount/$div)*100;
$desc=$psi*($disc/100);}}$pci=&my_round((($psi-($desc+$d->[5])))*(1+$perciva/100));
$psi=&my_round((($psi-($desc+$d->[5]))));
if($report_type eq 'resumed'){$station_name=exists$station_names{$data->{header}->[5]}?$station_names{$data->{header}->[5]}:$data->{header}->[5];
if($ainfo[1]==0&&$ainfo[4]){$sales_by_station{stations}->{$station_name}->{total}+=$pci*$q;
$sales_by_station{stations}->{$station_name}->{total_wo_vat}+=$psi*$q;
$sales_by_station{stations}->{$station_name}->{total_qttys}+=$q;
$sales_by_station{total}+=$pci*$q;
$sales_by_station{total_wo_vat}+=$psi*$q;
$sales_by_station{total_qttys}+=$q;
$sales_by_product{products}->{$prod_name}->{total}+=$pci*$q;
$sales_by_product{products}->{$prod_name}->{total_wo_vat}+=$psi*$q;
$sales_by_product{products}->{$prod_name}->{total_qttys}+=$q;
$sales_by_product{total}+=$pci*$q;
$sales_by_product{total_qttys}+=$q;}$station_name=exists$station_names{$d->[12]}?$station_names{$d->[12]}:$d->[12];
if(scalar keys%DELIVERY_AREAS&&exists$selections->{"50_products_to_deliver.txt"}&&exists$DELIVERY_AREAS{$area}){if(exists$extra_data->{delivery_date}&&$extra_data->{delivery_date}){$products_to_deliver{dates}->{$extra_data->{delivery_date}}->{products}->{$prod_name}->{total}+=$pci*$q;
$products_to_deliver{dates}->{$extra_data->{delivery_date}}->{products}->{$prod_name}->{total_wo_vat}+=$psi*$q;
$products_to_deliver{dates}->{$extra_data->{delivery_date}}->{products}->{$prod_name}->{total_qttys}+=$q;
$products_to_deliver{dates}->{$extra_data->{delivery_date}}->{total}+=$pci*$q;
$products_to_deliver{dates}->{$extra_data->{delivery_date}}->{total_wo_vat}+=$psi*$q;
$products_to_deliver{dates}->{$extra_data->{delivery_date}}->{total_qttys}+=$q;
$products_to_deliver{total}+=$pci*$q;
$products_to_deliver{total_qttys}+=$q;}}$sales_by_station_product{stations}->{$station_name}->{products}->{$prod_name}->{total}+=$pci*$q;
$sales_by_station_product{stations}->{$station_name}->{products}->{$prod_name}->{total_wo_vat}+=$psi*$q;
$sales_by_station_product{stations}->{$station_name}->{products}->{$prod_name}->{total_qttys}+=$q;
$sales_by_station_product{stations}->{$station_name}->{total}+=$pci*$q;
$sales_by_station_product{stations}->{$station_name}->{total_qttys}+=$q;
$sales_by_station_product{total}+=$pci*$q;
$sales_by_station_product{total_qttys}+=$q;
$sales_by_clerk_product{clerks}->{$clerk_name}->{products}->{$prod_name}->{total}+=$pci*$q;
$sales_by_clerk_product{clerks}->{$clerk_name}->{products}->{$prod_name}->{total_wo_vat}+=$psi*$q;
$sales_by_clerk_product{clerks}->{$clerk_name}->{products}->{$prod_name}->{total_qttys}+=$q;
$sales_by_clerk_product{clerks}->{$clerk_name}->{total}+=$pci*$q;
$sales_by_clerk_product{clerks}->{$clerk_name}->{total_qttys}+=$q;
$sales_by_clerk_product{total}+=$pci*$q;
$sales_by_clerk_product{total_qttys}+=$q;}$not_closed_checks{areas}->{$area}->{clerks}->{$clerk_name}+=$pci*$q;
$not_closed_checks{areas}->{$area}->{total}+=$pci*$q;
if($ainfo[1]==0&&$ainfo[4]){$not_closed_checks{vats}->{$perciva*1}->{total}+=$pci*$q;
$not_closed_checks{vats}->{$perciva*1}->{total_wo_vat}+=$psi*$q;
$not_closed_checks{vats}->{$perciva*1}->{vat}+=$pci*$q-$psi*$q;}$cinfo{$area}->{$number}+=$pci*$q;
if($report_type eq 'resumed'){if($ainfo[1]>0&&defined$card_sets){my$card_set_info=$card_sets->{by_table}->{$number};
my$line_total=$pci*$q;
my$line_total_wo_vat=$psi*$q;
if(defined$card_set_info){for(@$card_set_info){$sales_by_cardset{"set"}->{sets}->{$_}->{cards}->{$number}->{total}+=$line_total;
$sales_by_cardset{"set"}->{sets}->{$_}->{cards}->{$number}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"set"}->{sets}->{$_}->{cards}->{$number}->{total_qttys}+=$q;
$sales_by_cardset{"set"}->{sets}->{$_}->{name}=$card_sets->{sets}->{$_}->[0];
$sales_by_cardset{"set"}->{sets}->{$_}->{total}+=$line_total;
$sales_by_cardset{"set"}->{sets}->{$_}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"set"}->{sets}->{$_}->{total_qttys}+=$q;
$sales_by_cardset{"set"}->{total}+=$line_total;
$sales_by_cardset{"set"}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"set"}->{total_qttys}+=$q;}}else{$sales_by_cardset{"without_set"}->{total}+=$line_total;
$sales_by_cardset{"without_set"}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"without_set"}->{total_qttys}+=$q;
$sales_by_cardset{"without_set"}->{cards}->{$number}->{total}+=$line_total;
$sales_by_cardset{"without_set"}->{cards}->{$number}->{total_wo_vat}+=$line_total_wo_vat;
$sales_by_cardset{"without_set"}->{cards}->{$number}->{total_qttys}+=$q;}}}}foreach my $area(keys%cinfo){foreach my $number(keys%{$cinfo{$area}}){push@{$not_closed_checks{areas}->{$area}->{checks}},{number=>$number,total=>$cinfo{$area}->{$number},table_to_card=>$table_to_card,};}}my$det_del=$data->{details_deleted}||[];
if(scalar@$det_del){foreach my $rec(@$det_del){next if defined$clerk&&$clerk!=$rec->[7];
$rec->[10]||=0;
$rec->[4]||=0;
$rec->[5]||=0;
$rec->[3]||=1;
$rec->[6]||=0;
my$void_type="";
if($rec->[10]==3){$void_type="VOID_WASTE";}elsif($rec->[10]==2){$void_type="VOID";}elsif($rec->[10]==4){$void_type="CORRECTION";}next unless$void_type;
my$discount_w_vat=$rec->[3]*(1+$rec->[6]/100);
my$price=$rec->[4]-$discount_w_vat;
my$line_total=$rec->[3]*$price;
my$line_total_wo_vat=($rec->[3]*$price)/(1+$rec->[4]/100);
my$product_name=exists$PRODUCTS_INFO->{$rec->[1]}?$PRODUCTS_INFO->{$rec->[1]}->{name}:'UNKNOWN';
my$prod_name=&my_conv($product_name);
my$reason_tmp=$rec->[13]||"§0";
my@tmp_void=split/§/,$reason_tmp;
my$reason=$tmp_void[0];
my$login=exists$CLERKS_INFO->{$rec->[7]}?$CLERKS_INFO->{$rec->[7]}->{login}:'<UNKNOWN>';
if($rec->[10]==3){$reason=exists$waste_reasons{$reason}?$waste_reasons{$reason}:$reason;
$voids_by_reason{logins}->{$login}->{$reason}->{total}+=$line_total;
$voids_by_reason{logins}->{$login}->{$reason}->{total_wo_vat}+=$line_total_wo_vat;
$voids_by_reason{logins}->{$login}->{$reason}->{total_qttys}+=$rec->[3];
$voids_by_reason{totals}->{$reason}->{total}+=$line_total;
$voids_by_reason{totals}->{$reason}->{total_wo_vat}+=$line_total_wo_vat;
$voids_by_reason{totals}->{$reason}->{total_qttys}+=$rec->[3];}if($rec->[10]==3||$rec->[10]==2){my($hour_registered,$hour_voided)=split/\@/,$rec->[2];
my$clerk_registered=$tmp_void[1];
$hour_registered=~s/\:\d\d$//;
$hour_voided=~s/\:\d\d$//;
my$clerk_name=exists$CLERKS_INFO->{$clerk_registered}?$CLERKS_INFO->{$clerk_registered}->{login}:'<UNKNOWN>';
push@{$voids_detailed{$login}->{$data->{header}->[23]}},{table_num=>$number,product=>$prod_name,quantity=>$rec->[3],hour_registered=>$hour_registered,clerk_registered=>$clerk_name,hour_voided=>$hour_voided,}}$voids{logins}->{$login}->{$void_type}->{total}+=$line_total;
$voids{logins}->{$login}->{$void_type}->{total_wo_vat}+=$line_total_wo_vat;
$voids{logins}->{$login}->{$void_type}->{total_qttys}+=$rec->[3];
$voids{logins}->{$login}->{$void_type}->{products}->{$prod_name}->{total_qttys}+=$rec->[3];
$voids{logins}->{$login}->{$void_type}->{products}->{$prod_name}->{total}+=$line_total;
$voids{logins}->{$login}->{$void_type}->{products}->{$prod_name}->{total_wo_vat}+=$line_total_wo_vat;
$voids{totals}->{$void_type}->{total}+=$line_total;
$voids{totals}->{$void_type}->{total_wo_vat}+=$line_total_wo_vat;
$voids{totals}->{$void_type}->{total_qttys}+=$rec->[3];}}},($dir_areas."/".$area));
$not_closed_checks{areas}->{$area}->{checks}||=[];
if(!scalar@{$not_closed_checks{areas}->{$area}->{checks}}){delete$not_closed_checks{areas}->{$area};}else{$not_closed_checks{areas}->{$area}->{name}=$AREAS_INFO{$area}->[0];}},($dir_areas));}$not_closed_checks{areas}||={};
foreach my $area(keys%{$not_closed_checks{areas}}){$not_closed_checks{$area}=$not_closed_checks{areas}->{$area};}if($cfg->{POINTS_USAGE}){my$recs=$db->select(qq{
      SELECT id, name, nif, points
      FROM customers
      WHERE deleted = 0 AND points > 0
      ORDER BY name
    });
for(@$recs){$_->{points_value}=$_->{points}*$cfg->{POINTS_VALUE_PER_POINT_ON_SALE};
$points_by_customer{customers}->{$_->{name}}=$_;
$points_by_customer{total_points}+=$_->{points};
$points_by_customer{total_points_value}+=$_->{points_value};}}$recs=$db->select(qq{
    SELECT sh.id, sh.business_date, sh.value, sh.fo_doc_number,
      sha1.key_value AS manualdoc_serie, sha2.key_value AS manualdoc_total_w_vat,
      sha3.key_value AS manualdoc_total_vat, sha4.key_value AS manualdoc_docnum,
      sha5.key_value AS manualdoc_date, sha6.key_value AS manualdoc_type
    FROM sales_details sd
    LEFT JOIN sales_headers sh ON (sd.header = sh.id)
    LEFT JOIN sales_headers_aux sha1 ON (sh.id = sha1.header AND sha1.key_name = 'manualdoc_serie')
    LEFT JOIN sales_headers_aux sha2 ON (sh.id = sha2.header AND sha2.key_name = 'manualdoc_total_w_vat')
    LEFT JOIN sales_headers_aux sha3 ON (sh.id = sha3.header AND sha3.key_name = 'manualdoc_total_vat')
    LEFT JOIN sales_headers_aux sha4 ON (sh.id = sha4.header AND sha4.key_name = 'manualdoc_docnum')
    LEFT JOIN sales_headers_aux sha5 ON (sh.id = sha5.header AND sha5.key_name = 'manualdoc_date')
    LEFT JOIN sales_headers_aux sha6 ON (sh.id = sha6.header AND sha6.key_name = 'manualdoc_type')
    WHERE sha1.key_value IS NOT NULL AND
      sh.business_date >= ? AND sh.business_date <= ?$sql_clerk_query3
    GROUP BY sh.id, sh.business_date, sha1.key_value, sha2.key_value,
      sha3.key_value, sha4.key_value, sha5.key_value, sha6.key_value,
      sh.value, sh.fo_doc_number
    ORDER BY sh.fo_doc_number
  },@sql_params_two);
for(@$recs){$_->{date}=$_->{business_date};
push@{$manual_docs{$_->{manualdoc_date}}->{dates}},$_;
$manual_docs{$_->{manualdoc_date}}->{total}+=$_->{manualdoc_total_w_vat};
$manual_docs{$_->{manualdoc_date}}->{total_vat}+=$_->{manualdoc_total_vat};}$cfg->{MACHINE_LABEL}||="";
$info{machine_label}=$cfg->{MACHINE_LABEL};
$info{business_date}=&running_business_date($machine);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{station}=$station;
$info{voids}=\%voids;
$info{voids_detailed}=\%voids_detailed;
$info{consumptions}=\%consumptions;
$info{discounts_family}=\%discounts_family;
$info{persons_number}=\%persons_number;
$info{sales_family}=\%sales_family;
$info{sales_vat}=\%sales_vat;
$info{sales_vat_by_date}=\%sales_vat_by_date;
$info{sales_media}=\%sales_by_media;
$info{voids_by_reason}=\%voids_by_reason;
$info{sales_by_doctype}=\%sales_by_doctype;
$info{returns_by_product}=\%returns_by_product;
$info{points_by_customer}=\%points_by_customer;
$info{sales_by_product}=\%sales_by_product;
$info{sales_by_menus}=\%sales_by_menus;
$info{sales_by_product_extra_data}=\%sales_by_product_extra_data;
$info{sales_by_product_no_sons}=\%sales_by_product_no_sons;
$info{sales_by_station}=\%sales_by_station;
$info{sales_by_station_product}=\%sales_by_station_product;
$info{sales_by_clerk_product}=\%sales_by_clerk_product;
$info{sales_by_clerk_area_product}=\%sales_by_clerk_area_product;
$info{sales_by_clerk}=\%sales_by_clerk;
$info{sales_by_serie}=\%sales_by_serie;
$info{sales_by_customer}=\%sales_by_customer;
$info{sales_by_customer_product}=\%sales_by_customer_product;
$info{sales_by_customer_vat}=\%sales_by_customer_vat;
$info{sales_by_pricelevel}=\%sales_by_pricelevel;
$info{sales_by_cardset}=\%sales_by_cardset;
$info{sales_by_cashier}=\%sales_by_cashier;
$info{sales_by_hour}=\%sales_by_hour;
$info{sales_by_parent}=\%sales_by_parent;
$info{sales_by_area}=\%sales_by_area;
$info{sales_by_cost}=\%sales_by_cost;
$info{sales_by_list}=\%sales_by_list;
$info{total_tips}=$total_tips;
$info{total_service_charges}=$total_service_charges;
$info{counters_by_doctype}=\%counters_by_doctype;
$info{not_closed_checks}=\%not_closed_checks;
$info{clocks_by_clerk}=\%clocks_by_clerk;
$info{transfers}=\%transfers;
$info{date_from}=$business_date;
$info{date_to}=$date_to;
$info{finantial_info}=\%finantial_info;
$info{docs_canceled}=\%docs_canceled;
$info{drawer_openings}=\%drawer_openings;
$info{kept_in_source}=\%kept_in_source;
$info{sales_detailed}=\%sales_detailed;
$info{manual_docs}=\%manual_docs;
$info{products_to_deliver}=\%products_to_deliver;
$info{clerks_comissions}={};
foreach my $clerk(keys%$CLERKS_INFO){$info{clerks_comissions}->{$CLERKS_INFO->{$clerk}->{login}}=$CLERKS_INFO->{$clerk}->{commission_group};}$db->do("SET enable_nestloop TO on");
return\%info;}sub print_report_detailed{print_report(@_);}sub print_report_resumed{print_report(@_);}sub print_report_clerk{print_report(@_);}sub print_report_closeday{print_report(@_);}sub print_report{my($machine,$file)=@_;
if($machine->is_station()){return 2;}my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
my$SAFT_CompanyId=$cfg->{SAFT_CompanyId}||"";
my$SAFT_TaxRegistratioNumber=$cfg->{SAFT_TaxRegistratioNumber}||"";
my$SAFT_CompanyName=$cfg->{SAFT_CompanyName}||"";
my$SAFT_BusinessName=$cfg->{SAFT_BusinessName}||"";
my$SAFT_AddressDetail=$cfg->{SAFT_AddressDetail}||"";
my$SAFT_City=$cfg->{SAFT_City}||"";
my$SAFT_PostalCode=$cfg->{SAFT_PostalCode}||"";
my$INTERNET_SEND_EMAILS=$cfg->{INTERNET_SEND_EMAILS}||0;
my$INTERNET_GMAIL_LOGIN=$cfg->{INTERNET_GMAIL_LOGIN}||"";
my$INTERNET_GMAIL_PASSWORD=$cfg->{INTERNET_GMAIL_PASSWORD}||"";
my$INTERNET_SEND_MONTHLY_Z=$cfg->{INTERNET_SEND_MONTHLY_Z}||"";
my$INTERNET_REPORT_FORMAT=$cfg->{INTERNET_REPORT_FORMAT}||"pdf";
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my$business_date=&running_business_date($machine);
my($type,$date,$date_to,$station,$clerk,$to_pdf,$to_screen,$to_xls,$custom,$send_mail)=$file=~/\/report#(.*?)#(.*?)#(.*?)#(\d+)#(\d+)#(\d+)#(\d+)#(\d+)#(.*?)#(\d+)\.txt$/;
my$date_from=$date;
my$tmp1=$date;
my$tmp2=$date_to;
$tmp1=~s/\-//g;
$tmp2=~s/\-//g;
$date=$date_to if$tmp2<$tmp1;
print STDERR"### print_report -> $type -> $file -> $date -> $date_to -> $clerk -> $station -> $custom\n";
my$clerk_filter=$type eq 'user'?1:undef;
my@custom_tags=();
my$sales_details=0;
my%selections=();
if($custom eq 'custom'){push@custom_tags,'01_header.txt';
if(open(F,"< $file")){my$has_footer=0;
while(<F>){chop;
next unless$_;
$has_footer=1 if/_footer/;
push@custom_tags,$_;
$selections{$_}=1;
$sales_details=1 if$_ eq '41_sales_detailed.txt';}if(scalar(@custom_tags)>0&&$has_footer==0){push@custom_tags,'99_footer.txt';}close(F);}}my$selections_file="";
if(!scalar%selections){if($type eq 'detailed'){$selections_file="/opt/pos/common/reports/02_daily_detailed/selections.txt";}elsif($type eq 'resumed'){$selections_file="/opt/pos/common/reports/01_daily_simple/selections.txt";}elsif($type eq 'user'){$selections_file="/opt/pos/common/reports/03_daily_clerk/selections.txt";}}if(-e$selections_file){my@lines=read_file($selections_file);
for(@lines){chop;
$selections{$_}=1;}}my$content="";
my$tmpl="";
my$rep_dir="";
if($type eq 'closeday'){$tmpl="report_dayclose.tmpl";}elsif($type eq 'resumed'){$tmpl="report_daily_simple.tmpl";
$rep_dir="01_daily_simple";}elsif($type eq 'detailed'){$tmpl="report_daily_detailed.tmpl";
$rep_dir="02_daily_detailed";}elsif($type eq 'user'){$tmpl="report_daily_clerk.tmpl";
$rep_dir="03_daily_clerk";}my$info=_data_for_report($machine,$clerk,$station,$date,$date_to,$clerk_filter,$sales_details,\%selections,$type);
unlink($file);
if(scalar@custom_tags&&$rep_dir){my$report_dir=$machine->dir_server()."/common/reports/$rep_dir";
my$report_cnt="";
foreach my $tag(@custom_tags){if(open(F,"< $report_dir/$tag")){my$c=0;
while(<F>){next if$c++ ==0;
$report_cnt.=$_;}close(F);}}my$report=$machine->dir_server().'/common/print_templates/report_custom.tmpl';
$tmpl="report_custom.tmpl";
if(open(F,"> $report")){print F$report_cnt;
close(F);}}my$pt_certified_software=-e$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server"?1:0;
$info->{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($tmpl,$info,\$content,)||die$TEMPLATE->error;
if($to_xls){my$xls_file="/opt/pos/common/data/report_".$type."_".$date_from."_".$date_to.".xls";
&_to_xls($content,$business_date,$date_to,$xls_file);
if(-e$xls_file&&$send_mail&&$INTERNET_SEND_EMAILS&&$INTERNET_GMAIL_LOGIN&&$INTERNET_GMAIL_PASSWORD&&$INTERNET_REPORT_FORMAT eq 'xls'){my$dstr=&strftime("%Y",localtime)."/".&strftime("%m",localtime);
if(!-d"/opt/pos/common/data/emails_to_send/$dstr"){system("mkdir -p /opt/pos/common/data/emails_to_send/$dstr");}&move($xls_file,"/opt/pos/common/data/emails_to_send/$dstr");}}if($to_screen){my$dir_tmp=$machine->server_dir_tmp();
my$cnt_tmp=$content;
$cnt_tmp=~s/\@size_.*?\@//g;
$cnt_tmp=~s/\@paper_cut\@//g;
$cnt_tmp=~s/\@justify_.*?\@//g;
my$server_cfg=$machine->is_server()?$cfg:$machine->server_config->load();
_replace_saft_tags($server_cfg,\$cnt_tmp);
open(F,">> $dir_tmp/printer_screen#$station.txt");
print F$cnt_tmp;
print F"=======================================\n\n\n";
close(F);}if($to_pdf){my$d1=$date_from;
my$d2=$date_to;
$d1=~s/\-//g;
$d2=~s/\-//g;
my$pdf_file="/opt/pos/common/data/report_".$type."_".$d1."_".$d2.".pdf";
my$rrr=int(rand(10000));
my$fff="/tmp/print_$rrr.html";
my$content_tmp=$content;
$content_tmp=encode_entities(decode("utf8",$content_tmp));
$content_tmp=~s/\@size_double\@/<b>/g;
$content_tmp=~s/\@size_normal\@/<\/b>/g;
$content_tmp=~s/\@paper_cut\@//g;
$content_tmp=~s/\@justify_.*?\@//g;
my$server_cfg=$machine->is_server()?$cfg:$machine->server_config->load();
_replace_saft_tags($server_cfg,\$content_tmp);
open(F,"> $fff");
print F"<html><body><pre>$content_tmp</pre></body></html>";
close(F);
_pdf_gen($fff,$pdf_file);
if(-e$pdf_file&&$send_mail&&$INTERNET_SEND_EMAILS&&$INTERNET_GMAIL_LOGIN&&$INTERNET_GMAIL_PASSWORD&&$INTERNET_REPORT_FORMAT eq 'pdf'){my$dstr=&strftime("%Y",localtime)."/".&strftime("%m",localtime);
if(!-d"/opt/pos/common/data/emails_to_send/$dstr"){system("mkdir -p /opt/pos/common/data/emails_to_send/$dstr");}&move($pdf_file,"/opt/pos/common/data/emails_to_send/$dstr");}}return unless$REAL_PRINT;
if($to_screen||$to_pdf||$to_xls){return;}my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub _to_xls{my($cnt,$date_from,$date_to,$file)=@_;
my$start_title=0;
my$start_content=0;
print STDERR"##> _to_xls - $file\n";
$cnt=~s/\@.*?\@//g;
require Spreadsheet::WriteExcel;
my$workbook=Spreadsheet::WriteExcel->new($file)or die"error: $!";
my$worksheet=$workbook->add_worksheet("$date_from - $date_to");
my@lines=split/\n/,$cnt;
my$c=0;
foreach my $line(@lines){my$y=0;
my$arr=&_str2xls($line);
if(!scalar@$arr){$worksheet->write_string($c++,$y,"");}else{for(@$arr){$worksheet->write_string($c,$y++,$_);}$c++;}}}sub _str2xls{my$str=shift;
$str=~s/\n//g;
return[]unless$str;
if($str=~/^\s+\d/){$str=~s/^\s+//;}else{$str=~s/^\s+/---/;}$str=~s/\s+/ /g;
my@final_words=();
my@words=split/ /,$str;
my$str_tmp="";
foreach(@words){s/\(//g;
s/\)//g;
if(/[-]?\d+\.\d+/){if($str_tmp){push@final_words,$str_tmp;
$str_tmp="";}push@final_words,$_;}else{$str_tmp.=$_." ";}}if($str_tmp){push@final_words,$str_tmp;
$str_tmp="";}return\@final_words;}sub print_moneycount{my($machine,$file)=@_;
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
my$config=$machine->config()->load();
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}&get_clerks_information($db);
my($clerk,$station,$is_manual,$data)=$file=~/\/moneycount#(\d+)#(\d+)#(\d+)#(.*?)#/;
print STDERR"### print_moneycount -> $file -> $clerk -> $station -> $is_manual -> $data\n";
my$ccards=$cfg->{CREDIT_CARDS};
my@ccards_tmp=split/,/,$ccards;
my%ccards=map{$_=>1}@ccards_tmp;
my$pmethods=$cfg->{PAYMENT_METHODS}||"";
my@pmethods=split/,/,$pmethods;
my%pmethods=map{$_=>1}@pmethods;
$pmethods{INs}=1;
$pmethods{OUTs}=1;
$pmethods{VOUCHER}=1;
foreach my $ccard(keys%ccards){$pmethods{$ccard}=$ccard;}if(open(F,"< $file")){my%info=(miscs=>[]);
my$content="";
while(<F>){chop;
my@toks=split/#/;
next unless scalar@toks;
if(exists$pmethods{$toks[0]}){if($toks[3]=~/;/){my@toks2=split/;/,$toks[3];
if($toks2[0]*1>0){$info{total_counted}+=$toks2[0]unless$toks[0]eq 'OUTs'||$toks[0]eq 'INs';
$info{totals_pmethod}->{$toks[0]}+=$toks2[0];
push@{$info{pmethods}->{$toks[0]}},{name=>$toks2[1],value=>$toks2[0],custom=>1};}}else{if($toks[3]*1>0){$info{total_counted}+=$toks[3]unless$toks[0]eq 'OUTs'||$toks[0]eq 'INs';
$info{totals_pmethod}->{$toks[0]}+=$toks[3];
my$str=$toks[2]ne '-9999'?$toks[1]." x ".$toks[2]:'==>';
push@{$info{pmethods}->{$toks[0]}},{name=>$str,value=>$toks[3],custom=>0};}}}else{if($toks[0]eq 'CLERK'){my@toks2=split/\-/,$toks[3];
$info{clerk_code}=$toks2[0];
$info{clerk_name}=$CLERKS_INFO->{$toks2[0]}->{login};}elsif($toks[0]eq 'NEXT_DAY'){$info{next_day}=$toks[3];}elsif($toks[0]eq 'POS_SALES'){$info{pos_sales}=$toks[3];}elsif($toks[0]eq 'PREVIOUS_DAY'){$info{previous_day}=$toks[3];}elsif($toks[0]eq 'TOTAL_COUNTED'){$info{total_money}=$toks[3];}elsif($toks[0]eq 'DEPOSIT'){$info{deposit}=$toks[3];}elsif($toks[0]eq 'DAILY_BALANCE'){$info{daily_balance}=$toks[3];}}}my$money_counts=App::POS::Counters->new(db=>$db,name=>'money_counts',);
my$money_counts_last=App::POS::Counters->new(db=>$db,name=>'money_counts_last',);
my$business_date=$data;
my$date_str='NONE';
$info{transit}||=0;
$info{sales_global}||=0;
$info{sales_clerk}||=0;
$info{returns_global}||=0;
$info{returns_clerk}||=0;
$info{is_manual}||=$is_manual;
if(defined$business_date&&$business_date){$date_str=$business_date;}if($info{is_manual}){$date_str='NONE';
$money_counts->increment($date_str);}else{if($money_counts->exists($date_str)){return;}else{$money_counts->increment($date_str);}}$info{clerk_code}=$clerk;
$info{clerk_name}=$CLERKS_INFO->{$clerk}->{login}||'UNKNOWN';
$info{count_number}=$money_counts->cur_value($date_str);
$info{station}=$station;
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$config->{DETAILED_REPORT_AFTER_MONEYCOUNT}||=0;
if($config->{DETAILED_REPORT_AFTER_MONEYCOUNT}){my$max_id="";
if($money_counts_last->exists($business_date)){$max_id=$money_counts_last->cur_value($business_date);}my$dir_tmp=$machine->dir_tmp();
open(F,"> $dir_tmp/report#detailed#$business_date#$station#$clerk#$max_id.txt");
print F"1\n";
close(F);}my$res=$db->select("SELECT max(id) AS max_id FROM sales_headers WHERE business_date = ?",$business_date);
if(scalar@$res&&defined$res->[0]->{max_id}){$money_counts_last->set_value($business_date,$res->[0]->{max_id});}$info{totals_pmethod}->{OUTs}||=0;
$info{total_counted}+=$info{totals_pmethod}->{OUTs};
$info{diff_sales_global}=(($info{total_counted}-$info{transit})-$info{sales_global})+$info{returns_global};
$info{diff_sales_clerk}=($info{total_counted}-$info{sales_clerk})+$info{returns_clerk};
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('money_counter.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(N,"> $print_file");
print N$content;
close(N);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}close(F);}}sub integrate_clerk_in_out{my($machine,$file)=@_;
return 2 unless$machine->is_server();
my($op,$station,$clerk,$desc)=$file=~/clerk_in_out#(.*?)#(\d+)#(\d+)#(.*?)#/;
print STDERR"> clerk_in_out - $file, $op, $station, $clerk, $desc\n";
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
&get_clerks_information($db);
my$clerk_name=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'UNKNOWN';
my$date=&strftime("%Y-%m-%d",localtime);
my$hour=&strftime("%H:%M:%S",localtime);
my$business_date=&date_based_on_closing_hour("$date $hour",$CLOSE_HOUR);
my$id=$db->next_id("time_clock");
$db->do(qq{
    INSERT INTO time_clock VALUES (?, ?, ?, ?, ?, ?, ?, ?)
  },$id,$business_date,$hour,$station,$clerk,$clerk_name,$op,$desc);
my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{justification}=$desc;
$info{operation}=$op;
my$template="clerk_in_out.tmpl";
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub print_notclosed_check{my($machine,$file)=@_;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}my($station,$area,$is_internal,$dont_print,$check,$from_mobile)=$file=~/\/print_notclosed_check#(\d+)#(\d+)#(\d)#(\d)#(.*?)#(\d+)\.txt$/;
my$cfg=$machine->config()->load_fixed();
my$db=$machine->database();
if($station!=$cfg->{STATION_NUMBER}){return 2;}my$pt_certified_software=-e$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server"?1:0;
&get_products_information($db);
&get_clerks_information($db);
$cfg->{STATION_PRINT_CHECKS}=exists$cfg->{STATION_PRINT_CHECKS}?$cfg->{STATION_PRINT_CHECKS}:99;
$cfg->{STATION_PRINT_CHECKS}=99 if$cfg->{STATION_PRINT_CHECKS}==$cfg->{STATION_NUMBER};
$cfg->{CHECK_GROUP_PRODUCTS_TEXT}||="";
$cfg->{MENUS_PRINT_SELECTIONS}||="";
$cfg->{SHOW_ZERO_PRICE_IN_BILL}||=0;
if($pt_certified_software){$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}=1;
$cfg->{SHOW_ZERO_PRICE_IN_BILL}=1;}my$check_file=$machine->dir_areas()."/$area/$check".".toprint";
return unless-f$check_file;
my$o=App::POS::Check->new(file=>$check_file);
my$data=$o->data();
my$ex=$o->extra_data();
$ex->{print_language}||="";
unlink$check_file;
if($ex->{print_language}){&get_products_translations($db);}my$h=$data->{header}||[];
my$details=$data->{details}||[];
my$details_deleted=$data->{details_deleted}||[];
my$footers=$data->{footers}||[];
my$info={};
if(!scalar@$h){print STDERR"CHECK FILE - $check_file\n";
print STDERR"print_notclosed_check> Check without headers, returning...\n";
return;}$cfg->{SHOW_ZERO_PRICE_IN_INVOICE}=1 if$h->[8]==10;
my$discount_percent=$h->[10];
my$clerk_open_name=exists$CLERKS_INFO->{$h->[2]}?$CLERKS_INFO->{$h->[2]}->{login}:'UNKNOWN';
my$clerk_close_name=exists$CLERKS_INFO->{$h->[3]}?$CLERKS_INFO->{$h->[3]}->{login}:'UNKNOWN';
my$clerk_closed=$h->[3];
if(!defined$CLOSE_HOUR){my$close_hour=$cfg->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}my$doc_counters=App::POS::Counters->new(db=>$db,name=>'doc_counters',);
my$doc_hashes=App::POS::Counters->new(db=>$db,name=>'doc_hashes',);
my$request_numbers=App::POS::Counters->new(db=>$db,name=>'request_numbers',);
if(!defined$DOC_TYPE_SERIE){if($machine->is_server()){$DOC_TYPE_SERIE=$cfg->{DOC_TYPE_SERIE};}else{my$server_config=$machine->server_config();
my$server_cfg=$server_config->load_fixed();
$DOC_TYPE_SERIE=$server_cfg->{DOC_TYPE_SERIE};}}if(!scalar keys%$CLERK_SERIES){my$recs=$db->select("SELECT id, serie FROM clerks WHERE deleted = 0");
map{$CLERK_SERIES->{$_->{id}}=$_->{serie}}@$recs;}my$clerk_serie=1;
if(exists$CLERK_SERIES->{$h->[3]}){$clerk_serie=$CLERK_SERIES->{$h->[3]};}my$doc_serie="";
my$doc_serie_config="";
if($cfg->{DOC_TYPE_SERIE}){my$year=&strftime("%y",localtime);
$doc_serie=$cfg->{DOC_TYPE_SERIE};
$doc_serie=~s/\@YEAR\@/$year/g;
$doc_serie_config=$doc_serie;
$doc_serie.=$clerk_serie;}else{$doc_serie=strftime("%y",localtime).$clerk_serie;}my$doc_type_str=$cfg->{DOC_TYPE_TABLE_PRINT};
my$doc_type=6;
if($is_internal){$doc_type_str=$cfg->{DOC_TYPE_TABLE_PRINT_INTERNAL};
$doc_type=9;}my$cur_date=&strftime("%Y-%m-%d",localtime);
my$cur_hour=&strftime("%H:%M:%S",localtime);
my$memc=Cache::Memcached::Fast->new({servers=>[{address=>$machine->server_ip().':11211',weight=>1},],namespace=>'pos_files:',connect_timeout=>0.1,io_timeout=>0.1,close_on_error=>1,compress_threshold=>-1,compress_ratio=>0,max_failures=>3,failure_timeout=>1,nowait=>1,hash_namespace=>1,serialize_methods=>[\&JSON::encode_json,\&JSON::decode_json],});
my$bdate_bill=$memc->get('last_bill_date#'.$doc_type."#".$doc_serie_config);
if($pt_certified_software){my$rr=[];
if(!defined$bdate_bill){$rr=$db->select(qq{
        SELECT MAX(date_closed) AS date_closed
        FROM sales_headers
        WHERE doc_type = ?
      },$doc_type);
if(scalar@$rr){my($date_closed)=$rr->[0]->{date_closed}=~/^(.*?) /;
$memc->set('last_bill_date#'.$doc_type."#".$doc_serie_config,$date_closed);
$rr=[{business_date=>$date_closed}];}}else{push@$rr,{business_date=>$bdate_bill};}if(scalar@$rr&&defined$rr->[0]->{business_date}){if($cur_date ne$rr->[0]->{business_date}){my($year2,$month2,$day2)=$cur_date=~/^(\d+)\-(\d+)\-(\d+)/;
my($year1,$month1,$day1)=$rr->[0]->{business_date}=~/^(\d+)\-(\d+)\-(\d+)/;
my$ress=Delta_Days($year1,$month1,$day1,$year2,$month2,$day2);
if($ress<0){my$str="****************************************\n".&translate($machine,"JÁ EXISTE UMA CONSULTA COM DATA POSTERIOR")."\n"."****************************************\n".&translate($machine,"ÚLTIMA CONSULTA EFETUADA EM").": ".$rr->[0]->{business_date}."\n"."****************************************\n".&translate($machine,"TENTATIVA DE INTEGRAR NA DATA").": ".$cur_date."\n"."****************************************\n".&translate($machine,"VERIFICAR SE O RELÓGIO ESTÁ CORRECTO");
open(F,"> /opt/pos/common/tmp/printer_screen.txt");
print F$str;
close(F);
print STDERR"Check business_date is lower than LAST business date, ignoring...\n";
return undef;}}}}$memc->set('last_bill_date#'.$doc_type."#".$doc_serie_config,$cur_date);
my$business_date=&date_based_on_closing_hour($cur_date." ".$cur_hour,$CLOSE_HOUR);
my$bdate=$business_date;
$bdate=~s/\-//g;
my$external_doc="";
my$fo_doc_number=$doc_type_str;
my$doc_counter_key=$doc_type_str.'#'.$external_doc.'#'.$doc_serie;
my$previous_hash="";
my$dnumber=$doc_counters->cur_value($doc_counter_key);
if(defined$dnumber&&$dnumber){$previous_hash=$doc_hashes->cur_value($doc_counter_key);}else{$doc_counters->set_value($doc_counter_key,1);
$dnumber=1;
$previous_hash="";}my$doc_number=$dnumber;
$fo_doc_number.=" ".$doc_serie."/".$doc_number;
my@hash_chars=();
my$hash="";
if(-e$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server"){my$cdt=&strftime($cur_date."T".$cur_hour,localtime);
my$str_to_sign=$business_date.";".$cdt.";".$fo_doc_number.";".sprintf("%.02f",$h->[19]).";".$previous_hash;
my$socket=IO::Socket::INET->new(PeerAddr=>'127.0.0.1',PeerPort=>8050,Proto=>"tcp",);
if(!defined$socket){print STDERR"!!!! Couldn't connect to SIGN server !!!!\n";
my$sign_app="";
if(-e$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server.src"){$sign_app=$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server.src";}else{$sign_app=$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server";}my$cmd="$sign_app --cli --string=\"$str_to_sign\"";
print STDERR"###> $cmd\n";
$hash=`$sign_app --cli --string=\"$str_to_sign\"`;}else{print$socket "--string=\"".$str_to_sign."\"\n";
$hash=<$socket>;
$socket->close();}chop($hash);
@hash_chars=&_get_sign_chars(signature=>$hash);
$doc_hashes->set_value($doc_counter_key,$hash);}$info->{headers}={meals_txt=>&translate($machine,$cfg->{CHECK_GROUP_PRODUCTS_TEXT}),business_date=>$business_date,cur_date=>$cur_date,cur_hour=>$cur_hour,fo_doc_number=>$fo_doc_number,date=>$h->[0],date_closed=>$h->[1],hour=>$cur_hour,value=>$h->[19],discount=>$h->[9],clerk_open=>$h->[2],clerk_close=>$h->[3],station_open=>$h->[4],station_close=>$h->[5],area=>$h->[7],area_name=>exists$AREAS_INFO{$h->[7]}?$AREAS_INFO{$h->[7]}->[0]:'<UNKNOWN>',area_tables=>exists$AREAS_INFO{$h->[7]}?$AREAS_INFO{$h->[7]}->[1]:0,meals=>$h->[14],clerk_open_name=>$clerk_open_name,clerk_close_name=>$clerk_close_name,customer=>$h->[12],customer_nif=>$h->[13],hash=>$hash,hash_small=>join("",@hash_chars),service_charge=>$h->[17]||0,};
if($info->{headers}->{customer_nif}){my$cust=$db->select(qq{
      SELECT * FROM customers WHERE nif = ? ORDER BY deleted ASC LIMIT 1
    },$info->{headers}->{customer_nif});
if(scalar@$cust){$info->{headers}->{customer_id}=$cust->[0]->{id};
$info->{headers}->{customer_credit}=$cust->[0]->{total_credit};
$info->{headers}->{customer_address}=$cust->[0]->{address};
$info->{headers}->{customer_postal_code}=$cust->[0]->{postal_code};
$info->{headers}->{customer_city}=$cust->[0]->{city};
$info->{headers}->{customer_contact}=$cust->[0]->{contact};}}if(!scalar@$details){print STDERR"CHECK WITH NO DETAILS, ABORTING...\n";
return;}my%t=();
foreach my $d(@{$details}){next unless defined$d->[1];
if(!exists$PRODUCTS_MENUS->{$d->[1]}){if($cfg->{MENUS_PRINT_SELECTIONS}eq '1'){if(!exists$PRODUCTS_MENUS->{$d->[1]}&&$d->[13]ne 'MENU'){if(!$cfg->{SHOW_ZERO_PRICE_IN_BILL}){next unless$d->[4]*1!=0;}}}else{if(!$cfg->{SHOW_ZERO_PRICE_IN_BILL}){next unless$d->[4]*1!=0;}}}$d->[5]||=0;
my$key=$d->[1]."#".$d->[4]."#".$d->[5]."#".$d->[13];
if($PRODUCTS_INFO->{$d->[1]}->{is_weight}){$key=$d->[0];}my$is_menu=exists$PRODUCTS_MENUS->{$d->[1]}?1:0;
if(!$cfg->{MENUS_PRINT_SELECTIONS}){if($d->[13]eq 'MENU'&&$d->[4]==0){next;}}if($is_menu||$d->[13]eq 'MENU'){$key=$d->[0];}if(exists$t{$key}){$t{$key}->[3]+=$d->[3];}else{$t{$key}=$d;}}my@t=values%t;
$details=\@t;
my$mult=1;
my$total_quantities=0;
my$global_discount_percent=0;
my$global_discount=0;
my$total_discounts=0;
my$total_offers=0;
my%vat=();
if($h->[10]){if($h->[10]=~/\%$/){$global_discount_percent=1;
($global_discount)=$h->[10]=~/^(\d+)\%$/;}else{$global_discount=$h->[10];}foreach my $d(@$details){next unless scalar@$d;
next unless defined$d->[3];
my$qtty=$d->[3]*$mult;
my$PIVA=$d->[6];
my$PCI=$d->[4];
my$PSI=$PCI/(1+$PIVA/100);
my$checkLineDiscount=$d->[5];
$PSI||=0;
$checkLineDiscount||=0;
if(($PSI-$checkLineDiscount)>0){$total_quantities+=$qtty;}}}my$use_print_priorities=0;
foreach my $d(@$details){next unless scalar@$d;
next if$d->[3]*1==0;
next if exists$MESSAGES_INFO->{$d->[1]};
next if exists$PRODUCTS_EXTRAS->{$d->[1]}&&$d->[4]==0;
next if$PRODUCTS_INFO->{$d->[1]}->{name}=~/^\-\-\-\-\-\-\-\-\-\-/;
my$product_name;
if($ex->{print_language}&&exists$PRODUCTS_TRANSLATIONS->{$d->[1]}->{$ex->{print_language}}){$product_name=$PRODUCTS_TRANSLATIONS->{$d->[1]}->{$ex->{print_language}};}else{$product_name=exists$PRODUCTS_INFO->{$d->[1]}?$PRODUCTS_INFO->{$d->[1]}->{name}:'UNKNOWN';}$product_name=&my_conv($product_name,26);
my$clerk_name=exists$CLERKS_INFO->{$d->[7]}?$CLERKS_INFO->{$d->[7]}->{login}:'UNKNOWN';
my$qtty=$d->[3];
my$PIVA=$d->[6]||0;
my$PCI=$d->[4];
my$PSI=$PCI/(1+$PIVA/100);
my$VDU=$d->[5];
my$PU=$PSI-$VDU;
my$PL=$PU*$d->[3];
my$VIVA=$PL*($PIVA/100);
my$discount=$d->[5]||0;
my$discount_orig=0;
my$line_discount=0;
my$gdiscount=0;
if($global_discount_percent){$discount+=($PSI-$discount)*($global_discount/100);}elsif($global_discount>0){my$disc=($global_discount/($info->{headers}->{value}+$global_discount))*100;
$discount+=($PSI-$discount)*($disc/100);}$total_discounts+=$discount*$qtty*(1+$PIVA/100);
$use_print_priorities=1 if$PRINTING_PRIORITIES->{$d->[1]};
my$product_type="";
if($d->[13]eq 'MENU'){$product_type='MENU';}elsif($d->[13]eq 'EXTRA'){$product_type='EXTRA';}my$d={is_menu=>exists$PRODUCTS_MENUS->{$d->[1]}?1:0,product_type=>$product_type,printing_priority=>$PRINTING_PRIORITIES->{$d->[1]},product=>$d->[1],hour=>$d->[2],quantity=>$d->[3],price=>$d->[4],price_wo_vat=>$PSI,discount=>$discount,offer=>0,vat=>$d->[6],clerk=>$d->[7],station=>$d->[12],product_name=>$product_name,clerk_name=>$clerk_name,free_text=>$d->[13],order=>$d->[0],gbi=>$d->[-1],};
if(!$cfg->{MENUS_PRINT_SELECTIONS}){if($d->{product_type}eq 'MENU'){if($d->{price}*1>0){push@{$info->{details}},$d;}}else{push@{$info->{details}},$d;}}else{push@{$info->{details}},$d;}}$info->{details}||=undef;
return unless defined$info->{details};
if($use_print_priorities){@{$info->{details}}=reverse sort{$a->{printing_priority}<=>$b->{printing_priority}}@{$info->{details}};}else{@{$info->{details}}=sort{$a->{order}<=>$b->{order}}@{$info->{details}};}my$total_wo_discount=0;
my$products_quantities=0;
my$last_menu="";
my$value_net=0;
foreach my $d(@{$info->{details}}){$last_menu=$d if$d->{is_menu};
$d->{quantity}=$d->{quantity}*$mult;
$d->{vat}||=0;
$d->{txts}=[];
if($d->{free_text}&&$d->{free_text}ne 'EXTRA'){my@t=split/;/,$d->{free_text};
for my $tok(@t){next unless$tok;
$Text::Wrap::columns=38;
my$l=wrap('','',$tok);
my@lines=split/\n/,$l;
for(@lines){push@{$d->{txts}},$_;}}if(scalar@{$d->{txts}}==1&&$d->{txts}->[0]eq 'MENU'){$d->{txts}=[];}}my$sem_iva=&my_round($d->{quantity}*$d->{price_wo_vat});
my$com_iva=$d->{quantity}*$d->{price};
my$desconto_com_iva=0;
my$desconto_sem_iva=0;
if($d->{price}!=0){$d->{price_wo_vat}||=1;
$desconto_com_iva=$d->{quantity}*$d->{price}*($d->{discount}/$d->{price_wo_vat});
$desconto_sem_iva=&my_round($d->{quantity}*$d->{discount});}$com_iva=$com_iva-$desconto_com_iva;
$sem_iva=$sem_iva-$desconto_sem_iva;
$value_net+=($sem_iva-$desconto_sem_iva);
my$valor_iva=$com_iva-$sem_iva;
$d->{line_total}=$d->{price}*$d->{quantity};
$d->{unit_price}=$d->{price};
$d->{quantity}=$d->{quantity};
$d->{line_total_w_discount}=$d->{line_total}-my_round($desconto_com_iva);
$vat{$d->{vat}}->{w_vat}+=$d->{line_total_w_discount};
$vat{$d->{vat}}->{wo_vat}+=$desconto_com_iva>0?my_round($sem_iva):$sem_iva;
$total_wo_discount+=$d->{line_total};
$products_quantities+=$d->{quantity};
if($d->{product_type}eq 'MENU'&&$last_menu){if(!$cfg->{MENUS_PRINT_SELECTIONS}){$last_menu->{unit_price}+=$d->{unit_price};}$last_menu->{line_total_w_discount}+=$d->{unit_price};}}my$total_vat=0;
for(keys%vat){$vat{$_}->{vat_v}=&my_round($vat{$_}->{w_vat})-&my_round($vat{$_}->{wo_vat});
$total_vat+=$vat{$_}->{vat_v};}my$discount_was_percentage=0;
if($discount_percent=~/%/){$discount_was_percentage=1;
$discount_percent=~s/%//g;}$info->{products_number}=scalar@{$info->{details}};
$info->{products_quantities}=$products_quantities;
$info->{total_discounts}=$total_discounts;
$info->{discount_percent}=$discount_percent;
$info->{discount_was_percentage}=$discount_was_percentage;
$info->{total_wo_discount}=$total_wo_discount;
$doc_counters->increment($doc_counter_key);
my%info=(check=>$info);
my$content="";
$cfg->{DONT_RESTART_REQUEST_NUMBERS}||=0;
my$req_key=$cfg->{DONT_RESTART_REQUEST_NUMBERS}?'requests':$business_date;
$info{vat_info}=\%vat;
$info{check_number}=$check;
$info{check_name}=$o->name();
$info{request_number}=$request_numbers->cur_value($req_key);
$info{check_name}||="";
if(!$info{check_name}){$info{table_desc}=$check;}else{if($info{check_name}=~/^\d+$/){$info{table_desc}=$info{check_name};}else{$info{table_desc}=$check." (".$info{check_name}.")";}}$data->{extra_data}->{delivery_info}||="";
if($data->{extra_data}->{delivery_info}){my$dinfo=&_decode_delivery_info($db,$data);
$info{delivery_info}=$dinfo;}if($cfg->{PRINT_BARCODE_IN_BILL}&&$info{check_number}=~/^\d+$/){$BARCODES{$file}="999990".sprintf("%06s",sprintf("%02d",$info->{headers}->{area}).sprintf("%04d",$info{check_number}));}my$tmpl_file="";
if($is_internal){if(-e$machine->dir().'/common/print_templates/'.$cfg->{LANG}."/print_bill_internal.tmpl"){$tmpl_file=$cfg->{LANG}."/print_bill_internal.tmpl";}else{$tmpl_file="print_bill_internal.tmpl";}}else{if(-e$machine->dir().'/common/print_templates/'.$cfg->{LANG}."/print_bill.tmpl"){$tmpl_file=$cfg->{LANG}."/print_bill.tmpl";}else{$tmpl_file="print_bill.tmpl";}}my$print_station=undef;
my$print_printer=undef;
$cfg->{MOBILE_PRINT_BILLS}||="";
if($cfg->{MOBILE_PRINT_BILLS}&&$from_mobile){if(!%MOBILE_PRINT_BILLS){my@by_area=split/\-/,$cfg->{MOBILE_PRINT_BILLS};
foreach my $tok(@by_area){my@toks=split/,/,$tok;
if(scalar@toks==3){$MOBILE_PRINT_BILLS{$toks[0]}->{station}=$toks[1];
$MOBILE_PRINT_BILLS{$toks[0]}->{printer}=$toks[2];}elsif(scalar@toks==2){$MOBILE_PRINT_BILLS{ALL}->{station}=$toks[0];
$MOBILE_PRINT_BILLS{ALL}->{printer}=$toks[1];}}}if(exists$MOBILE_PRINT_BILLS{$info{check}->{headers}->{area_name}}){$print_station=$MOBILE_PRINT_BILLS{$info{check}->{headers}->{area_name}}->{station};
$print_printer=$MOBILE_PRINT_BILLS{$info{check}->{headers}->{area_name}}->{printer};}elsif(exists$MOBILE_PRINT_BILLS{ALL}){$print_station=$MOBILE_PRINT_BILLS{ALL}->{station};
$print_printer=$MOBILE_PRINT_BILLS{ALL}->{printer};}}$cfg->{PRINTER_OVERRIDE_BY_DOCUMENT}||="";
if($cfg->{PRINTER_OVERRIDE_BY_DOCUMENT}&&!defined$print_station&&!defined$print_printer){if(!%DOC_TYPE_PRINTER_OVERRIDES){my@by_doc=split/\-/,$cfg->{PRINTER_OVERRIDE_BY_DOCUMENT};
foreach my $tok(@by_doc){my@toks=split/,/,$tok;
if(scalar@toks==3){$DOC_TYPE_PRINTER_OVERRIDES{$toks[0]}->{station}=$toks[1];
$DOC_TYPE_PRINTER_OVERRIDES{$toks[0]}->{printer}=$toks[2];}else{print STDERR"PRINTER_OVERRIDE_BY_DOCUMENT has an incorrect value... Check docs...\n";}}}if(exists$DOC_TYPE_PRINTER_OVERRIDES{$doc_type}){$from_mobile=1;
$print_station=$DOC_TYPE_PRINTER_OVERRIDES{$doc_type}->{station};
$print_printer=$DOC_TYPE_PRINTER_OVERRIDES{$doc_type}->{printer};}}$info{check}->{extra_data}=$data->{extra_data};
$info{check}->{kept_in_source}||=0;
if(!$dont_print){$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($tmpl_file,\%info,\$content,)||die$TEMPLATE->error;
if($pt_certified_software){if($print_bill_md5_valid){$print_bill_md5_cur=_file_md5("/opt/pos/common/print_templates/print_bill.tmpl")unless defined$print_bill_md5_cur;
if($print_bill_md5_cur ne$print_bill_md5_valid){$content="\n\n"."---------------------------------------\n"."DOCUMENTO DE IMPRESSAO NAO E VALIDO\n"."---------------------------------------\n"."\n\n\@paper_cut\@";}}}if(-e"/opt/pos/.nif"){open(F,"< /opt/pos/.nif");
my$nif=<F>;
chop($nif);
close(F);
if($nif){my@lines=split/\n/,$content;
$lines[2].="\nContribuinte n. $nif";
$content=join("\n",@lines);}}return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,station_close=>$station,);
if(defined$print_file){if($from_mobile&&defined$print_station){$print_printer--;
$print_file=~s/print#\d+#\d+#/print#$print_station#$print_printer#/;}open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}my$r=int(rand(10000));
my$time=time;
$time-=2;
my$new_id=&create_UUID_as_string();
my$dbh=$db->dbh();
$dbh->do("COPY sales_hashes (id, header, gb_identifier_header, business_date, system_entry_date, fo_doc_number, "."value, hash, hash_small, doc_type, value_net, clerk_close, customer_id, serie) FROM stdin");
$info->{headers}->{customer_id}||=0;
$value_net||=0;
my$serie=exists$CLERK_SERIES->{$h->[3]}?$CLERK_SERIES->{$h->[3]}:1;
$value_net=0 if$info->{headers}->{value}*1==0;
$dbh->pg_putline($new_id."\t0\t".$h->[-1]."\t$business_date\t".$cur_date."T".$cur_hour."\t$fo_doc_number\t".$info->{headers}->{value}."\t$hash\t".(join("",@hash_chars))."\t$doc_type\t$value_net\t".$info->{headers}->{clerk_close}."\t".$info->{headers}->{customer_id}."\t$serie\n");
$dbh->pg_endcopy();
if($pt_certified_software){$dbh->do("COPY sales_hashes_products (hash_id, gb_identifier_detail, business_date, product_id, "."price, price_wo_vat, quantity, discount, vat) FROM stdin");
foreach my $d(@{$info->{details}}){$dbh->pg_putline("$new_id\t$d->{gbi}\t$business_date\t$d->{product}\t$d->{price}\t$d->{price_wo_vat}\t"."$d->{quantity}\t$d->{discount}\t$d->{vat}\n");
$memc->set('gbi_had_bill#'.$d->{gbi},1);}$dbh->pg_endcopy();}else{foreach my $d(@{$info->{details}}){$memc->set('gbi_had_bill#'.$d->{gbi},1);}}my$kitchen_monitor_zones=$machine->config()->pzones_with_kitchen_monitor();
if($kitchen_monitor_zones){&kitchen_monitor_set_printed_or_payed($machine,$data->{header}->[-1],"bill");}}sub print_check_hold{my($machine,$file)=@_;
if($machine->is_server()){my($check_file,$station)=$file=~/^(.*?)\.(\d+)\.hold$/;
&_handle_request_prints($machine,$check_file,'hold',$station,$file);}else{return 2;}}sub printer_error{my($machine,$file)=@_;
my$cfg=$machine->config->load();
my($station,$printer,$error_station)=$file=~/printer_error#(\d+)#(\d+)#(\d+)\.txt$/;
print STDERR"printer_error - $file\n";
my$my_station=defined$error_station&&$error_station?$error_station:$station;
my$ignore_file=$machine->server_dir_data()."/printer_ignore#$my_station#$printer.txt";
my$alert_file=$machine->dir_tmp()."/printer_error_alert#$my_station#$printer#$station.txt";
if(!-e$ignore_file){if($cfg->{STATION_NUMBER}==$my_station){print STDERR"This is the alert station, will create alert file - $alert_file\n";
&copy($file,$alert_file);
unlink$file;}else{print STDERR"This isn't the alert station ignoring...\n";
return 2;}}else{print STDERR"Error printer is being ignored, will remove alert file...\n";
unlink($alert_file);}}sub print_file{my($machine,$file)=@_;
my$cfg=$machine->config->load();
my($path,$station,$printer,$finalize,$timestamp)=$file=~/^(.*?)\/print#(\d+)#(\d+)#(\d+)#(.*?)\./;
my$binary=$timestamp=~/binary/?1:0;
my$pt_certified_software=-e$machine->dir()."/common/skins/".$cfg->{LANG}."/sign_server"?1:0;
if($cfg->{STATION_NUMBER}==$station){if($finalize==1){if(exists$cfg->{STATION_PRINT_CHECKS}&&$cfg->{STATION_PRINT_CHECKS}!=99){my$new_file=$path."/print#".$cfg->{STATION_PRINT_CHECKS}."#$printer#$finalize#".time.".txt";
if($file eq$new_file){print STDERR"Redirect to itself, ignoring...\n";}else{my$new_file2=$path."/ttttt#".$cfg->{STATION_PRINT_CHECKS}."#$printer#$finalize#".time.".txt";
&copy($file,$new_file2);
&copy($new_file2,$new_file);
unlink($new_file2);
return;}}}my$dir_server_tmp=$machine->server_dir_tmp();
my$dir_server_data=$machine->server_dir_data();
my$ignore_file="$dir_server_data/printer_ignore#$station#$printer.txt";
if(-e$ignore_file){print STDERR"Won't print file because printer is being ignored...\n";
return;}my@redirects=<$dir_server_data/printer_redirect#$station#$printer#*.txt>;
if(scalar@redirects){foreach my $re(@redirects){my($from_station,$from_printer,$to_station,$to_printer)=$re=~/\/printer_redirect#(\d+)#(\d+)#(\d+)#(\d+)\./;
my$new_file="$dir_server_tmp/print#$to_station#$to_printer#$finalize#$timestamp.txt";
if($file eq$new_file){print STDERR"Redirect to itself, ignoring...\n";}else{my$new_file2="$dir_server_tmp/ttttt#$to_station#$to_printer#$finalize#$timestamp.txt";
&copy($file,$new_file2);
&copy($new_file2,$new_file);
unlink($new_file2);
unlink($file);
return;}}}my$printers=$machine->printers();
my$printer_idx=$printer;
my$error_str="";
my$in_error_printer=-1;
my$in_error_station=-1;
my$error_file="/tmp/printer_error#".$printer_idx.".txt";
if(-e$error_file){my$error_printer_idx=$printer_idx+1;
$in_error_station=$station;
$error_str="!!ERROR > ".$printers->[$printer_idx]->{Description}."!!";
$printers->[$printer_idx]->{BackupPrinter}||="";
if($printers->[$printer_idx]->{BackupPrinter}){my@t=split/\-/,$printers->[$printer_idx]->{BackupPrinter};
if(scalar@t==1&&$t[0]=~/^\d+$/){print STDERR"PRINTER $error_printer_idx IS IN ERROR, WILL SEND TO PRINTER $t[0]\n";
$t[0]-- if$t[0]>0;
$in_error_printer=$t[0];}elsif(scalar@t==2&&$t[0]=~/^\d+$/&&$t[1]=~/^\d+$/){print STDERR"PRINTER $error_printer_idx IS IN ERROR, WILL SEND TO STATION $t[0] PRINTER $t[1]\n";
$in_error_station=$t[0]if$t[0]!=$station;
$t[1]-- if$t[1]>0;
$in_error_printer=$t[1];}else{print STDERR"PRINTER $error_printer_idx IS IN ERROR, INVALID FORMAT FOR BACKUP PRINTER - ".$printers->[$printer_idx]->{BackupPrinter}."\n";}}else{print STDERR"PRINTER $error_printer_idx IS IN ERROR, WILL SEND TO STATION MAIN PRINTER - $STATION_MAIN_PRINTER\n";
$in_error_printer=$STATION_MAIN_PRINTER;}}if($in_error_printer!=-1&&$in_error_station!=-1){$timestamp=time.$$.int(rand(10000));
my$new_file="$dir_server_tmp/print#$in_error_station#$in_error_printer#$finalize#$timestamp.txt";
open(M,"< $file");
my@m=<M>;
close(M);
open(M,"> $file");
print M"$error_str\n";
print M@m;
close(M);
&copy($file,$new_file);
unlink($file);
return;}if(scalar@$printers&&exists$printers->[$printer_idx]){$printers->[$printer_idx]->{Device}||="";
my$cnt2="";
my$size=-s$file;
{if(open(F,"< $file")){local$/=undef;
$cnt2=<F>;
close(F);}}my$server_cfg=$machine->is_server()?$cfg:$machine->server_config->load();
_replace_saft_tags($server_cfg,\$cnt2);
if(uc($printers->[$printer_idx]->{Device})eq '@SCREEN@'){my$dir_tmp=$machine->dir_tmp();
$cnt2=~s/\@.*?\@//g;
if($error_str){$cnt2.="\n$error_str\n";}open(F,">> $dir_tmp/printer_screen.txt");
print F$cnt2;
print F"=======================================\n\n\n";
close(F);
unlink$file;
return;}my$script=$printers->[$printer_idx]->{Script}||'';
my$driver=$printers->[$printer_idx]->{Driver}||'';
my$invert=$printers->[$printer_idx]->{Invert}||0;
my$printer=App::POS::Printer->new(driver=>$driver);
my$p_class=$printer->get_class();
if(exists$printers->[$printer_idx]->{TextEncoding}&&$binary==0){$cnt2=encode($printers->[$printer_idx]->{TextEncoding},decode("utf8",$cnt2));}return unless defined$cnt2;
if(exists$BARCODES{$file}){my$barcode=delete$BARCODES{$file};
my@l=();
my$barcode_method="";
my$barcode_method_small="";
my$barcode_method_big="";
if(length($barcode)==12){$barcode_method='barcode_ean13';
$barcode_method_small='barcode_small_ean13';
$barcode_method_big='barcode_big_ean13';
my$cd=calcEAN13CD($barcode);
$barcode=$barcode.$cd;}elsif(length($barcode)==13){$barcode_method='barcode_ean13';
$barcode_method_small='barcode_small_ean13';
$barcode_method_big='barcode_big_ean13';}else{$barcode_method='barcode_39';
$barcode_method_small='barcode_small_39';
$barcode_method_big='barcode_big_39';}if($cnt2=~/\@barcode\@/mg){@l=$p_class->$barcode_method();
$cnt2=~s/\@barcode\@/\@barcode\@$barcode\n\@justify_left\@/mg;}elsif($cnt2=~/\@barcode_small\@/mg){@l=$p_class->$barcode_method_small();
$cnt2=~s/\@barcode_small\@/\@barcode_small\@$barcode\n\@justify_left\@/mg;}elsif($cnt2=~/\@barcode_big\@/mg){@l=$p_class->$barcode_method_big();
$cnt2=~s/\@barcode_big\@/\@barcode_big\@$barcode\n\@justify_left\@/mg;}my$seq="";
if(scalar@l){for(@l){$_=~s/#BARCODE#/$barcode/g;
$seq.=$_;}}$cnt2=~s/\@barcode\@/$seq/mg;
$cnt2=~s/\@barcode_small\@/$seq/mg;
$cnt2=~s/\@barcode_big\@/$seq/mg;}&_printer_tags_replace($p_class,$printers->[$printer_idx],\$cnt2)if$binary==0;
if($error_str){$cnt2="$error_str\n$cnt2";}if($script&&-e$script){my$tmp_dir=$machine->dir_server()."/server/data/tmp";
my$r=$$."_".int(rand(10000));
my$file="$tmp_dir/$r.txt";
open(F,"> $file");
print F$cnt2;
close(F);
my$check_info_file="none";
if(defined$LAST_INTEGRATED_CHECK){$r=$$."_".int(rand(10000));
$check_info_file="$tmp_dir/$r.txt";
open(F,"> $check_info_file");
print F Dumper($LAST_INTEGRATED_CHECK);
close(F);
$LAST_INTEGRATED_CHECK=undef;}system("\"$script\" \"$file\" \"$check_info_file\"");}eval{local$SIG{ALRM}=sub{die"alarm\n"};
$printers->[$printer_idx]->{Device}||="";
$printers->[$printer_idx]->{IP}||="";
$printers->[$printer_idx]->{CupsQueue}||="";
if($printers->[$printer_idx]->{CupsQueue}){print STDERR"Will print file to CupsQueue > ".$printers->[$printer_idx]->{CupsQueue}."\n";
my$cls=$printer->get_class();
if($invert){my$seq=$cls->print_invert();
$cnt2=$seq.$cnt2;}else{my$seq=$cls->print_normal();
$cnt2=$seq.$cnt2;}my$r=$$."_".int(rand(10000));
my$file="/tmp/$r.txt";
open(F,"> $file");
print F$cnt2;
close(F);
system("lp -d \"".$printers->[$printer_idx]->{CupsQueue}."\" $file");}elsif($printers->[$printer_idx]->{IP}){alarm 15;
print STDERR"Will print file $file to IP ".$printers->[$printer_idx]->{IP}."\n";
my$sock=new IO::Socket::INET(PeerAddr=>$printers->[$printer_idx]->{IP},PeerPort=>'9100',Proto=>'tcp',Timeout=>5,);
die"Could not create socket to ".$printers->[$printer_idx]->{IP}.": $!\n" unless$sock;
my$cls=$printer->get_class();
if($invert){my$seq=$cls->print_invert();
$cnt2=$seq.$cnt2;
print$sock $cnt2;}else{my$seq=$cls->print_normal();
print$sock $seq.$cnt2;}close($sock);}elsif($printers->[$printer_idx]->{Device}){my$cls=$printer->get_class();
if($invert){my$seq=$cls->print_invert();
$cnt2=$seq.$cnt2;}else{my$seq=$cls->print_normal();
$cnt2=$seq.$cnt2;}$printers->[$printer_idx]->{SlowBuffer}||=0;
my$sl=0;
if($printers->[$printer_idx]->{SlowBuffer}){$sl=2;
my@t=split/,/,$printers->[$printer_idx]->{SlowBuffer};
if(scalar@t>1){$sl=$t[1];}else{$sl=$t[0];}}if(($printers->[$printer_idx]->{Device}=~/lp/&&$driver=~/TM300/)||($printers->[$printer_idx]->{SlowBuffer})){alarm 45;
my@l=split/\n/,$cnt2;
my$c=0;
foreach my $l(@l){my$str=$l;
while(my$ss=substr($str,0,10,'')){if(open(Z,"> ".$printers->[$printer_idx]->{Device})){print Z$ss;
close(Z);}else{print STDERR"ERROR WRITING TO: ".$printers->[$printer_idx]->{Device}." - $!\n";}}if(open(Z,"> ".$printers->[$printer_idx]->{Device})){print Z"\n";
close(Z);}else{print STDERR"ERROR WRITING TO: ".$printers->[$printer_idx]->{Device}." - $!\n";}if($c==10){$c=0;
print STDERR"sleep...\n";
sleep$sl;}$c++;}if(open(N,"> ".$printers->[$printer_idx]->{Device})){print N"";
close(N);}else{print STDERR"ERROR WRITING TO: ".$printers->[$printer_idx]->{Device}." - $!\n";}}else{alarm 15;
if($cfg->{USE_TICKET_SCALE}&&$printers->[$printer_idx]->{Device}=~/doc2print/){my$r="/tmp/doc2print.txt.".$$.int(rand(10000));
open(Z,"> $r");
print Z$cnt2;
close(Z);}else{if(open(F,"> ".$printers->[$printer_idx]->{Device})){print F$cnt2;
close(F);}else{print STDERR"ERROR WRITING TO: ".$printers->[$printer_idx]->{Device}." - $!\n";}}}}alarm 0;};
if($@){print STDERR"ERROR ALARM() PRINTING - $@\n";}else{unlink($file);
return;}}}else{return 2;}}sub _register_printers{my($machine,$devices,$init_hardware)=@_;
$init_hardware=1 unless defined$init_hardware;
my$config=$machine->config()->load();
$config->{STATION_NUMBER}||=0;
my$has_main=0;
my$d=$machine->dir_server()."/server/data/registered_printers/".$config->{STATION_NUMBER};
if(!-e$d){system("mkdir -p \"$d\"");}&find(sub{return unless-f$File::Find::name;
unlink$File::Find::name;},($d));
foreach my $device(@$devices){my$num=$device->{num};
my$info=$device->{device};
$info->{Main}||=0;
$info->{Inactive}||=0;
if($info->{Inactive}){next;}$info->{InitSystemCommand}||="";
if($init_hardware&&$info->{InitSystemCommand}){my$device=$info->{Device};
$info->{InitSystemCommand}=~s/\@DEVICE\@/$device/g;
print STDERR"Will execute: ".$info->{InitSystemCommand}."\n";
my$res=system($info->{InitSystemCommand});
print STDERR"Result: $res\n";}$info->{Device}||="";
$info->{IP}||="";
my$ip="";
my$device="";
if($info->{Device}){$device=$info->{Device};}elsif($info->{IP}){$ip=$info->{IP};}else{print STDERR"ERROR!!!! Device or IP needs to be defined for printer $num...\n";}$info->{logo1}||="";
$info->{logo2}||="";
$info->{logo3}||="";
if($info->{logo1}){my$logof="/opt/pos/common/data/".$info->{logo1};
my$o=App::POS::Hardware::PrinterLogo->new(image=>$logof);
my$cnt=$o->image_data();}if($info->{logo2}){my$logof="/opt/pos/common/data/".$info->{logo2};
my$o=App::POS::Hardware::PrinterLogo->new(image=>$logof);
my$cnt=$o->image_data();}if($info->{logo3}){my$logof="/opt/pos/common/data/".$info->{logo3};
my$o=App::POS::Hardware::PrinterLogo->new(image=>$logof);
my$cnt=$o->image_data();}open(F,"> $d/$num");
print F"Printer=$num#Device=".$device."#Description=".$info->{Description}."#IP=$ip\n";
close(F);
if($info->{Main}){$STATION_MAIN_PRINTER=$num;
$has_main=1;
open(F,"> $d/main");
print F"$num\n";
close(F);}}if(!$has_main){print STDERR">>>>>>>>>>>> NO MAIN PRINTER DEFINED!!!!!!!!!!\n";}}sub printers_monitor_group{my($daemon_name,$machine,$devices)=@_;
$machine->config()->__cache("");
$devices=$machine->config()->devices_by_type($daemon_name);
&_printer_files_cleanup($machine,$devices);
my$config=$machine->config()->load();
$config->{STATION_NUMBER}||=0;
my$station=$config->{STATION_NUMBER};
my$register=1;
my$did_register=0;
my$init_hardware=1;
my%serial_devices_monitor=();
my%printers_in_error=();
foreach my $device(@$devices){$device->{device}->{SerialMonitor}||=0;
$device->{device}->{IP}||="";
my$error_file="/tmp/printer_error#".$device->{num}.".txt";
unlink($error_file)if-e$error_file;
if($device->{device}->{SerialMonitor}){my$PortObj=Device::SerialPort->new($device->{device}->{Device});
$serial_devices_monitor{$device->{num}}=$PortObj;}}while(1){if($machine->is_server()){if($register){print STDERR"[SERVER] Will register printers...\n";
&_register_printers($machine,$devices,$init_hardware);
$did_register=1;}$register=0;}else{my$sdir=$machine->dir_server()."/server/data/registered_printers/$station";
if(-e"/tmp/server_error.txt"){$register=1;}else{$register=1 unless-d$sdir;}if($register){print STDERR"[STATION] Will register printers...\n";
$machine->register_on_server();
&_register_printers($machine,$devices,$init_hardware);
$did_register=1;}$register=0;}if($did_register){foreach my $device(@$devices){my$num=$device->{num};
print STDERR"Will register device $num...\n";
my$info=$device->{device};
next if uc($info->{Device})eq '@SCREEN@';
&_handle_printer($machine,$config,$num,$info,$config->{STATION_NUMBER});}$did_register=0;}foreach my $device(@$devices){$device->{device}->{SerialMonitor}||=0;
my$error_file="/tmp/printer_error#".$device->{num}.".txt";
if($device->{device}->{SerialMonitor}){my$PortObj=$serial_devices_monitor{$device->{num}};
my$i=&_linestatus($PortObj);
if($i->{dsr}eq 'OFF'){print STDERR"PRINTER ".$device->{num}.": DISCONNECTED\n";
open(F,"> $error_file");
print F"PRINTER ".$device->{num}.": OFFLINE\n";
close(F);}else{if(!exists$printers_in_error{$device->{num}}){$printers_in_error{$device->{num}}=0;}my($count_in,$string_in)=$PortObj->read(10);
if($count_in==1){if(ord($string_in)==19){$printers_in_error{$device->{num}}=1;
print STDERR"PRINTER ".$device->{num}.": NOT OK\n";}elsif(ord($string_in)==17){$printers_in_error{$device->{num}}=0;
print STDERR"PRINTER ".$device->{num}.": OK\n";}else{print STDERR"PRINTER ".$device->{num}.": Unknown char read from printer...\n";}}if($printers_in_error{$device->{num}}==1){open(F,"> $error_file");
print F"PRINTER ".$device->{num}.": ERROR\n";
close(F);}else{unlink$error_file if-e$error_file;}}}elsif($device->{device}->{IP}){my$p=Net::Ping->new("icmp");
my$st=$p->ping($device->{device}->{IP},2);
if(!$st){open(F,"> $error_file");
print F"PRINTER ".$device->{num}.": NO PING\n";
close(F);}else{unlink$error_file if-e$error_file;}}}sleep 1;}}sub _printer_files_cleanup{my($machine,$devices)=@_;}sub _handle_printer{my($machine,$config,$num,$info,$station_number)=@_;
print STDERR"> _handle_printer - $num\n";
$info->{Inactive}||=0;
if($info->{Inactive}){return;}my$dir_tmp=$machine->dir_tmp();
my$station=$config->{STATION_NUMBER};
my$d_server=$machine->dir_server();
my$dir_server_tmp=$machine->server_dir_tmp();
my$dir_server_data=$machine->server_dir_data();
if(uc($info->{Device})eq '@SCREEN@'){print STDERR"SCREEN printer, returning...\n";
return;}my$ignore_file="$dir_server_data/printer_ignore#$station#$num.txt";
my$d=$d_server."/server/data/registered_printers/".$config->{STATION_NUMBER};
my$error_station=0;
if(exists$info->{StationShowErrors}&&defined$info->{StationShowErrors}&&$info->{StationShowErrors}ne ''){$error_station=$info->{StationShowErrors};}else{$error_station=$config->{STATION_NUMBER};}my$fh=IO::File->new();
my@redirects=<$dir_server_data/printer_redirect#$station#$num#*.txt>;
if(!-e$ignore_file&&!scalar@redirects){my$timeout=5;
my$error=0;
eval{local$SIG{ALRM}=sub{die"alarm\n"};
alarm$timeout;
if(-e$info->{Device}){}else{print STDERR"Device ".$info->{Device}." doesn't exists...\n";
$error=1;}alarm 0;};
if($@||$error){print STDERR"ERROR - $@\n";
print STDERR"Can't CONNECT to printer $num in ".$info->{Device}."\n";
my$f="$dir_server_tmp/printer_error#$station#$num#".$error_station.".txt";
if(open(NN,"> $f")){print NN"Printer=$num#Device=".$info->{Device}."#Description=".$info->{Description}."\n";
close(NN);}}else{print STDERR"printer in station $station with number $num is cool...\n";
my$e_file="$dir_server_tmp/printer_error#$station#$num#".$error_station.".txt";
unlink$e_file if-e$e_file;}}else{print STDERR"STATION: $station_number, PRINTER: $num - is being ignored or redirected, ignoring...\n";}$info->{Device}||="";
$info->{IP}||="";
my$ip="";
my$device="";
if($info->{Device}){$device=$info->{Device};}elsif($info->{IP}){$ip=$info->{IP};}else{print STDERR"ERROR!!!! Device or IP needs to be defined for printer $num...\n";}$info->{CupsQueue}||="";
if($info->{CupsQueue}ne ''){system("/etc/init.d/cups restart");}open(F,"> $d/$num");
print F"Printer=$num#Device=".$device."#Description=".$info->{Description}."#IP=$ip\n";
close(F);
if($info->{Main}){open(F,"> $d/main");
print F"$num\n";
close(F);}undef$fh;}sub _format_string{my($w,$len)=@_;
$w=sprintf("%-".$len."s",decode("utf8",$w));
return encode("utf8",$w);}sub _printer_tags_replace{my($printer,$printer_info,$cnt_ref)=@_;
return unless defined$cnt_ref;
my$value=$printer->document_start();
$$cnt_ref=~s/\@document_start\@/$value/g if defined$value;
$value=$printer->document_end();
$$cnt_ref=~s/\@document_end\@/$value/g if defined$value;
$value=$printer->print_invert();
$$cnt_ref=~s/\@print_invert\@/$value/g if defined$value;
$value=$printer->print_normal();
$$cnt_ref=~s/\@print_normal\@/$value/g if defined$value;
$value=$printer->red();
$$cnt_ref=~s/\@red\@/$value/g if defined$value;
$value=$printer->bold();
$$cnt_ref=~s/\@bold\@/$value/g if defined$value;
$value=$printer->size_small();
$$cnt_ref=~s/\@size_small\@/$value/g if defined$value;
$value=$printer->size_double();
$$cnt_ref=~s/\@size_double\@/$value/g if defined$value;
$value=$printer->size_normal();
$$cnt_ref=~s/\@size_normal\@/$value/g if defined$value;
$value=$printer->size_huge();
$$cnt_ref=~s/\@size_huge\@/$value/g if defined$value;
$value=$printer->underlined();
$$cnt_ref=~s/\@underlined\@/$value/g if defined$value;
$value=$printer->underlined_off();
$$cnt_ref=~s/\@underlined_off\@/$value/g if defined$value;
$value=$printer->line_change();
$$cnt_ref=~s/\@line_change\@/$value/g if defined$value;
$value=$printer->cashdrawer1_open();
$$cnt_ref=~s/\@cashdrawer1_open\@/$value/g if defined$value;
$value=$printer->cashdrawer2_open();
$$cnt_ref=~s/\@cashdrawer2_open\@/$value/g if defined$value;
$value=$printer->line_spacing_normal();
$$cnt_ref=~s/\@line_spacing_normal\@/$value/g if defined$value;
$value=$printer->line_spacing_big();
$$cnt_ref=~s/\@line_spacing_big\@/$value/g if defined$value;
$value=$printer->paper_cut();
$$cnt_ref=~s/\@paper_cut\@/$value/g if defined$value;
$value=$printer->bell();
$$cnt_ref=~s/\@bell\@/$value/g if defined$value;
$value=$printer->black();
$$cnt_ref=~s/\@black\@/$value/g if defined$value;
$value=$printer->justify_center();
$$cnt_ref=~s/\@justify_center\@/$value/g if defined$value;
$value=$printer->justify_left();
$$cnt_ref=~s/\@justify_left\@/$value/g if defined$value;
$value=$printer->justify_right();
$$cnt_ref=~s/\@justify_right\@/$value/g if defined$value;
$value=$printer->logo();
$$cnt_ref=~s/\@logo\@/$value/g if defined$value;
if($$cnt_ref=~/\@logo1\@/){my$logo=$printer_info->{logo1}||"";
if($logo){my$logof="/opt/pos/common/data/".$logo;
if(-e"/opt/pos/common/data/".$logo){my$o=App::POS::Hardware::PrinterLogo->new(image=>$logof);
my$cnt=$o->image_data();
$cnt.=chr(0x1B).chr(0x32);
$$cnt_ref=~s/\@logo1\@/$cnt/g;}}else{$$cnt_ref=~s/\@logo1\@//g;}}if($$cnt_ref=~/\@logo2\@/){my$logo=$printer_info->{logo2}||"";
if($logo){my$logof="/opt/pos/common/data/".$logo;
if(-e"/opt/pos/common/data/".$logo){my$o=App::POS::Hardware::PrinterLogo->new(image=>$logof);
my$cnt=$o->image_data();
$cnt.=chr(0x1B).chr(0x32);
$$cnt_ref=~s/\@logo2\@/$cnt/g;}}else{$$cnt_ref=~s/\@logo2\@//g;}}if($$cnt_ref=~/\@logo3\@/){my$logo=$printer_info->{logo3}||"";
if($logo){my$logof="/opt/pos/common/data/".$logo;
if(-e"/opt/pos/common/data/".$logo){my$o=App::POS::Hardware::PrinterLogo->new(image=>$logof);
my$cnt=$o->image_data();
$cnt.=chr(0x1B).chr(0x32);
$$cnt_ref=~s/\@logo3\@/$cnt/g;}}else{$$cnt_ref=~s/\@logo3\@//g;}}$printer->tweak_content($cnt_ref);}sub _handle_request_prints{my($machine,$check_file,$mode,$hold_station,$hold_file)=@_;
my$hold_check_file=$hold_file.".check";
my$db=$machine->database();
my$cfg=$machine->config()->load();
$cfg->{STATION_PRINT_CHECKS}=exists$cfg->{STATION_PRINT_CHECKS}?$cfg->{STATION_PRINT_CHECKS}:99;
$cfg->{STATION_PRINT_CHECKS}=99 if$cfg->{STATION_PRINT_CHECKS}==$cfg->{STATION_NUMBER};
$cfg->{CHECK_GROUP_PRODUCTS_TEXT}||="";
$cfg->{PRINT_REQUESTS}||=0;
$cfg->{PRINT_VOIDS}||=0;
my$printers=$machine->printers();
my$fsize=-s$hold_file;
my%idx_to_hold=();
my$len=-s$hold_file;
if(defined$len&&$len>2){local$/=undef;
open(F,"< $hold_file");
my$cnt=<F>;
chop($cnt);
close(F);
if($cnt=~/^IDX=/){$cnt=~s/^IDX=//;
my@t=split/;/,$cnt;
map{$idx_to_hold{$_}=1}@t;}}if(!defined$PRINTING_ZONES_CONFIG){$PRINTING_ZONES_CONFIG=$machine->printing_zones_quick();}if(!defined$PRINTING_ZONES_FILTERS){$PRINTING_ZONES_FILTERS=$machine->printing_zones_filters();}&get_clerks_information($db);
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}if(!defined$CLOSE_HOUR){my$close_hour=$cfg->{END_BUSINESS_HOUR}||"05:00";
$CLOSE_HOUR=$close_hour;
my@tmp=split/:/,$close_hour;
$CLOSE_HOUR.=":00" if scalar@tmp==2;}&get_products_information($db);
if(!defined$MESSAGES_INFO){my$q=qq{
      SELECT id, name FROM products WHERE is_message = 1 AND deleted = 0
    };
my$tmp=$db->select($q);
map{$MESSAGES_INFO->{$_->{id}}=$_}@$tmp;}my$check_o=App::POS::Check->new(file=>$hold_check_file);
my$check=$check_o->data();
$check->{header}=[]unless defined$check->{header};
$check->{details}=[]unless defined$check->{details};
unlink$hold_check_file;
if(!scalar@{$check->{header}}){print STDERR"_handle_request_prints> Check without headers, returning...\n";
return;}if(defined$check_o->table_number()&&$check_o->table_number()>90000){print STDERR"Check is above 90000 (created from other checks), won't print requests for it...\n";
return;}my$total_quantities=0;
map{$total_quantities+=$_->[3]}@{$check->{details}};
my$ex=$check_o->extra_data();
my$check_business_date=&date_based_on_closing_hour($check->{header}->[0],$CLOSE_HOUR);
my$cur_business_date=&date_based_on_closing_hour(&strftime("%Y-%m-%d %H:%M:%S",localtime),$CLOSE_HOUR);
$check->{header}->[8]||=0;
my$customer_name=$check->{header}->[12]||"";
my$customer_nif=$check->{header}->[13]||"";
if($check->{header}->[8]==99){print STDERR"!!!!!!!!!!!!!!!!!!!! EXTERNAL DOC, RETURNING !!!!!!!!!!!!!!!!!!!!\n";
return;}my$check_number=$check_o->{table_number};
my$area=$check_o->{area};
my$area_split_idx=undef;
$cfg->{AREA}||=[];
$cfg->{GROUP_REQUESTS_BY_PRINTER}||=0;
$cfg->{SORT_REQUESTS_BY_PRINT_PRIORITY}||=0;
$cfg->{DONT_GROUP_WITH_DECIMALS}||=0;
$cfg->{GROUPING_REQUESTED_PRODUCTS}||=0;
$cfg->{DAILY_SPECIALS_CONTROL_QUANTITIES}||=0;
$cfg->{DONT_RESTART_REQUEST_NUMBERS}||=0;
$cfg->{GROUP_BY_PRODUCT_UTIL_NAME}||=0;
$cfg->{UTIL1_PRODUCT_NAME}||="";
$cfg->{UTIL2_PRODUCT_NAME}||="";
$cfg->{UTIL3_PRODUCT_NAME}||="";
for(my$i=0;$i<scalar@{$cfg->{AREA}};$i++){my@f=split/,/,$cfg->{AREA}->[$i];
if(scalar@f>4&&lc($f[4])eq 'splits'){$area_split_idx=$i;
last;}}my$is_new_check=0;
my%voids_printed=();
my%to_print_request;
my%to_print_void;
my$info={};
my$products_requested=App::POS::Counters->new(db=>$db,name=>'products_requested',);
my$products_requested_req_number=App::POS::Counters->new(db=>$db,name=>'products_requested_req_number',);
my$products_voided=App::POS::Counters->new(db=>$db,name=>'products_voided',);
my$products_voided_qttys=App::POS::Counters->new(db=>$db,name=>'products_voided_qttys',);
my$request_numbers=App::POS::Counters->new(db=>$db,name=>'request_numbers',);
my$request_numbers_checks=App::POS::Counters->new(db=>$db,name=>'request_numbers_checks',);
my$doc_type=$check->{header}->[8];
if($mode eq 'finalize'&&($doc_type==2||$doc_type==13||$doc_type==14||$doc_type==15||$doc_type==33)){print STDERR"WON'T PRINT REQUESTS BECAUSE WE'RE FINALIZING A VOID\n";
return;}my$doc_types=$machine->config()->doc_types_by_id();
my$doc_types_by_name=$machine->config()->doc_types_by_name();
$doc_type=$doc_types->{$doc_type};
my$check_unique_id=$check->{header}->[-1];
my$group_products=1;
my%qttys_requested=();
my%qttys_voided=();
my%util_grouping_by_prod=();
my$util_grouping_key="0_none";
my$util_grouping_idx=0;
if($doc_type eq$cfg->{DOC_TYPE_VOID}){my$last_valid_zone="";
my$last_product_zone="";
for(@{$check->{details}}){next unless scalar@$_;
my$bd_key=$_->[-1];
my$i=$PRODUCTS_INFO->{$_->[1]};
my$printing_zone=$i->{printing_zone};
if(defined$printing_zone&&$printing_zone&&$printing_zone ne '-----'){$last_product_zone=$printing_zone;}next unless$products_requested->exists($bd_key);
my$vrequested=$products_requested->cur_value($bd_key);
my$del_key=$bd_key."#".$_->[0];
next if$products_voided_qttys->exists($del_key);
next unless$vrequested>0;
$products_voided->set_value($bd_key,$_->[3]);
$products_voided_qttys->set_value($del_key,1);
if($vrequested-$_->[3]<0){$_->[3]=$vrequested;
$products_requested->set_value($bd_key,0);}else{$vrequested-=$_->[3];
$products_requested->set_value($bd_key,$vrequested);}if($cfg->{DONT_GROUP_WITH_DECIMALS}){$_->[3]=$_->[3]*1;
if($_->[3]!~/^\d+$/){$group_products=0;}}$qttys_voided{$_->[1]}+=$_->[3];
if(exists$PRODUCTS_EXTRAS->{$_->[1]}){$group_products=0;
if($printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}}if(defined$CAN_DELIVER_PRODUCT_ID&&$_->[1]==$CAN_DELIVER_PRODUCT_ID){if(defined$printing_zone&&$printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}if($printing_zone eq '0'){$printing_zone=$last_product_zone;}}my$name_prefix="";
if($_->[13]eq 'MENU'){$group_products=0;
$name_prefix=" ";}if(!$_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$last_valid_zone="";}next unless$printing_zone&&exists$PRINTING_ZONES_CONFIG->{$printing_zone};
my@notes=();
if($_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$group_products=0;
@notes=split/;/,$_->[13];}if($_->[13]ne 'EXTRA'){$last_valid_zone=$printing_zone;}my$pname=$name_prefix.&shrink_words($PRODUCTS_INFO->{$_->[1]}->{name},$cfg);
my($hour_registered,$hour_voided)=split/\@/,$_->[2];
$hour_registered=~s/\:\d\d$//;
$hour_voided=~s/\:\d\d$//;
push@{$to_print_void{$printing_zone}},{order=>$_->[0],handy_plu=>$PRODUCTS_INFO->{$_->[1]}->{handy_plu}||'',product_code=>$_->[1],product_name=>$pname,quantity=>$_->[3]*1,hour=>$_->[2],hour_registered=>$hour_registered,hour_voided=>$hour_voided,price=>$_->[4],vat=>$_->[6],clerk_code=>$_->[7],clerk_name=>$CLERKS_INFO->{$_->[7]}->{login}||'UNKNOWN',station=>$_->[12],area=>$area,is_extra=>exists$PRODUCTS_EXTRAS->{$_->[1]}?1:0,is_menu=>$_->[13]eq 'MENU'?1:0,is_weight=>$PRODUCTS_INFO->{$_->[1]}->{is_weight},is_message=>exists$MESSAGES_INFO->{$_->[1]}?1:0,foreign=>0,key=>$bd_key,};}for(@{$check->{details_deleted}}){next unless scalar@$_;
my$bd_key=$_->[-1];
my$i=$PRODUCTS_INFO->{$_->[1]};
my$printing_zone=$i->{printing_zone};
if(defined$printing_zone&&$printing_zone&&$printing_zone ne '-----'){$last_product_zone=$printing_zone;}next unless$products_requested->exists($bd_key);
my$vrequested=$products_requested->cur_value($bd_key);
my$del_key=$bd_key."#".$_->[0];
next if$products_voided_qttys->exists($del_key);
next unless$vrequested>=0;
$products_voided->set_value($bd_key,$_->[3]);
$products_voided_qttys->set_value($del_key,1);
if($vrequested-$_->[3]<0){$_->[3]=$vrequested;
$products_requested->set_value($bd_key,0);}else{my$num=$vrequested-$_->[3];
$products_requested->set_value($bd_key,$num);}$qttys_voided{$_->[1]}+=$_->[3];
if($PRODUCTS_EXTRAS->{$_->[1]}){$group_products=0;
if($printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}}if(defined$CAN_DELIVER_PRODUCT_ID&&$_->[1]==$CAN_DELIVER_PRODUCT_ID){if(defined$printing_zone&&$printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}if($printing_zone eq '0'){$printing_zone=$last_product_zone;}}my$name_prefix="";
if($_->[13]eq 'MENU'){$group_products=0;
$name_prefix=" ";}if(!$_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$last_valid_zone="";}next unless$printing_zone&&exists$PRINTING_ZONES_CONFIG->{$printing_zone};
my@notes=();
if($_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$group_products=0;
@notes=split/;/,$_->[13];}if($_->[13]ne 'EXTRA'){$last_valid_zone=$printing_zone;}my$pname=$name_prefix.&shrink_words($PRODUCTS_INFO->{$_->[1]}->{name},$cfg);
my($hour_registered,$hour_voided)=split/\@/,$_->[2];
$hour_registered=~s/\:\d\d$//;
$hour_voided=~s/\:\d\d$//;
push@{$to_print_void{$printing_zone}},{order=>$_->[0],handy_plu=>$PRODUCTS_INFO->{$_->[1]}->{handy_plu}||'',product_code=>$_->[1],product_name=>$pname,quantity=>$_->[3]*1,hour=>$_->[2],hour_registered=>$hour_registered,hour_voided=>$hour_voided,price=>$_->[4],vat=>$_->[6],clerk_code=>$_->[7],clerk_name=>$CLERKS_INFO->{$_->[7]}->{login}||'UNKNOWN',station=>$_->[12],area=>$area,is_weight=>$PRODUCTS_INFO->{$_->[1]}->{is_weight},is_extra=>exists$PRODUCTS_EXTRAS->{$_->[1]}?1:0,is_menu=>$_->[13]eq 'MENU'?1:0,is_message=>exists$MESSAGES_INFO->{$_->[1]}?1:0,foreign=>0,key=>$bd_key,};}}else{my$idx2=0;
my$idx=0;
my$last_valid_zone="";
my$last_product_zone="";
for(@{$check->{details}}){next unless scalar@$_;
if(scalar keys%idx_to_hold&&!exists($idx_to_hold{$idx2})){$idx2++;
next;}$idx2++;
my$bd_key=$_->[-1];
my$i=$PRODUCTS_INFO->{$_->[1]};
my$printing_zone=$i->{printing_zone};
if(defined$printing_zone&&$printing_zone&&$printing_zone ne '-----'){$last_product_zone=$printing_zone;}if($products_requested->exists($bd_key)){next;}if($area_split_idx==$check_o->area()){print STDERR"request being made in the 'splits' area, ignoring...\n";
next;}if($cfg->{GROUP_BY_PRODUCT_UTIL_NAME}){my$name=$i->{name};
if($name eq$cfg->{UTIL1_PRODUCT_NAME}){$util_grouping_key=$name;}elsif($name eq$cfg->{UTIL2_PRODUCT_NAME}){$util_grouping_key=$name;}elsif($name eq$cfg->{UTIL3_PRODUCT_NAME}){$util_grouping_key=$name;}}$products_requested->set_value($bd_key,$_->[3]);
$qttys_requested{$_->[1]}+=$_->[3];
if($cfg->{DONT_GROUP_WITH_DECIMALS}){$_->[3]=$_->[3]*1;
if($_->[3]!~/^\d+$/){$group_products=0;}}if(exists$PRODUCTS_EXTRAS->{$_->[1]}){$group_products=0;
if($printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}}if(defined$CAN_DELIVER_PRODUCT_ID&&$_->[1]==$CAN_DELIVER_PRODUCT_ID){if(defined$printing_zone&&$printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}if($printing_zone eq '0'){$printing_zone=$last_product_zone;}}my$name_prefix="";
if($_->[13]eq 'MENU'){$group_products=0;
$name_prefix=" ";}if(!$_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$last_valid_zone="";}next unless$printing_zone&&exists$PRINTING_ZONES_CONFIG->{$printing_zone};
my@notes=();
if($_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$group_products=0;
@notes=split/;/,$_->[13];}if($_->[13]ne 'EXTRA'){$last_valid_zone=$printing_zone;}my$pname=$name_prefix.&shrink_words($PRODUCTS_INFO->{$_->[1]}->{name},$cfg);
push@{$to_print_request{$printing_zone}},{order=>$_->[0],handy_plu=>$PRODUCTS_INFO->{$_->[1]}->{handy_plu}||'',product_code=>$_->[1],product_name=>$pname,quantity=>$_->[3]*1,hour=>$_->[2],price=>$_->[4],vat=>$_->[6],clerk_code=>$_->[7],clerk_name=>$CLERKS_INFO->{$_->[7]}->{login}||'UNKNOWN',station=>$_->[12],area=>$area,is_extra=>exists$PRODUCTS_EXTRAS->{$_->[1]}?1:0,is_menu=>$_->[13]eq 'MENU'?1:0,is_weight=>$PRODUCTS_INFO->{$_->[1]}->{is_weight},is_message=>exists$MESSAGES_INFO->{$_->[1]}?1:0,notes=>\@notes,foreign=>0,key=>$bd_key,};
if($cfg->{GROUP_BY_PRODUCT_UTIL_NAME}){$util_grouping_by_prod{$bd_key}=$util_grouping_key;}$idx++;}for(@{$check->{details_deleted}}){next unless scalar@$_;
my$bd_key=$_->[-1];
my$i=$PRODUCTS_INFO->{$_->[1]};
my$printing_zone=$i->{printing_zone};
if(defined$printing_zone&&$printing_zone&&$printing_zone ne '-----'){$last_product_zone=$printing_zone;}next unless$products_requested->exists($bd_key);
my$vrequested=$products_requested->cur_value($bd_key);
my$del_key=$bd_key."#".$_->[0];
next if$products_voided_qttys->exists($del_key);
next unless$vrequested>0;
$products_voided->set_value($bd_key,$_->[3]);
$products_voided_qttys->set_value($del_key,1);
if($vrequested-$_->[3]<0){$_->[3]=$vrequested;
$products_requested->set_value($bd_key,0);}else{my$num=$vrequested-$_->[3];
$products_requested->set_value($bd_key,$num);}$qttys_voided{$_->[1]}+=$_->[3];
if(exists$PRODUCTS_EXTRAS->{$_->[1]}){$group_products=0;
if($printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}}if(defined$CAN_DELIVER_PRODUCT_ID&&$_->[1]==$CAN_DELIVER_PRODUCT_ID){if(defined$printing_zone&&$printing_zone eq '-----'||!$printing_zone){$printing_zone=0;}if($last_valid_zone&&!$printing_zone){$printing_zone=$last_valid_zone;}if($printing_zone eq '0'){$printing_zone=$last_product_zone;}}my$name_prefix="";
if($_->[13]eq 'MENU'){$group_products=0;
$name_prefix=" ";}if(!$_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$last_valid_zone="";}next unless$printing_zone&&exists$PRINTING_ZONES_CONFIG->{$printing_zone};
my@notes=();
if($_->[13]&&$_->[13]ne 'EXTRA'&&$_->[13]ne 'MENU'){$group_products=0;
@notes=split/;/,$_->[13];}if($_->[13]ne 'EXTRA'){$last_valid_zone=$printing_zone;}my$pname=$name_prefix.&shrink_words($PRODUCTS_INFO->{$_->[1]}->{name},$cfg);
my($hour_registered,$hour_voided)=split/\@/,$_->[2];
$hour_registered=~s/\:\d\d$//;
$hour_voided=~s/\:\d\d$//;
push@{$to_print_void{$printing_zone}},{order=>$_->[0],handy_plu=>$PRODUCTS_INFO->{$_->[1]}->{handy_plu}||'',product_code=>$_->[1],product_name=>$pname,quantity=>$_->[3]*1,hour=>$_->[2],hour_registered=>$hour_registered,hour_voided=>$hour_voided,price=>$_->[4],vat=>$_->[6],clerk_code=>$_->[7],clerk_name=>$CLERKS_INFO->{$_->[7]}->{login}||'UNKNOWN',station=>$_->[12],area=>$area,is_weight=>$PRODUCTS_INFO->{$_->[1]}->{is_weight},is_extra=>exists$PRODUCTS_EXTRAS->{$_->[1]}?1:0,is_menu=>$_->[13]eq 'MENU'?1:0,is_message=>exists$MESSAGES_INFO->{$_->[1]}?1:0,foreign=>0,key=>$bd_key,};}}if($cfg->{DAILY_SPECIALS_CONTROL_QUANTITIES}){my$daily_specials_avbl_qtys=$machine->hash_from_hdd("/opt/pos/server/data/database/daily_specials_avbl_qtys.ui");
my$daily_specials=$machine->daily_specials();
foreach my $prod_id(keys%qttys_requested){if(exists$daily_specials->{$prod_id}){$daily_specials->{$prod_id}->{max_qtty}||=0;
if($daily_specials->{$prod_id}->{max_qtty}>0){$daily_specials_avbl_qtys->{$prod_id}-=$qttys_requested{$prod_id};}}}foreach my $prod_id(keys%qttys_voided){if(exists$daily_specials->{$prod_id}){$daily_specials->{$prod_id}->{max_qtty}||=0;
if($daily_specials->{$prod_id}->{max_qtty}>0){$daily_specials_avbl_qtys->{$prod_id}+=$qttys_voided{$prod_id};}}}$machine->hash_to_hdd("/opt/pos/server/data/database/daily_specials_avbl_qtys.ui",$daily_specials_avbl_qtys);}$cfg->{PRINTING_ZONE_LINK}||=[];
my$link_info={};
foreach my $l(@{$cfg->{PRINTING_ZONE_LINK}}){my@t=split/,/,$l;
if(scalar@t==2){$link_info->{$t[0]}->{$t[1]}=1;}}if(scalar keys%to_print_request&&scalar keys%$link_info){foreach my $k(keys%$link_info){my@keys=keys%{$link_info->{$k}};
foreach my $kk(@keys){&_slurp_printing_zone(\%to_print_request,$kk,$k);}}}if(scalar keys%to_print_void&&scalar keys%$link_info){foreach my $k(keys%$link_info){my($tmp1,$tmp2)=each%{$link_info->{$k}};
&_slurp_printing_zone(\%to_print_void,$tmp1,$k);}}my$kitchen_monitor_zones=$machine->config()->pzones_with_kitchen_monitor();
my$zones_by_name=$machine->config->printing_zones_by_name();
my$last_print_priority=0;
if($cfg->{PRINT_REQUESTS}&&defined$check_number){my$check_number_map=exists$TABLES_TO_CARDS{$check_number}?$TABLES_TO_CARDS{$check_number}:$check_number;
my$req_key=$cfg->{DONT_RESTART_REQUEST_NUMBERS}?'requests':$check_o->business_date();
if(!$request_numbers->exists($req_key)){$request_numbers->set_value($req_key,1);}else{$request_numbers->increment($req_key);}my@prod_final=();
my$my_area=$area;
if(exists$check->{extra_data}->{original_area}){$my_area=$check->{extra_data}->{original_area};}my$area_price=$AREAS_INFO{$my_area}->[2]||"";
if($area_price){$area_price=~s/sell_price//;}my%info=(customer_name=>$customer_name,customer_nif=>$customer_nif,custom_table_number=>$ex->{custom_table_number},area_price=>$area_price,area=>$my_area,area_name=>$AREAS_INFO{$my_area}->[0],check_number=>$check_number,check_number_map=>$check_number_map,datetime=>&strftime("%Y-%m-%d %H:%M:%S",localtime),date=>&strftime("%Y-%m-%d",localtime),hour=>&strftime("%H:%M:%S",localtime),request_number=>$request_numbers->cur_value($req_key),persons_number=>$check->{header}->[15]||0,total_quantities=>$total_quantities,);
$check->{extra_data}->{queue_name}||="";
if($check->{extra_data}->{queue_name}){$info{queue_number}=_read_queue_number($machine,$check->{extra_data}->{queue_name});}my$name_file=$machine->dir_server()."/server/data/areas/$area/$check_number.name";
if(-e$name_file){local$/=undef;
open(F,"< ".$name_file);
my$cnt=<F>;
chop($cnt);
close(F);
$cnt=~s/\n//g;
$info{check_name}=$cnt;}$info{check_name}||="";
if(!$info{check_name}){$info{table_desc}=$check_number;}else{if($info{check_name}=~/^\d+$/){$info{table_desc}=$info{check_name};}else{$info{table_desc}=$check_number." (".$info{check_name}.")";}}my$v1=$request_numbers->cur_value($req_key);
if($request_numbers_checks->exists($check_unique_id)){my$v2=$request_numbers_checks->cur_value($check_unique_id);
$v2.=",".$v1;
$request_numbers_checks->set_value($check_unique_id,$v2);}else{$request_numbers_checks->set_value($check_unique_id,$v1);}my%group_by_printer=();
my%group_by_pzone=();
my$have_printing_priority=0;
foreach my $zone(keys%to_print_request){my$printers=$PRINTING_ZONES_CONFIG->{$zone};
my$products=$to_print_request{$zone};
my%i=();
my@prod=();
my$seat_idx=0;
my$seats=$check_o->{data}->{extra_data}->{seats};
$seats||="";
my@seats=split/#/,$seats;
if($cfg->{GROUPING_REQUESTED_PRODUCTS}){if($cfg->{GROUPING_REQUESTED_PRODUCTS}==1){$group_products=1;}elsif($cfg->{GROUPING_REQUESTED_PRODUCTS}==2||$cfg->{GROUPING_REQUESTED_PRODUCTS}==4){$group_products=0;}}if(scalar keys%util_grouping_by_prod){$group_products=0;}if(!$group_products){foreach my $p(sort{$a->{order}<=>$b->{order}}@$products){$products_requested_req_number->set_value($p->{key},$info{request_number});
my$seats_str="";
$seat_idx=$p->{order};
if(scalar@seats&&$p->{order}<=scalar(@seats)){$seats_str=$seats[$seat_idx];}my$id=$p->{product_code};
my$printing_priority=exists$PRINTING_PRIORITIES->{$id}?$PRINTING_PRIORITIES->{$id}:0;
$have_printing_priority=1 if$printing_priority;
if(!$p->{is_extra}){$last_print_priority=$printing_priority;}else{$printing_priority=0;
$printing_priority=$last_print_priority unless$printing_priority;}$p->{quantity}||=1;
if($cfg->{GROUPING_REQUESTED_PRODUCTS}==4&&$p->{quantity}>1&&$p->{quantity}!~/\./){for(my$i=0;$i<$p->{quantity};$i++){push@prod,{seats=>$seats_str,foreign=>$p->{foreign},foreign_orig=>$p->{foreign_orig},quantity=>1,hour=>$p->{hour},station=>$p->{station},area=>$p->{area},vat=>$p->{vat},price=>$p->{price},clerk_name=>$p->{clerk_name},clerk_code=>$p->{clerk_code},product_code=>$p->{product_code},product_name=>$p->{product_name},handy_plu=>$p->{handy_plu},is_extra=>$p->{is_extra},is_menu=>$p->{is_menu},is_message=>$p->{is_message},is_weight=>$p->{is_weight},key=>$p->{key},printing_priority=>$printing_priority,order=>$p->{order},};}}else{push@prod,{seats=>$seats_str,foreign=>$p->{foreign},foreign_orig=>$p->{foreign_orig},quantity=>$p->{quantity},hour=>$p->{hour},station=>$p->{station},area=>$p->{area},vat=>$p->{vat},price=>$p->{price},clerk_name=>$p->{clerk_name},clerk_code=>$p->{clerk_code},product_code=>$p->{product_code},product_name=>$p->{product_name},handy_plu=>$p->{handy_plu},is_extra=>$p->{is_extra},is_menu=>$p->{is_menu},is_message=>$p->{is_message},is_weight=>$p->{is_weight},key=>$p->{key},printing_priority=>$printing_priority,order=>$p->{order},};}if(scalar@{$p->{notes}}){foreach my $note(@{$p->{notes}}){push@prod,{quantity=>1,hour=>$p->{hour},station=>$p->{station},area=>$p->{area},vat=>0,price=>0,clerk_name=>$p->{clerk_name},clerk_code=>$p->{clerk_code},product_code=>"",product_name=>$note,is_extra=>1,order=>"10".$p->{order},};}}}}else{foreach my $p(reverse sort{$a->{order}<=>$b->{order}}@$products){$products_requested_req_number->set_value($p->{key},$info{request_number});
my$id=$p->{product_code};
my$printing_priority=exists$PRINTING_PRIORITIES->{$id}?$PRINTING_PRIORITIES->{$id}:0;
$have_printing_priority=1 if$printing_priority;
if(!$p->{is_extra}){$last_print_priority=$printing_priority;}else{$printing_priority=0;
$printing_priority=$last_print_priority unless$printing_priority;}$seat_idx=$p->{order};
if(scalar@seats&&$p->{order}<=scalar(@seats)){if(exists$i{$p->{product_code}}->{seats}){$i{$p->{product_code}}->{seats}=$i{$p->{product_code}}->{seats}.",".$seats[$seat_idx]if defined$seats[$seat_idx];}else{$i{$p->{product_code}}->{seats}=$seats[$seat_idx];}}$i{$p->{product_code}}->{quantity}+=$p->{quantity};
$i{$p->{product_code}}->{hour}=$p->{hour};
$i{$p->{product_code}}->{is_weight}=$p->{is_weight};
$i{$p->{product_code}}->{station}=$p->{station};
$i{$p->{product_code}}->{area}=$p->{area};
$i{$p->{product_code}}->{vat}=$p->{vat};
$i{$p->{product_code}}->{price}=$p->{price};
$i{$p->{product_code}}->{foreign}=$p->{foreign};
$i{$p->{product_code}}->{foreign_orig}=$p->{foreign_orig};
$i{$p->{product_code}}->{clerk_name}=$p->{clerk_name};
$i{$p->{product_code}}->{clerk_code}=$p->{clerk_code};
$i{$p->{product_code}}->{product_code}=$p->{product_code};
$i{$p->{product_code}}->{product_name}=$p->{product_name};
$i{$p->{product_code}}->{handy_plu}=$p->{handy_plu};
$i{$p->{product_code}}->{order}=$p->{order};
$i{$p->{product_code}}->{key}=$p->{key};
$i{$p->{product_code}}->{printing_priority}=$printing_priority;
$i{$p->{product_code}}->{is_extra}=$p->{is_extra};}@prod=values%i;
@prod=sort{$a->{order}<=>$b->{order}}@prod;}if(exists$kitchen_monitor_zones->{$zone}&&!ref($kitchen_monitor_zones->{$zone})){&kitchen_monitor_save_products($machine,\%info,$zone,$products);}my$a_tmp=$area+1;
my$c=0;
foreach my $printer(@$printers){my($station,$num)=split/#/,$printer;
my$area_tmp=$area+1;
my$station_tmp=$station+1;
my$copies=1;
if(exists$PRINTING_ZONES_FILTERS->{$zone}->{$c}){my$filter=$PRINTING_ZONES_FILTERS->{$zone}->{$c};
$copies=$PRINTING_ZONES_FILTERS->{$zone}->{Copies}->[$c];
if(defined$filter->{FromStation}&&$filter->{FromStation}ne ''&&$filter->{FromStation}!=$hold_station){$c++;
next;}if(defined$filter->{FromArea}&&$filter->{FromArea}ne ''&&$filter->{FromArea}!=$area_tmp){$c++;
next;}}my$rule_number=$c+1;
if(exists$kitchen_monitor_zones->{$zone}&&ref($kitchen_monitor_zones->{$zone})&&exists$kitchen_monitor_zones->{$zone}->{$rule_number}){my$folder_name=$kitchen_monitor_zones->{$zone}->{$rule_number};
&kitchen_monitor_save_products($machine,\%info,$zone,\@prod,$folder_name);}foreach my $rec(@prod){$rec->{printing_zone}=$zone;
my%info=%$rec;
push@{$group_by_printer{$station}->{$num-1}->{$copies}},\%info;
push@{$group_by_pzone{$zone}->{$station}->{$num-1}->{$copies}},\%info;}$c++;}}if($cfg->{GROUP_REQUESTS_BY_PRINTER}){foreach my $station(keys%group_by_printer){foreach my $num(keys%{$group_by_printer{$station}}){foreach my $copies(keys%{$group_by_printer{$station}->{$num}}){my$prods=$group_by_printer{$station}->{$num}->{$copies};
if($cfg->{SORT_REQUESTS_BY_PRINT_PRIORITY}&&$have_printing_priority){@$prods=sort{$a->{printing_priority}<=>$b->{printing_priority}||$a->{order}<=>$b->{order}}@$prods;}$cfg->{GROUPING_REQUESTED_PRODUCTS}||=0;
my$individual_products=$cfg->{GROUPING_REQUESTED_PRODUCTS}==3||$cfg->{GROUPING_REQUESTED_PRODUCTS}==4?1:0;
if($individual_products){my@prints=();
my$cur=[];
my$product_idx=1;
for(reverse@$prods){$_->{idx}=$product_idx++;
$_->{idx_total}=scalar@$prods;
if($_->{is_extra}){push@$cur,$_;}else{push@$cur,$_;
push@prints,\@{$cur};
$cur=[];}}foreach my $print(@prints){my@p=reverse@$print;
my$template='products_request.tmpl';
my$pzone="";
$pzone=$p[0]->{printing_zone}if scalar@p;
if($pzone){my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$pzone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$pzone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$pzone}->{$station}->{$printer_num}->{Template};}}$info{products}||=[];
@{$info{products}}=sort{$a->{foreign}<=>$b->{foreign}}@{$info{products}};
$info{operation}="request";
$info{products}=\@p;
if($cfg->{GROUP_BY_PRODUCT_UTIL_NAME}){my$prods=$info{products};
foreach my $p(@$prods){$p->{util_grouping_key}=$util_grouping_by_prod{$p->{key}};}my$last_grp="";
my@new_prods=();
my%group_qttys=();
foreach my $p(sort{$a->{util_grouping_key}cmp$b->{util_grouping_key}}@$prods){if($p->{util_grouping_key}ne '0_none'){if($last_grp ne$p->{util_grouping_key}){$p->{util_grouping_key_changed}=1;}$last_grp=$p->{util_grouping_key};}if(exists$group_qttys{$last_grp."#".$p->{product_code}}){my$pref=$group_qttys{$last_grp."#".$p->{product_code}};
$pref->{quantity}+=$p->{quantity};}else{$group_qttys{$last_grp."#".$p->{product_code}}=$p;
push@new_prods,$p;}}$info{products}=\@new_prods;}my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}else{$info{products}=$prods;
my$pzone="";
$pzone=scalar@$prods?$prods->[0]->{printing_zone}:"";
my$template='products_request.tmpl';
if($pzone){my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$pzone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$pzone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$pzone}->{$station}->{$printer_num}->{Template};}}$info{products}||=[];
@{$info{products}}=sort{$a->{foreign}<=>$b->{foreign}}@{$info{products}};
$info{operation}="request";
if($cfg->{GROUP_BY_PRODUCT_UTIL_NAME}){my$prods=$info{products};
foreach my $p(@$prods){$p->{util_grouping_key}=$util_grouping_by_prod{$p->{key}};}my$last_grp="";
my@new_prods=();
my%group_qttys=();
foreach my $p(sort{$a->{util_grouping_key}cmp$b->{util_grouping_key}}@$prods){if($p->{util_grouping_key}ne '0_none'){if($last_grp ne$p->{util_grouping_key}){$p->{util_grouping_key_changed}=1;}$last_grp=$p->{util_grouping_key};}if(exists$group_qttys{$last_grp."#".$p->{product_code}}){my$pref=$group_qttys{$last_grp."#".$p->{product_code}};
$pref->{quantity}+=$p->{quantity};}else{$group_qttys{$last_grp."#".$p->{product_code}}=$p;
push@new_prods,$p;}}$info{products}=\@new_prods;}my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}}}}else{foreach my $zone(keys%group_by_pzone){foreach my $station(keys%{$group_by_pzone{$zone}}){foreach my $num(keys%{$group_by_pzone{$zone}->{$station}}){foreach my $copies(keys%{$group_by_pzone{$zone}->{$station}->{$num}}){my$prods=$group_by_pzone{$zone}->{$station}->{$num}->{$copies};
if($cfg->{SORT_REQUESTS_BY_PRINT_PRIORITY}&&$have_printing_priority){@$prods=sort{$a->{printing_priority}<=>$b->{printing_priority}||$a->{order}<=>$b->{order}}@$prods;}$cfg->{GROUPING_REQUESTED_PRODUCTS}||=0;
my$individual_products=$cfg->{GROUPING_REQUESTED_PRODUCTS}==3||$cfg->{GROUPING_REQUESTED_PRODUCTS}==4?1:0;
if($individual_products){my@prints=();
my$cur=[];
my$product_idx=1;
for(reverse@$prods){$_->{idx}=$product_idx++;
$_->{idx_total}=scalar@$prods;
if($_->{is_extra}){push@$cur,$_;}else{push@$cur,$_;
push@prints,\@{$cur};
$cur=[];}}foreach my $print(@prints){my@p=reverse@$print;
my$template='products_request.tmpl';
my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$zone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$zone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$zone}->{$station}->{$printer_num}->{Template};}$info{products}||=[];
@{$info{products}}=sort{$a->{foreign}<=>$b->{foreign}}@{$info{products}};
$info{products}=\@p;
$info{operation}="request";
if($cfg->{GROUP_BY_PRODUCT_UTIL_NAME}){my$prods=$info{products};
foreach my $p(@$prods){$p->{util_grouping_key}=$util_grouping_by_prod{$p->{key}};}my$last_grp="";
my@new_prods=();
my%group_qttys=();
foreach my $p(sort{$a->{util_grouping_key}cmp$b->{util_grouping_key}}@$prods){if($p->{util_grouping_key}ne '0_none'){if($last_grp ne$p->{util_grouping_key}){$p->{util_grouping_key_changed}=1;}$last_grp=$p->{util_grouping_key};}if(exists$group_qttys{$last_grp."#".$p->{product_code}}){my$pref=$group_qttys{$last_grp."#".$p->{product_code}};
$pref->{quantity}+=$p->{quantity};}else{$group_qttys{$last_grp."#".$p->{product_code}}=$p;
push@new_prods,$p;}}$info{products}=\@new_prods;}my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}else{if($cfg->{GROUP_BY_PRODUCT_UTIL_NAME}){foreach my $p(@$prods){$p->{util_grouping_key}=$util_grouping_by_prod{$p->{key}};}my$last_grp="";
my@new_prods=();
my%group_qttys=();
foreach my $p(sort{$a->{util_grouping_key}cmp$b->{util_grouping_key}}@$prods){if($p->{util_grouping_key}ne '0_none'){if($last_grp ne$p->{util_grouping_key}){$p->{util_grouping_key_changed}=1;}$last_grp=$p->{util_grouping_key};}if(exists$group_qttys{$last_grp."#".$p->{product_code}}){my$pref=$group_qttys{$last_grp."#".$p->{product_code}};
$pref->{quantity}+=$p->{quantity};}else{$group_qttys{$last_grp."#".$p->{product_code}}=$p;
push@new_prods,$p;}}$prods=\@new_prods;}$info{products}=$prods;
my$template='products_request.tmpl';
my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$zone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$zone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$zone}->{$station}->{$printer_num}->{Template};}$info{products}||=[];
@{$info{products}}=sort{$a->{foreign}<=>$b->{foreign}}@{$info{products}};
$info{operation}="request";
my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}}}}}}else{print STDERR"PRINT_REQUESTS IN config.ini IS TURNED OFF...\n";}if($cfg->{PRINT_VOIDS}&&defined$check_number&&$check_number!~/^0\./){my$request_number=$request_numbers_checks->cur_value($check_unique_id);
my$check_number_map=exists$TABLES_TO_CARDS{$check_number}?$TABLES_TO_CARDS{$check_number}:$check_number;
my$my_area=$area;
if(exists$check->{extra_data}->{original_area}){$my_area=$check->{extra_data}->{original_area};}my$area_price=$AREAS_INFO{$my_area}->[2]||"";
if($area_price){$area_price=~s/sell_price//;}if($request_number=~/,/){my@aa=split/,/,$request_number;
$request_number=$aa[-1];}my%info=(customer_name=>$customer_name,customer_nif=>$customer_nif,custom_table_number=>$ex->{custom_table_number},area_price=>$area_price,area=>$my_area,area_name=>$AREAS_INFO{$my_area}->[0],persons_number=>$check->{header}->[15]||0,check_number=>$check_number,check_number_map=>$check_number_map,request_number=>$request_number,datetime=>&strftime("%Y-%m-%d %H:%M:%S",localtime),date=>&strftime("%Y-%m-%d",localtime),hour=>&strftime("%H:%M:%S",localtime),total_quantities=>$total_quantities,);
$check->{extra_data}->{queue_name}||="";
if($check->{extra_data}->{queue_name}){$info{queue_number}=_read_queue_number($machine,$check->{extra_data}->{queue_name});}my$name_file=$machine->dir_server()."/server/data/areas/$area/$check_number.name";
if(-e$name_file){local$/=undef;
open(F,"< ".$name_file);
my$cnt=<F>;
chop($cnt);
close(F);
$info{check_name}=$cnt;}$info{check_name}||="";
if(!$info{check_name}){$info{table_desc}=$check_number;}else{if($info{check_name}=~/^\d+$/){$info{table_desc}=$info{check_name};}else{$info{table_desc}=$check_number." (".$info{check_name}.")";}}my@prod_final=();
my%group_by_printer=();
my%group_by_pzone=();
my$have_printing_priority=0;
$check->{extra_data}->{delivery_info}||="";
if($check->{extra_data}->{delivery_info}){my$dinfo=&_decode_delivery_info($db,$check);
$info{delivery_info}=$dinfo;}my%kitchen_monitor_void=();
foreach my $zone(keys%to_print_void){my$printers=$PRINTING_ZONES_CONFIG->{$zone};
my$products=$to_print_void{$zone};
my%i=();
my@prod=();
if(exists$kitchen_monitor_zones->{$zone}&&!ref($kitchen_monitor_zones->{$zone})){&kitchen_monitor_void_products($machine,\%info,$zone,$products);}if($cfg->{GROUPING_REQUESTED_PRODUCTS}){if($cfg->{GROUPING_REQUESTED_PRODUCTS}==1){$group_products=1;}elsif($cfg->{GROUPING_REQUESTED_PRODUCTS}==2||$cfg->{GROUPING_REQUESTED_PRODUCTS}==4){$group_products=0;}}if(!$group_products){foreach my $p(sort{$a->{order}<=>$b->{order}}@$products){my$id=$p->{product_code};
my$printing_priority=exists$PRINTING_PRIORITIES->{$id}?$PRINTING_PRIORITIES->{$id}:0;
$have_printing_priority=1 if$printing_priority;
if(!$p->{is_extra}){$last_print_priority=$printing_priority;}else{$printing_priority=0;
$printing_priority=$last_print_priority unless$printing_priority;}push@prod,{foreign=>$p->{foreign},foreign_orig=>$p->{foreign_orig},quantity=>$p->{quantity},hour=>$p->{hour},hour_registered=>$p->{hour_registered},hour_voided=>$p->{hour_voided},station=>$p->{station},area=>$p->{area},vat=>$p->{vat},price=>$p->{price},clerk_name=>$p->{clerk_name},clerk_code=>$p->{clerk_code},product_code=>$p->{product_code},product_name=>$p->{product_name},handy_plu=>$p->{handy_plu},is_weight=>$p->{is_weight},is_extra=>$p->{is_extra},is_menu=>$p->{is_menu},is_message=>$p->{is_message},key=>$p->{key},printing_priority=>$printing_priority,order=>$p->{order},};}}else{foreach my $p(reverse sort{$a->{order}<=>$b->{order}}@$products){my$id=$p->{product_code};
my$printing_priority=exists$PRINTING_PRIORITIES->{$id}?$PRINTING_PRIORITIES->{$id}:0;
$have_printing_priority=1 if$printing_priority;
if(!$p->{is_extra}){$last_print_priority=$printing_priority;}else{$printing_priority=0;
$printing_priority=$last_print_priority unless$printing_priority;}$i{$p->{product_code}}->{quantity}+=$p->{quantity};
$i{$p->{product_code}}->{hour}=$p->{hour};
$i{$p->{product_code}}->{hour_voided}=$p->{hour_voided};
$i{$p->{product_code}}->{hour_registered}=$p->{hour_registered};
$i{$p->{product_code}}->{is_weight}=$p->{is_weight};
$i{$p->{product_code}}->{station}=$p->{station};
$i{$p->{product_code}}->{area}=$p->{area};
$i{$p->{product_code}}->{vat}=$p->{vat};
$i{$p->{product_code}}->{price}=$p->{price};
$i{$p->{product_code}}->{foreign}=$p->{foreign};
$i{$p->{product_code}}->{foreign_orig}=$p->{foreign_orig};
$i{$p->{product_code}}->{clerk_name}=$p->{clerk_name};
$i{$p->{product_code}}->{clerk_code}=$p->{clerk_code};
$i{$p->{product_code}}->{product_code}=$p->{product_code};
$i{$p->{product_code}}->{product_name}=$p->{product_name};
$i{$p->{product_code}}->{handy_plu}=$p->{handy_plu};
$i{$p->{product_code}}->{order}=$p->{order};
$i{$p->{product_code}}->{key}=$p->{key};
$i{$p->{product_code}}->{printing_priority}=$printing_priority;
$i{$p->{product_code}}->{is_extra}=$p->{is_extra};}@prod=values%i;}my$a_tmp=$area+1;
my$c=0;
foreach my $printer(@$printers){my($station,$num)=split/#/,$printer;
my$area_tmp=$area+1;
my$station_tmp=$station+1;
my$copies=1;
if(exists$PRINTING_ZONES_FILTERS->{$zone}->{$c}){my$filter=$PRINTING_ZONES_FILTERS->{$zone}->{$c};
$copies=$PRINTING_ZONES_FILTERS->{$zone}->{Copies}->[$c];
if(defined$filter->{FromStation}&&$filter->{FromStation}ne ''&&$filter->{FromStation}!=$hold_station){$c++;
next;}if(defined$filter->{FromArea}&&$filter->{FromArea}ne ''&&$filter->{FromArea}!=$area_tmp){$c++;
next;}}my$rule_number=$c+1;
foreach my $rec(@prod){if(exists$kitchen_monitor_zones->{$zone}&&ref($kitchen_monitor_zones->{$zone})&&exists$kitchen_monitor_zones->{$zone}->{$rule_number}){my$folder_name=$kitchen_monitor_zones->{$zone}->{$rule_number};
$kitchen_monitor_void{$folder_name}->{$rec->{key}}=$rec;}$rec->{printing_zone}=$zone;
my%info=%$rec;
push@{$group_by_printer{$station}->{$num-1}->{$copies}},\%info;
push@{$group_by_pzone{$zone}->{$station}->{$num-1}->{$copies}},\%info;}$c++;}}if(scalar keys%kitchen_monitor_void){foreach my $folder_name(keys%kitchen_monitor_void){my$info=$kitchen_monitor_void{$folder_name};
my@prods=values%$info;
if(scalar@prods){my$zone=$prods[0]->{printing_zone};
&kitchen_monitor_void_products($machine,\%info,$zone,\@prods,$folder_name);}}}if($cfg->{GROUP_REQUESTS_BY_PRINTER}){foreach my $station(keys%group_by_printer){foreach my $num(keys%{$group_by_printer{$station}}){foreach my $copies(keys%{$group_by_printer{$station}->{$num}}){my$prods=$group_by_printer{$station}->{$num}->{$copies};
if($cfg->{SORT_REQUESTS_BY_PRINT_PRIORITY}&&$have_printing_priority){@$prods=sort{$a->{printing_priority}<=>$b->{printing_priority}||$a->{order}<=>$b->{order}}@$prods;}$cfg->{GROUPING_REQUESTED_PRODUCTS}||=0;
my$individual_products=$cfg->{GROUPING_REQUESTED_PRODUCTS}==3||$cfg->{GROUPING_REQUESTED_PRODUCTS}==4?1:0;
if($individual_products){my@prints=();
my$cur=[];
my$product_idx=1;
for(reverse@$prods){$_->{idx}=$product_idx++;
$_->{idx_total}=scalar@$prods;
if($_->{is_extra}){push@$cur,$_;}else{push@$cur,$_;
push@prints,\@{$cur};
$cur=[];}}foreach my $print(@prints){my@p=reverse@$print;
$info{products}=\@p;
my$pzone="";
$pzone=scalar@p?$p[0]->{printing_zone}:"";
my$template='products_void.tmpl';
if($pzone){my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$pzone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$pzone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$pzone}->{$station}->{$printer_num}->{Template};}}$info{operation}="void";
my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}else{$info{products}=$prods;
my$pzone="";
$pzone=scalar@$prods?$prods->[0]->{printing_zone}:"";
my$template='products_void.tmpl';
if($pzone){my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$pzone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$pzone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$pzone}->{$station}->{$printer_num}->{Template};}}$info{operation}="void";
my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}}}}else{foreach my $zone(keys%group_by_pzone){foreach my $station(keys%{$group_by_pzone{$zone}}){foreach my $num(keys%{$group_by_pzone{$zone}->{$station}}){foreach my $copies(keys%{$group_by_pzone{$zone}->{$station}->{$num}}){my$prods=$group_by_pzone{$zone}->{$station}->{$num}->{$copies};
if($cfg->{SORT_REQUESTS_BY_PRINT_PRIORITY}&&$have_printing_priority){@$prods=sort{$a->{printing_priority}<=>$b->{printing_priority}||$a->{order}<=>$b->{order}}@$prods;}$cfg->{GROUPING_REQUESTED_PRODUCTS}||=0;
my$individual_products=$cfg->{GROUPING_REQUESTED_PRODUCTS}==3||$cfg->{GROUPING_REQUESTED_PRODUCTS}==4?1:0;
if($individual_products){my@prints=();
my$cur=[];
my$product_idx=1;
for(reverse@$prods){$_->{idx}=$product_idx++;
$_->{idx_total}=scalar@$prods;
if($_->{is_extra}){push@$cur,$_;}else{push@$cur,$_;
push@prints,\@{$cur};
$cur=[];}}foreach my $print(@prints){my@p=reverse@$print;
$info{products}=\@p;
my$template='products_void.tmpl';
my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$zone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$zone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$zone}->{$station}->{$printer_num}->{Template};}$info{operation}="void";
my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}else{$info{products}=$prods;
my$template='products_void.tmpl';
my$pi=$machine->config()->printers_info();
my$printer_num=$num+1;
$pi->{$zone}->{$station}->{$printer_num}->{Template}||="";
if($pi->{$zone}->{$station}->{$printer_num}->{Template}){$template=$pi->{$zone}->{$station}->{$printer_num}->{Template};}$info{operation}="void";
my$content="";
$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process($template,\%info,\$content)||die$TEMPLATE->error;
my$archive_dir=$machine->dir_server().'/server/data/order_archive/'.$station."/".$num;
&make_path($archive_dir)unless-d$archive_dir;
my$archived=0;
my$zone="";
if(scalar@$prods){$zone=$prods->[0]->{printing_zone};}for(my$i=0;$i<$copies;$i++){my$r=int(rand(10000));
my$fname="print#".$station."#".$num."#0#".time."$r.txt";
if(!$archived++){open(F,"> $archive_dir/$fname");
print F$content;
close(F);}my$f=$machine->server_dir_tmp()."/".$fname;
open(F,"> $f");
print F$content;
close(F);}}}}}}}}else{print STDERR"PRINT_VOIDS IN config.ini IS TURNED OFF...\n";}}sub _find_file_to_print{my%a=(machine=>undef,station=>undef,station_close=>undef,@_);
my$machine=$a{machine};
my$cfg=$machine->config()->load_fixed();
my$station_close=$a{station_close};
my$station=$a{station};
my$station_to_print=0;
if($cfg->{STATION_PRINT_CHECKS}==99){$station_to_print=$station_close;}else{$station_to_print=$cfg->{STATION_PRINT_CHECKS};}$station_to_print=$station unless defined$station_to_print;
if(exists$MAIN_PRINTERS{$station_to_print}){my$printer=$MAIN_PRINTERS{$station_to_print};
my$r=int(rand(100000));
return($machine->server_dir_tmp()."/print#$station_to_print#".$printer."#1#".time."$r.txt",$station_to_print);}else{my$main_file=$machine->dir_server()."/server/data/registered_printers/".$station_to_print."/main";
if(!-e$main_file){print STDERR"Can't find main file for station $station_to_print ($main_file)\n";
print STDERR"CHECK IF THAT STATION HAS A 'Main' PRINTER!\n";
return(undef,undef);}else{my$printer=undef;
{local$/=undef;
open(F,"< $main_file");
$printer=<F>;
chop($printer);
close(F);}if(defined$printer){$MAIN_PRINTERS{$station_to_print}=$printer;
my$r=int(rand(100000));
return($machine->server_dir_tmp()."/print#$station_to_print#".$printer."#1#".time."$r.txt",$station_to_print);}}}return(undef,undef);}sub _get_sign_chars{my%a=(signature=>undef,chars=>[0,10,20,30],@_);
my@chars=split//,$a{signature};
my@c=@{$a{chars}};
return@chars[@c];}sub _decode_card_data{my$str=shift;
my$r={};
my@chars=split//,$str;
my$is_dallas=0;
my$read=0;
my$cur=0;
my$ignore_next=0;
foreach my $c(@chars){my$ord=ord($c);
if($ord==243){$cur=1;
$read=1;}elsif($ord==241){$is_dallas=1;
$cur="read";
$read=1;}elsif($ord==242){$is_dallas=1;
$cur="read";
$read=1;
$r->{$cur}=1;}elsif($ord==244){$ignore_next=1;}elsif($ord==1||$ord==2||$ord==3||$ord==4||$ord==5){$cur=$ord;
$read=1;
$ignore_next=1;}else{if($ignore_next==1){$ignore_next=0;
next;}else{$r->{$cur}.=$c;}}}$r->{type}=$is_dallas?'dallas':'card';
return$r;}sub _get_template_obj{my$machine=shift;
return Template->new({INCLUDE_PATH=>$machine->dir_server().'/common/print_templates',CACHE_SIZE=>0,EVAL_PERL=>1,});}sub _decode_expire{my$ve=shift;
my$expiration="";
my$val;
if($ve){if(($val)=$ve=~/^(\d+)a$/){my($y,$m,$d)=Today();
my$days=365*$val;
my($fy,$fm,$fd)=Add_Delta_Days($y,$m,$d,$days);
$expiration="$fy-$fm-$fd";}elsif(($val)=$ve=~/^(\d+)m$/){my($y,$m,$d)=Today();
my$days=30*$val;
my($fy,$fm,$fd)=Add_Delta_Days($y,$m,$d,$days);
$expiration="$fy-$fm-$fd";}elsif(($val)=$ve=~/^(\d+)d$/){my($y,$m,$d)=Today();
my$days=$val;
my($fy,$fm,$fd)=Add_Delta_Days($y,$m,$d,$days);
$expiration="$fy-$fm-$fd";}}return$expiration||'2200-01-01';}sub _linestatus{my$p=shift;
my$info={};
my$status=$p->modemlines;
$info->{dtr}=($status& MS_DTR_ON)?"ON ":"OFF";
$info->{cts}=($status& MS_CTS_ON)?"ON ":"OFF";
$info->{rts}=($status& MS_RTS_ON)?"ON ":"OFF";
$info->{dsr}=($status& MS_DSR_ON)?"ON ":"OFF";
$info->{ring}=($status& MS_RING_ON)?"ON ":"OFF";
$info->{rlsd}=($status& MS_RLSD_ON)?"ON ":"OFF";
return$info;}sub _slurp_printing_zone{my($info,$from,$to)=@_;
return unless defined$from&&defined$to;
my$r_orig=exists$info->{$from}?$info->{$from}:undef;
my$r_dest=exists$info->{$to}?$info->{$to}:undef;
if(defined$r_orig&&defined$r_dest){my%dest_keys=();
map{$dest_keys{$_->{key}}=1}@$r_dest;
foreach my $rec(@$r_orig){next if exists$dest_keys{$rec->{key}};
my@notes=();
if(exists$rec->{foreign_orig}&&$rec->{foreign_orig}eq$to){next;}if(exists$rec->{notes}){@notes=@{$rec->{notes}};}my%info=%{$rec};
$info{notes}=\@notes;
$info{foreign}=1;
$info{foreign_orig}=$from;
push@$r_dest,\%info;}}}sub _get_report_lists_info{my$db=shift;
my%info=();
my$r=$db->select(qq{
    SELECT pl.*, l.*, l.kind as list_kind, pl.kind as line_kind
    FROM products_lists pl
    LEFT JOIN lists l ON (pl.list_id = l.id)
    LEFT JOIN product_groups pg ON (pl.product_id = pg.product_id)
    WHERE l.kind = 'L' AND l.for_reporting = 1
  });
foreach my $rec(@$r){$info{lists}->{$rec->{list_id}}->{start_hour}=$rec->{start_hour};
$info{lists}->{$rec->{list_id}}->{end_hour}=$rec->{end_hour};
$info{lists}->{$rec->{list_id}}->{weekdays}=$rec->{weekdays};
my@a=split/,/,$rec->{weekdays};
$info{lists}->{$rec->{list_id}}->{weekdays_as_array}=\@a;
$info{lists}->{$rec->{list_id}}->{name}=$rec->{list_name};
if($rec->{line_kind}eq 'G'){my$prods=$db->select(qq{
        SELECT p.id
        FROM product_groups pg
        LEFT JOIN products p ON (pg.product_id = p.id)
        WHERE pg.group_id = ?
      },$rec->{product_id});
for(@$prods){next unless defined$_->{product_id};
$info{lists}->{$rec->{list_id}}->{products}->{$_->{product_id}}=1;
$info{lists_by_products}->{$_->{id}}->{$rec->{list_id}}=1;}}else{$info{lists}->{$rec->{list_id}}->{products}->{$rec->{product_id}}=1;
$info{lists_by_products}->{$rec->{product_id}}->{$rec->{list_id}}=1;}}return\%info;}sub get_products_translations{my$db=shift;
if(!defined$PRODUCTS_TRANSLATIONS){my$tmp=$db->select("SELECT * FROM product_names");
map{if($_->{product_id}&&$_->{language}){$PRODUCTS_TRANSLATIONS->{$_->{product_id}}->{$_->{language}}=$_->{value};}}@$tmp;}}sub get_clerks_information{my$db=shift;
if(!defined$CLERKS_INFO){my$tmp=$db->select("SELECT * FROM clerks WHERE deleted = 0");
for(@$tmp){$_->{login}=&my_conv($_->{login});
if($_->{drawer}){$CLERKS_DRAWER->{$_->{id}}=$_->{drawer};}$CLERKS_INFO->{$_->{id}}=$_;
$CLERKS_IDS_BY_LOGIN->{$_->{login}}=$_->{id};}}}sub get_customers_information{my$db=shift;
my$info={};
my$recs=$db->select("SELECT id, name, nif FROM customers ORDER BY deleted");
map{$info->{$_->{id}}=$_}@$recs;
return$info;}sub get_products_information{my$db=shift;
if(!defined$PRODUCTS_INFO){my$q=qq{
        SELECT p.*,
        CASE
          WHEN f.id IS NOT NULL THEN COALESCE(f.name,'----------')
          ELSE COALESCE(sf.name,'----------')
        END as family_name, f.print_priority AS f_print_priority,
        CASE
          WHEN sf.id IS NOT NULL THEN COALESCE(sf.name,'----------')
          ELSE '----------'
        END as subfamily_name, sf.print_priority AS sf_print_priority
        FROM products p
        LEFT JOIN product_groups pg ON (p.id = pg.product_id)
        LEFT JOIN groups sf ON (pg.group_id = sf.id)
        LEFT JOIN groups f ON (sf.parent = f.id)
      };
my$tmp=$db->select($q);
for(@$tmp){$_->{name}=&my_conv($_->{name});
$_->{button_text}=&my_conv($_->{button_text});
$_->{family_name}=&my_conv($_->{family_name});
$_->{subfamily_name}=&my_conv($_->{subfamily_name});
$PRODUCTS_EXTRAS->{$_->{id}}=1 if$_->{is_extra};
$PRODUCTS_MENUS->{$_->{id}}=1 if$_->{is_menu};
$PRODUCTS_IDS_BY_HANDY_PLU->{$_->{handy_plu}}=$_->{id}if$_->{handy_plu}&&$_->{deleted}==0;
$PRODUCTS_INFO->{$_->{id}}=$_;
$PRINTING_PRIORITIES->{$_->{id}}=$_->{print_priority};
$PRINTING_PRIORITIES->{$_->{id}}=$_->{sf_print_priority}if$_->{sf_print_priority}&&!$PRINTING_PRIORITIES->{$_->{id}};
$PRINTING_PRIORITIES->{$_->{id}}=$_->{f_print_priority}if$_->{f_print_priority}&&!$PRINTING_PRIORITIES->{$_->{id}};}$q=qq{
      SELECT p.*
      FROM products p
      LEFT JOIN product_groups pg ON (p.id = pg.product_id)
      WHERE (pg.group_id = 0 OR id NOT IN (SELECT product_id FROM product_groups))
    };
$tmp=$db->select($q);
map{$_->{name}=&my_conv($_->{name});
$_->{button_text}=&my_conv($_->{button_text});
$PRODUCTS_EXTRAS->{$_->{id}}=1 if$_->{is_extra};
$PRODUCTS_MENUS->{$_->{id}}=1 if$_->{is_menu};
$PRODUCTS_INFO->{$_->{id}}=$_;
$PRODUCTS_IDS_BY_HANDY_PLU->{$_->{handy_plu}}=$_->{id}if$_->{handy_plu}&&$_->{deleted}==0;}@$tmp;
$tmp=$db->select(qq{
      SELECT * FROM products_extra_data
    });
map{$PRODUCTS_EXTRA_DATA->{$_->{product_id}}->{$_->{field_name}}=$_->{field_value}}@$tmp;}}sub shrink_words{my$str=shift;
my$cfg=shift;
if(exists$cfg->{DONT_SHRINK_WORDS}&&$cfg->{DONT_SHRINK_WORDS}){return$str;}if(length($str)<20){return$str;}$str=&trim_string($str);
my$new_str="";
my@words=split/\s/,$str;
foreach my $w(@words){my$len=length($w);
if($len>2){if($len>=5){$new_str.=substr($w,0,5)." ";}else{$new_str.=$w." ";}}}$new_str=~s/\s$//;
return$new_str;}sub trim_string{my$w=shift;
$w=~s/^\s+//;
$w=~s/\s+$//;
$w=~s/\s+/ /g;
return$w;}sub lazy_file_create{my($file,$content)=@_;
my$r="/tmp/".$$.int(rand(10000));
if(open(F,"> $r")){$content||="";
print F$content;
close(F);
&move($r,$file);}}sub external_print{my$cfg=shift;
my$cnt=shift;
my$prefix=shift;
my$dont_print=shift;
my$station=shift;
my$pdf_only=shift;
$prefix||="";
$prefix=~s/\//_/g if$prefix;
my$r="_".$$.int(rand(100));
my$file_html="/tmp/".$prefix.$r.".html";
my$file_pdf="/tmp/".$prefix.$r.".pdf";
$cnt=encode("iso8859-1",decode("utf8",$cnt));
open(F,"> $file_html");
print F$cnt;
close(F);
$file_pdf=~s/\://g;
$file_pdf=~s/\s/_/g;
_pdf_gen($file_html,$file_pdf);
if($pdf_only==0){$dont_print||=0;
if(!$dont_print){if($cfg->{STATION_NUMBER}!=$station){print STDERR"Will send PDF $file_pdf to station $station...\n";
my$r=int(rand(10000));
&move($file_pdf,"/opt/pos/server/data/tmp/pdf_to_station_print#$station#".time."#$r.pdf");}else{system("lpr \"$file_pdf\"");}}}unlink($file_html);}sub process_barcode{my($machine,$file)=@_;
if(open(F,"< $file")){local$/=undef;
my$barcode=<F>;
close(F);
_send_barcode_to_ui($barcode);
unlink$file;}}sub points_customer_statement{my($machine,$file)=@_;
my$cfg=$machine->config()->load_fixed();
return 2 unless$cfg->{STATION_NUMBER}eq '0';
$cfg->{POINTS_USAGE}||=0;
$cfg->{POINTS_VALUE_PER_POINT}||=0;
$cfg->{POINTS_VALUE_PER_POINT_ON_SALE}||=1;
my($station,$clerk,$customer_id)=$file=~/points_customer_statement#(.*?)#(.*?)#(.*?)\.txt$/;
my$db=$machine->database();
&get_clerks_information($db);
my$points=$db->select("SELECT id, name, city, postal_code, address, points FROM customers WHERE id = ?",$customer_id,);
my$actual_points=0;
my$actual_points_value=0;
my$name="";
my$city="";
my$postal_code="";
my$address="";
my$sales=[];
if(scalar@$points){$actual_points=$points->[0]->{points}||0;
$actual_points_value=$actual_points*$cfg->{POINTS_VALUE_PER_POINT_ON_SALE};
$address=$points->[0]->{address}||"";
$city=$points->[0]->{city}||"";
$postal_code=$points->[0]->{postal_code}||"";
$name=$points->[0]->{name}||"";
$sales=$db->select(qq{
      SELECT sha1.key_value AS points_used, sh.business_date, sh.value, sh.id, sh.hour, sh.fo_doc_number,
        sha2.key_value AS points_assigned
      FROM sales_headers sh
      LEFT JOIN sales_headers_aux sha1 ON (sh.id = sha1.header AND sha1.key_name = 'points_used')
      LEFT JOIN sales_headers_aux sha2 ON (sh.id = sha2.header AND sha2.key_name = 'points_assigned')
      WHERE sh.customer_id = ?
      ORDER BY sh.id DESC
    },$customer_id);}my%info=();
my$content="";
$info{date}=&strftime("%Y-%m-%d",localtime);
$info{hour}=&strftime("%H:%M:%S",localtime);
$info{datetime}=&strftime("%Y-%m-%d %H:%M:%S",localtime);
$info{station}=$station;
$info{clerk_code}=$clerk;
$info{clerk_name}=exists$CLERKS_INFO->{$clerk}?$CLERKS_INFO->{$clerk}->{login}:'<UNKNOWN>';
$info{customer_points}=$actual_points;
$info{customer_points_value}=$actual_points_value;
$info{customer_address}=$address;
$info{customer_name}=$name;
$info{customer_city}=$city;
$info{customer_postal_code}=$postal_code;
$info{records}=$sales;
if(!defined$TEMPLATE){$TEMPLATE=&_get_template_obj($machine);}$info{i18n}=sub{&translate($machine,shift)};
$TEMPLATE->process('report_points_customer.tmpl',\%info,\$content,)||die$TEMPLATE->error;
return unless$REAL_PRINT;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$content;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub sms_report{my($machine,$file)=@_;
my$cfg=$machine->config()->load_fixed();
return 2 unless$cfg->{STATION_NUMBER}eq '0';
my$NIF=$cfg->{SAFT_TaxRegistratioNumber}||0;
my$biz_name=$cfg->{SAFT_BusinessName}||"";
my$SMS_PHONE=$cfg->{SMS_PHONE}||"";
my$USE_SMS=$cfg->{USE_SMS}||0;
return unless$USE_SMS;
my($date,$clerk,$t_total,$nt_total,$m_id)=$file=~/sms_report#(.*?)#(.*?)#(.*?)#(.*?)#(.*?)\.txt$/;
my$sales_details=0;
my$clerk_filter=0;
my%selections=();
my$type='01_daily_simple';
my$info=_data_for_report($machine,$clerk,$cfg->{STATION_NUMBER},$date,$date,$clerk_filter,$sales_details,\%selections,$type);
return unless scalar%$info;
if(!-d"/opt/pos/server/data/sms"){mkdir"/opt/pos/server/data/sms";}my$t_wo_vat=$info->{sales_vat}->{total_wo_vat}||0;
my$t_w_vat=$info->{sales_vat}->{total}||0;
$t_total||=0;
$nt_total||=0;
my$r=rand(10000);
my$str=$SMS_PHONE?"&phone=$SMS_PHONE":"";
open(F,"> /opt/pos/server/data/sms/$r.txt");
print F"http://pos.m.net-bo.com/eod_send?t_wo_vat=$t_wo_vat&t_w_vat=$t_w_vat&t_total=$t_total"."&nt_total=$nt_total&m_id=$m_id&biz_date=$date&biz_name=".uri_escape(my_conv($biz_name))."&nif=$NIF&date_gen=".uri_escape(&strftime("%Y:%m:%d %H:%M:%S",localtime))."$str\n";
close(F);
_flush_msgs("/opt/pos/server/data/sms");}sub _flush_msgs{my$d=shift;
$ua->timeout(15);
&find(sub{return unless-f$File::Find::name;
local$/=undef;
open(F,"< $File::Find::name");
my$cnt=<F>;
$cnt=~s/\n//g;
close(F);
if(!$cnt){unlink$File::Find::name;
return;}print STDERR"WILL TRY: $_\n";
my$res=get($cnt);
$res||="";
print STDERR"SMS URL: $cnt\n";
if($res eq 'OK'){print STDERR"SENT - $File::Find::name\n";
unlink$File::Find::name;}else{print STDERR"$_ - ERROR SENDING, WILL REMOVE IT...\n";
unlink$File::Find::name;}},($d));}sub process_shutdown{my($machine,$file)=@_;
my($station)=$file=~/shutdown#(\d+)\./;
my$cfg=$machine->config()->load_fixed();
if($station!=$cfg->{STATION_NUMBER}){return 2;}system('/sbin/shutdown -h now "Power button pressed"');}sub process_scale{my($machine,$file)=@_;
if(open(F,"< $file")){local$/=undef;
my$barcode=<F>;
close(F);
_send_scale_to_ui($barcode);
unlink$file;}}sub pdf_to_station_print{my($machine,$file)=@_;
my($station)=$file=~/pdf_to_station_print#(\d+)#/;
my$cfg=$machine->config()->load_fixed();
if($station!=$cfg->{STATION_NUMBER}){return 2;}print STDERR"Will print PDF - $file\n";
system("lpr \"$file\"");}sub set_owner_information{my$machine=shift;
my$h=shift;
if(!scalar keys%OWNER_INFO_CACHE){my$config;
if($machine->is_server()){$config=$machine->config();}else{$config=$machine->server_config();}my$cfg=$config->load_fixed();
$cfg->{SAFT_CompanyName}||="SAFT_CompanyName";
$cfg->{SAFT_AddressDetail}||="SAFT_AddressDetail";
$cfg->{SAFT_PostalCode}||="SAFT_PostalCode";
$cfg->{SAFT_City}||="SAFT_City";
$cfg->{SAFT_TaxRegistratioNumber}||="SAFT_TaxRegistratioNumber";
$cfg->{SAFT_CompanyId}||="SAFT_CompanyId";
$cfg->{SAFT_Country}||="SAFT_Country";
$OWNER_INFO_CACHE{owner_company_name}=$cfg->{SAFT_CompanyName};
$OWNER_INFO_CACHE{owner_business_name}=$cfg->{SAFT_BusinessName};
$OWNER_INFO_CACHE{owner_address}=$cfg->{SAFT_AddressDetail};
$OWNER_INFO_CACHE{owner_postal_code}=$cfg->{SAFT_PostalCode};
$OWNER_INFO_CACHE{owner_city}=$cfg->{SAFT_City};
$OWNER_INFO_CACHE{owner_nif}=$cfg->{SAFT_TaxRegistratioNumber};
$OWNER_INFO_CACHE{owner_company_id}=$cfg->{SAFT_CompanyId};
$OWNER_INFO_CACHE{owner_country}=$cfg->{SAFT_Country};}foreach my $k(keys%OWNER_INFO_CACHE){$h->{$k}=$OWNER_INFO_CACHE{$k};}}sub clerk_cashdrawer_decode{my$machine=shift;
my($station,$clerk,$manual,$pnum)=@_;
if(exists$CLERKS_DRAWER->{$clerk}){my$cfg=$machine->config()->load_fixed();
$cfg->{IGNORE_CLERK_DRAWER}||=0;
if($cfg->{IGNORE_CLERK_DRAWER}){return 1;}my@a=split/,/,$CLERKS_DRAWER->{$clerk};
if(scalar@a==3){my($new_station,$new_printer,$new_drawer_num)=@a;
my$dir_server_tmp=$machine->server_dir_tmp();
$new_printer--;
my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$business_date=&date_based_on_closing_hour($date,$CLOSE_HOUR);
my$r=int(rand(10000));
my$new_file="$dir_server_tmp/drawer#$new_station#$clerk#$manual#$new_printer#$new_drawer_num#1#".$business_date."#".time."$r.txt";
&lazy_file_create($new_file,1);
return undef;}elsif(scalar@a==2){my($new_station,$new_drawer_num)=@a;
my$dir_server_tmp=$machine->server_dir_tmp();
my$new_printer=9999;
my$date=&strftime("%Y-%m-%d %H:%M:%S",localtime);
my$business_date=&date_based_on_closing_hour($date,$CLOSE_HOUR);
my$r=int(rand(10000));
my$new_file="$dir_server_tmp/drawer#$new_station#$clerk#$manual#$new_printer#$new_drawer_num#1#".$business_date."#".time."$r.txt";
&lazy_file_create($new_file,1);
return undef;}}return 1;}sub x64_txt_message{my($line1,$line2)=@_;
$line1||="";
$line2||="";
if($line1){$line1=substr($line1,0,16);
$line1=sprintf("%-16s",$line1);}if($line2){$line2=substr($line2,0,16);
$line2=sprintf("%-16s",$line2);}return$line1.$line2;}sub x64_log{my$msg=shift;
my$datetime=&strftime("%Y%m%d_%H%M%S",localtime);
open(FF,">> /root/logs/x64.log");
print FF"[$datetime] $msg\n";
close(FF);}sub kitchen_monitor_save_products{my($machine,$info,$zone,$products,$folder_name)=@_;
$zone=$folder_name if defined$folder_name;
my$dir=$machine->dir_server().'/server/data/kitchen_terminal/'.$zone;
system("mkdir -p \"$dir\"")unless-d$dir;
my$had_new=0;
my$file=$dir.'/'.sprintf("%06d",$info->{request_number});
open(FF,"> $file");
print FF$products->[0]->{clerk_name}."#".$info->{hour}."\n";
print FF$info->{area_name}."#".$info->{check_number}."#".$products->[0]->{station}."\n\n";
foreach my $p(@$products){$p->{notes}||=[];
my$name=$p->{product_name};
if(scalar@{$p->{notes}}){$name=$p->{notes}->[0];}my$type=0;
$type=1 if$p->{is_extra};
$type=2 if$p->{is_menu};
print FF$p->{quantity}."#".$type."#".$name."§".$p->{product_code}."#".$p->{key}."\n";
$had_new=1;}close(FF);
if($had_new==1){open(NNN,"> $file.new");
print NNN"1\n";
close(NNN);}}sub kitchen_monitor_void_products{my($machine,$info,$zone,$products,$folder_name)=@_;
$zone=$folder_name if defined$folder_name;
my$db=$machine->database();
my$products_requested_req_number=App::POS::Counters->new(db=>$db,name=>'products_requested_req_number',);
my$dir=$machine->dir_server().'/server/data/kitchen_terminal/'.$zone;
system("mkdir -p \"$dir\"")unless-d$dir;
my%did=();
foreach my $p(@$products){next if exists$did{$p->{key}};
$did{$p->{key}}=1;
$p->{notes}||=[];
my$name=$p->{product_name};
if(scalar@{$p->{notes}}){$name=$p->{notes}->[0];}my$type=0;
$type=1 if$p->{is_extra};
$type=2 if$p->{is_menu};
my$original_request=$products_requested_req_number->cur_value($p->{key});
my$file=$dir.'/'.sprintf("%06d",$original_request);
my@to_add_end=();
my@lines=();
if(open(FF,"< $file")){while(<FF>){chop;
my@t=split/#/;
if(scalar@t&&$p->{key}eq$t[-1]){if($p->{quantity}<=$t[0]*1){$t[0]-=$p->{quantity};
push@lines,\@t if$t[0]>0;
my@new=@t;
$new[0]=$p->{quantity}*-1;
push@to_add_end,\@new;}else{push@lines,\@t;}}else{push@lines,\@t;}}close(FF);}for(@to_add_end){push@lines,$_;}open(FF,"> $file");
for(@lines){my$line=join("#",@$_);
print FF$line."\n";}close(FF);
open(FF,">> $file.changed");
print FF"1\n";
close(FF);}}sub kitchen_monitor_set_printed_or_payed{my($machine,$unique_id,$operation)=@_;
my$db=$machine->database();
my$kitchen_monitor_zones=$machine->config()->pzones_with_kitchen_monitor();
return unless scalar keys%$kitchen_monitor_zones;
my$request_numbers_checks=App::POS::Counters->new(db=>$db,name=>'request_numbers_checks',);
my%folders=();
foreach my $zone(keys%$kitchen_monitor_zones){if(!ref($kitchen_monitor_zones->{$zone})){$folders{$zone}=1;}else{my@val=values%{$kitchen_monitor_zones->{$zone}};
map{$folders{$_}=1}@val;}}my$requests=$request_numbers_checks->cur_value($unique_id);
return unless defined$requests;
my@reqa=split/,/,$requests;
my%reqh=map{sprintf("%06d",$_)=>1}@reqa;
foreach my $zone(keys%folders){my$dir=$machine->dir_server().'/server/data/kitchen_terminal/'.$zone;
system("mkdir -p \"$dir\"")unless-d$dir;
my@files=&read_dir($dir);
foreach my $file(@files){if(exists$reqh{$file}){open(F,"> $dir/$file.$operation");
print F"1\n";
close(F);
open(F,"< $dir/$file");
open(C,"> /tmp/req.tmp");
my$c=0;
while(<F>){my$line;
if($c==1&&$operation eq 'payed'){s/\n//;
$line=$_."#$operation\n";}else{$line=$_;}print C$line;
$c++;}close(F);
close(C);
&move("/tmp/req.tmp","$dir/$file");
open(F,"> $dir/$file.changed");
print F"1\n";
close(F);}}}}sub running_business_date{my$machine=shift;
my$biz_date_file=$machine->dir_server()."/.business_date";
my$biz_date=undef;
if(-e$biz_date_file){local$/=undef;
open(F,"< $biz_date_file");
$biz_date=<F>;
chop($biz_date);
close(F);}return$biz_date;}sub _add_to_document_history{my($db,$info,$check)=@_;
my%control=();
my$h=$info->{headers}||{};
return unless exists$DOCS_TO_HISTORY{$h->{doc_type}};
return if$h->{customer_nif}eq '999999990'||$h->{customer_nif}eq ''||$h->{customer_nif}eq '0';
my$date=$h->{business_date};
my$amount_payed=0;
my$doc_value=$h->{value};
$doc_value*=-1 if$h->{doc_type}==8||$h->{doc_type}==35;
if($h->{doc_type}==8||$h->{doc_type}==35){$info->{docs_payed}||=[];
foreach my $doc(@{$info->{docs_payed}}){next if exists$control{$doc->{gb_identifier}};
my$v=$doc->{doc_value}*1;
$db->do(qq{
        UPDATE document_history
        SET amount_payed = amount_payed + $v
        WHERE gbi = ? AND doc_type <> 5
      },$doc->{gb_identifier});
$control{$doc->{gb_identifier}}=1;}}elsif($h->{doc_type}==5||$h->{doc_type}==90){$amount_payed=$doc_value;}elsif($h->{doc_type}==30||$h->{doc_type}==31||$h->{doc_type}==32||$h->{doc_type}==33||$h->{doc_type}==34){$date=$check->{data}->{extra_data}->{supplier_doc_date};}elsif($h->{doc_type}==7){my$invoice_is_payed=$check->{data}->{extra_data}->{invoice_is_payed}||'0';
$amount_payed=$doc_value if$invoice_is_payed;}my@params=($db->next_id("document_history"),$h->{id},$h->{__unique_id},$h->{customer_nif},$date,$h->{doc_type},$h->{fo_doc_number},&my_round($doc_value),&my_round($amount_payed));
$db->copy_to(qq{
    COPY document_history (id, header, gbi, nif, doc_date, doc_type, fo_doc_number, doc_value, amount_payed)
    FROM stdin
  },@params);}sub _serial_port_status{my$port=shift;
my$status=$port->modemlines;
printf STDERR ("Modem status = 0x%04X (DTR=%s CTS=%s RTS=%s DSR=%s RNG=%s CD=%s)\n",$status,($status& MS_DTR_ON)?"ON ":"off",($status& MS_CTS_ON)?"ON ":"off",($status& MS_RTS_ON)?"ON ":"off",($status& MS_DSR_ON)?"ON ":"off",($status& MS_RING_ON)?"ON ":"off",($status& MS_RLSD_ON)?"ON ":"off",);}sub get_cashier_names{my$machine=shift;
die"Missing 'machine' parameter..." unless defined$machine;
return if scalar%CASHIER_NAMES;
my$cfile=$machine->dir_server().'/etc/config.ini';
open(F,"< $cfile");
while(<F>){chop;
if(/^CASHIERS=/){my$l=$_;
$l=~s/^CASHIERS=//;
my@t=split/,/,$l;
$CASHIER_NAMES{$t[0]}=$t[1];}}}sub string_normalize{my$str=shift;
$str=~tr/áéíóúàèìòùâêîôûãõç/aeiouaeiouaeiouaoc/;
$str=~tr/ÁÉÍÓÚÀÈÌÒÙÂÊÎÔÛÃÕÇ/AEIOUAEIOUAEIOUAOC/;
return$str;}sub calcEAN13CD{my($sTxt)=@_;
my($i,$iSum);
my@aWeight=(1,3,1,3,1,3,1,3,1,3,1,3);
$iSum=0;
for($i=0;$i<12;$i++){$iSum+=substr($sTxt,$i,1)*$aWeight[$i];}$iSum%=10;
$iSum=($iSum==0)?0:(10-$iSum);
return"$iSum";}sub _decode_delivery_info{my$db=shift;
my$data=shift;
my$info={delivery_notes=>[]};
$data->{extra_data}->{delivery_info}||="";
return$info unless$data->{extra_data}->{delivery_info};
$data->{header}||=[];
if(scalar@{$data->{header}}){my$nif=$data->{header}->[13]||"";
if($nif){my$rec=$db->select("SELECT * FROM customers WHERE deleted = 0 AND nif = ? ORDER BY deleted",$nif);
$info->{customer}=$rec->[0]if scalar@$rec;}}my$str=$data->{extra_data}->{delivery_info};
my@recs=split/»«/,$str;
for(@recs){my@a=split/;/;
if(scalar@a>=2){push@{$info->{delivery_notes}},{name=>$a[0],value=>$a[1]};}}return$info;}sub _get_doc_origin{my($machine,$headers,$relations)=@_;
my$r=[];
my$term=&translate($machine,"Origem");
my$db=$machine->database();
my%valid_docs=(1=>1,5=>1,90=>1,7=>1,2=>1,13=>1,33=>1,15=>1,);
my%lines_idx=();
if(%$relations){my@a=values%$relations;
map{$lines_idx{$_->{gbi}}=$_->{idx}}@a;}if(exists$valid_docs{$headers->{doc_type}}){my$recs=$db->select(qq{
      SELECT sh.fo_doc_number, sh.business_date, sh.gb_identifier
      FROM document_operations doco
      LEFT JOIN sales_headers sh ON (sh.gb_identifier = doco.source_gb_identifier)
      WHERE doco.dest_gb_identifier = ?
    },$headers->{gb_identifier});
for(@$recs){my$str=$term.": ".$_->{business_date}." ".$_->{fo_doc_number};
$str.=" [".$lines_idx{$_->{gb_identifier}}."]" if exists$lines_idx{$_->{gb_identifier}};
push@$r,$str;}}return$r;}sub _get_doc_bills{my($machine,$headers)=@_;
my$r=[];
my$term=&translate($machine,"Origem");
my$db=$machine->database();
my%valid_docs=(1=>1,5=>1,90=>1,7=>1,);
if(exists$valid_docs{$headers->{doc_type}}){my$recs=$db->select(qq{
      SELECT fo_doc_number, business_date
      FROM sales_hashes
      WHERE gb_identifier_header = ? AND (doc_type = 6 OR doc_type = 9)
    },$headers->{gb_identifier});
for(@$recs){push@$r,$term.": ".$_->{fo_doc_number}." - ".$_->{business_date};}$recs=$db->select(qq{
      SELECT sl.*, sh.fo_doc_number, sh.business_date
      FROM split_docs_link sl
      LEFT JOIN sales_hashes sh ON (sl.gbi_old = sh.gb_identifier_header)
      WHERE sl.gbi_new = ? AND sh.doc_type = 6
    },$headers->{gb_identifier});
for(@$recs){push@$r,$term.": ".$_->{fo_doc_number}." - ".$_->{business_date};}}return$r;}sub _print_file{my($machine,$station,$str)=@_;
my($print_file,$station_to_print)=&_find_file_to_print(machine=>$machine,station=>$station,);
if(defined$print_file){open(F,"> $print_file");
print F$str;
close(F);}else{print STDERR"ERROR! CAN'T FIND PRINTER TO USE!\n";}}sub _send_barcode_to_ui{my$barcode=shift;
my$sock=IO::Socket::INET->new(PeerAddr=>'127.0.0.1',PeerPort=>'8088',Proto=>'tcp',Timeout=>5,);
print$sock "#BARCODE#$barcode\n";
$sock->close();}sub _send_scale_to_ui{my$barcode=shift;
my$sock=IO::Socket::INET->new(PeerAddr=>'127.0.0.1',PeerPort=>'8088',Proto=>'tcp',Timeout=>5,);
print$sock "#SCALE#$barcode\n";
$sock->close();}sub _send_product_request_to_ui{my($machine,$station,$clerk,$area,$table,$product,$qty)=@_;
my$cfg=$machine->config()->load_fixed();
my$sock=IO::Socket::INET->new(PeerAddr=>$machine->is_server()?'127.0.0.1':$cfg->{NETWORK_SERVER_IP},PeerPort=>'8088',Proto=>'tcp',Timeout=>5,);
print$sock "#PRODUCT_REQUEST#$station#$clerk#$area#$table#$product#$qty\n";
$sock->close();}sub _read_queue_number{my($machine,$name)=@_;
my$dir_server_data=$machine->server_dir_data();
my$queue_file="$dir_server_data/queues/$name.txt";
return 0 unless-e$queue_file;
if(open(F,"< $queue_file")){local$/=undef;
my$num=<F>;
$num=~s/\n//g;
close(F);
return$num;}return 0;}sub _replace_saft_tags{my$cfg=shift;
my$cnt_ref=shift;
my@saft_tags=qw/
  SAFT_BusinessName SAFT_CompanyName SAFT_CompanyId SAFT_AddressDetail
  SAFT_PostalCode SAFT_City SAFT_TaxRegistratioNumber
  /;
foreach my $tag(@saft_tags){my$v=$cfg->{$tag}||"";
$$cnt_ref=~s/\@$tag\@/$v/g if$v;}}sub _file_md5{my$f=shift;
my$cnt="";
if(open(F,"< $f")){local$/=undef;
$cnt=<F>;
close(F);}return md5_hex($cnt);}sub _pdf_gen{my($html_f,$pdf_f)=@_;
return undef unless defined$html_f&&defined$pdf_f;
my$r1=$$.int(rand(10000));
my$r2=$$.int(rand(10000));
my$pdf_tmp="/opt/pos/common/tmp/$r1.pdf";
system("export DISPLAY=:0.0 ; wkhtmltopdf --page-size A4 \"$html_f\" \"$pdf_tmp\"");
unlink($html_f);
if(-e"/usr/bin/pdftk"){my$cmd="/usr/bin/pdftk \"".$pdf_tmp."\" output /opt/pos/common/tmp/$r2.pdf owner_pw $r2";
system($cmd);
move("/opt/pos/common/tmp/$r2.pdf",$pdf_f);}else{move($pdf_tmp,$pdf_f);}return 1;}1;
