package App::POS::Hardware::CustomerDisplays::VFD;

use strict;
use warnings;
use Time::HiRes qw( usleep );

use base qw( App::POS::Hardware::CustomerDisplays );

sub type { "SERIAL" }

sub init {
  my $self = shift;
}

sub write {
  my $self = shift;
  my $str = shift || undef;
  return unless defined $str;

  my $port = $self->serial_obj();

  if (! defined $port) {
    print STDERR "port is not defined, returning...\n";
    return;
  }

  my( $str1, $str2 ) = $self->_text_process($str, 20, 20);
  #print STDERR "STR1 : #$str1# #".length($str1)."#\n";
  #print STDERR "STR2 : #$str2# #".length($str2)."#\n";

  # clean display
  #my $count_out = $port->write(chr(0x0D));
  #usleep(2000);

  usleep(10000);

  # write to display
  if ($str1) {
    my @chars = split //, $str1;
    for (@chars) {
      $port->write($_);
      usleep(2000);
    }
  }

  if ($str2) {
    my @chars = split //, $str2;
    for (@chars) {
      $port->write($_);
      usleep(2000);
    }
  }
}

1;
