package App::POS::Hardware::CustomerDisplays::TOSHIBA_C10;

use strict;
use warnings;
use Time::HiRes qw( usleep );

use base qw( App::POS::Hardware::CustomerDisplays );

sub type { "SERIAL" }

sub init {
  my $self = shift;
}

sub write {
  my $self = shift;
  my $str = shift || undef;
  return unless defined $str;

  my $port = $self->serial_obj();

  if (! defined $port) {
    print STDERR "port is not defined, returning...\n";
    return;
  }

  my( $str1, $str2 ) = $self->_text_process($str, 20, 20);
  #print STDERR "STR1 : #$str1# #".length($str1)."#\n";
  #print STDERR "STR2 : #$str2# #".length($str2)."#\n";

  my $crlf = chr(0x0D).chr(0x0A);
  my $lfcr = chr(0x0A).chr(0x0D);

  my $clear = chr(0x1B).chr(0x5B).chr(0x32).chr(0x4A);
  $port->write($clear);
  usleep(2000);

  my $pos = &_set_pos(1, 5);
  $port->write($pos);
  usleep(2000);

  $port->write($str1.$crlf);
  usleep(2000);
  $port->write($str2.$crlf);
  usleep(2000);

}

sub _set_pos {
  my $lin = shift ;
  my $col = shift;
  return chr(0x1B).chr(0x5B).chr($lin).chr(0x3B).chr($col).chr(0x48);
}

1;

__END__
#
#  Toshiba C10 com display de 4x20 carateres
#  Port=COM2  8 databits  parity=odd  1 stopbit  baudrate =115200
#
my $clear_display = chr(0x1B).chr(0x5B).chr(0x32).chr(0x4A);
my $clear_2_end_of_line = chr(0x1B).chr(0x5B).chr(0x30).chr(0x4B); 
my $cursor_off = chr(0x1B).chr(0x5C).chr(0x3F).chr(0x4C).chr(0x043).chr(0x00);
my $cursor_blink = chr(0x1B).chr(0x5C).chr(0x3F).chr(0x4C).chr(0x043).chr(0x01);
my $cursor_full = chr(0x1B).chr(0x5C).chr(0x3F).chr(0x4C).chr(0x043).chr(0x02);
my $cr = chr(0x0D);
my $lf = chr(0x0A)


sub dimming {
  my $str = shift ;
  if ($str > 35 || $str < 30) {
    return "";
  } else { 
    return chr(0x1B).chr(0x5C).chr(0x3F).chr(0x4C).chr(0x044).chr($str);
}

sub set_pos {
  my $lin = shift ;
  my $col = shift;
  return chr(0x1B).chr(0x5B).chr($lin).chr(0x3B).chr($col).chr(0x48);
}
