package App::POS::Hardware::CustomerDisplays::TOSHIBA;

use strict;
use warnings;
use Time::HiRes qw( usleep );

use base qw( App::POS::Hardware::CustomerDisplays );

sub type { "SERIAL" }

sub init {
  my $self = shift;
}

sub write {
  my $self = shift;
  my $str = shift || undef;
  return unless defined $str;

  my $port = $self->serial_obj();

  if (! defined $port) {
    print STDERR "port is not defined, returning...\n";
    return;
  }

  my( $str1, $str2 ) = $self->_text_process($str, 20, 20);
  #print STDERR "STR1 : #$str1# #".length($str1)."#\n";
  #print STDERR "STR2 : #$str2# #".length($str2)."#\n";

  # clean display
  my $cols = 20;

  $port->write(chr(27).chr(91).chr(49).chr(59).chr(49).chr(72));

  for (my $i=0; $i<$cols; $i++) {
    my $count_out = $port->write(chr(32));
    usleep(2000);
  }

  $port->write(chr(27).chr(91).chr(50).chr(59).chr(49).chr(72));

  for (my $i=0; $i<$cols; $i++) {
    my $count_out = $port->write(chr(32));
    usleep(2000);
  }

  usleep(10000);

  # write to it
  if ($str1) {
    $port->write(chr(27).chr(91).chr(49).chr(59).chr(49).chr(72));
    usleep(1000);
    my @chars = split //, $str1;
    for (@chars) {
      $port->write($_);
      usleep(2000);
    }
  }

  if ($str2) {
    $port->write(chr(27).chr(91).chr(50).chr(59).chr(49).chr(72));
    usleep(1000);
    my @chars = split //, $str2;
    for (@chars) {
      $port->write($_);
      usleep(2000);
    }
  }
}

1;

