package App::POS::Hardware::CustomerDisplays::CCTV;

use strict;
use warnings;
use Time::HiRes qw( usleep );

use base qw( App::POS::Hardware::CustomerDisplays );

sub type { "SERIAL" }

sub init {
  my $self = shift;
}

sub write {
  my $self = shift;
  my $str = shift || undef;
  return unless defined $str;

  my $port = $self->serial_obj();

  if (! defined $port) {
    print STDERR "port is not defined, returning...\n";
    return;
  }

  my( $str1, $str2 ) = $self->_text_process($str, 20, 20);
  #print STDERR "STR1 : #$str1# #".length($str1)."#\n";
  #print STDERR "STR2 : #$str2# #".length($str2)."#\n";

  if ($str1) {
    $port->write($str1."\n")
    #my @chars = split //, $str1;
    #for (@chars) {
    #  $port->write($_);
    #  usleep(2000);
    #}
  }

  usleep(5000);

  if ($str2) {
    $port->write($str2."\n")
    #my @chars = split //, $str2;
    #for (@chars) {
    #  $port->write($_);
    #  usleep(2000);
    #}
  }
}

1;

