package App::POS::Hardware::CustomerDisplays::BLEEP750;

use strict;
use warnings;
use Time::HiRes qw( usleep );

use base qw( App::POS::Hardware::CustomerDisplays );

sub type { "SERIAL" }

sub init {
  my $self = shift;
}

sub write {
  my $self = shift;
  my $str = shift || undef;
  return unless defined $str;

  my $port = $self->serial_obj();

  if (! defined $port) {
    print STDERR "port is not defined, returning...\n";
    return;
  }

  my( $str1, $str2 ) = $self->_text_process($str, 20, 19);
  #print STDERR "STR1 : #$str1# #".length($str1)."#\n";
  #print STDERR "STR2 : #$str2# #".length($str2)."#\n";

  $port->write(chr(0x1F));             # reset display
  usleep(2000);
  $port->write(chr(0x04).chr(0xFF));   # full brightness
  usleep(2000);
  $port->write(chr(0x10));             # reset display
  usleep(2000);

  chop($str1);
  my @chars = split //, $str1;

  $port->write(chr(0x10).chr(0x00));   # first char of first line
  usleep(4000);

  for (@chars) {
    $port->write($_); # write to it
    usleep(2000);
  }

  usleep(4000);
  $port->write(chr(0x10).chr(0x14));   # first char of second line
  usleep(4000);

  chop($str2);
  @chars = split //, $str2;
  
  #print STDERR "##> #$str1#\n";
  #print STDERR "##> #$str2#\n";

  for (@chars) {
    $port->write($_); # write to it
    usleep(2000);
  }
}

1;

