package App::POS::Hardware::CustomerDisplays::AUDITORNOVA;

use strict;
use warnings;
use Time::HiRes qw( usleep );

use base qw( App::POS::Hardware::CustomerDisplays );

sub type { "SERIAL" }

sub init {
  my $self = shift;
}

sub write {
  my $self = shift;
  my $str = shift || undef;
  return unless defined $str;

  my $port = $self->serial_obj();

  if (! defined $port) {
    print STDERR "port is not defined, returning...\n";
    return;
  }

  my( $str1, $str2 ) = $self->_text_process($str, 20, 20);
  #print STDERR "STR1 : #$str1# #".length($str1)."#\n";
  #print STDERR "STR2 : #$str2# #".length($str2)."#\n";

  #my $count_out = $port->write(chr(0x1F).chr(0x58)."4");
  my $count_out = $port->write(chr(0x1B).chr(0x40));
  usleep(2000);

  usleep(10000);

  # write to display
  if ($str1) {
    $count_out = $port->write(chr(0x1B).chr(0x51).chr(0x41).$str1);
    usleep(20000);
  }

  if ($str2) {
    $count_out = $port->write(chr(0x1B).chr(0x51).chr(0x42).$str2);
    usleep(20000);
  }
}

1;
