package App::POS::Hardware::CustomerDisplays;

use strict;
use warnings;
use POSIX qw( strftime );
use App::POS::Utils qw( chars );

use base qw( App::Class );

sub init {
  my $self = shift;
  my %a = ( info => undef, @_ );

  die "Missing 'info' parameter..." unless defined $a{info};
  $self->{info} = $a{info};
}

sub info {
  my $self = shift;
  @_ ? $self->{info} = shift : $self->{info};
}

sub serial_obj {
  my $self = shift;
  @_ ? $self->{config} = shift : $self->{config};
}

sub write { die "Must override the 'write' method..." }

sub _text_process {
  my $self = shift;

  my( $string, $nchars, $nchars_l2 ) = @_;

  my $str1 = "";
  my $str2 = "";

  $string ||= "";

  if (defined $string && $string) {
    my @toks = split /#/, $string;

    if (scalar @toks == 4) {
      $self->info->{TextCurrency} ||= 'T:';
      $self->info->{TextWeight} ||= 'KG:';

      my $name = substr($toks[0], 0, 15);
      my $pkg = $toks[1];
      my $p = $self->info->{TextCurrency} . " ". $toks[3];
      my $kg = $self->info->{TextWeight} . " " . $toks[2];

      if (length($name) < 10) {
        my $len = 10-length($name);
        $name = $name.(" " x $len);
      }
      else {
        $name = substr($name, 0, 10);
      }

      if (length($pkg) < 6) {
        my $len = 6-length($pkg);
        $pkg = (" " x $len).$pkg;
      }
      else {
        $pkg = substr($pkg, 0, 6);
      }

      if (length($p) < 10) {
        my $len = 10-length($p);
        $p = (" " x $len).$p;
      }
      else {
        $p = substr($p, 0, 10);
      }

      if (length($kg) < 10) {
        my $len = 10-length($kg);
        $kg = $kg.(" " x $len);
      }
      else {
        $kg = substr($kg, 0, 10);
      }

      $str1 = $name . $pkg;
      $str2 = $kg . $p;
    }
    #
    # product registration
    #
    elsif (scalar @toks == 3) {
      $self->info->{TextPrice} ||= "Q:";
      $self->info->{TextQuantity} ||= "P:";
      $self->info->{Hospitality} ||= 0;

      # name
      $toks[0] ||= "";

      # prod price & check total
      $toks[1] ||= "0";

      my @vals = split /,/, $toks[1];
      my( $prod_price, $check_total ) = ( $toks[1], 0 );
      ( $prod_price, $check_total ) = @vals if scalar @vals;

      # qtty
      $toks[2] ||= "0";
      $toks[2] =~ s/\.00$//;

      if ($self->info->{Hospitality}) {
        # no decimals
        if ($toks[2] =~ /\.000$/) {
          #XXXXXXXXXXXXXXXXXXXX
          #10 COCA COLA   12.12 
          $toks[2] =~ s/\.000$//;
          
          # qtd < 10
          if (length($toks[2]) == 1) {
            $str1 = sprintf("%-1s", $toks[2]) . " " . chars($toks[0], 11) . " " . sprintf("%6s", $prod_price);
          }
          else {
            $str1 = sprintf("%-2s", $toks[2]) . " " . chars($toks[0], 10) . " " . sprintf("%6s", $prod_price);
          }
        }
        # decimals
        else {
          # remove last 0, if exists
          $toks[2] = sprintf("%.2f", $toks[2]);
          $toks[2] =~ s/0$/ /;
          #XXXXXXXXXXXXXXXXXXXX
          #1.20 COCA COLA 12.12 
          $str1 = sprintf("%4s", $toks[2]) . sprintf("%-9s", chars($toks[0], 9)) . " " . sprintf("%6s", $prod_price);
        }
        
        #XXXXXXXXXXXXXXXXXXXX
        #TOTAL     XXXXXXXXXX (10)
        #print STDERR "#### COOL!!! - $prod_price - $check_total\n";

        $str2 = sprintf("%-11s", $self->info->{TextCheckTotal}) .
          sprintf("%9s", $check_total);
      }
      else {
        $str1 = substr($toks[0], 0, $nchars);
        my $tmp = $self->info->{TextPrice}." ".$prod_price." ".$self->info->{TextQuantity}." ".$toks[2];
        my $len = $nchars-length($tmp);
        $len = 1 unless $len > 1;
        $str2 = $self->info->{TextPrice}." ".$prod_price.(" " x $len)." ".$self->info->{TextQuantity}." ".$toks[2];
      }

      #print STDERR "#### #$str1#\n";
      #print STDERR "#### #$str2#\n";
    }
    #
    # idle
    #
    elsif (scalar @toks == 1) {
      $self->info->{TextIdle} ||= "";

      if ($self->info->{TextIdle}) {
        my @r = split /,/, $self->info->{TextIdle};
        my $time_str = &strftime("%Y-%m-%d %H:%M", localtime);
        my $date_str = &strftime("%Y-%m-%d", localtime);
        my $hour_str = &strftime("%H:%M", localtime);

        if (defined $r[0]) {
          $r[0] =~ s/\@DATETIME\@/$time_str/;
          $r[0] =~ s/\@DATE\@/$date_str/;
          $r[0] =~ s/\@HOUR\@/$hour_str/;
          $str1 = sprintf("%-".$nchars."s", $r[0]);
        }

        if (defined $r[1]) {
          $r[1] =~ s/\@DATETIME\@/$time_str/;
          $r[1] =~ s/\@DATE\@/$date_str/;
          $r[1] =~ s/\@HOUR\@/$hour_str/;
          $str2 = sprintf("%-".$nchars."s", $r[1]);
        }
      }
    }
    #
    # void
    #
    elsif (scalar @toks == 2) {
      $self->info->{TextVoided}      ||= "";
      $self->info->{TextCheckTotal}  ||= "TOTAL:";
      $self->info->{TextCheckChange} ||= "CHANGE:";

      $toks[0] ||= 0;
      $toks[1] ||= 0;

      if ($toks[0] eq 'VOID') {
        if ($self->info->{TextVoided} ne '') {
          $str1 = $self->info->{TextVoided} . " " x ($nchars-length($self->info->{TextVoided}));
          $str1 = substr($str1, 0, $nchars) if length($str1) > $nchars;
          $str2 = $toks[1] . " " x ($nchars-length($toks[1]));
          $str2 = substr($str2, 0, $nchars) if length($str2) > $nchars;
        }
      }
      elsif ($toks[0] eq 'CUSTOM') {
        if (length($toks[1]) > $nchars) {
          $str1 = substr($toks[1], 0, $nchars);
          $str2 = substr($toks[1], $nchars, $nchars_l2);
        }
        else {
          $str1 = $toks[1];
          $str2 = "";
        }
      }
      else {
        my $tmp = $self->info->{TextCheckTotal}." ".$toks[0];
        my $len = $nchars-length($tmp);
        $len = 1 unless $len > 1;
        $str1 = $self->info->{TextCheckTotal}." ".(" " x $len).$toks[0];

        $tmp = $self->info->{TextCheckChange}." ".$toks[1];
        $len = $nchars-length($tmp);
        $len = 1 unless $len > 1;
        $str2 = $self->info->{TextCheckChange}." ".(" " x $len).$toks[1];
      }
    }
    else {
      print STDERR "Unknown string to handle: $string\n";
    }
  }

  if (length($str1) > $nchars) {
    #print STDERR "#$str1#\n";
    #$str1 = sprintf("%-".$nchars."s", "*OVERFLOW*")
    $str1 = substr($str1, 0, $nchars);
  }
  elsif (length($str1) < $nchars) {
    my $diff = $nchars - length($str1);
    my $str = " " x $diff;
    $str1 .= $str;
  }

  if (length($str2) > $nchars) {
    #print STDERR "#$str2#\n";
    #$str2 = sprintf("%-".$nchars."s", "*OVERFLOW*")
    $str2 = substr($str2, 0, $nchars);
  }
  elsif (length($str1) < $nchars) {
    my $diff = $nchars - length($str2);
    my $str = " " x $diff;
    $str2 .= $str;
  }

  $str1 = sprintf("%-".$nchars."s", $str1);
  $str2 = sprintf("%-".$nchars_l2."s", $str2);

  return( $str1, $str2 );
}

1;

