package App::POS::Area;

use strict;
use warnings;
use FindBin qw( $Bin );
use File::Path qw( mkpath );
use File::Slurp qw( read_dir );
use File::Copy qw( copy move );
use Data::Dumper;

use base qw( App::Class );

sub init {
  my $self = shift;
  my %a = ( machine => undef, number => undef, @_ );

  $self->debug("init");

  die "Missing 'machine' parameter..." unless defined $a{machine};
  die "Missing 'number' parameter..." unless defined $a{number};

}

sub number {
  my $self = shift;
  return $self->{number};
}

sub machine {
  my $self = shift;
  return $self->{machine};
}

sub name {
  my $self = shift;
  return $self->{__name} if exists $self->{__name}; # cache
  $self->_extract_info_from_config();
  return $self->{__name};
}

sub tables_number {
  my $self = shift;
  return $self->{__tables_number} if exists $self->{__tables_number}; # cache
  $self->_extract_info_from_config();
  return $self->{__tables_number};
}

sub start_table {
  my $self = shift;
  return $self->{__start_table} if exists $self->{__start_table}; # cache
  $self->_extract_info_from_config();
  return $self->{__start_table};
}

sub is_splits {
  my $self = shift;
  return $self->{__is_splits} if exists $self->{__is_splits}; # cache
  $self->_extract_info_from_config();
  return $self->{__is_splits};
}

sub is_consumption {
  my $self = shift;
  return $self->{__is_consumption} if exists $self->{__is_consumption}; # cache
  $self->_extract_info_from_config();
  return $self->{__is_consumption};
}

sub is_suspend {
  my $self = shift;
  return $self->{__is_suspend} if exists $self->{__is_suspend}; # cache
  $self->_extract_info_from_config();
  return $self->{__is_suspend};
}

sub price_field {
  my $self = shift;
  return $self->{__price_field} if exists $self->{__price_field}; # cache
  $self->_extract_info_from_config();
  return $self->{__price_field};
}

sub vat_field {
  my $self = shift;
  return $self->{__vat_field} if exists $self->{__vat_field}; # cache
  $self->_extract_info_from_config();
  return $self->{__vat_field};
}

sub dir {
  my $self = shift;

  my $dir = $self->machine()->dir_server();
  return $dir."/server/data/areas/".$self->number();
}

sub checks {
  my $self = shift;

  my $dir = $self->dir();

  my @files = read_dir($dir);
  my @r = ();

  foreach my $f (@files) {
    next unless $f =~ /^(\d+)\.total$/;
    my $c = App::POS::Check->new( file => $dir."/$1" );
    push @r, $c;
  }

  return \@r;
}

sub checks_info {
  my $self = shift;

  my $dir = $self->dir();
  my @r = ();

  my @files = read_dir($dir);

  foreach my $f (sort @files) {
    next unless $f =~ /^(\d+)$/;
    my $c = App::POS::Check->new( file => $dir."/".$1, lazy => 1 );
    my $data = $c->data();

    push @r, {
      number => $f,
      is_locked => $c->is_locked(),
      is_holded => $c->is_holded(),
      value => $data->{header}->[19],
    };
  }

  return \@r;
}

sub check_totals {
  my $self = shift;

  my $dir = $self->dir();

  my @files = read_dir($dir);
  my %r = ();

  foreach my $f (@files) {
    next unless $f =~ /^(\d+)\.total$/;

    local $/ = undef;

    if (open(F, " < ".$dir."/$1.total")) {
      my $total = <F>;
      chop($total);
      $total ||= 0;
      close(F);

      $r{$1} = $total;
    }
  }

  return \%r;
}

#
# Internal methods
#

sub _extract_info_from_config {
  my $self = shift;

  my $cfg = $self->machine()->config()->load_fixed();
  $cfg->{AREA} ||= [];

  $self->{__name} = "NONAME";
  $self->{__tables_number} = 0;
  $self->{__is_splits} = 0;
  $self->{__start_table} = 1;
  $self->{__is_consumption} = 0;
  $self->{__is_suspend} = 0;
  $self->{__price_field} = 'sell_price1';
  $self->{__vat_field} = 'sell_vat1';

  for (my $i=0; $i<scalar @{$cfg->{AREA}}; $i++) {
    my @a = split /,/, $cfg->{AREA}->[$i];

    if (scalar @a) {
      $a[4] ||= "";
      $self->{__name} = $a[0];
      $self->{__tables_number} = $a[1] || 0;
      $self->{__start_table} = $a[6] if defined $a[6];
      $self->{__start_table} ||= 0;
      $self->{__is_splits} = 1 if $a[4] eq 'splits';
      $self->{__is_consumption} = 1 if $a[4] eq 'consumption';
      $self->{__is_suspend} = 1 if $a[4] eq 'suspend';
      $self->{__price_field} = $a[2] if $a[2];
      $self->{__vat_field} = $a[3] if $a[3];
    }

    last if $i == $self->number();
  }
}


1;

