package App::Class;

use strict;
use warnings;
use Data::Dumper;
use Digest::MD5 qw( md5_hex );

sub new {
  my $c = shift;
  my %a = ( @_ );

  my $s = bless {%a}, ref($c) || $c;

  $s->debug("new()");

  $s->init(%a);

  return $s;
}

sub init {}

sub dump {
  my $s = shift;
  my $r = shift;

  print STDERR Dumper($r);
}

sub debug {
  my $s = shift;
  my $m = shift || "";

  #print STDERR "[".ref($s)."] $m\n";
}

sub vfh {
  my $self = shift;

  my( $h, $k ) = @_;

  return undef unless exists $h->{$k};
  return $h->{$k} if defined $h->{$k} && $h->{$k} ne '';
  return undef;
}

sub directory_separator {
  my $self = shift;

  if ($^O eq 'MSWin32') {
    return "\\";
  } else {
    return '/';
  }
}

1;

