#!/bin/bash

DONT_EXECUTE_ITSELF=$1

PWD=`dirname $0`

disk_rw

rm /opt/bin/releases 2> /dev/null
ln -s /opt/pos/common/bin/releases /opt/bin/releases

cp $PWD/network.sh /opt/bin

# if db changes are published, apply them
if [ -e "/opt/pos/doc/db_changes.postgres" ]; then
  psql -U root pos < /opt/pos/doc/db_changes.postgres
  psql -U root pos < /opt/pos/doc/db_changes.postgres
  rm /opt/pos/doc/db_changes.postgres
fi

cp $PWD/postgresql.conf.close /etc/postgresql/9.1/main/postgresql.conf.close
cp $PWD/postgresql.conf.open /etc/postgresql/9.1/main/postgresql.conf.open

if [ ! -e "/usr/local/share/man/man3/Image::BMP.3pm" ]; then
  mkdir -p /usr/local/share/man/man3 2> /dev/null
  tar zxf $PWD/Image-BMP-1.17.tar.gz --directory /tmp
  cd /tmp/Image-BMP-1.17
  perl Makefile.PL
  make
  make install
fi

# this is the file we're using at the moment to check if *.deb needs to
# be installed
# install all avbl debs
dpkg -E -i $PWD/libdigest-hmac-perl_1.03+dfsg-1_all.deb
dpkg -E -i $PWD/*.deb
apt-get clean

cp $PWD/memcached.conf /etc/memcached.conf
/etc/init.d/memcached restart

HAS_SYSCTL=`cat /etc/sysctl.conf | grep tcp_tw_reuse`

if [ "$HAS_SYSCTL" = "" ]; then
  echo "net.ipv4.tcp_fin_timeout = 30" >> /etc/sysctl.conf
  echo "net.ipv4.tcp_tw_reuse = 1" >> /etc/sysctl.conf
  echo "net.ipv4.tcp_tw_recycle = 0" >> /etc/sysctl.conf
  echo "net.ipv4.tcp_keepalive_time = 300" >> /etc/sysctl.conf
  echo "net.ipv4.tcp_keepalive_probes =  3" >> /etc/sysctl.conf
  echo "net.ipv4.tcp_keepalive_intvl = 30" >> /etc/sysctl.conf
  echo "net.ipv4.tcp_syncookies = 1" >> /etc/sysctl.conf
  sysctl -a -p
fi

HAS_SYSCTL=`cat /etc/sysctl.conf | grep "net.ipv4.tcp_fin_timeout = 30"`

if [ "$HAS_SYSCTL" != "" ]; then
  perl -pi -e "s/net\.ipv4\.tcp_fin_timeout = 30/net.ipv4.tcp_fin_timeout = 2/g" /etc/sysctl.conf
  echo "net.ipv4.tcp_orphan_retries = 1" >> /etc/sysctl.conf
  sysctl -a -p
fi

if [ ! -e "/usr/local/share/man/man3/Email::Send::SMTP::Gmail.3pm" ]; then
  tar zxf $PWD/Email-Send-SMTP-Gmail-0.46.tar.gz --directory /tmp
  cd /tmp/Email-Send-SMTP-Gmail-0.46
  perl Makefile.PL
  make
  make install
fi

disk_ro

HAS_MCT_MODULES=`cat /etc/modules | grep mct_u232`

if [ "$HAS_MCT_MODULES" != "" ]; then
  disk_rw
  cat /etc/modules | grep -v mct_u232 > /tmp/ttt.txt
  mv /tmp/ttt.txt /etc/modules
  depmod -a
  disk_ro
  reboot
fi

#
# cleanup /etc/modules
#

HAS_MODULES=0
HAS_USBLP=`cat /etc/modules | grep usblp | grep -v grep`
HAS_USBSERIAL=`cat /etc/modules | grep usbserial | grep -v grep`

if [ "$HAS_USBLP" != "" ]; then
  HAS_MODULES=1
fi

if [ "$HAS_USBSERIAL" != "" ]; then
  HAS_MODULES=1
fi

if [ "$HAS_MODULES" = "1" ]; then
  disk_rw
  perl -pi -e "s/usblp//g" /etc/modules
  perl -pi -e "s/usbserial//g" /etc/modules
  depmod -a
  disk_ro
  reboot
fi

# check correct mount options
HAS_BARRIER=`cat /etc/fstab | grep barrier`

if [ "$HAS_BARRIER" = "" ]; then
  disk_rw
  perl -pi -e "s|notail,noatime|notail,noatime,barrier=flush,data=ordered|gm" /etc/fstab
  disk_ro
fi

# safer postgres
HAS_SYNCHRONOUS_COMMIT=`cat /etc/postgresql/9.1/main/postgresql.conf | grep "synchronous_commit = on"`

if [ "$HAS_SYNCHRONOUS_COMMIT" = "" ]; then
  disk_rw
  perl -pi -e 's/synchronous_commit = off/synchronous_commit = on/' /etc/postgresql/9.1/main/postgresql.conf*
  disk_ro
fi

# graphical display cleanup
if [ -e "/opt/pos/common/addons/graphical_display/config.ini" ]; then
  rm /opt/pos/common/addons/graphical_display/config.ini*
  rm -rf /opt/pos/common/addons/graphical_display/playlists
  rm -rf /opt/pos/common/addons/graphical_display/*.png
fi

# cleanup
#rm -rf /opt/pos/common/bin/devices_handler.pl /opt/pos/lib/App/POS/Printer /opt/pos/lib/App/POS/Hardware 2> /dev/null

# cleanup tmpl in reports
for file in `find /opt/pos/common/skins/PT/reports | grep "\.tmpl"`; do
  rm $file
done

rm /opt/pos/common/skins/PT/reports/01_daily_simple/11_offers_by_group.txt 2> /dev/null
rm /opt/pos/common/skins/PT/reports/02_daily_detailed/11_offers_by_group.txt 2> /dev/null
rm /opt/pos/common/skins/PT/reports/03_daily_clerk/11_offers_by_group.txt 2> /dev/null
rm /opt/pos/common/skins/PT/reports/04_dayclose/11_offers_by_group.txt 2> /dev/null
rm /opt/pos/common/skins/PT/reports/04_dayclose/04_vat_payed.txt 2> /dev/null
rm /opt/pos/common/skins/PT/reports/03_daily_clerk/04_vat_payed.txt 2> /dev/null
rm /opt/pos/common/skins/PT/reports/02_daily_detailed/04_vat_payed.txt 2> /dev/null
rm /opt/pos/common/skins/PT/reports/01_daily_simple/04_vat_payed.txt 2> /dev/null

# remove hp rules
if [ -e "/etc/udev/rules.d/40-hplip.rules" ]; then
  disk_rw
  rm /etc/udev/rules.d/40-hplip.rules 2> /dev/null
  rm /etc/udev/rules.d/56-hpmud_add_printer.rules 2> /dev/null
  rm /etc/udev/rules.d/56-hpmud_support.rules 2> /dev/null
  rm /etc/udev/rules.d/86-hpmud_plugin.rules 2> /dev/null
  disk_ro
fi

if [ -e "/opt/pos/.machine_id" ]; then
  rm /opt/pos/.machine_id
fi

if [ -e "/opt/pos/install/bashrc" ]; then
  cp /opt/pos/install/bashrc /root/.bashrc
fi

SKIN=`cat /opt/pos/etc/config.ini | grep LANG= | grep -v "#" | cut -f2 -d"="`

if [ -e "/opt/pos/common/bin/pos.gambas" ]; then
  rm /opt/pos/common/bin/pos.gambas
fi

# old skin cleanup
if [ -e "/opt/pos/common/skins/$SKIN/db_export.pl" ]; then
  echo "UPDATE clerks SET skin = ''" > /tmp/sql_$$.txt
  psql -U root pos < /tmp/sql_$$.txt
  rm /tmp/sql_$$.txt

  rm /opt/pos/common/skins/$SKIN/db_export.pl
  rm /opt/pos/common/skins/$SKIN/db_import
  rm /opt/pos/common/skins/$SKIN/machine_configurator.cfg
  rm -rf /opt/pos/common/skins/$SKIN/translations/*
fi

if [ -d "/opt/pos/codigo" ]; then
  rm -rf /opt/pos/codigo
fi

# clean a wrongly inserted report (48_vat_saft.txt)
find /opt/pos/common/reports | grep 48_vat_saft | xargs rm -f

#if [ "$DONT_EXECUTE_ITSELF" = "" ]; then
  reindexdb -U root pos -t sales_headers
  reindexdb -U root pos -t sales_payments
  reindexdb -U root pos -t sales_details
  reindexdb -U root pos -t sales_headers_aux
  reindexdb -U root pos -t sales_hashes
  reindexdb -U root pos -t counters

  #/opt/pos/install/install.sh DONT_EXECUTE_ITSELF
#fi


