#!/bin/bash

CONFIG="/opt/pos/etc/config.ini"
VNC_STATIONS=`cat $CONFIG | grep "VNC_STATIONS" | cut -f2 -d=`
VNC_RESCALE=`cat $CONFIG | grep "VNC_RESCALE" | cut -f2 -d=`

if [ "$VNC_STATIONS" = "" ] || [ "$VNC_STATIONS" = "0" ]; then
  exit
fi

KILL=$1

USER="root"
GEOMETRY="800x600"
DEPTH="16"

if [ "$KILL" != "" ]; then
  # kill x11vnc
  ps xa | grep x11vnc | grep rfbport | grep -v grep | awk '{ print $1 }' | xargs kill -9 2> /dev/null

  DISP_COUNT=1

  for pid in `ps xa | grep Xtightvnc | grep -v grep | awk '{ print $1 }'`; do
    su ${USER} -c "/usr/bin/vncserver -kill :${DISP_COUNT}"
    DISP_COUNT=`expr $DISP_COUNT + 1`
  done
else
  for i in $(seq 1 $VNC_STATIONS); do
    NAME="pos$i"
    DISPLAY=$i
    OPTIONS="-name \"${NAME}\" -depth ${DEPTH} -geometry ${GEOMETRY} :${DISPLAY}"

    echo "WILL START > vncserver > DISPLAY ${DISPLAY}"

    /usr/bin/vncserver ${OPTIONS}
  done

  sleep 5

  for i in $(seq 1 $VNC_STATIONS); do
    echo "WILL START > run_vnc_station.sh > DISPLAY $i"
    DISPLAY=$i

    if [ "$VNC_RESCALE" != "" ]; then
      /opt/pos/common/bin/run_vnc_station_x11vnc.sh $DISPLAY $VNC_RESCALE &
    fi

    /opt/pos/common/bin/run_vnc_station.sh $DISPLAY &
  done
fi

