#!/bin/bash

# setup ram disks
/opt/pos/common/bin/setup_ram_disks.sh

# logs cleanup
find /var/log | grep \.*.gz | xargs rm 2> /dev/null
find /var/log/ | egrep '\.log\.' | xargs rm 2> /dev/null

# psql safeness
rm -rf /tmp/pg_stat_tmp ; mkdir /tmp/pg_stat_tmp ; chmod 777 /tmp/pg_stat_tmp 2> /dev/null
rm -rf /var/log/postgresql/*

CONFIG="/opt/pos/etc/config.ini"
HAS_X64=`cat $CONFIG | grep X64_ACTIVE | grep -v "#X64" | grep -v grep | grep 1`
HAS_MUSIC=`cat $CONFIG | grep MUSIC_PLAY | grep -v grep | grep 1`
STATION_NUMBER=`cat /opt/pos/etc/config.ini | grep STATION_NUMBER | cut -f2 -d=`
MYLANG=`cat /opt/pos/etc/config.ini | grep LANG= | cut -f2 -d=`
PRODUCTS_SUGESTION=`cat /opt/pos/etc/config.ini | grep PRODUCTS_SUGESTION | grep -v AUTO | cut -f2 -d=`
USE_NETBO=`cat /opt/pos/etc/config.ini | grep USE_NETBO | grep -v AUTO | cut -f2 -d=`
PRINTERS_INIT_ON_BOOT=`cat /opt/pos/etc/config.ini | grep PRINTERS_INIT_ON_BOOT | cut -f2 -d=`

if [ ! -d "/opt/pos/server/data/areas" ]; then
  mkdir -p /opt/pos/server/data/areas
fi

if [ ! -d "/opt/pos/server/data/tmp" ]; then
  mkdir -p /opt/pos/server/data/tmp
fi

if [ ! -d "/opt/pos/server/data/database" ]; then
  mkdir -p /opt/pos/server/data/database
fi

if [ ! -d "/opt/pos/common/data" ]; then
  mkdir -p /opt/pos/common/data
fi

if [ ! -d "/opt/pos/common/music" ]; then
  mkdir -p /opt/pos/common/music
fi

if [ ! -d "/opt/pos/common/print_templates/include" ]; then
  mkdir -p /opt/pos/common/print_templates/include
fi

if [ ! -d "/opt/pos/server/data/images" ]; then
  mkdir -p /opt/pos/server/data/images
fi

if [ ! -d "/opt/pos/server/data/product_images" ]; then
  mkdir -p /opt/pos/server/data/product_images
fi

if [ ! -d "/opt/pos/server/data/group_images" ]; then
  mkdir -p /opt/pos/server/data/group_images
fi

if [ ! -d "/opt/pos/server/data/table_plans" ]; then
  mkdir -p /opt/pos/server/data/table_plans
fi

if [ ! -e "/opt/pos/common/print_templates/include/documents_header.tmpl" ]; then
  touch /opt/pos/common/print_templates/include/documents_header.tmpl
fi

if [ ! -e "/opt/pos/common/print_templates/include/documents_footer.tmpl" ]; then
  touch /opt/pos/common/print_templates/include/documents_footer.tmpl
fi

# port mappings
/opt/pos/common/bin/com_port_mappings.sh

# cpu monitor
/opt/pos/common/bin/cpu_monitor.sh &

# if we're not server, stop database
if [ "$STATION_NUMBER" != "0" ]; then
  # run_pos and cpu_monitor will take care to remove this
  touch /tmp/server_error.txt
  #touch /tmp/server_db_error.txt
else
  INTERNET_DASHBOARD=`cat /opt/pos/etc/config.ini | grep INTERNET_DASHBOARD | cut -f2 -d=`

  if [ "$INTERNET_DASHBOARD" = "1" ]; then
    if [ ! -f "/etc/cron.d/ptkeys" ]; then
      echo "*/10 * * * * root /opt/pos/server/apps/ptkeys.pl" > /etc/cron.d/ptkeys
      /etc/init.d/cron restart
    fi
  else
    if [ -f "/etc/cron.d/ptkeys" ]; then
      rm /etc/cron.d/ptkeys
      /etc/init.d/cron restart
    fi
  fi

  if [ "$USE_NETBO" = "1" ]; then
    IS_RUN=`ps xa | grep tray_application | grep -v grep`

    if [ "$IS_RUN" = "" ]; then
      /root/weckOFFICE/bin/tray_application
    fi

    /opt/pos/common/bin/previous_date_export &
  fi

  if [ -e "/opt/pos/common/skins/$MYLANG/sign_server" ]; then
    /opt/pos/common/skins/$MYLANG/sign_server &
  fi

  /opt/pos/server/apps/custom_scale.sh &
  /opt/pos/server/apps/run_suggestions.sh &
  #/opt/pos/server/apps/bdb_cleanup.pl &
  /opt/pos/server/apps/counters_cleanup.pl &

  rm -rf /opt/pos/server/data/registered_stations/*
  rm -rf /opt/pos/server/data/registered_printers/*

  # cleanup orders archive
  if [ -d "/opt/pos/server/data/order_archive" ]; then
    find "/opt/pos/server/data/order_archive" -mmin +59 -type f -name "*.txt" -exec rm -f {} \;
  fi

  # cleanup docs print archive
  if [ -d "/opt/pos/server/data/print_checks_archive" ]; then
    find "/opt/pos/server/data/print_checks_archive" -mmin +59 -type f -name "*.txt" -exec rm -f {} \;
  fi

  # cleanup sales to net older than 10 days
  find /opt/pos/common/data -mtime +10 | grep ".zip" | grep sales_ | xargs rm

  # cleanup nextid files
  #for file in `find /opt/pos/server/data/areas | grep nextid`; do
  #  CUR_TIME=`date +%s`
  #  FILE_TIME=`stat -c %Y $file`
  #  DIFF=`expr $CUR_TIME - $FILE_TIME`

  #  # 2 hours
  #  if [ $DIFF -gt 7200 ]; then
  #    rm -rf $file
  #  fi
  #done
fi

/opt/pos/common/bin/restart_hardware_handler.sh
/opt/pos/common/bin/mobile_devices.sh &
/opt/pos/common/bin/graphical_customer_display.sh &
/opt/pos/common/bin/ntp_set_date.sh &

if [ "$PRINTERS_INIT_ON_BOOT" = "1" ]; then
  /opt/pos/common/bin/printers_init &
fi

#if [ "$HAS_3G" != "" ]; then
#  /opt/pos/common/bin/3g.sh &
#fi

if [ "$HAS_X64" != "" ]; then
  /opt/pos/common/bin/x64.sh &
fi

if [ "$HAS_MUSIC" != "" ]; then
  /opt/pos/common/bin/music.sh &
fi

HAS_EXTERNAL_PRINTING=`cat $CONFIG | grep EXTERNAL_INVOICE_TOPRINTER | grep -v grep | grep 1`

if [ "$HAS_EXTERNAL_PRINTING" != "" ]; then
  service cups start
  PRINTER=`lpstat -p | cut -f2 -d" "`

  if [ "$PRINTER" != "" ]; then
    lpadmin -p $PRINTER -E
  fi
fi

if [ -e "/root/.fluxbox/init.hidden" ]; then
  mv /root/.fluxbox/init.hidden /root/.fluxbox/init
fi

