#!/bin/bash

NSI=`cat /opt/pos/etc/config.ini | grep "NETWORK_SERVER_IP" | cut -f2 -d=`

if [ "$NSI" = "" ]; then
  exit 0
fi

PIDD=$$

curl --retry 0 http://$NSI:8088 -o /tmp/$PIDD 2> /dev/null 

SERVER_DATE=`cat /tmp/$PIDD | cut -d"#" -f7`

if [ "$SERVER_DATE" != "" ]; then
  YEAR=`echo $SERVER_DATE | cut -f1 -d"_"`
  MONTH=`echo $SERVER_DATE | cut -f2 -d"_"`
  DAY=`echo $SERVER_DATE | cut -f3 -d"_"`
  HOUR=`echo $SERVER_DATE | cut -f4 -d"_"`
  MIN=`echo $SERVER_DATE | cut -f5 -d"_"`
  SEC=`echo $SERVER_DATE | cut -f6 -d"_"`
  date -s "$YEAR-$MONTH-$DAY $HOUR:$MIN:$SEC"
fi



