#!/usr/bin/perl

use strict;
use warnings;
use lib '/opt/pos/lib';
use App::POS::Check;
use Data::Dumper;

my $port       = shift;
my $area       = shift;
my $area_name  = shift;
my $check      = shift;
my $type       = shift;
my $str        = shift;

if (! defined $port || ! defined $area || ! defined $area_name || ! defined $check) {
  die "Usage: $0 <port> <area> <area_name> <check> <type> [str]\n";
}

#open(F, ">> /tmp/loggg.txt");
#print F Dumper($str);
#close(F);
#my $check_file = "/opt/pos/server/data/areas/$area/$check";
#my $check_o = App::POS::Check->new( file => $check_file );
#my $data = $check_o->data();

&wp($port, "AREA: $area_name, CHECK: $check");

if ($type eq 'customerdisplay') {
}
elsif ($type eq 'checkfinalize') {
}

my @toks = split /#/, $str;

#open(F, ">> /tmp/loggg.txt");
#print F Dumper(\@toks);
#close(F);

if (! scalar @toks) {
  exit 0;
}

if ($toks[0] eq 'idle') {
  exit 0;
}

# anulacao
if ($toks[0] eq 'VOID') {
  &wp($port, "ANULOU: $toks[1]");
  #&wp($port, "");
  #&wp($port, "");
}

# registo
elsif (scalar @toks == 3) {
  #&wp($port, "PRODUTO: $toks[0], QTD: $toks[2], TOTAL: $toks[1]");
  &wp($port, "$toks[0], $toks[2], $toks[1]");
}

# pagamento
elsif (scalar @toks == 2) {
  &wp($port, "TOTAL: $toks[0], TROCO: $toks[1]");
}

else {
  &wp($port, "DOC: ".$toks[0]);
}

sub wp {
  my( $port, $msg ) = @_;
  open(F, "> $port");
  print F "$msg\n";
  close(F);
}

