#!/usr/bin/perl
#
# Protocolo ICL
#

use strict;
use warnings;
use Device::SerialPort;

my $STX = chr(0x02);
my $ETX = chr(0x03);
my $ACK = chr(0x06);
my $ENQ = chr(0x05);
my $TAB = chr(0x11);
my $LF = chr(10);
my $CR = chr(13);

my $port = shift;
my $baud = shift || "9600";
my $parity = shift || "even";
my $databits = shift || "8";
my $stopbits = shift || "1";
my $handshake = shift || "none";

die "missing port" unless defined $port;

my $PortObj = Device::SerialPort->new($port);
$PortObj->baudrate($baud);
$PortObj->parity($parity);
$PortObj->databits($databits);
$PortObj->stopbits($stopbits);
$PortObj->handshake($handshake);

my $count_in;
my $string_in;
my $msg;
my $ntries=0;
my $value_found=0;

while ($ntries < 10) {
  $PortObj->write($ENQ);
  sleep 0.1;
  ( $count_in, $string_in ) = $PortObj->read(255);

  if ($count_in ne 0) {
    if (substr $string_in ,1,1 eq chr(40)) {
        print substr $string_in, 9,5;
        $value_found =1;
    }

  }
  $ntries ++;
}
if ($value_found eq 0) {
  print "ERROR";
}
