#!/usr/bin/perl
#
# Protocolo dos POS CASIO
#

use strict;
use warnings;
use Device::SerialPort;

my $STX = chr(0x02);
my $ETX = chr(0x03);
my $ACK = chr(0x06);
my $ENQ = chr(0x05);
my $TAB = chr(0x11);
my $LF  = chr(10);
my $CR  = chr(13);

my $port = shift;
my $baud = shift || "9600";
my $parity = shift || "even";
my $databits = shift || "8";
my $stopbits = shift || "1";
my $handshake = shift || "none";

die "missing port" unless defined $port;

my $PortObj = Device::SerialPort->new($port);
$PortObj->baudrate($baud);
$PortObj->parity($parity);
$PortObj->databits($databits);
$PortObj->stopbits($stopbits);
$PortObj->handshake($handshake);

my $count_in;
my $string_in;
my $success = 0;
my $ntries=1;

while ($ntries < 10) {
  $PortObj->write($STX);
  sleep 0.1;
  ( $count_in, $string_in ) = $PortObj->read(255);

  if ($string_in eq $ACK) {
    $PortObj->write(chr(0x40).chr(0x31).'00001'.$CR.$LF);
    sleep 0.1;

    ( $count_in, $string_in ) = $PortObj->read(255);

    if ($string_in eq $ACK) {
      $PortObj->write(chr(0x31).chr(0x30).$CR.$LF);
      sleep 0.1;
      ( $count_in, $string_in ) = $PortObj->read(255);

      if ($string_in eq $STX) {
        $PortObj->write($ACK);
        sleep 0.1;

        ( $count_in, $string_in ) = $PortObj->read(1);

        if ($string_in =~ /\d+/) {
          $success = 1;
          print substr $string_in, 1,5;
        }
      }
    }
  }

  sleep 0.5;
  $ntries++;
}

if (! $success) {
  print "ERROR";
}


