#!/usr/bin/perl
#
# Protocolo 
#

use strict;
use warnings;
use Device::SerialPort;

my $STX = chr(0x02);
my $ETX = chr(0x03);
my $ACK = chr(0x06);
my $ENQ = chr(0x05);
my $TAB = chr(0x11);
my $LF = chr(10);
my $CR = chr(13);

my $port = shift;
my $baud = shift || "9600";
my $parity = shift || "even";
my $databits = shift || "8";
my $stopbits = shift || "1";
my $handshake = shift || "none";

die "missing port" unless defined $port;

my $PortObj = Device::SerialPort->new($port);
$PortObj->baudrate($baud);
$PortObj->parity($parity);
$PortObj->databits($databits);
$PortObj->stopbits($stopbits);
$PortObj->handshake($handshake);

my $count_in;
my $string_in;
my $msg;
my $ntries = 0;
my $value_found = 0;

while ($ntries < 10) {
  $PortObj->write(chr(0x57).$CR);
  sleep 0.1;
  ( $count_in, $string_in ) = $PortObj->read(255);
 	my( $num ) = $string_in =~ /(\d+\.\d+)/;
 	if (defined $num && $num*1 > 0) {
     print  sprintf("%.3f", $num)."\n";
     $value_found = 1
  }
  $ntries++;
}
if ($value_found eq 0) {
  print "ERROR";
}
