#!/usr/bin/perl
#
# Protocolo das caixas registadoras Anker
#

use strict;
use warnings;
use Device::SerialPort;

my $STX = chr(0x02);
my $ETX = chr(0x03);
my $ACK = chr(0x06);
my $ENQ = chr(0x05);
my $TAB = chr(0x11);
my $LF = chr(10);
my $CR = chr(13);

my $port = shift;
my $baud = shift || "9600";
my $parity = shift || "even";
my $databits = shift || "8";
my $stopbits = shift || "1";
my $handshake = shift || "none";

die "missing port" unless defined $port;

my $PortObj = Device::SerialPort->new($port)|| die "Error opening $port";
$PortObj->baudrate($baud);
$PortObj->parity($parity);
$PortObj->databits($databits);
$PortObj->stopbits($stopbits);
$PortObj->handshake($handshake);

my $count_in;
my $string_in;
my $num;
my $ntries=1;
my $sucess = 0;

while ($ntries < 10) {
  $PortObj->write($STX.chr(0x30).chr(0x31).$TAB.'00001'.$ETX);
  sleep 0.1;
  ( $count_in, $string_in ) = $PortObj->read(255);

  if ($string_in eq $ACK) {
    $PortObj->write($ENQ);
    sleep 0.1;
    ( $count_in, $string_in ) = $PortObj->read(255);
    if ($string_in =~ /\d+/) {
      $sucess = 1;
      my( $num ) = $string_in =~ /(\d+\.\d+)/;
      if (defined $num && $num*1 > 0) {
           print  sprintf("%.3f", $num)."\n";
      }
    }
  }

  $ntries++;
}

if (! $sucess) {
  print "ERROR";
}


