#!/usr/bin/perl
#
# Protocolo das EPS B0, Libra AM-15K (mode 7.1=envio continuo)
#   
#

use strict;
use warnings;
use Device::SerialPort;

my $STX = chr(0x02);
my $ETX = chr(0x03);
my $ACK = chr(0x06);
my $ENQ = chr(0x05);
my $TAB = chr(0x11);
my $LF = chr(10);
my $CR = chr(13);

my $port = shift;
my $baud = shift || "9600";
my $parity = shift || "even";
my $databits = shift || "8";
my $stopbits = shift || "1";
my $handshake = shift || "none";

die "missing port" unless defined $port;

my $PortObj = Device::SerialPort->new($port)|| die "Error opening $port";
$PortObj->baudrate($baud);
$PortObj->parity($parity);
$PortObj->databits($databits);
$PortObj->stopbits($stopbits);
$PortObj->handshake($handshake);

my $count_in;
my $string_in;
my $num;
my $ntries=1;
my $sucess = 0;

while ($ntries < 10) {
  ( $count_in, $string_in ) = $PortObj->read(255);
#print $string_in;
      my( $num ) = $string_in =~ /(\d+\.\d+)/;
      if (defined $num && $num*1 > 0) {
          print  sprintf("%.3f", $num)."\n";
          $sucess = 1;
      }
      $ntries++;
}

if (! $sucess) {
  print "ERROR";
}


