#!/bin/bash

# makes sure only display 0 starts the application
if [ "$DISPLAY" != ":0" ] && [ "$DISPLAY" != ":0.0" ]; then
  while [ true ]; do
    sleep 600
  done
fi

# kill old x11vnc running
for pid in `ps xa | grep x11vnc | grep -v rfbport | grep -v grep | awk '{ print $1 }'`; do
  kill -9 $pid
done

# start a new one
/usr/bin/x11vnc -norc -forever -scale 800x600 -geometry 800x600 -noxdamage -nowcr -noscr -bg -display :0

TEAMVIEWER_ALWAYS_RUNNING=`cat /opt/pos/etc/config.ini | grep TEAMVIEWER_ALWAYS_RUNNING | cut -f2 -d=`

if [ "$TEAMVIEWER_ALWAYS_RUNNING" = "1" ]; then
  if [ -e "/opt/pos/common/bin/teamviewer.sh" ]; then
    /opt/pos/common/bin/teamviewer.sh 1 &
  fi
fi

# cleanup done files
find /opt/pos/server/data/areas/ | grep "\.done" | xargs rm 2> /dev/null

/opt/pos/common/bin/vnc_stations.sh &

while [ 1 ]; do
  STATION_NUMBER=`cat /opt/pos/etc/config.ini | grep STATION_NUMBER | cut -f2 -d=`
  SCREEN_ROTATE_ON_START=`cat /opt/pos/etc/config.ini | grep SCREEN_ROTATE_ON_START | cut -f2 -d=`
  USE_ADVERT_CUSTOMER_DISPLAY=`cat /opt/pos/etc/config.ini | grep USE_ADVERT_CUSTOMER_DISPLAY | cut -f2 -d=`
  BACKGROUND_WEB_BROWSER=`cat /opt/pos/etc/config.ini | grep BACKGROUND_WEB_BROWSER | cut -f2 -d=`
  SORT_CLERKS_BASED_ON_SALES=`cat /opt/pos/etc/config.ini | grep SORT_CLERKS_BASED_ON_SALES | cut -f2 -d=`
  HAS_3G=`cat /opt/pos/etc/config.ini | grep 3G_ACTIVE | cut -f2 -d=`
  USE_TICKET_SCALE=`cat /opt/pos/etc/config.ini | grep USE_TICKET_SCALE | cut -f2 -d=`

  # restart scale ticket software
  if [ "$USE_TICKET_SCALE" = "1" ]; then
    ps xa | grep scale_tickets | grep -v grep | awk '{ print $1 }' | xargs kill -9 2> /dev/null
  fi

  # screen rotate
  if [ "$SCREEN_ROTATE_ON_START" != "" ]; then
    /opt/pos/common/bin/screen_rotate rotate
  fi

  # stop and start hid readers
  if [ -e "/opt/pos/etc/hid.txt" ]; then
    for pid in `ps xa | grep usb_hid_reader | grep -v grep | awk '{ print $1 }'`; do
      kill -9 $pid
    done

    /opt/pos/common/bin/usb_hid_reader.pl &
  fi

  # install additional components
  if [ -e "/opt/pos/install/install.sh" ]; then
    /opt/pos/install/install.sh
    rm -rf /opt/pos/install/*
  fi

  # server is available with no errors
  if [ ! -e "/tmp/server_error.txt" ] && [ ! -e "/tmp/server_db_error.txt" ]; then
    # server cleanups
    if [ "$STATION_NUMBER" = "0" ]; then
      PRINT_CHECK_PRODUCTS_MODE=`cat /opt/pos/etc/config.ini | grep PRINT_CHECK_PRODUCTS_MODE | cut -f2 -d=`

      if [ "$PRINT_CHECK_PRODUCTS_MODE" = "1" ]; then
        rm /opt/pos/common/print_templates/include/products.tmpl
        ln -s /opt/pos/common/print_templates/include/products.single.tmpl /opt/pos/common/print_templates/include/products.tmpl
      elif [ "$PRINT_CHECK_PRODUCTS_MODE" = "2" ]; then
        rm /opt/pos/common/print_templates/include/products.tmpl
        ln -s /opt/pos/common/print_templates/include/products.double.tmpl /opt/pos/common/print_templates/include/products.tmpl
      fi

      # sort clerks based on their sales
      if [ "$SORT_CLERKS_BASED_ON_SALES" != "" ]; then
        /opt/pos/server/apps/clerks_set_priority
      fi

      # fix db indexes
      /opt/pos/server/apps/fix_indexes &

      # berkeydb safeness
      rm -rf /opt/pos/server/data/database/__*

      MYLANG=`cat /opt/pos/etc/config.ini | grep LANG= | cut -f2 -d=`

      if [ "$MYLANG" != "" ]; then
        if [ -e "/opt/pos/common/skins/$MYLANG/custom/login.png" ]; then
          fbsetbg -f /opt/pos/common/skins/$MYLANG/custom/login.png
        else
          fbsetbg -f /opt/pos/common/skins/$MYLANG/login.png
        fi
      fi
    else
      if [ -e "/shares/pos/etc/config.ini" ]; then
        MYLANG=`cat /shares/pos/etc/config.ini | grep LANG= | cut -f2 -d=`

        if [ "$MYLANG" != "" ]; then
          if [ -e "/opt/pos/common/skins/$MYLANG/custom/login.png" ]; then
            fbsetbg -f /opt/pos/common/skins/$MYLANG/custom/login.png
          else
            fbsetbg -f /opt/pos/common/skins/$MYLANG/login.png
          fi
        fi
      fi
    fi

    if [ "$BACKGROUND_WEB_BROWSER" != "" ]; then
      CHROME_RUNNING=`ps xa | grep chromium-browser | grep -v grep`

      if [ "$CHROME_RUNNING" = "" ]; then
        /usr/bin/chromium-browser --user-data-dir=/root/.chrome &
      fi
    fi

    # start network manager applet
    #if [ -e "/root/.fluxbox/init.hidden" ] && [ -e "/usr/bin/nm-applet" ]; then
    #  ISRUN=`ps xa | grep "nm\-applet" | grep -v grep`

    #  if [ "$ISRUN" = "" ]; then
    #    nm-applet &
    #    sleep 3
    #    xdotool mousemove 790 1 click 3
    #  fi
    #fi

    # restart hardware handler
    /opt/pos/common/bin/restart_hardware_handler.sh &

    if [ "$USE_ADVERT_CUSTOMER_DISPLAY" = "1" ]; then
      /opt/pos/common/addons/graphical_display/app
    else
      # script to stop services and free some memory. Only is executed
      # if it exists.
      if [ -e "/root/free_memory.sh" ]; then
        /root/free_memory.sh
      fi

      # if defined, auto start 3g
      if [ "$HAS_3G" = "1" ]; then
        /opt/pos/common/bin/3g_activate.sh &
      fi

      # start pos
      CUR_DATE=`date +%Y%m%d_%H%M%S`
      echo "$CUR_DATE > WILL START POS" >> /tmp/code.log
      /opt/pos/common/bin/pos /opt/pos
      CUR_DATE=`date +%Y%m%d_%H%M%S`
      echo "$CUR_DATE > POS ENDED..." >> /tmp/code.log
    fi
  fi

  sleep 1
done

